/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.EmptyRealModeIDList;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.TreeDetailListUI;
import com.kingdee.eas.framework.client.TreeListUI;
import com.kingdee.eas.framework.client.UILifeCycleEvent;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import com.kingdee.eas.framework.client.UILifeListenerEditIdList;
import com.kingdee.util.Uuid;

public class UILifeListenerListIdList
extends UILifeCycleImp {
    private IIDList idList = null;
    private EditUI editui = null;

    public UILifeListenerListIdList(IIDList idList, EditUI editui) {
        this.idList = idList;
        this.editui = editui;
    }

    @Override
    public void onDestroyWindow(UILifeCycleEvent event) {
        Object owner = this.editui.getUIContext().get("Owner");
        if (owner != null && owner instanceof ListUI) {
            ListUI listui = (ListUI)this.editui.getUIContext().get("Owner");
            if (listui instanceof TreeListUI || listui instanceof TreeDetailListUI) {
                return;
            }
            if (this.editui != null) {
                IMetaDataPK queryPK = this.idList.getMetaDataPK();
                EntityViewInfo entityViewInfo = this.idList.getEntityViewInfo();
                try {
                    if (listui != null && listui.getQueryUuid() != null) {
                        listui.setQueryUuid(null);
                    } else if (queryPK != null) {
                        IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
                        executor.setObjectView(entityViewInfo);
                        Uuid uuid = executor.openQuery();
                        this.idList.setQuery(this.idList.getMetaDataPK(), this.idList.getEntityViewInfo(), uuid);
                        executor = null;
                    }
                    this.editui.getUILifeCycleHandler().addRuleListener(new UILifeListenerEditIdList(this.idList));
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void afterFirstFillData(UILifeCycleEvent event) {
        if (this.idList instanceof EmptyRealModeIDList) {
            return;
        }
        Object owner = this.editui.getUIContext().get("Owner");
        if (owner != null && owner instanceof ListUI) {
            ListUI listui = (ListUI)this.editui.getUIContext().get("Owner");
            if (listui instanceof TreeListUI || listui instanceof TreeDetailListUI) {
                return;
            }
            RealModeIDList realModeIDList = (RealModeIDList)this.idList;
            String currentId = realModeIDList.getCurrentID();
            int oldCurIndex = this.idList.getCurrentIndex();
            IMetaDataPK queryPK = this.idList.getMetaDataPK();
            EntityViewInfo entityViewInfo = this.idList.getEntityViewInfo();
            Uuid uuid = listui.getQueryUuid();
            realModeIDList.reset(listui.getBillCount(), listui.getRowCount());
            realModeIDList.setQuery(queryPK, entityViewInfo, uuid);
            realModeIDList.setCurrentID(currentId);
            if (oldCurIndex != this.idList.getCurrentIndex()) {
                this.editui.initScrollButtons();
            }
        }
    }
}

