/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.framework.client.IUILoadFilter;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class UILoadFilterHelper {
    private static Logger logger = Logger.getLogger(UILoadFilterHelper.class);
    private static List loadFilterList = null;

    public static void loadParseRpc(String uiClassName) throws Exception {
        if (loadFilterList == null) {
            return;
        }
        PermissionCommonUtil.checkSSLconfig((String)uiClassName);
        Iterator lt = loadFilterList.iterator();
        while (lt.hasNext()) {
            UILoadFilterHelper.processRpcFilter(uiClassName, (String)lt.next());
        }
    }

    public static List getLoadFilterList() {
        return loadFilterList;
    }

    public static void addRpcFileter(String className) {
        if (loadFilterList == null) {
            loadFilterList = new ArrayList();
        }
        if (className != null && !loadFilterList.contains(className)) {
            loadFilterList.add(className);
        }
    }

    private static void processRpcFilter(String uiClassName, String className) {
        String classStr = StringUtils.cnulls((String)className);
        if (StringUtils.isEmpty((String)classStr)) {
            return;
        }
        try {
            IUILoadFilter filter = (IUILoadFilter)UILoadFilterHelper.class.getClassLoader().loadClass(classStr).newInstance();
            filter.doFilter(uiClassName);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

