/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.cloud.screen.draw;

import com.kingdee.eas.framework.client.cloud.screen.draw.IShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class WordShape
implements IShape {
    JPanel parent;
    JTextArea area;
    String text;
    boolean isDrawed = false;
    boolean isFocused = false;
    protected Color color;
    protected int startX;
    protected int startY;
    protected int endX;
    protected int endY;
    private static float[] dash1 = new float[]{5.0f};
    private static Stroke s = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);

    public WordShape(JPanel owner, Color c, int x, int y) {
        this.parent = owner;
        this.color = c;
        this.startX = this.endX = x;
        this.startY = this.endY = y;
        this.area = new JTextArea();
        this.area.setBorder(BorderFactory.createEmptyBorder());
        this.area.setSize(50, 30);
        this.area.setLocation(x - this.parent.getX(), y - this.parent.getY());
        this.area.setWrapStyleWord(true);
        this.area.setFocusable(true);
        this.area.setForeground(c);
        this.parent.add(this.area);
        this.initListener();
    }

    void initListener() {
        this.area.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                WordShape.this.removeTextArea();
            }
        });
    }

    void removeTextArea() {
        if (this.area != null) {
            this.text = this.area.getText();
            this.isDrawed = !this.isDrawed;
            this.parent.remove(this.area);
            this.area = null;
            this.parent.repaint();
        }
    }

    @Override
    public void draw(Graphics2D g) {
        int h;
        int y;
        int w;
        int x;
        Stroke oldStroke = g.getStroke();
        g.setColor(this.color);
        g.setStroke(s);
        if (this.startX > this.endX) {
            x = this.endX;
            w = this.startX - this.endX;
        } else {
            x = this.startX;
            w = this.endX - this.startX;
        }
        if (this.startY > this.endY) {
            y = this.endY;
            h = this.startY - this.endY;
        } else {
            y = this.startY;
            h = this.endY - this.startY;
        }
        if (w < 50) {
            w = 50;
        }
        if (h < 25) {
            h = 25;
        }
        if (this.area != null) {
            FontMetrics fm = g.getFontMetrics();
            this.text = this.area.getText();
            int sw = fm.stringWidth(this.text);
            if (sw > w) {
                w = sw;
            }
            if (w > this.area.getWidth()) {
                this.area.setSize(w, h);
            }
            this.area.setLocation(x, y);
            g.drawRect(x - 2, y - 2, w + 2, h + 7);
            if (!this.isFocused) {
                System.out.println("text get foucs...");
                this.area.requestFocus();
                this.isFocused = !this.isFocused;
            }
            g.setStroke(oldStroke);
            this.parent.repaint();
        } else {
            g.drawString(this.text, x - 2, y + 10);
        }
    }

    @Override
    public void processCursorEvent(MouseEvent evt, int type) {
        if (type != 2) {
            return;
        }
        int x = evt.getX();
        int y = evt.getY();
        if (evt.isShiftDown()) {
            this.regulateShape(x, y);
        } else {
            this.endX = x;
            this.endY = y;
        }
    }

    protected void regulateShape(int x, int y) {
        int w = x - this.startX;
        int h = y - this.startY;
        int s = Math.min(Math.abs(w), Math.abs(h));
        if (s == 0) {
            this.endX = this.startX;
            this.endY = this.startY;
        } else {
            this.endX = this.startX + s * (w / Math.abs(w));
            this.endY = this.startY + s * (h / Math.abs(h));
        }
    }

    class TextArea
    extends JTextArea {
        private Rectangle2D mfRect = new Rectangle2D.Float();

        TextArea() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(WordShape.this.color);
            this.mfRect.setRect(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1);
            g2d.setStroke(s);
            g2d.draw(this.mfRect);
        }
    }
}

