/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.exportexcel;

import com.kingdee.eas.framework.client.exportexcel.Excel2003Exporter;
import com.kingdee.eas.framework.client.exportexcel.Excel2007Exporter;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigParam;
import com.kingdee.eas.framework.client.exportexcel.IExcelExporter;

public class ExcelExporterFactory {
    private static final ExcelExporterFactory exporterFactory = new ExcelExporterFactory();

    private ExcelExporterFactory() {
    }

    public static ExcelExporterFactory getInstance() {
        return exporterFactory;
    }

    public IExcelExporter getExcelExporter(ExportExcelConfigParam param) {
        if (param == null) {
            throw new IllegalArgumentException("ArgumentERROR:param=" + param);
        }
        IExcelExporter exporter = null;
        switch (param.getExcelVersion()) {
            case 1: {
                exporter = new Excel2003Exporter();
                break;
            }
            case 0: {
                exporter = new Excel2007Exporter();
                break;
            }
            default: {
                exporter = new Excel2003Exporter();
            }
        }
        return exporter;
    }
}

