/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.exportexcel;

import com.kingdee.bos.ctrl.kdf.excel.ui.ExportListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.UITypeHelper;
import com.kingdee.eas.framework.client.exportexcel.ExcelExporterFactory;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigManager;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigParam;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigUI;
import com.kingdee.eas.framework.client.exportexcel.IExcelExporter;
import com.kingdee.eas.framework.client.exportexcel.ReflashSessionThread;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class ExportExcelHelper {
    private static final Logger logger = Logger.getLogger(ExportExcelHelper.class);
    private CoreUI UI = null;
    private KDTable table = null;
    private boolean isDesensitization = false;

    public ExportExcelHelper(CoreUI uI, KDTable table) {
        this.UI = uI;
        this.table = table;
    }

    public void setIsDesensitization(boolean isDesensitization) {
        this.isDesensitization = isDesensitization;
    }

    private IUIWindow createExportExcelConfigDialog(UIContext uiContext) {
        long onLoadStart = System.currentTimeMillis();
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create(ExportExcelConfigUI.class.getName(), (Map)uiContext, null, null);
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        final IUIWindow window1 = window;
        if (window1 instanceof JDialog) {
            WindowListener[] Listeners = ((JDialog)window1).getWindowListeners();
            ((JDialog)window1).removeWindowListener(Listeners[0]);
            ((JDialog)window1).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (window1.getUIObject() instanceof ExportExcelConfigUI) {
                        ((ExportExcelConfigUI)window1.getUIObject()).disposeUIWindow();
                    }
                }
            });
        }
        long onLoadCost = System.currentTimeMillis() - onLoadStart;
        logger.debug((Object)("Create ExportExcelConfigDialog spent " + onLoadCost + " ms."));
        return window;
    }

    public void createExportConfigUI() throws IOException {
        UIContext uiContext = new UIContext((Object)this.UI);
        if (this.isDesensitization) {
            uiContext.put((Object)"isDesensitization", (Object)true);
        }
        IUIWindow window = this.createExportExcelConfigDialog(uiContext);
        ExportExcelConfigUI exportExcelConfigUI = (ExportExcelConfigUI)window.getUIObject();
        ExportExcelConfigParam param = ExportExcelConfigManager.loadExportExcelConfig();
        int selectedRowCount = 0;
        if (this.UI instanceof ListUI) {
            ListUI listUI = (ListUI)this.UI;
            try {
                selectedRowCount = listUI.getSelectedRowCount(this.table);
                if (listUI.getMaxReturnRowCount() > 0 && selectedRowCount > listUI.getMaxReturnRowCount()) {
                    selectedRowCount = listUI.getMaxReturnRowCount();
                }
            }
            catch (Throwable e2) {
                selectedRowCount = KDTableUtil.getSelectedRows((KDTable)this.table).length;
            }
        } else {
            selectedRowCount = KDTableUtil.getSelectedRows((KDTable)this.table).length;
        }
        int rowCount = this.table.getRowCount();
        exportExcelConfigUI.setHelper(this);
        exportExcelConfigUI.setRowCount(rowCount);
        exportExcelConfigUI.setSelectedRowCount(selectedRowCount);
        exportExcelConfigUI.setTable(this.table);
        exportExcelConfigUI.initConfigParam(param);
        window.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File export2Excel(ExportExcelConfigParam param, ExportListener[] listeners) throws Exception {
        String alias = "\u5bfc\u51faEXECEL\nexport fileName:" + param.getFileName() + "\nexport UI:" + this.UI.getClass().getName();
        BOSObjectType bosObjectType = null;
        IObjectPK logPK = null;
        if (this.UI instanceof ListUI) {
            bosObjectType = UITypeHelper.getType((ListUI)this.UI);
        } else if (this.UI instanceof EditUI) {
            bosObjectType = UITypeHelper.getType((EditUI)this.UI);
        }
        if (bosObjectType == null) {
            bosObjectType = BOSObjectType.create((String)"EXPEXCEL");
        }
        logPK = LogUtil.beginLog(null, (String)"export2Excel", (BOSObjectType)bosObjectType, null, (String)alias);
        String sessionId = SysContext.getSysContext().getSessionID();
        ReflashSessionThread t = new ReflashSessionThread();
        t.setSessionId(sessionId);
        t.setMillis(60000L);
        t.start();
        File file = null;
        try {
            IExcelExporter exporter = ExcelExporterFactory.getInstance().getExcelExporter(param);
            file = exporter.startExport(this.table, param, listeners);
            if (logPK != null) {
                LogUtil.afterLog(null, (IObjectPK)logPK);
            }
        }
        finally {
            t.setFlag(false);
        }
        return file;
    }
}

