/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.service;

import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.client.daq.DataAcquisitionClientHelper;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.util.LowTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermissionService
implements IBindService {
    private static Logger logger = Logger.getLogger(PermissionService.class);
    private Map serviceContext;
    private Map uiContext;

    public void beforeActionPerformed(Map serviceContext) throws Throwable {
        this.serviceContext = serviceContext;
        this.uiContext = (Map)serviceContext.get("UICONTEXT");
        LowTimer t = new LowTimer();
        t.reset();
        IItemAction act = (IItemAction)serviceContext.get("ACTION");
        if (act != null) {
            try {
                DataAcquisitionClientHelper.actionDeal((IObjectPK)((IObjectPK)this.uiContext.get("USER.PK")), (IItemAction)act);
            }
            catch (Exception e) {
                logger.error((Object)"\u4fe1\u606f\u91c7\u96c6\u5931\u8d25", (Throwable)e);
            }
            this.handlePermissionForItemAction(act);
            logger.info((Object)("Handle permission : " + t.msValue() + "ms"));
        }
    }

    private void handlePermissionForItemAction(IItemAction action) throws Throwable {
        IObjectPK userPK = (IObjectPK)this.uiContext.get("USER.PK");
        IObjectPK orgPK = (IObjectPK)this.uiContext.get("ORG.PK");
        IUIObject ui = action.getUIObject();
        if (ui != null) {
            orgPK = ui.getOrgPK(action);
        }
        IMetaDataPK metaPK = (IMetaDataPK)this.uiContext.get("METADATA.PK");
        String permissionItem = (String)this.uiContext.get("PERMISSIONITEM");
        Boolean orgExtFromCtx = (Boolean)this.uiContext.get("ORGEXT");
        if (orgExtFromCtx == null) {
            orgExtFromCtx = Boolean.TRUE;
        }
        PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, (IMetaDataPK)metaPK, (ItemAction)((ItemAction)action), (String)permissionItem, (boolean)orgExtFromCtx, (Map)this.getUIContext(action));
    }

    private Map getUIContext(IItemAction action) {
        Map<String, String> ctxMap = new HashMap();
        try {
            ListUI listUI = null;
            EditUI editUI = null;
            if (ListUI.class.isAssignableFrom(action.getUIObject().getClass())) {
                ArrayList selectIds;
                listUI = (ListUI)action.getUIObject();
                ctxMap = listUI.getUIContext();
                ArrayList idList = listUI.getSelectedIdValuesArrayList();
                if (idList.size() == 0 && (selectIds = (ArrayList)this.uiContext.get("selectIds")) != null) {
                    idList.addAll(selectIds);
                }
                ctxMap.put("selectIds", (String)((Object)idList));
                ctxMap.put("getKeyFieldName", listUI.getKeyFieldNameForWF());
            } else if (EditUI.class.isAssignableFrom(action.getUIObject().getClass())) {
                ArrayList lstId = new ArrayList();
                editUI = (EditUI)action.getUIObject();
                ctxMap = editUI.getUIContext();
                lstId.add(editUI.getUIContext().get("ID"));
                ctxMap.put("selectIds", (String)((Object)lstId));
                ctxMap.put("getKeyFieldName", "id");
            } else if (CoreUI.class.isAssignableFrom(action.getUIObject().getClass())) {
                ArrayList lstId = new ArrayList();
                CoreUI coreUI = (CoreUI)action.getUIObject();
                ctxMap = coreUI.getUIContext();
                if (ctxMap != null) {
                    if (ctxMap.get("selectIds") != null) {
                        lstId.addAll((List)ctxMap.get("selectIds"));
                    }
                    ctxMap.put("selectIds", (String)((Object)lstId));
                    ctxMap.put("getKeyFieldName", "id");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ctxMap;
    }

    protected ArrayList getSelectedIdValues(KDTable tblMain, String keyId) {
        ArrayList<String> selectList = new ArrayList<String>();
        int size = tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = tblMain.getSelectManager().get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                String strId = tblMain.getRow(j).getCell(keyId).getValue().toString();
                selectList.add(strId);
                System.out.println(strId);
            }
        }
        return selectList;
    }

    public void afterActionPerformed(Map serviceContext) throws Throwable {
        this.serviceContext = serviceContext;
        IItemAction act = (IItemAction)serviceContext.get("ACTION");
        LowTimer t = new LowTimer();
        t.reset();
        if (act != null) {
            IMetaDataPK metaPK = (IMetaDataPK)this.uiContext.get("METADATA.PK");
            String permissionItem = (String)this.uiContext.get("PERMISSIONITEM");
            PermissionHelper.signature((IMetaDataPK)metaPK, (ItemAction)((ItemAction)act), (String)permissionItem, (Map)this.getUIContext(act));
            logger.info((Object)("After signature(if): " + t.msValue() + "ms"));
        }
    }

    public void finalActionPerformed(Map serviceContext) throws Throwable {
    }
}

