/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.uicontroller;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.AbstraceFrameWorkService;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.ListUISupport;
import com.kingdee.eas.framework.client.uicontroller.IService;
import com.kingdee.eas.framework.client.uicontroller.ITableSelectionSupport;
import com.kingdee.eas.framework.client.uicontroller.IUIModelListener;
import com.kingdee.eas.framework.client.uicontroller.UIStateEnum;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenu;

public class UIActionValidPermissionService
extends AbstraceFrameWorkService
implements IService {
    private static final String IS_ALLOW_VISIBLE = "is_allow_visible";
    private CoreUI ui;
    private ArrayList filter_actions = new ArrayList();
    private ArrayList skip_buttons = new ArrayList();

    @Override
    public void setUI(CoreUI ui) {
        this.ui = ui;
        if (ui.getUISupport() != null) {
            ui.getUISupport().addUIModelListener(new IUIModelListener(){

                @Override
                public void uiStateChanged(UIStateEnum new_state, UIStateEnum old_state) {
                    if (2 == new_state.getValue()) {
                        UIActionValidPermissionService.this.fillFilterActionListWhenOnLoad();
                    }
                }

                @Override
                public void mainOrgChanged(String oldOrgId, String newOrgId) {
                }
            });
        }
    }

    public void resetAllControlShow() {
        List[] all = new List[]{this.getAllMenuItem(), this.getAllToolBarButton()};
        for (int i = 0; i < all.length; ++i) {
            for (AbstractButton button : all[i]) {
                IItemAction action = (IItemAction)button.getAction();
                if (this.filter_actions.contains(action)) continue;
                button.setVisible(true);
            }
        }
    }

    public void HideControlWhenNoPermission() {
        this.handleControl(true);
    }

    public void DisableControlWhenNoPermission() {
        this.handleControl(false);
    }

    private void filterAction(List source, List filter) {
        Iterator it = source.iterator();
        while (it.hasNext()) {
            if (!filter.contains(it.next())) continue;
            it.remove();
        }
    }

    private void handleControl(boolean hiden) {
        List action_list = this.getAllUIActionList();
        this.filterAction(action_list, this.filter_actions);
        if (!this.handlePermission(action_list)) {
            return;
        }
        List[] all = new List[]{this.getAllMenuItem(), this.getAllToolBarButton()};
        for (int i = 0; i < all.length; ++i) {
            for (AbstractButton button : all[i]) {
                IItemAction action;
                String allow_visible;
                if (this.skip_buttons.contains(button) || (allow_visible = (action = (IItemAction)button.getAction()).getExtendProperty(IS_ALLOW_VISIBLE)) == null) continue;
                if (hiden) {
                    button.setVisible("true".equals(allow_visible));
                    continue;
                }
                button.setEnabled("true".equals(allow_visible));
            }
        }
    }

    protected List getAllUIActionList() {
        ArrayList action_list = new ArrayList();
        this.appendActionList(action_list, this.getAllMenuItem());
        this.appendActionList(action_list, this.getAllToolBarButton());
        return action_list;
    }

    private void fillFilterActionListWhenOnLoad() {
        if (!this.ui.getUISupport().isUIShowed()) {
            return;
        }
        this.filter_actions.clear();
        ArrayList items = (ArrayList)this.getAllMenuItem();
        items.addAll(this.getAllToolBarButton());
        for (Object ctrl : items) {
            AbstractButton button;
            if (!(ctrl instanceof AbstractButton) || !((button = (AbstractButton)ctrl).getAction() instanceof IItemAction) || button.isVisible()) continue;
            this.skip_buttons.add(button);
            if (this.filter_actions.contains(button.getAction())) continue;
            this.filter_actions.add(button.getAction());
        }
    }

    private void appendActionList(ArrayList action_list, List items) {
        for (Object ctrl : items) {
            AbstractButton button;
            if (!(ctrl instanceof AbstractButton) || !((button = (AbstractButton)ctrl).getAction() instanceof IItemAction) || action_list.contains(button.getAction())) continue;
            action_list.add(button.getAction());
        }
    }

    protected boolean handlePermission(List action_list) {
        if (action_list.size() == 0) {
            return false;
        }
        IItemAction[] actions = new IItemAction[action_list.size()];
        action_list.toArray(actions);
        try {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            ObjectUuidPK user_pk = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            IObjectPK org_pk = this.getCurrentOrgPK();
            IMetaDataPK[] ui_pks = new IMetaDataPK[actions.length];
            for (int i = 0; i < ui_pks.length; ++i) {
                ui_pks[i] = this.ui.getMetaDataPK();
            }
            IMetaDataPK[] action_pks = new IMetaDataPK[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                action_pks[i] = MetaDataPK.create((String)UIActionValidPermissionService.getActionName((IItemAction)actions[i].getItemAction()));
            }
            boolean[] results = iPermission.hasFunctionPermission((IObjectPK)user_pk, org_pk, ui_pks, action_pks);
            this.syncVisibleProperty(actions, results);
            return true;
        }
        catch (Exception e) {
            this.handException("fail at PermissionFactory.getRemoteInstance \uff1a" + this.getClass().getName(), e);
            return false;
        }
    }

    protected void syncVisibleProperty(IItemAction[] actions, boolean[] results) {
        for (int i = 0; i < actions.length; ++i) {
            actions[i].setExtendProperty(IS_ALLOW_VISIBLE, results[i] ? "true" : "false");
        }
    }

    protected IObjectPK getCurrentOrgPK() {
        String org_id;
        ITableSelectionSupport table_selection;
        if (this.ui.getUISupport() instanceof ListUISupport && (table_selection = ((ListUISupport)this.ui.getUISupport()).getTableSelectionSupport()) != null && (org_id = table_selection.getOrgIdWithSelection(((ListUI)this.ui).getMainTable())) != null) {
            return new ObjectUuidPK(org_id);
        }
        return this.ui.getOrgPK(null);
    }

    public void processActionPermission() {
        int model = this.ui.getValidActionPermissionMode();
        if (model == 1) {
            this.HideControlWhenNoPermission();
        } else if (model == 2) {
            this.DisableControlWhenNoPermission();
        }
    }

    private List getAllToolBarButton() {
        ArrayList<Component> all_buttons = new ArrayList<Component>();
        if (this.ui.getUIToolBar() != null) {
            Component[] coms = this.ui.getUIToolBar().getToolBarComponents();
            for (int i = 0; i < coms.length; ++i) {
                if (!(coms[i] instanceof KDWorkButton) || !(((KDWorkButton)coms[i]).getAction() instanceof IItemAction)) continue;
                all_buttons.add(coms[i]);
            }
        }
        return all_buttons;
    }

    private List getAllMenuItem() {
        ArrayList all_menuitems = new ArrayList();
        if (this.ui.getUIMenuBar() != null) {
            int menu_count = this.ui.getUIMenuBar().getMenuCount();
            for (int i = 0; i < menu_count; ++i) {
                JMenu menu = this.ui.getUIMenuBar().getMenu(i);
                this.getMenuItems(menu, all_menuitems);
            }
        }
        return all_menuitems;
    }

    private void getMenuItems(JMenu menu, List items) {
        if (menu == null) {
            return;
        }
        for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
            Component menu_item = menu.getMenuComponent(i);
            if (menu_item instanceof KDMenuItem && ((KDMenuItem)menu_item).getAction() instanceof IItemAction) {
                ((ArrayList)items).add(menu_item);
                continue;
            }
            if (!(menu_item instanceof JMenu)) continue;
            this.getMenuItems((JMenu)menu_item, items);
        }
    }

    public static String getActionName(IItemAction action) {
        String clzName = action.getClass().getName();
        int idx = clzName.lastIndexOf(36);
        String actionName = idx > -1 ? clzName.substring(idx + 1) : ((idx = clzName.lastIndexOf(46)) > -1 ? clzName.substring(idx + 1) : clzName);
        return actionName;
    }
}

