/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.uicontroller;

import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.uicontroller.IService;
import com.kingdee.eas.framework.client.uicontroller.IUISupport;
import com.kingdee.eas.framework.client.uicontroller.UISupport;
import com.kingdee.eas.framework.configuration.client.ClientConfiguationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UIServiceConfigManager {
    private static Logger logger = Logger.getLogger(UISupport.class);
    private static HashMap name_map_class = new HashMap();

    public static void addAllService() {
        List class_list = ClientConfiguationManager.getConfiguation("bos").getList("easframework.uiservices.class_name", new ArrayList());
        for (int i = 0; i < class_list.size(); ++i) {
            String name = class_list.get(i).toString();
            int pos = name.lastIndexOf(".");
            String key = name;
            if (pos != -1) {
                key = key.substring(pos + 1);
            }
            UIServiceConfigManager.addConfigService(key, name);
        }
    }

    public static void addConfigService(String service_name, String service_class_name) {
        name_map_class.put(service_name.toLowerCase(), service_class_name);
    }

    public static void fillServices(IUISupport ui_support) {
        for (Map.Entry entry : name_map_class.entrySet()) {
            IService service = UIServiceConfigManager.createService(entry.getValue().toString(), ui_support.getUIView());
            if (service == null) continue;
            ui_support.registService(entry.getKey().toString(), service);
        }
    }

    public static IService createService(String class_name, CoreUI ui) {
        try {
            Class<?> cls = Class.forName(class_name);
            IService service = (IService)cls.newInstance();
            if (!service.isEnable()) {
                return null;
            }
            service.setUI(ui);
            return service;
        }
        catch (ClassNotFoundException e) {
            UIServiceConfigManager.handException("class no found " + class_name, e);
        }
        catch (Exception e) {
            UIServiceConfigManager.handException("class newInstance fail  " + class_name, e);
        }
        return null;
    }

    protected static void handException(String error, Exception ex) {
        logger.error((Object)error);
    }

    static {
        UIServiceConfigManager.addAllService();
    }
}

