/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.workflow;

import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.attachment.util.VariousAttachmentInfoMaker;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.workflow.AbstractTempWorkFlowUI;
import com.kingdee.eas.framework.workflow.TempWorkFlowFactory;
import com.kingdee.eas.framework.workflow.TempWorkFlowInfo;
import com.kingdee.eas.framework.workflow.TempWorkFlowManagerFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;

public class TempWorkFlowUI
extends AbstractTempWorkFlowUI {
    private static final long serialVersionUID = 3256873461040802332L;
    private static final int DEFAULTATTACHS = 9;
    private BOSUuid workFlowID;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        String orgBosID;
        String title;
        super.onLoad();
        if (this.entityTempWorkFlow == null) {
            this.entityTempWorkFlow = new TempWorkFlowInfo();
        }
        this.workFlowID = this.entityTempWorkFlow.getId();
        if (this.workFlowID == null) {
            this.workFlowID = BOSUuid.create((BOSObjectType)this.entityTempWorkFlow.getBOSType());
        }
        this.txtWfSender.setText(SysContext.getSysContext().getCurrentUserInfo().getName());
        this.entityTempWorkFlow = new TempWorkFlowInfo();
        this.entityTempWorkFlow.setId(this.workFlowID);
        Object obj = this.getUIContext().get("attachs");
        if (obj != null && obj instanceof File[]) {
            File[] attachs = (File[])obj;
            int num = attachs.length;
            for (int i = 0; i < num; ++i) {
                this.addAttachFromOrg(attachs[i]);
            }
        }
        if ((title = (String)this.getUIContext().get("title")) != null && !title.equals("")) {
            this.entityTempWorkFlow.setWfTitle(title);
            this.txtWfTitle.setText(title);
        }
        if ((orgBosID = (String)this.getUIContext().get("orgBillBosID")) == null || orgBosID.equals("")) {
            System.out.println("orgBosID can't be null");
        }
        this.entityTempWorkFlow.setOrgBillBosID(orgBosID);
        this.kDWorkButton1.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.kDWorkButton2.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
    }

    private void addAttachFromOrg(File file) throws Exception {
        String fullname = file.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        byte[] content = FileGetter.getBytesFromFile((File)file);
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(mainname);
        sai.setExtName(extname);
        sai.setContent(content);
        IAttachment attachment = AttachmentFactory.getRemoteInstance();
        AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAttachmentInfo((IAttachment)attachment, (String)this.workFlowID.toString(), (SimpleAttachmentInfo)sai);
        attachment.addnew(attachmentInfo).toString();
        this.initAttachmentPanel();
    }

    @Override
    public void actionAddAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentManagerFactory.getClientManager().showAttachmentListUIByBoID(this.workFlowID.toString(), (Object)this);
        this.initAttachmentPanel();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.validateParams() && TempWorkFlowManagerFactory.getRemoteInstance().addNew(this.entityTempWorkFlow)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"77_TempWorkFlowUI"));
        }
    }

    @Override
    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        if (this.validateParams()) {
            TempWorkFlowFactory.getRemoteInstance().submitWorkFlow(this.entityTempWorkFlow);
            this.getUIWindow().close();
        }
    }

    private boolean validateParams() {
        String title = this.txtWfTitle.getText();
        if (title == null || title.equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"78_TempWorkFlowUI"));
            this.txtWfTitle.requestFocus();
            return false;
        }
        this.entityTempWorkFlow.setWfTitle(title);
        String instruts = this.txtWfInstruct.getText();
        if (instruts == null || instruts.equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"79_TempWorkFlowUI"));
            this.txtWfInstruct.requestFocus();
            return false;
        }
        this.entityTempWorkFlow.setWfInstrut(instruts);
        String content = this.txtWfContent.getText();
        if (content == null || content.equals("")) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"80_TempWorkFlowUI"));
            this.txtWfContent.requestFocus();
            return false;
        }
        this.entityTempWorkFlow.setWfContent(content);
        this.entityTempWorkFlow.setWfDate(this.pkWfDate.getTimestamp());
        this.entityTempWorkFlow.setWfSender(this.txtWfSender.getText());
        this.entityTempWorkFlow.setWfOrigin((SystemEnum)((Object)this.txtWfOrigin.getSelectedItem()));
        return true;
    }

    private void initAttachmentPanel() {
        KDLabelContainer lalName;
        int i;
        int n = 0;
        ComplexAttachmentInfo[] attachInfos = null;
        try {
            String[] attachIDs = AttachmentManagerFactory.getClientManager().getAttachmentIDsByBoID(this.workFlowID.toString());
            n = attachIDs.length;
            attachInfos = new ComplexAttachmentInfo[n];
            ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
            cais.needMainName();
            cais.needExtName();
            cais.needID();
            for (i = 0; i < n; ++i) {
                attachInfos[i] = AttachmentManagerFactory.getClientManager().getComplexAttachmentInfo(attachIDs[i], cais);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.attachmentPanel.setLayout((LayoutManager)new FlowLayout(0));
        this.attachmentPanel.removeAll();
        for (i = 0; i < n; ++i) {
            lalName = new KDLabelContainer();
            String fileName = i + 1 + "." + attachInfos[i].getMainName();
            if (!StringUtils.isEmpty((String)attachInfos[i].getExtName())) {
                fileName = fileName + "." + attachInfos[i].getExtName();
            }
            lalName.setMaximumSize(new Dimension(fileName.length() * 8, 19));
            lalName.setPreferredSize(new Dimension(fileName.length() * 8, 19));
            lalName.setName(attachInfos[i].getId());
            lalName.setToolTipText(attachInfos[i].getMainName() + " " + attachInfos[i].getDescription());
            lalName.setBoundLabelText(fileName);
            lalName.setBoundLabelLength(fileName.length() * 2);
            lalName.setBoundLabelUnderline(true);
            lalName.addMouseListener((MouseListener)new MyMouseListener((Component)((Object)this)));
            this.attachmentPanel.add((Component)lalName);
            this.attachmentPanel.add((Component)lalName);
        }
        for (i = n; i < 9; ++i) {
            lalName = new KDLabelContainer();
            this.attachmentPanel.add((Component)lalName);
        }
        this.attachmentPanel.revalidate();
    }

    private void _setCursor(Component cp, Cursor cursor) {
        cp.setCursor(cursor);
        if (cp instanceof Container) {
            Container cc = (Container)cp;
            int n = cc.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component curComponent = cc.getComponent(i);
                if (!curComponent.isFocusable()) continue;
                this._setCursor(curComponent, cursor);
            }
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        Component owner;

        public MyMouseListener(Component owner) {
            this.owner = owner;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TempWorkFlowUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TempWorkFlowUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TempWorkFlowUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(3));
            try {
                if (e.getButton() == 1 && e.getComponent() instanceof KDLabelContainer) {
                    KDLabelContainer con = (KDLabelContainer)e.getComponent();
                    AttachmentManagerFactory.getClientManager().viewAttachment(con.getName());
                }
            }
            catch (Exception es) {
                es.printStackTrace();
            }
            finally {
                TempWorkFlowUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(0));
            }
        }
    }
}

