/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.TableXMLHelper;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CommonTablePanel;
import com.kingdee.eas.base.commonquery.client.QueryToolBar;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.config.AbstractTablePreferencesHelper;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.UserCustomConfigInfo;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.framework.config.UserXMLHelper;
import com.kingdee.eas.framework.config.client.TablePreferences;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TableListPreferencesHelper
extends AbstractTablePreferencesHelper {
    private static Logger logger = Logger.getLogger(TableListPreferencesHelper.class);
    private static final String frameworkResourceFile = "com.kingdee.eas.framework.FrameWorkResource.";
    private QuerySolutionInfo querySolutionInfo = null;
    private com.kingdee.eas.base.commonquery.UserPreferenceData userPreferenceData = null;
    private String uiName = null;
    private String queryName = null;
    private boolean isTransfer = true;
    private boolean isDefaultSolution = false;
    private boolean isInit = true;
    private boolean isSupportDynQuery = false;
    private ItemAction saveAction = null;
    private ItemAction deleteAction = null;

    public TableListPreferencesHelper(CoreUI ui) {
        this.resHelper = new ResourceBundleHelper(RESNAME);
        this.ui = ui;
    }

    @Override
    public void setQuerySolutionInfo(QuerySolutionInfo querySolutionInfo) {
        this.querySolutionInfo = querySolutionInfo;
        this.setSaveActionEnable();
        this.setDeleteActionEnable();
    }

    @Override
    public void setUserPreferenceData(com.kingdee.eas.base.commonquery.UserPreferenceData userPreferenceData) {
        this.userPreferenceData = userPreferenceData;
    }

    public void setIsSupportDynQuery(boolean isSupportDynQuery) {
        this.isSupportDynQuery = isSupportDynQuery;
    }

    public boolean isSupportDynQuery() {
        return this.isSupportDynQuery;
    }

    @Override
    public void setDefaultSolution(boolean isDefaultSolution) {
        this.isDefaultSolution = isDefaultSolution;
    }

    @Override
    public void setUiQueryName(String uiName, String queryName) {
        this.uiName = uiName;
        this.queryName = queryName;
    }

    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public void setDialog(CommonQueryDialog dialog) {
        this.dialog = dialog;
        if (dialog != null) {
            try {
                this.querySolutionInfo = dialog.getCurrentSolutionInfo();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isUiQueryNull() {
        return this.uiName == null || this.queryName == null;
    }

    @Override
    public void init() {
        if (this.ui.getClass().equals(TablePreferences.class)) {
            return;
        }
        this.findAllTables(null);
        for (String key : this.tables.keySet()) {
            KDTable table = (KDTable)this.tables.get(key);
            if (this.querySolutionInfo == null && (this.dialog == null || this.dialog.getCommonTableParams() == null)) {
                try {
                    String configXml;
                    if (!(this.ui instanceof ListUI)) break;
                    ListUI curUI = (ListUI)this.ui;
                    QuerySolutionInfo Info = this.getDefaultSolution();
                    String string = configXml = Info == null ? null : Info.getTableParams();
                    if (configXml != null) {
                        com.kingdee.eas.base.commonquery.UserPreferenceData userData = TableXMLHelper.loadPreferenceData((String)configXml);
                        curUI.applyPreference(this.querySolutionInfo, userData);
                    }
                }
                catch (Exception E) {
                    E.printStackTrace();
                }
            }
            this.addMenuToTable(table);
        }
        this.isInit = false;
    }

    @Override
    public UserCustomConfigItemData getColumnDataFromTable(KDTable tb, UserCustomConfigItemData itemData) {
        try {
            String configXml = null;
            if (!this.isInit) {
                if (this.dialog != null && this.querySolutionInfo != null && this.dialog.getCommonTableParams() != null && this.dialog.getCommonTableParams().getTableCurrentSetting() != null) {
                    this.dialog.refreshTableParams();
                    this.querySolutionInfo.setTableParams(this.dialog.getCommonTablePanel().getTableParams());
                }
                if (this.querySolutionInfo == null) {
                    this.querySolutionInfo = this.getDefaultSolution();
                } else if (!this.querySolutionInfo.getSolutionType().getValue().equals("10")) {
                    this.isTransfer = false;
                }
                String string = configXml = this.querySolutionInfo == null ? null : this.querySolutionInfo.getTableParams();
                if (this.userPreferenceData != null && this.userPreferenceData.getTableCurrentSetting() != null && (configXml == null || TableXMLHelper.loadPreferenceData((String)configXml).getTableCurrentSetting().getColumnData().size() != this.userPreferenceData.getTableCurrentSetting().getColumnData().size())) {
                    configXml = TableXMLHelper.ConfigItemDataToXml((com.kingdee.eas.base.commonquery.UserCustomConfigItemData)this.userPreferenceData.getTableCurrentSetting());
                }
            }
            if (configXml == null) {
                ListUI curUi = (ListUI)this.ui;
                configXml = Util.getTableParams((MetaDataPK)((MetaDataPK)curUi.getMainQueryPK()), (Component)((Object)curUi));
                if (this.querySolutionInfo == null) {
                    this.querySolutionInfo = new QuerySolutionInfo();
                    this.querySolutionInfo.setId(BOSUuid.create((String)"F93E381C"));
                    this.querySolutionInfo.setOwner(SysContext.getSysContext().getCurrentUserInfo().getId());
                    this.querySolutionInfo.setQueryObjectName(this.queryName);
                    this.querySolutionInfo.setParentUIName(this.uiName);
                    this.querySolutionInfo.setRowCount(1000);
                    this.querySolutionInfo.setOrgID(SysContext.getSysContext().getCurrentCtrlUnit().getId());
                    this.querySolutionInfo.setShareType(ShareTypeEnum.USER_LEVEL);
                    this.querySolutionInfo.setIsUserDefaultSolu(true);
                    this.querySolutionInfo.setSolutionType(SolutionTypeEnum.SYSTEM_SOLUTION);
                } else if (this.querySolutionInfo.getTableParams() == null) {
                    this.querySolutionInfo.setTableParams(configXml);
                }
            }
            List permissionList = new ArrayList();
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            ObjectUuidPK orgPK = null;
            if (this.ui.getUIContext().get(this.ui.getMainType()) != null) {
                orgPK = new ObjectUuidPK(((OrgUnitInfo)this.ui.getUIContext().get(this.ui.getMainType())).getId());
            }
            UserPreferenceData userData = UserXMLHelper.loadPreferenceData(configXml);
            Iterator iter = userData.getTables().keySet().iterator();
            while (iter.hasNext()) {
                UserCustomConfigItemData info = (UserCustomConfigItemData)userData.getTables().get(iter.next());
                if (info == null) continue;
                permissionList = TableListPreferencesHelper.doFieldPermission(((ListUI)this.ui).getMainQueryPK(), (IObjectPK)userPK, (IObjectPK)orgPK, tb);
                if (permissionList != null) {
                    for (int i = 0; i < permissionList.size(); ++i) {
                        String key = (String)permissionList.get(i);
                        if (key == null) continue;
                        info.getColumnData().remove(key);
                    }
                }
                for (String key : info.getColumnData().keySet()) {
                    info.getColumnData().put(key, this.string2ColumnData((String)info.getColumnData().get(key)));
                }
            }
            if (this.isTransfer) {
                this.transferConfig(tb, userData);
            }
            if (userData.getTables().size() > 0) {
                return (UserCustomConfigItemData)userData.getTables().values().toArray()[0];
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return null;
    }

    private void transferConfig(KDTable tb, UserPreferenceData userData) {
        UserCustomConfigItemData curItemConfig = null;
        if (userData.getTables().size() <= 0) {
            return;
        }
        curItemConfig = (UserCustomConfigItemData)userData.getTables().values().toArray()[0];
        Map curMapColumn = curItemConfig.getColumnData();
        UserCustomConfigItemData itemData = null;
        itemData = this.getColumnDataFromTable(tb);
        itemData = this.getGenricDataFromTable(tb, itemData);
        Map mapColumn = itemData.getColumnData();
        Map mapGenric = itemData.getGenericData();
        for (Map.Entry entry : mapColumn.entrySet()) {
            String key = (String)entry.getKey();
            if (!curMapColumn.containsKey(key)) continue;
            ColumnItemData data = (ColumnItemData)entry.getValue();
            ColumnItemData curData = (ColumnItemData)curMapColumn.get(key);
            curData.setAlign(data.getAlign());
            curData.setHidden(data.isHidden());
            curData.setIndex(data.getIndex());
            curData.setKey(data.getKey());
            curData.setLocked(data.isLocked());
            curData.setSorted(data.isSorted());
            curData.setTitle(data.getTitle());
            curData.setWidth(data.getWidth());
        }
        try {
            curItemConfig.getGenericData().put("RowHeight", mapGenric.get("RowHeight"));
            curItemConfig.getGenericData().put("RowFontSize", mapGenric.get("RowFontSize"));
            if (tb.getHeadRowCount() > 0) {
                curItemConfig.getGenericData().put("HeadFontSize", mapGenric.get("HeadFontSize"));
                curItemConfig.getGenericData().put("HeadHeight", mapGenric.get("HeadHeight"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    public UserCustomConfigItemData getColumnDataFromTable(KDTable tb) {
        return super.getColumnDataFromTable(tb, null);
    }

    @Override
    public ItemAction getActionShowPreference(KDTable table) {
        return new ActionShowPreference(table);
    }

    @Override
    public ItemAction getActionRestoreDefault(KDTable table) {
        return new ActionRestoreDefault(table);
    }

    @Override
    public ItemAction getActionSave(KDTable table) {
        this.saveAction = new ActionSave(table);
        this.setSaveActionEnable();
        return this.saveAction;
    }

    private void setSaveActionEnable() {
        if (this.saveAction != null) {
            this.saveAction.setVisible(this.querySolutionInfo != null && !this.querySolutionInfo.getSolutionType().getValue().equals("10"));
        }
    }

    @Override
    public ItemAction getActionDelete(KDTable table) {
        this.deleteAction = new ActionDelete(table);
        this.setDeleteActionEnable();
        return this.deleteAction;
    }

    private void setDeleteActionEnable() {
        if (this.deleteAction != null) {
            this.deleteAction.setVisible(this.querySolutionInfo != null && !this.querySolutionInfo.getSolutionType().getValue().equals("10"));
        }
    }

    @Override
    public UserPreferenceData getUserDataFromDB(UserCustomConfigInfo userConfigInfo) {
        return this.getUserDataFromDB();
    }

    @Override
    public UserPreferenceData getUserDataFromDB() {
        UserPreferenceData userData = null;
        try {
            if (this.querySolutionInfo == null) {
                return null;
            }
            String configXml = this.querySolutionInfo.getTableParams();
            userData = UserXMLHelper.loadPreferenceData(configXml);
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return userData;
    }

    @Override
    public void saveDataToDB(UserPreferenceData data) throws Exception {
    }

    private QuerySolutionInfo getDefaultSolution() {
        QuerySolutionInfo queryInfo = null;
        if (this.uiName == null || this.queryName == null) {
            return null;
        }
        try {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            queryInfo = iQuery.getDefaultSolution(this.uiName, this.queryName);
            if (queryInfo == null) {
                queryInfo = (QuerySolutionInfo)iQuery.getDefaultSolutionInfo(this.uiName, this.queryName);
                this.isDefaultSolution = true;
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return queryInfo;
    }

    @Override
    public UserCustomConfigItemData getDefaultUserData(KDTable t) {
        String configXml = "";
        if (!this.isDefaultSolution) {
            try {
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                QuerySolutionInfo queryInfo = (QuerySolutionInfo)iQuery.getDefaultSolutionInfo(this.uiName, this.queryName);
                configXml = queryInfo.getTableParams();
            }
            catch (Exception iQuery) {
                // empty catch block
            }
        }
        if (configXml == null || configXml.trim().equals("")) {
            if (this.uiTables.get(t) == null && t != null && !StringUtils.isEmpty((String)this.uiName)) {
                return this.defaultUserData.getTableCurrentSetting(this.uiName + "." + t.getName());
            }
            return this.defaultUserData.getTableCurrentSetting((String)this.uiTables.get(t));
        }
        try {
            UserCustomConfigItemData itemData;
            UserPreferenceData userData = UserXMLHelper.loadPreferenceData(configXml);
            if (userData != null) {
                Iterator iter = userData.getTables().keySet().iterator();
                while (iter.hasNext()) {
                    UserCustomConfigItemData info = (UserCustomConfigItemData)userData.getTables().get(iter.next());
                    if (info == null) continue;
                    for (String key : info.getColumnData().keySet()) {
                        info.getColumnData().put(key, this.string2ColumnData((String)info.getColumnData().get(key)));
                    }
                }
            }
            if ((itemData = userData.getTableCurrentSetting(t.getName())) == null) {
                itemData = userData.getTableCurrentSetting("solution");
            }
            return itemData;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void restoreDefaultSolution(KDTable tb) {
        String configXml = "";
        try {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            QuerySolutionInfo queryInfo = (QuerySolutionInfo)iQuery.getDefaultSolutionInfo(this.uiName, this.queryName);
            configXml = queryInfo.getTableParams();
        }
        catch (Exception iQuery) {
            // empty catch block
        }
        if (configXml == null || configXml.trim().equals("")) {
            this.restoreDefault(tb);
            try {
                StringWriter writer = new StringWriter();
                UserXMLHelper.saveData(this.defaultUserData, (Writer)writer, "UTF-8");
                this.querySolutionInfo.setTableParams(writer.toString());
            }
            catch (Exception writer) {}
        } else {
            try {
                UserPreferenceData userData = UserXMLHelper.loadPreferenceData(configXml);
                if (userData != null) {
                    Iterator iter = userData.getTables().keySet().iterator();
                    while (iter.hasNext()) {
                        UserCustomConfigItemData info = (UserCustomConfigItemData)userData.getTables().get(iter.next());
                        if (info == null) continue;
                        for (String key : info.getColumnData().keySet()) {
                            info.getColumnData().put(key, this.string2ColumnData((String)info.getColumnData().get(key)));
                        }
                    }
                    this.applyConfigFromData(tb, (UserCustomConfigItemData)userData.getTables().get("solution"), false);
                    this.querySolutionInfo.setTableParams(configXml);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveConfig(KDTable tb) {
        try {
            if (this.querySolutionInfo == null) {
                return;
            }
            Map curMapColumn = null;
            if (this.userPreferenceData != null) {
                com.kingdee.eas.base.commonquery.UserCustomConfigItemData curConfigItemData = this.userPreferenceData.getTableCurrentSetting();
                curMapColumn = curConfigItemData.getColumnData();
            }
            UserCustomConfigItemData itemData = null;
            itemData = this.getColumnDataFromTable(tb);
            itemData = this.getGenricDataFromTable(tb, itemData);
            com.kingdee.eas.base.commonquery.UserCustomConfigItemData queryConfigItemData = new com.kingdee.eas.base.commonquery.UserCustomConfigItemData();
            Map mapColumn = itemData.getColumnData();
            Map mapGenric = itemData.getGenericData();
            for (Map.Entry entry : mapColumn.entrySet()) {
                String key = (String)entry.getKey();
                if (curMapColumn != null && !curMapColumn.containsKey(key)) continue;
                ColumnItemData data = (ColumnItemData)entry.getValue();
                com.kingdee.eas.base.commonquery.ColumnItemData columnItem = new com.kingdee.eas.base.commonquery.ColumnItemData();
                columnItem.setAlign(data.getAlign());
                columnItem.setHidden(data.isHidden());
                columnItem.setIndex(data.getIndex());
                columnItem.setKey(data.getKey());
                columnItem.setLocked(data.isLocked());
                columnItem.setSorted(data.isSorted());
                columnItem.setTitle(data.getTitle());
                columnItem.setWidth(data.getWidth());
                queryConfigItemData.getColumnData().put(key, columnItem);
            }
            try {
                queryConfigItemData.getGenericData().put("RowHeight", mapGenric.get("RowHeight"));
                queryConfigItemData.getGenericData().put("HeadFontSize", mapGenric.get("HeadFontSize"));
                queryConfigItemData.getGenericData().put("HeadHeight", mapGenric.get("HeadHeight"));
                queryConfigItemData.getGenericData().put("RowFontSize", mapGenric.get("RowFontSize"));
            }
            catch (Exception entry) {
                // empty catch block
            }
            try {
                Method method = queryConfigItemData.getClass().getMethod("setTotalColumns", List.class);
                method.invoke((Object)queryConfigItemData, itemData.getTotalColumns());
            }
            catch (Exception e) {
                logger.error((Object)"UserCustomConfigItemData setTotalColumns error!", (Throwable)e);
            }
            com.kingdee.eas.base.commonquery.UserPreferenceData queryUserData = new com.kingdee.eas.base.commonquery.UserPreferenceData();
            queryUserData.getSolutions().put("solution", queryConfigItemData);
            StringWriter writer = new StringWriter();
            TableXMLHelper.saveData((com.kingdee.eas.base.commonquery.UserPreferenceData)queryUserData, (Writer)writer, (String)"UTF-8");
            this.querySolutionInfo.setTableParams(((Object)writer).toString());
            if (this.querySolutionInfo.getSolutionType().getValue().equals("10")) {
                this.setDefaultSolution(true);
            } else {
                this.setDefaultSolution(false);
            }
            if (this.isDefaultSolution) {
                return;
            }
            QueryToolBar.editSolutionInfo((QuerySolutionInfo)this.querySolutionInfo);
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        finally {
            if (this.dialog != null) {
                this.dialog.refreshTableParams();
            }
        }
    }

    private void saveMySolution() {
        try {
            String orgID = this.querySolutionInfo.getOrgID().toString();
            String queryObjectName = this.querySolutionInfo.getQueryObjectName();
            String parentUIName = this.querySolutionInfo.getParentUIName();
            String mySolutionName = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.MySolutionName");
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            QuerySolutionInfo newQuerySolutionInfo = iQuerySolution.getOwnerSolutionByName(orgID, queryObjectName, parentUIName, this.querySolutionInfo.getShareType(), mySolutionName);
            if (newQuerySolutionInfo == null) {
                newQuerySolutionInfo = new QuerySolutionInfo();
                newQuerySolutionInfo.setName(mySolutionName);
            }
            newQuerySolutionInfo.setOrgID(this.querySolutionInfo.getOrgID());
            newQuerySolutionInfo.setOwner(this.querySolutionInfo.getOwner());
            newQuerySolutionInfo.setQueryObjectName(queryObjectName);
            newQuerySolutionInfo.setParentUIName(parentUIName);
            newQuerySolutionInfo.setShareType(this.querySolutionInfo.getShareType());
            newQuerySolutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            newQuerySolutionInfo.setTableParams(this.querySolutionInfo.getTableParams());
            if (this.dialog != null && this.dialog.getCommonqueryPanel() != null) {
                CommonQueryPanel commonQueryPanel = this.dialog.getCommonqueryPanel();
                if (commonQueryPanel != null && commonQueryPanel.getEntityViewInfo() != null) {
                    newQuerySolutionInfo.setEntityViewInfo(commonQueryPanel.getEntityViewInfo().toString());
                } else {
                    newQuerySolutionInfo.setEntityViewInfo("");
                }
                if (commonQueryPanel != null && commonQueryPanel.getLockedEntityViewInfo() != null) {
                    newQuerySolutionInfo.setLockedEntityViewInfo(commonQueryPanel.getLockedEntityViewInfo().toString());
                } else {
                    newQuerySolutionInfo.setLockedEntityViewInfo("");
                }
                if (commonQueryPanel != null && commonQueryPanel.getDynQuerySolutionInfo() != null) {
                    newQuerySolutionInfo.setDynQuery(commonQueryPanel.getDynQuerySolutionInfo());
                }
                QueryPanelCollection queryPanelCollection = QueryToolBar.getQueryPanelCollection((CommonQueryPanel)commonQueryPanel);
                newQuerySolutionInfo.getQueryPanelInfo().addCollection(queryPanelCollection);
                if (commonQueryPanel.isDisVisiableRowCount()) {
                    newQuerySolutionInfo.setRowCount(-1);
                } else {
                    newQuerySolutionInfo.setRowCount(commonQueryPanel.getRowCount());
                }
            } else {
                newQuerySolutionInfo.setEntityViewInfo("");
                newQuerySolutionInfo.setLockedEntityViewInfo("");
                newQuerySolutionInfo.setRowCount(this.querySolutionInfo.getRowCount());
                QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
                queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.FILTER_PANEL);
                queryPanelInfo.setQuerySolution(newQuerySolutionInfo);
                newQuerySolutionInfo.getQueryPanelInfo().add(queryPanelInfo);
            }
            IObjectPK objectPK = iQuerySolution.save((CoreBaseInfo)newQuerySolutionInfo);
            if (newQuerySolutionInfo.getId() == null) {
                newQuerySolutionInfo.setId(BOSUuid.read((String)objectPK.toString()));
                iQuerySolution.saveDefaultSolution(objectPK.toString(), newQuerySolutionInfo.getParentUIName(), newQuerySolutionInfo.getQueryObjectName(), newQuerySolutionInfo.getRowCount(), true);
            }
            if (this.dialog != null) {
                this.dialog.setCurrentSolutionInfo(newQuerySolutionInfo);
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    @Override
    public void saveDelete(KDTable tb) {
        if (this.querySolutionInfo == null || this.isDefaultSolution) {
            return;
        }
        QuerySolutionInfo info = this.getDefaultSolution();
        if (info == null) {
            return;
        }
        this.querySolutionInfo.setTableParams(info.getTableParams());
        boolean bool = QueryToolBar.editSolutionInfo((QuerySolutionInfo)this.querySolutionInfo);
    }

    class ActionRestoreDefault
    extends ItemAction {
        private KDTable t;

        public ActionRestoreDefault(KDTable t) {
            this.t = t;
            String _tempStr = null;
            _tempStr = TableListPreferencesHelper.this.resHelper.getString("RestoreDefault");
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            TableListPreferencesHelper.this.restoreDefaultSolution(this.t);
            this.t.reLayoutAndPaint();
            if (TableListPreferencesHelper.this.dialog != null) {
                TableListPreferencesHelper.this.dialog.refreshTableParams();
            }
        }
    }

    class ActionDelete
    extends ItemAction {
        private KDTable t;

        public ActionDelete(KDTable t) {
            this.t = t;
            String _tempStr = TableListPreferencesHelper.this.resHelper.getString("DeleteCurrentSetting");
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            if (MsgBox.showConfirm2((String)TableListPreferencesHelper.this.resHelper.getString("DeleteInformation")) == 0) {
                TableListPreferencesHelper.this.saveDelete(this.t);
                TableListPreferencesHelper.this.restoreDefaultSolution(this.t);
                if (TableListPreferencesHelper.this.dialog != null) {
                    TableListPreferencesHelper.this.dialog.refreshTableParams();
                    if (TableListPreferencesHelper.this.querySolutionInfo != null && TableListPreferencesHelper.this.dialog.getCommonTableParams() != null && TableListPreferencesHelper.this.dialog.getCommonTableParams().getTableCurrentSetting() != null) {
                        TableListPreferencesHelper.this.querySolutionInfo.setTableParams(TableListPreferencesHelper.this.dialog.getCommonTablePanel().getTableParams());
                    }
                }
            }
        }
    }

    class ActionSave
    extends ItemAction {
        private KDTable t;

        public ActionSave(KDTable t) {
            this.t = t;
            String _tempStr = null;
            _tempStr = TableListPreferencesHelper.this.resHelper.getString("SaveCurrentSetting");
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            TableListPreferencesHelper.this.saveConfig(this.t);
        }
    }

    class ActionShowPreference
    extends ItemAction {
        private KDTable t;

        public ActionShowPreference(KDTable t) {
            this.t = t;
            String _tempStr = null;
            _tempStr = TableListPreferencesHelper.this.resHelper.getString("UITitle");
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            UIContext ctx = new UIContext((Object)TableListPreferencesHelper.this.ui);
            ctx.put((Object)"CurrentTable", (Object)this.t);
            if (TableListPreferencesHelper.this.ui != null && TableListPreferencesHelper.this.ui.gettHelper() != null) {
                ctx.put((Object)"helper", (Object)TableListPreferencesHelper.this.ui.gettHelper());
            } else {
                ctx.put((Object)"helper", (Object)TableListPreferencesHelper.this);
            }
            IUIWindow uiWindow = null;
            try {
                if (TableListPreferencesHelper.this.dialog != null && TableListPreferencesHelper.this.dialog.getUiObject() != null) {
                    ctx.put((Object)"queryInfo", (Object)MetaDataPK.create((String)TableListPreferencesHelper.this.getQueryName()));
                    ctx.put((Object)"width", (Object)String.valueOf(500));
                    ctx.put((Object)"height", (Object)String.valueOf(375));
                    ctx.put((Object)"owner", (Object)TableListPreferencesHelper.this.ui);
                    ctx.put((Object)"COMMON_QUERY_PARAM", (Object)TableListPreferencesHelper.this.dialog.getCommonQueryParam());
                    if (TableListPreferencesHelper.this.ui instanceof ListUI) {
                        ctx.put((Object)"QuerySolutionInfo", (Object)((ListUI)TableListPreferencesHelper.this.ui).getCurrentSolutionInfo());
                        ctx.put((Object)"IsSupportDynQuery", (Object)TableListPreferencesHelper.this.isSupportDynQuery());
                    }
                    ctx.put((Object)"mainOrgColl", (Object)new OrgUnitCollection());
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CommonTablePanel.class.getName(), (Map)ctx, null, OprtState.VIEW);
                    uiWindow.show();
                } else {
                    ctx.put((Object)"owner", (Object)TableListPreferencesHelper.this.ui);
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TablePreferences.class.getName(), (Map)ctx, null, OprtState.VIEW);
                    uiWindow.show();
                }
            }
            catch (UIException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            catch (Exception e2) {
                ExceptionHandler.handle((Throwable)e2);
            }
        }
    }
}

