/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.config.AbstractTablePreferencesHelper;
import com.kingdee.eas.framework.config.IObjectMultiPKBuilder;
import com.kingdee.eas.framework.config.IUserCustomConfig;
import com.kingdee.eas.framework.config.UserCustomConfigFactory;
import com.kingdee.eas.framework.config.UserCustomConfigInfo;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.framework.config.UserXMLHelper;
import com.kingdee.eas.framework.config.client.TablePreferences;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

public class TablePreferencesHelper
extends AbstractTablePreferencesHelper {
    private static Logger logger = Logger.getLogger(TablePreferencesHelper.class);
    private IObjectMultiPKBuilder pkBuilder = null;
    private boolean canSetTable = true;
    public static final String OWNER = "owner";

    public TablePreferencesHelper(CoreUI ui, IObjectMultiPKBuilder pkBuilder) {
        this.resHelper = new ResourceBundleHelper(RESNAME);
        this.ui = ui;
        this.pkBuilder = pkBuilder;
    }

    public TablePreferencesHelper(final CoreUI ui) {
        this(ui, new IObjectMultiPKBuilder(){

            @Override
            public IObjectPK buildPK() {
                ObjectMultiPK pk = new ObjectMultiPK();
                pk.setKeyValue("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
                String uiClassName = ui.getMetaDataPK().getFullName();
                pk.setKeyValue("uiClassName", (Object)uiClassName);
                return pk;
            }
        });
    }

    @Override
    public boolean isCanSetTable() {
        return this.canSetTable;
    }

    @Override
    public void setCanSetTable(boolean canSetTable) {
        this.canSetTable = canSetTable;
    }

    @Override
    public void init() {
        if (this.ui.getClass().equals(TablePreferences.class)) {
            return;
        }
        this.findAllTables(null);
        for (String key : this.tables.keySet()) {
            KDTable table = (KDTable)this.tables.get(key);
            if (this.defaultUserData != null && this.defaultUserData.getTableCurrentSetting(key) != null && this.defaultUserData.getTableCurrentSetting(key).getColumnData() != null && this.defaultUserData.getTableCurrentSetting(key).getColumnData().size() != 0) continue;
            this.defaultUserData = this.getUserDataFromUI();
        }
        if (this.tables.isEmpty()) {
            return;
        }
        UserPreferenceData userDBData = this.getUserDataFromDB();
        for (String key : this.tables.keySet()) {
            KDTable table = (KDTable)this.tables.get(key);
            try {
                this.addMenuToTable(table);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.isCanSetTable() || userDBData == null || userDBData.getTableCurrentSetting(key) == null) continue;
            this.applyConfigFromData(table, userDBData.getTableCurrentSetting(key), false);
        }
    }

    public IUserCustomConfig getBizInterface() throws Exception {
        return UserCustomConfigFactory.getRemoteInstance();
    }

    @Override
    public ItemAction getActionShowPreference(KDTable table) {
        return new ActionShowPreference(table);
    }

    @Override
    public ItemAction getActionRestoreDefault(KDTable table) {
        return new ActionRestoreDefault(table);
    }

    @Override
    public ItemAction getActionSave(KDTable table) {
        return new ActionSave(table);
    }

    @Override
    public ItemAction getActionDelete(KDTable table) {
        return new ActionDelete(table);
    }

    @Override
    public UserPreferenceData getUserDataFromDB() {
        return this.getUserDataFromDB(null);
    }

    @Override
    public UserPreferenceData getUserDataFromDB(UserCustomConfigInfo userConfigInfo) {
        UserPreferenceData userData;
        IObjectPK pk = this.pkBuilder.buildPK();
        if (userConfigInfo == null) {
            try {
                userConfigInfo = this.getBizInterface().getValue(pk);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (userConfigInfo == null || userConfigInfo.getConfigXML() == null) {
            return null;
        }
        try {
            userData = UserXMLHelper.loadPreferenceData(userConfigInfo.getConfigXML());
            for (String tableName : userData.getTables().keySet()) {
                KDTable table = (KDTable)this.tables.get(tableName);
                UserCustomConfigItemData info = (UserCustomConfigItemData)userData.getTables().get(tableName);
                if (info == null) continue;
                List permissionList = this.getPermissionList(table);
                if (permissionList != null) {
                    for (int i = 0; i < permissionList.size(); ++i) {
                        String key = (String)permissionList.get(i);
                        if (key == null) continue;
                        info.getColumnData().remove(key);
                    }
                }
                for (String key : info.getColumnData().keySet()) {
                    info.getColumnData().put(key, this.string2ColumnData((String)info.getColumnData().get(key)));
                }
            }
        }
        catch (JDOMException e1) {
            logger.error((Object)("load preference data failed:" + (Object)((Object)e1)));
            return null;
        }
        catch (IOException e1) {
            logger.error((Object)("load preference data failed:" + e1));
            return null;
        }
        if (userData.getVersion().compare(UserPreferenceData.VER_2_0_0) < 0) {
            userData = this.upgradeToVer2_0_0(userData);
            StringWriter writer = null;
            try {
                writer = new StringWriter();
                UserXMLHelper.saveData(userData, (Writer)writer, "UTF-8");
                userConfigInfo.setConfigXML(writer.toString());
                this.getBizInterface().update(pk, userConfigInfo);
            }
            catch (Exception e) {
                logger.error((Object)"update preference data error.", (Throwable)e);
            }
        }
        return userData;
    }

    @Override
    public void saveDataToDB(UserPreferenceData data) throws Exception {
        try (StringWriter writer = null;){
            writer = new StringWriter();
            UserXMLHelper.saveData(data, (Writer)writer, "UTF-8");
            IObjectPK pk = this.pkBuilder.buildPK();
            UserCustomConfigInfo userConfigInfo = new UserCustomConfigInfo();
            userConfigInfo.setUser(SysContext.getSysContext().getCurrentUserInfo());
            userConfigInfo.setUiClassName((String)pk.getKeyValue("uiClassName"));
            userConfigInfo.setConfigXML(writer.toString());
            this.getBizInterface().delete(pk);
            this.getBizInterface().addnew(userConfigInfo);
        }
    }

    @Override
    public void saveConfig(KDTable tb) {
        try {
            Map map;
            String printSetting;
            UserPreferenceData userData = this.getUserDataFromDB();
            if (userData == null) {
                userData = new UserPreferenceData();
                userData.setVersion(UserPreferenceData.VER_2_0_0);
            }
            UserCustomConfigItemData itemData = null;
            itemData = this.getColumnDataFromTable(tb, itemData);
            itemData = this.getGenricDataFromTable(tb, itemData);
            if (userData.getTableCurrentSetting(this.ui.getClass().getName() + "." + tb.getName()) != null && (printSetting = (String)(map = userData.getTableCurrentSetting(this.ui.getClass().getName() + "." + tb.getName()).getGenericData()).get("PrintSetting")) != null) {
                itemData.getGenericData().put("PrintSetting", printSetting);
            }
            if (this.uiTables.get(tb) != null) {
                userData.getTables().put(this.uiTables.get(tb), itemData);
            }
            this.saveDataToDB(userData);
        }
        catch (Exception e) {
            logger.error((Object)("save userconfig error:" + e));
        }
    }

    @Override
    public void saveDelete(KDTable tb) {
        try {
            IObjectPK pk = this.pkBuilder.buildPK();
            this.getBizInterface().delete(pk);
        }
        catch (Exception e) {
            logger.error((Object)("save userconfig error:" + e));
        }
    }

    @Override
    public void applyConfigFromData(KDTable table, UserCustomConfigItemData userData, boolean hasData) {
        EditUI editUI;
        ListUI listUI;
        KDWorkButton btnDesensitization;
        super.applyConfigFromData(table, userData, hasData);
        if (this.ui instanceof ListUI && (btnDesensitization = (listUI = (ListUI)this.ui).getBtnDesensitization()) != null && btnDesensitization.isEnabled()) {
            btnDesensitization.setVisible(table.getShowDesensitizationEyes());
        }
        if (this.ui instanceof EditUI && !(editUI = (EditUI)this.ui).getShowEyesWithoutTable()) {
            List<Component> desensitizationComponents = editUI.getDesensitizationComponents();
            boolean visible = false;
            for (Component component : desensitizationComponents) {
                if (!component.isVisible() || !(component instanceof KDTable) || !((KDTable)component).getShowDesensitizationEyes()) continue;
                visible = true;
            }
            KDWorkButton btnDesensitization2 = editUI.getBtnDesensitization();
            if (btnDesensitization2 != null && btnDesensitization2.isEnabled()) {
                btnDesensitization2.setVisible(visible);
            }
        }
    }

    class ActionRestoreDefault
    extends ItemAction {
        private KDTable t;

        public ActionRestoreDefault(KDTable t) {
            this.t = t;
            String _tempStr = null;
            _tempStr = TablePreferencesHelper.this.resHelper.getString("RestoreDefault");
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            TablePreferencesHelper.this.restoreDefault(this.t);
        }
    }

    class ActionDelete
    extends ItemAction {
        private KDTable t;

        public ActionDelete(KDTable t) {
            this.t = t;
            String _tempStr = TablePreferencesHelper.this.resHelper.getString("DeleteCurrentSetting");
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            TablePreferencesHelper.this.saveDelete(this.t);
            TablePreferencesHelper.this.restoreDefault(this.t);
        }
    }

    class ActionSave
    extends ItemAction {
        private KDTable t;

        public ActionSave(KDTable t) {
            this.t = t;
            String _tempStr = null;
            _tempStr = TablePreferencesHelper.this.resHelper.getString("SaveCurrentSetting");
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            TablePreferencesHelper.this.saveConfig(this.t);
        }
    }

    class ActionShowPreference
    extends ItemAction {
        private KDTable t;

        public ActionShowPreference(KDTable t) {
            this.t = t;
            String _tempStr = null;
            _tempStr = TablePreferencesHelper.this.resHelper.getString("UITitle");
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            if (TablePreferencesHelper.this.ui instanceof ListUI && TablePreferencesHelper.this.dialog != null && TablePreferencesHelper.this.dialog.getUiObject() != null) {
                try {
                    ((ListUI)TablePreferencesHelper.this.ui).showCommonDialogForTableSeting();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
                return;
            }
            UIContext ctx = new UIContext((Object)TablePreferencesHelper.this.ui);
            ctx.put((Object)"CurrentTable", (Object)this.t);
            ctx.put((Object)"helper", (Object)TablePreferencesHelper.this);
            ctx.put((Object)TablePreferencesHelper.OWNER, (Object)TablePreferencesHelper.this.ui);
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TablePreferences.class.getName(), (Map)ctx, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }
}

