/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.IUserCustomConfig;
import com.kingdee.eas.framework.config.IUserCustomConfigItemUI;
import com.kingdee.eas.framework.config.IUserCustomConfigLoader;
import com.kingdee.eas.framework.config.UserCustomConfigData;
import com.kingdee.eas.framework.config.UserCustomConfigItem;
import com.kingdee.eas.framework.config.UserCustomConfigLoader;
import com.kingdee.eas.framework.config.UserCustomConfigSolution;
import com.kingdee.eas.framework.config.client.AbstractPreferencesUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PreferencesUI
extends AbstractPreferencesUI {
    private KDSplitPane splitPaneMain;
    private KDSplitPane splitPaneRight;
    private KDScrollPane scrollPaneLeft;
    private KDScrollPane scrollPaneRight;
    private KDTree itemTree;
    private KDTable tableEdit;
    private KDPanel pnlBottom;
    private KDButton btnApply;
    private KDButton btnSave;
    private KDButton btnClose;
    private static final Color MAINANEL_COLOR = new Color(217, 217, 208);
    private static String RESNAME = "com.kingdee.eas.framework.config.Preferences";
    private ResourceBundleHelper resHelper;
    private JLabel lblImage;
    private KDPanel pnlButton;
    private KDTree solutionTree;
    private KDTreeView itemTreeView;
    private KDTreeView solutionTreeView;
    private IUserCustomConfigLoader config = new UserCustomConfigLoader();
    private IUserCustomConfigItemUI currentItemUI;
    private UserCustomConfigData configData;
    private CoreUI parent;
    private Map configItems;
    private DefaultKingdeeTreeNode defaultSolutionNode;
    private DefaultKingdeeTreeNode defaultItemNode;

    public PreferencesUI() throws Exception {
        this.resHelper = new ResourceBundleHelper(RESNAME);
        this.btnApply = new KDButton(this.resHelper.getString("BtnApply"));
        this.btnSave = new KDButton(this.resHelper.getString("BtnSave"));
        this.btnClose = new KDButton(EASResource.getString((String)"exit"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.parent = (CoreUI)this.getUIContext().get("Owner");
        this.initialize();
        this.initSolutionTreeView();
        this.initItemTreeView();
        this.setUITitle(this.resHelper.getString("UITitle"));
        this.itemTreeView.requestFocus();
        this.solutionTreeView.requestFocus();
    }

    private void initItemTreeView() {
        this.initItemTree();
        this.itemTreeView.setTree(this.itemTree);
        this.itemTreeView.setTitle(this.resHelper.getString("ItemTreeTitle"));
        this.itemTreeView.setPreferredSize(new Dimension(150, 1));
        this.itemTreeView.setShowButton(false);
    }

    private void initSolutionTreeView() {
        this.initSolutionTree();
        this.solutionTreeView.setTree(this.solutionTree);
        this.solutionTreeView.setPreferredSize(new Dimension(150, 1));
        this.solutionTreeView.setTitle(this.resHelper.getString("SolutionTreeTitle"));
        this.solutionTreeView.setShowButton(false);
        this.addButtonToTreeView();
    }

    private KDPanel getBottomPanel() {
        if (this.pnlBottom == null) {
            this.pnlBottom = new KDPanel();
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setColumns(1);
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(12);
            borderLayout.setVgap(8);
            this.pnlBottom.setLayout((LayoutManager)borderLayout);
            this.pnlBottom.setBackground(MAINANEL_COLOR);
            KDSeparator sp = new KDSeparator();
            this.pnlBottom.add((Component)sp, (Object)"North");
            JPanel panel_2 = new JPanel();
            BorderLayout borderLayout1 = new BorderLayout();
            borderLayout1.setHgap(12);
            borderLayout1.setVgap(8);
            panel_2.setLayout(borderLayout1);
            this.pnlBottom.add((Component)panel_2, (Object)"Center");
            JPanel panel_1 = new JPanel();
            GridLayout gridLayout_1 = new GridLayout();
            gridLayout_1.setVgap(10);
            gridLayout_1.setHgap(6);
            panel_1.setLayout(gridLayout_1);
            panel_2.add((Component)panel_1, "East");
            panel_1.setPreferredSize(new Dimension(205, 30));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreferencesUI.this.performSaveAction(e);
                }
            });
            panel_1.add((Component)this.btnSave);
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreferencesUI.this.destroyWindow();
                }
            });
            panel_1.add((Component)this.btnClose);
        }
        return this.pnlBottom;
    }

    private void performSaveAction(ActionEvent e) {
        for (int i = 0; i < this.configData.getSolutions().size(); ++i) {
            UserCustomConfigSolution solution = (UserCustomConfigSolution)this.configData.getSolutions().get(i);
            List configItemList = this.parent.getUserConfigHelper().getConfigItemList();
            for (int j = 0; j < configItemList.size(); ++j) {
                UserCustomConfigItem item = (UserCustomConfigItem)configItemList.get(j);
                if (item.getItemUI() == null || !(item.getItemUI() instanceof IUserCustomConfigItemUI)) continue;
                IUserCustomConfigItemUI itemUI = (IUserCustomConfigItemUI)((Object)item.getItemUI());
                if (!this.currentItemUI.equals(itemUI)) {
                    itemUI.setItem(this.configData, solution, item, this.parent.getUserConfigHelper());
                }
                itemUI.saveData(this.configData);
            }
        }
        try {
            this.parent.getUserConfigHelper().saveDataToDB(this.configData);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        this.destroyWindow();
    }

    private void initialize() throws BOSException {
        this.setLayout(new BorderLayout());
        this.add(this.getImgLabel(), "North");
        this.add((Component)this.getSplitPaneMain(), "Center");
        this.add((Component)this.getBottomPanel(), "South");
        this.configData = (UserCustomConfigData)this.getUIContext().get("ConfigData");
    }

    private JLabel getImgLabel() {
        if (this.lblImage == null) {
            this.lblImage = new JLabel();
            ImageIcon imgTitle = new ImageIcon(EASResource.getImage((String)"imgSetting_pic"));
            this.lblImage.setIcon(imgTitle);
        }
        return this.lblImage;
    }

    private KDSplitPane getSplitPaneMain() {
        if (this.splitPaneMain == null) {
            this.splitPaneMain = new KDSplitPane();
            this.splitPaneMain.setDividerSize(3);
            this.splitPaneMain.setDividerLocation(170);
            this.splitPaneMain.setHasDividerPointer(false);
            this.splitPaneMain.setPreferredSize(new Dimension(550, 400));
            this.splitPaneMain.add((Component)this.getScrollPaneLeft(), (Object)"left");
            this.splitPaneMain.add((Component)this.getSplitPaneRight(), (Object)"right");
        }
        return this.splitPaneMain;
    }

    private KDScrollPane getScrollPaneLeft() {
        if (this.scrollPaneLeft == null) {
            this.scrollPaneLeft = new KDScrollPane((Component)this.getSolutionTreeView());
        }
        return this.scrollPaneLeft;
    }

    private KDTreeView getSolutionTreeView() {
        if (this.solutionTreeView == null) {
            this.solutionTreeView = new KDTreeView();
        }
        return this.solutionTreeView;
    }

    private void initSolutionTree() {
        if (this.solutionTree == null) {
            this.solutionTree = new KDTree();
        }
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"");
        for (int i = 0; i < this.configData.getSolutions().size(); ++i) {
            DefaultKingdeeTreeNode childNode;
            UserCustomConfigSolution solution = (UserCustomConfigSolution)this.configData.getSolutions().get(i);
            if (solution.isSelected()) {
                this.defaultSolutionNode = childNode = new DefaultKingdeeTreeNode((Object)(solution.getName() + this.resHelper.getString("Selected")));
            } else {
                childNode = new DefaultKingdeeTreeNode((Object)solution.getName());
            }
            childNode.setUserObject((Object)solution);
            childNode.setCustomIcon(EASResource.getIcon((String)"imgTree_layoutproject"));
            root.add((MutableTreeNode)childNode);
            if (i != 0) continue;
            this.selectNode(this.solutionTree, childNode);
        }
        this.solutionTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.solutionTree.setShowCheckBox(false);
        this.solutionTree.setRootVisible(false);
        this.solutionTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (PreferencesUI.this.currentItemUI != null) {
                    DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)PreferencesUI.this.itemTree.getLastSelectedPathComponent();
                    UserCustomConfigItem item = (UserCustomConfigItem)selectedNode.getUserObject();
                    DefaultKingdeeTreeNode selectedSolutionNode = (DefaultKingdeeTreeNode)PreferencesUI.this.solutionTree.getLastSelectedPathComponent();
                    PreferencesUI.this.currentItemUI.setItem(PreferencesUI.this.configData, (UserCustomConfigSolution)selectedSolutionNode.getUserObject(), item, PreferencesUI.this.parent.getUserConfigHelper());
                }
            }
        });
    }

    private void selectNode(KDTree tree, DefaultKingdeeTreeNode node) {
        TreePath path = new TreePath(((DefaultTreeModel)tree.getModel()).getPathToRoot((TreeNode)node));
        tree.setSelectionPath(path);
    }

    private KDTreeView getItemTreeView() {
        if (this.itemTreeView == null) {
            this.itemTreeView = new KDTreeView();
        }
        return this.itemTreeView;
    }

    private void initItemTree() {
        if (this.itemTree == null) {
            this.itemTree = new KDTree();
        }
        this.configItems = (Map)this.getUIContext().get("ConfigItems");
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"");
        for (String name : this.configItems.keySet()) {
            UserCustomConfigItem item = (UserCustomConfigItem)this.configItems.get(name);
            this.addItem(root, item);
        }
        if (root.children().hasMoreElements()) {
            this.defaultItemNode = (DefaultKingdeeTreeNode)root.children().nextElement();
        }
        this.itemTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.itemTree.setShowCheckBox(false);
        this.itemTree.setRootVisible(false);
        this.itemTree.setShowsRootHandles(true);
        this.itemTree.expandAllNodes(true, (TreeNode)root);
        this.itemTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PreferencesUI.this.itemTreeValueChanged_Performed();
            }
        });
    }

    private void itemTreeValueChanged_Performed() {
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)this.itemTree.getLastSelectedPathComponent();
        if (selectedNode == null && this.defaultItemNode != null) {
            selectedNode = this.defaultItemNode;
        }
        if (selectedNode == null) {
            return;
        }
        DefaultKingdeeTreeNode selectedSolutionNode = (DefaultKingdeeTreeNode)this.solutionTree.getLastSelectedPathComponent();
        if (selectedSolutionNode == null && this.defaultSolutionNode != null) {
            selectedSolutionNode = this.defaultSolutionNode;
        }
        if (selectedSolutionNode == null) {
            return;
        }
        UserCustomConfigItem item = (UserCustomConfigItem)selectedNode.getUserObject();
        if (item.getItemUI() != null && item.getItemUI() instanceof IUserCustomConfigItemUI) {
            this.currentItemUI = (IUserCustomConfigItemUI)((Object)item.getItemUI());
            this.splitPaneRight.remove((Component)this.getTableEdit());
            this.splitPaneRight.setDividerSize(3);
            this.splitPaneRight.setDividerLocation(200);
            this.splitPaneRight.setHasDividerPointer(false);
            ((IUserCustomConfigItemUI)((Object)item.getItemUI())).setItem(this.configData, (UserCustomConfigSolution)selectedSolutionNode.getUserObject(), item, this.parent.getUserConfigHelper());
            this.splitPaneRight.add((Component)((Object)item.getItemUI()), (Object)"right");
        }
    }

    private void addItem(DefaultKingdeeTreeNode node, UserCustomConfigItem item) {
        DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)item.getDesc());
        childNode.setUserObject((Object)item);
        childNode.setCustomIcon(EASResource.getIcon((String)"imgTree_layoutproject"));
        node.add((MutableTreeNode)childNode);
        if (this.itemTree.getSelectionCount() == 0) {
            this.selectNode(this.itemTree, childNode);
        }
        if (item.getSubItems().size() > 0) {
            for (int i = 0; i < item.getSubItems().size(); ++i) {
                UserCustomConfigItem subItem = (UserCustomConfigItem)item.getSubItems().get(i);
                this.addItem(childNode, subItem);
            }
        }
    }

    private void addButtonToTreeView() {
        AbstractAction actNew = new AbstractAction("", EASResource.getIcon((String)"imgTbtn_new")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        AbstractAction actEdit = new AbstractAction("", EASResource.getIcon((String)"imgTbtn_edit")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        AbstractAction actDel = new AbstractAction("", EASResource.getIcon((String)"imgTbtn_delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        JPopupMenu menu = this.solutionTree.getPopupMenu();
        EventListener[] ls = this.solutionTree.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            this.solutionTree.addTreePopupMenu(new TreePopupMenuListener(){

                public boolean popMenu(TreePopupMenuEvent event) {
                    return false;
                }
            });
            this.solutionTree.setShowPopMenuDefaultItem(false);
            JMenuItem itemAdd = new JMenuItem(actNew);
            itemAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
            menu.add(itemAdd);
            JMenuItem itemEdit = new JMenuItem(actEdit);
            itemEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
            menu.add(itemEdit);
            JMenuItem itemRemove = new JMenuItem(actDel);
            itemRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
            menu.add(itemRemove);
        }
    }

    private KDScrollPane getScrollPaneRight() {
        if (this.scrollPaneRight == null) {
            this.scrollPaneRight = new KDScrollPane((Component)this.getItemTreeView());
        }
        return this.scrollPaneRight;
    }

    private KDSplitPane getSplitPaneRight() {
        if (this.splitPaneRight == null) {
            this.splitPaneRight = new KDSplitPane();
            this.splitPaneRight.setDividerSize(3);
            this.splitPaneRight.setDividerLocation(200);
            this.splitPaneRight.setHasDividerPointer(false);
            this.splitPaneRight.add((Component)this.getScrollPaneRight(), (Object)"left");
            this.splitPaneRight.add((Component)this.getTableEdit(), (Object)"right");
        }
        return this.splitPaneRight;
    }

    private KDTable getTableEdit() {
        if (this.tableEdit == null) {
            this.tableEdit = new KDTable();
            this.tableEdit.getSelectManager().setSelectMode(1);
        }
        return this.tableEdit;
    }

    protected IUserCustomConfig getBizInterface() throws Exception {
        return this.parent.getUserConfigHelper().getBizInterface();
    }
}

