/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.SelectException;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class QuickSearchItems {
    private static final String KEY_QUICKSEARCH = "QuickSearchItems";
    private static Logger logger = Logger.getLogger(QuickSearchItems.class);
    private static final String NO_ONE_ITEM = "[no one item]";
    private static final String KEY_BIZDATE = "bizDateField";
    private String bizDateField;

    public Object[] getDefaultQuickSearchItems(IMetaDataPK metaDataPK) throws BOSException {
        List<SimplePropertyUnit> fields = this.getFieldQuickSearchList(metaDataPK);
        if (fields.size() == 0) {
            return new Object[]{new FilterItemCollection(), new String[0], this.bizDateField};
        }
        FilterItemCollection collection = new FilterItemCollection();
        String[] signs = new String[fields.size()];
        int i = 0;
        for (SimplePropertyUnit field : fields) {
            if (!ConstDataType.STRING.equals((Object)field.getReturnType())) continue;
            CompareType type = CompareType.LIKE;
            String compareValue = "%*%";
            FilterItemInfo item = new FilterItemInfo(field.getName(), (Object)compareValue, type);
            collection.add(item);
            signs[i++] = "LIKE";
            if (i != 5) continue;
            break;
        }
        Object[] results = new Object[]{collection, signs, this.bizDateField};
        return results;
    }

    private List<SimplePropertyUnit> getFieldQuickSearchList(IMetaDataPK metaDataPK) throws BOSException {
        ArrayList<SimplePropertyUnit> results = new ArrayList<SimplePropertyUnit>();
        if (metaDataPK == null) {
            return results;
        }
        SimpleQuery query = this.getSimpleQuery(metaDataPK);
        this.bizDateField = query.getExtendedProperty(KEY_BIZDATE);
        SimplePropertyUnitCollection col = query.propertyUnits();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            String property = col.get(i).getExtendedProperty("isQuickSearchField");
            if (property == null || property.equals("") || !Boolean.valueOf(property).booleanValue()) continue;
            results.add(col.get(i));
        }
        return results;
    }

    private SimpleQuery getSimpleQuery(IMetaDataPK metaDataPK) throws SelectException, BOSException {
        QuerySelect select = new QuerySelect(metaDataPK.getFullName());
        select.extendPropertySelect().select(KEY_BIZDATE);
        select.propertyUnitSelect().select("*", "returnType").extendPropertySelect().select("isQuickSearchField");
        SimpleQuery query = MetaDataAccessFactory.getRemoteInstance().select(select);
        return query;
    }

    public void saveQuickSearchItems(ListUI ui, FilterItemCollection collection, String[] compareSign) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < collection.size(); ++i) {
            FilterItemInfo item = collection.get(i);
            sb.append(item.getPropertyName()).append(",");
            sb.append(item.getCompareExpression()).append(",");
            sb.append(item.getCompareValue() == null ? "" : item.getCompareValue().toString());
            sb.append(",");
            sb.append(compareSign[i]);
            sb.append(";");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(NO_ONE_ITEM);
        }
        ConfigServiceUtils.saveUserConfigData(KEY_QUICKSEARCH, ui, sb.toString());
    }

    public String getBizDateFieldName(IMetaDataPK metaDataPK) {
        if (this.bizDateField != null) {
            return this.bizDateField;
        }
        try {
            SimpleQuery query = this.getSimpleQuery(metaDataPK);
            this.bizDateField = query.getExtendedProperty(KEY_BIZDATE);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.bizDateField;
    }
}

