/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.report;

import com.kingdee.eas.framework.report.IRptFilterObject;
import com.kingdee.eas.framework.report.RptFilterUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;

public class RptFilterInfo
implements Serializable {
    private static final long serialVersionUID = -6678379334104142382L;
    protected HashMap valueMap = new HashMap();
    private String rptFilterObjectClassName;

    public void setString(String key, String value) {
        this.valueMap.put(key, value);
    }

    public String getString(String key) {
        return (String)this.valueMap.get(key);
    }

    public void setStringArray(String key, String[] value) {
        this.valueMap.put(key, value);
    }

    public String[] getStringArray(String key) {
        return (String[])this.valueMap.get(key);
    }

    public void setBoolean(String key, boolean value) {
        this.valueMap.put(key, new Boolean(value));
    }

    public boolean getBoolean(String key) {
        Object value = this.valueMap.get(key);
        if (value != null) {
            return (Boolean)this.valueMap.get(key);
        }
        return false;
    }

    public void setBooleanArray(String key, boolean[] value) {
        Boolean[] bool = new Boolean[value.length];
        for (int i = 0; i < value.length; ++i) {
            bool[i] = new Boolean(value[i]);
        }
        this.valueMap.put(key, bool);
    }

    public boolean[] getBooleanArray(String key) {
        Object value = this.valueMap.get(key);
        if (value != null && value instanceof Boolean[]) {
            Boolean[] bvalue = (Boolean[])value;
            boolean[] bool = new boolean[bvalue.length];
            for (int i = 0; i < bvalue.length; ++i) {
                bool[i] = bvalue[i] != null ? bvalue[i] : false;
            }
            return bool;
        }
        return null;
    }

    public void setInt(String key, int value) {
        this.valueMap.put(key, new Integer(value));
    }

    public int getInt(String key) {
        Object obj = this.valueMap.get(key);
        if (obj != null) {
            return (Integer)obj;
        }
        return -1;
    }

    public void setIntArray(String key, int[] value) {
        Integer[] iValue = new Integer[value.length];
        for (int i = 0; i < value.length; ++i) {
            iValue[i] = new Integer(value[i]);
        }
        this.valueMap.put(key, iValue);
    }

    public int[] getIntArray(String key) {
        Object value = this.valueMap.get(key);
        if (value != null && value instanceof Integer[]) {
            Integer[] ivalue = (Integer[])value;
            int[] integer = new int[ivalue.length];
            for (int i = 0; i < ivalue.length; ++i) {
                integer[i] = ivalue[i] != null ? ivalue[i] : 0;
            }
            return integer;
        }
        return null;
    }

    public void setShort(String key, short value) {
        this.valueMap.put(key, new Short(value));
    }

    public short getShort(String key) {
        Object obj = this.valueMap.get(key);
        if (obj != null) {
            return (Short)obj;
        }
        return -1;
    }

    public void setShortArray(String key, short[] value) {
        Short[] sValue = new Short[value.length];
        for (int i = 0; i < value.length; ++i) {
            sValue[i] = new Short(value[i]);
        }
        this.valueMap.put(key, sValue);
    }

    public short[] getShortArray(String key) {
        Object value = this.valueMap.get(key);
        if (value != null && value instanceof Short[]) {
            Short[] sValue = (Short[])value;
            short[] shortvalue = new short[sValue.length];
            for (int i = 0; i < sValue.length; ++i) {
                shortvalue[i] = sValue[i] != null ? sValue[i] : (short)0;
            }
            return shortvalue;
        }
        return null;
    }

    public void setDouble(String key, double value) {
        this.valueMap.put(key, new Double(value));
    }

    public double getDouble(String key) {
        Object obj = this.valueMap.get(key);
        if (obj != null) {
            return (Double)obj;
        }
        return 0.0;
    }

    public void setDoubleArray(String key, double[] value) {
        Double[] dValue = new Double[value.length];
        for (int i = 0; i < value.length; ++i) {
            dValue[i] = new Double(value[i]);
        }
        this.valueMap.put(key, dValue);
    }

    public double[] getDoubleArray(String key) {
        Object value = this.valueMap.get(key);
        if (value != null && value instanceof Double[]) {
            Double[] dvalue = (Double[])value;
            double[] doublevalue = new double[dvalue.length];
            for (int i = 0; i < dvalue.length; ++i) {
                doublevalue[i] = dvalue[i] != null ? dvalue[i] : 0.0;
            }
            return doublevalue;
        }
        return null;
    }

    public void setBigDecimal(String key, BigDecimal value) {
        this.valueMap.put(key, value);
    }

    public BigDecimal getBigDecimal(String key) {
        return (BigDecimal)this.valueMap.get(key);
    }

    public void setObject(String key, Object value) {
        this.valueMap.put(key, RptFilterUtils.toRptFilterMapFromObject(value));
    }

    public Object getObject(String key) {
        return RptFilterUtils.toObjectFromRptFilterMap(this.valueMap.get(key));
    }

    public void setRptFilerObject(String key, IRptFilterObject value) {
        this.valueMap.put(key, value.toRptFilterInfo());
    }

    public IRptFilterObject getRptFilerObject(String key) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        RptFilterInfo map = (RptFilterInfo)this.valueMap.get(key);
        if (map != null) {
            IRptFilterObject value = (IRptFilterObject)Class.forName(map.getRptFilterObjectClassName()).newInstance();
            return value.toIRptFilerObject(map);
        }
        return null;
    }

    public void putAll(RptFilterInfo rptFilterObject) {
        this.valueMap.putAll(rptFilterObject.valueMap);
    }

    public String getRptFilterObjectClassName() {
        return this.rptFilterObjectClassName;
    }

    public void setRptFilterObjectClassName(String className) {
        this.rptFilterObjectClassName = className;
    }
}

