/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.util;

import com.kingdee.bos.ctrl.data.modal.DataConvertHelper;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataValueConvertor {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String STD_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String ISO_SIMPLE_DATE_FORMAT = "yyyyMMdd";
    private static final Pattern ISO_DATE_SIMPLE_PATTERN = Pattern.compile("\\d{4}\\d{2}\\d{2}");
    private static final Pattern ISO_DATE_FORMAT_PATTERN = Pattern.compile("\\d{4}\\-\\d{1,2}\\-\\d{1,2}");
    private static final Pattern ISO_DATETIME_FORMAT_PATTERN = Pattern.compile("\\d{4}\\-\\d{1,2}\\-\\d{1,2}T\\d{1,2}:\\d{1,2}:\\d{1,2}");
    private static final Pattern STD_DATETIME_FORMAT_PATTERN = Pattern.compile("\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}");

    public Object convertToRealType(Object obj, DataType dataType, String className) throws DataConvertException {
        block14: {
            if (obj == null) {
                return null;
            }
            if (dataType.equals((Object)DataType.ENUM)) {
                try {
                    Class<?> c = Class.forName(className);
                    if (IntEnum.class.isAssignableFrom(c)) {
                        Integer value = !(obj instanceof Integer) ? Integer.valueOf(obj.toString()) : (Integer)obj;
                        Method m = c.getMethod("getEnum", Integer.TYPE);
                        IntEnum e = (IntEnum)m.invoke(null, value);
                        return e;
                    }
                    if (StringEnum.class.isAssignableFrom(c)) {
                        Method m = c.getMethod("getEnum", String.class);
                        StringEnum e = (StringEnum)m.invoke(null, obj.toString());
                        return e;
                    }
                    break block14;
                }
                catch (ClassNotFoundException e) {
                    throw new DataConvertException("The datatype's className is not a valid Enum class.");
                }
                catch (SecurityException e) {
                    throw new DataConvertException((Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new DataConvertException((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new DataConvertException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new DataConvertException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new DataConvertException((Throwable)e);
                }
            }
            if (dataType.equals((Object)DataType.DECIMAL)) {
                return new BigDecimal(obj.toString());
            }
        }
        try {
            return DataConvertHelper.convertData((Object)obj, (com.kingdee.bos.ctrl.common.DataType)this.dataTypeAdapting(dataType));
        }
        catch (DataConvertHelper.DataConvertException e) {
            throw new DataConvertException((Throwable)e);
        }
    }

    public static Map<String, BizEnumValueInfo> getEnumValueMap(BizEnumInfo enumType) {
        if (enumType == null) {
            return null;
        }
        HashMap<String, BizEnumValueInfo> enumsMap = new HashMap<String, BizEnumValueInfo>();
        BizEnumValueCollection enumValues = enumType.getEnumValue();
        for (BizEnumValueInfo enumInfo : enumValues) {
            enumsMap.put(enumInfo.getString(), enumInfo);
        }
        return enumsMap;
    }

    public static Map<String, BizEnumValueInfo> getEnumValueMap(OwnPropertyInfo propertyInfo) {
        if (!DataType.ENUM.equals((Object)propertyInfo.getDataType())) {
            return null;
        }
        return DataValueConvertor.getEnumValueMap(propertyInfo.getEnumType());
    }

    public Object stringConvert(String val, DataType dataType, BizEnumInfo enumType) throws DataConvertException {
        String str = val;
        if (dataType == null) {
            dataType = DataType.OBJECTPK;
        }
        if (dataType.equals((Object)DataType.STRING)) {
            return str;
        }
        if (StringUtils.isEmpty((String)val)) {
            return null;
        }
        if (dataType.equals((Object)DataType.ENUM)) {
            Map<String, BizEnumValueInfo> enumsMap = DataValueConvertor.getEnumValueMap(enumType);
            BizEnumValueInfo enumObj2 = enumsMap.get(val);
            if (enumObj2 == null) {
                for (BizEnumValueInfo enumObj2 : enumsMap.values()) {
                    if (!enumObj2.getAlias().equals(val)) continue;
                    return enumObj2.getValue();
                }
                throw new DataConvertException(QuickFilterResources.getMessage("INVALIDENUM"));
            }
            return enumObj2.getValue();
        }
        if (dataType.equals((Object)DataType.OBJECTPK)) {
            return new ObjectStringPK(val);
        }
        if (dataType.equals((Object)DataType.DATE) || dataType.equals((Object)DataType.TIMESTAMP) || dataType.equals((Object)DataType.TIME)) {
            DateFormat dateFormat = this.getMatchDateFormat(val);
            if (dateFormat != null) {
                try {
                    return dateFormat.parse(val);
                }
                catch (ParseException parseException) {}
            }
        } else if (dataType.equals((Object)DataType.BOOLEAN)) {
            if (EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"86_DataValueConvertor").equals(val) || "1".equals(val)) {
                return Boolean.TRUE;
            }
            if (EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"87_DataValueConvertor").equals(val) || "0".equals(val)) {
                return Boolean.FALSE;
            }
            if ("true".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val)) {
                return Boolean.valueOf(val);
            }
            throw new DataConvertException(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"88_DataValueConvertor"));
        }
        try {
            return DataConvertHelper.convertData((Object)val, (com.kingdee.bos.ctrl.common.DataType)this.dataTypeAdapting(dataType));
        }
        catch (DataConvertHelper.DataConvertException e) {
            throw new DataConvertException(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"89_DataValueConvertor"));
        }
    }

    public Object stringConvert(String val, PropertyInfo propertyInfo) throws DataConvertException {
        String str = val;
        DataType dataType = propertyInfo instanceof OwnPropertyInfo ? ((OwnPropertyInfo)propertyInfo).getDataType() : DataType.OBJECTPK;
        if (dataType.equals((Object)DataType.ENUM)) {
            return this.stringConvert(val, dataType, ((OwnPropertyInfo)propertyInfo).getEnumType());
        }
        return this.stringConvert(val, dataType, null);
    }

    private DateFormat getMatchDateFormat(String val) throws DataConvertException {
        Matcher matcher = ISO_DATE_SIMPLE_PATTERN.matcher(val);
        if (matcher.matches()) {
            return new SimpleDateFormat(ISO_SIMPLE_DATE_FORMAT);
        }
        matcher = ISO_DATETIME_FORMAT_PATTERN.matcher(val);
        if (matcher.matches()) {
            return new SimpleDateFormat(ISO_DATETIME_FORMAT);
        }
        matcher = ISO_DATE_FORMAT_PATTERN.matcher(val);
        if (matcher.matches()) {
            return new SimpleDateFormat(ISO_DATE_FORMAT);
        }
        matcher = STD_DATETIME_FORMAT_PATTERN.matcher(val);
        if (matcher.matches()) {
            return new SimpleDateFormat(STD_DATETIME_FORMAT);
        }
        throw new DataConvertException(QuickFilterResources.getMessage("INVALIDDATETIME"));
    }

    com.kingdee.bos.ctrl.common.DataType dataTypeAdapting(DataType dataType) throws DataConvertException {
        if (dataType.equals((Object)DataType.STRING)) {
            return com.kingdee.bos.ctrl.common.DataType.STRING;
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return com.kingdee.bos.ctrl.common.DataType.BOOLEAN;
        }
        if (dataType.equals((Object)DataType.DECIMAL)) {
            return com.kingdee.bos.ctrl.common.DataType.DECIMAL;
        }
        if (dataType.equals((Object)DataType.DATE) || dataType.equals((Object)DataType.TIMESTAMP) || dataType.equals((Object)DataType.TIME)) {
            return com.kingdee.bos.ctrl.common.DataType.DATETIME;
        }
        if (dataType.equals((Object)DataType.INTEGER)) {
            return com.kingdee.bos.ctrl.common.DataType.INTEGER;
        }
        if (dataType.equals((Object)DataType.SHORT)) {
            return com.kingdee.bos.ctrl.common.DataType.SHORT;
        }
        if (dataType.equals((Object)DataType.LONG)) {
            return com.kingdee.bos.ctrl.common.DataType.LONG;
        }
        if (dataType.equals((Object)DataType.FLOAT)) {
            return com.kingdee.bos.ctrl.common.DataType.FLOAT;
        }
        if (dataType.equals((Object)DataType.DOUBLE)) {
            return com.kingdee.bos.ctrl.common.DataType.DOUBLE;
        }
        if (dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.CHAR)) {
            return com.kingdee.bos.ctrl.common.DataType.BYTE;
        }
        throw new DataConvertException("does not support the dataType " + dataType);
    }

    public class DataConvertException
    extends Exception {
        public DataConvertException(String arg0) {
            super(arg0);
        }

        public DataConvertException(Throwable cause) {
            super(cause);
        }
    }
}

