/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.util;

import com.kingdee.util.StringUtils;

public class Version {
    public int major;
    public int minor;
    public int mend;
    private static final String SPLIT_CHAR = ".";

    public Version() {
    }

    public Version(int major, int minor, int mend) {
        this.major = major;
        this.minor = minor;
        this.mend = mend;
    }

    public String getVerString() {
        return this.major + SPLIT_CHAR + this.minor + SPLIT_CHAR + this.mend;
    }

    public String toString() {
        return this.getVerString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version ver = (Version)obj;
            return this.major == ver.major && this.minor == ver.minor && this.mend == ver.mend;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compare(Version ver) {
        if (this.major > ver.major) {
            return 1;
        }
        if (this.major < ver.major) {
            return -1;
        }
        if (this.minor > ver.minor) {
            return 1;
        }
        if (this.minor < ver.minor) {
            return -1;
        }
        if (this.mend > ver.mend) {
            return 1;
        }
        if (this.mend < ver.mend) {
            return -1;
        }
        return 0;
    }

    public static Version parseVersion(String verStr) {
        Version ver = new Version();
        if (!StringUtils.isEmpty((String)verStr)) {
            try {
                String[] vals = StringUtils.split((String)verStr, (String)SPLIT_CHAR);
                if (vals.length > 0) {
                    ver.major = Integer.parseInt(vals[0]);
                }
                if (vals.length > 1) {
                    ver.minor = Integer.parseInt(vals[1]);
                }
                if (vals.length > 2) {
                    ver.mend = Integer.parseInt(vals[2]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ver;
    }
}

