/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.formula.kscript.debug.ui;

import com.kingdee.bos.formula.kscript.debug.DebugEnv;
import com.kingdee.bos.formula.kscript.debug.ui.DebugUI;
import com.kingdee.bos.formula.kscript.debug.ui.StringScript;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IDebugProvider;
import com.kingdee.bos.kscript.debug.IDebugRuntime;
import com.kingdee.bos.kscript.debug.IValue;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class FormulaDebugTool
implements IDebugProvider {
    public static final FormulaDebugTool localDebugProvider = new FormulaDebugTool();
    static final Logger logger = Logger.getLogger(FormulaDebugTool.class);
    private static DebugUI ui = null;
    private static boolean inited = false;

    public static synchronized DebugUI getDebugUI() {
        if (ui == null) {
            ui = new DebugUI();
            ui.setVisible(true);
        }
        return ui;
    }

    private FormulaDebugTool() {
    }

    public void debugNotify(final IDebugContext debug, final int state, final IValue value) {
        FormulaDebugTool.getDebugUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FormulaDebugTool.getDebugUI().debugNotify(debug, state, value);
            }
        });
    }

    public static void initializeLocalDebuger() {
        logger.debug((Object)"kscript debuger is initialized to local.");
        try {
            DebugEnv env = (DebugEnv)DebugEnv.registerDebuger(localDebugProvider);
            FormulaDebugTool.getDebugUI().getDebugManager().enlistDebug(null, (IDebugRuntime)env);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void debug(String formulaStr) {
        FormulaDebugTool.initUI();
        FormulaDebugTool.loadScript(formulaStr);
    }

    private static void loadScript(String formulaStr) {
        DebugUI ui = FormulaDebugTool.getDebugUI();
        try {
            ui.loadScript(new StringScript(formulaStr));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void initUI() {
        DebugUI ui = FormulaDebugTool.getDebugUI();
        if (!inited) {
            try {
                BasicConfigurator.configure();
                FormulaDebugTool.initializeLocalDebuger();
                String l1 = "javax.swing.plaf.metal.MetalLookAndFeel";
                String l2 = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                String l3 = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                String l0 = l1;
                ui.setVisible(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            inited = true;
        }
        ui.setVisible(true);
    }

    public static void main(String[] args) {
        String formulaStr = "var formula_result; \n //{bos_formula_comments_var:var_name=formula_result|var_type=|var_scope=return|var_alias=\u516c\u5f0f\u7ed3\u679c|var_desc=\u516c\u5f0f\u8fd4\u56de\u7ed3\u679c}  var __src; //{bos_formula_comments_var:var_name=__src|var_type=com.kingdee.eas.scm.sd.sale.__src|var_scope=in|var_alias=\u9500\u552e\u5408\u540c|var_desc=}  \n formula_result  =  __src.id ; \n return formula_result;";
        FormulaDebugTool.debug(formulaStr);
    }
}

