/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.builder;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.resource.BizEnumCollection;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class EnumTreeBuilder {
    public static Window getWindowForComponent(Component parentComponent) throws HeadlessException {
        if (parentComponent == null) {
            return JOptionPane.getRootFrame();
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return EnumTreeBuilder.getWindowForComponent(parentComponent.getParent());
    }

    public static DefaultTreeModel createTreeModel(BOSObjectType bosType, IMetaDataPK[] pks, DefaultKingdeeTreeNode root, boolean cutPK) {
        DefaultKingdeeTreeNode tempRoot = null;
        tempRoot = root != null ? root : new DefaultKingdeeTreeNode();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        if (pks != null) {
            for (int i = 0; i < pks.length; ++i) {
                IMetaDataPK pk = pks[i];
                if (MetaDataTypeList.PACKAGE.equals((Object)bosType)) {
                    BizEnumCollection enumCol = (BizEnumCollection)loader.getAllObjectByPackage(MetaDataTypeList.BIZENUM, pk.getPackage());
                    int size = enumCol.size();
                    for (int j = 0; j < size; ++j) {
                        BizEnumInfo bizEnum = enumCol.get(j);
                        DefaultKingdeeTreeNode pknode = null;
                        pknode = cutPK ? EnumTreeBuilder.getPKNodeByPKName(bizEnum, tempRoot) : EnumTreeBuilder.getPKNodeByPKNameNew(bizEnum, tempRoot);
                        int si = tempRoot.getChildCount();
                        boolean exist = false;
                        for (int k = 0; k < si; ++k) {
                            DefaultKingdeeTreeNode te = (DefaultKingdeeTreeNode)tempRoot.getChildAt(k);
                            if (te == null || te.getUserObject() == null || !te.getUserObject().equals(pknode.getUserObject())) continue;
                            exist = true;
                            break;
                        }
                        if (exist || pknode.getUserObject() == null) continue;
                        tempRoot.add((MutableTreeNode)pknode);
                    }
                    continue;
                }
                if (!MetaDataTypeList.BIZENUM.equals((Object)bosType)) continue;
                BizEnumInfo bizenum = (BizEnumInfo)loader.get(MetaDataTypeList.BIZENUM, pk);
                DefaultKingdeeTreeNode pknode = null;
                pknode = cutPK ? EnumTreeBuilder.getPKNodeByPKName(bizenum, tempRoot) : EnumTreeBuilder.getPKNodeByPKNameNew(bizenum, tempRoot);
                int si = tempRoot.getChildCount();
                boolean exist = false;
                for (int k = 0; k < si; ++k) {
                    DefaultKingdeeTreeNode te = (DefaultKingdeeTreeNode)tempRoot.getChildAt(k);
                    if (te == null || te.getUserObject() == null || !te.getUserObject().equals(pknode.getUserObject())) continue;
                    exist = true;
                    break;
                }
                if (exist || pknode.getUserObject() == null) continue;
                tempRoot.add((MutableTreeNode)pknode);
            }
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)tempRoot);
        return model;
    }

    public static void addEnums2Root(DefaultKingdeeTreeNode root, Vector enums) {
        if (enums != null) {
            int size = enums.size();
            for (int i = 0; i < size; ++i) {
                BizEnumInfo bizEnum = (BizEnumInfo)enums.get(i);
                DefaultKingdeeTreeNode enumNode = new DefaultKingdeeTreeNode((Object)new EnumNode(bizEnum));
                BizEnumValueCollection bevc = bizEnum.getEnumValue();
                int si = bevc.size();
                for (int j = 0; j < si; ++j) {
                    BizEnumValueInfo bevi = bevc.get(j);
                    DefaultMutableTreeNode bevinode = new DefaultMutableTreeNode(bevi);
                    enumNode.add((MutableTreeNode)bevinode);
                }
                root.add((MutableTreeNode)enumNode);
            }
        }
    }

    public static void insertEnums2Root(DefaultKingdeeTreeNode root, Vector enums) {
        if (enums != null) {
            int size = enums.size();
            for (int i = 0; i < size; ++i) {
                BizEnumInfo bizEnum = (BizEnumInfo)enums.get(i);
                EnumNode iNode = new EnumNode(bizEnum);
                boolean exist = false;
                int rS = root.getChildCount();
                for (int j = 0; j < rS; ++j) {
                    DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)root.getChildAt(j);
                    Object obj = child.getUserObject();
                    if (!(obj instanceof EnumNode) || !obj.equals(iNode)) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                DefaultKingdeeTreeNode enumNode = new DefaultKingdeeTreeNode((Object)iNode);
                BizEnumValueCollection bevc = bizEnum.getEnumValue();
                int si = bevc.size();
                for (int j = 0; j < si; ++j) {
                    BizEnumValueInfo bevi = bevc.get(j);
                    DefaultMutableTreeNode bevinode = new DefaultMutableTreeNode(bevi);
                    enumNode.add((MutableTreeNode)bevinode);
                }
                root.insert((MutableTreeNode)enumNode, 0);
            }
        }
    }

    private static DefaultKingdeeTreeNode getPKNodeByPKName(BizEnumInfo enumInfo, DefaultKingdeeTreeNode root) {
        int j;
        if (enumInfo == null || enumInfo.getPackage() == null) {
            return root;
        }
        String packageName = enumInfo.getPackage();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        DefaultKingdeeTreeNode ret = new DefaultKingdeeTreeNode();
        StringTokenizer st = new StringTokenizer(packageName, ".");
        boolean toUse = false;
        String wholepk = "";
        boolean first = true;
        DefaultKingdeeTreeNode pnode = new DefaultKingdeeTreeNode();
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!first) {
                wholepk = wholepk + ".";
            }
            wholepk = wholepk + temp;
            if (temp.equals("bos") || temp.equals("eas") || toUse) {
                if (temp.equals("eas") || temp.equals("bos")) {
                    boolean exist = false;
                    int rcc = root.getChildCount();
                    for (j = 0; j < rcc; ++j) {
                        DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)root.getChildAt(j);
                        if (!temp.equals(tempNode.getUserObject())) continue;
                        pnode = tempNode;
                        ret = tempNode;
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        ret.setUserObject((Object)temp);
                        pnode = ret;
                    }
                } else {
                    String wpk = wholepk + "." + temp;
                    IMetaDataPK newpk = MetaDataPKFactory.getMetaDataPK((String)wpk);
                    PackageInfo pkInfo = (PackageInfo)loader.get(MetaDataTypeList.PACKAGE, newpk);
                    String nodename = pkInfo.getAlias() == null ? pkInfo.getName() : pkInfo.getAlias();
                    boolean exist = false;
                    int rcc = pnode.getChildCount();
                    for (int j2 = 0; j2 < rcc; ++j2) {
                        DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)pnode.getChildAt(j2);
                        if (!nodename.equals(tempNode.getUserObject())) continue;
                        pnode = tempNode;
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)nodename);
                        pnode.add((MutableTreeNode)node);
                        pnode = node;
                    }
                }
                toUse = true;
            }
            first = false;
        }
        DefaultKingdeeTreeNode enumnode = new DefaultKingdeeTreeNode((Object)new EnumNode(enumInfo));
        BizEnumValueCollection bevc = enumInfo.getEnumValue();
        int si = bevc.size();
        for (j = 0; j < si; ++j) {
            BizEnumValueInfo bevi = bevc.get(j);
            DefaultKingdeeTreeNode evnode = new DefaultKingdeeTreeNode((Object)bevi);
            enumnode.add((MutableTreeNode)evnode);
        }
        pnode.add((MutableTreeNode)enumnode);
        return ret;
    }

    private static DefaultKingdeeTreeNode getPKNodeByPKNameNew(BizEnumInfo enumInfo, DefaultKingdeeTreeNode root) {
        if (enumInfo == null || enumInfo.getPackage() == null) {
            return root;
        }
        String packageName = enumInfo.getPackage();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String wholepk = "";
        boolean first = true;
        DefaultKingdeeTreeNode pnode = new DefaultKingdeeTreeNode();
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!first) {
                wholepk = wholepk + ".";
            } else {
                pnode = root;
            }
            wholepk = wholepk + temp;
            String wpk = wholepk + "." + temp;
            IMetaDataPK newpk = MetaDataPKFactory.getMetaDataPK((String)wpk);
            PackageInfo pkInfo = (PackageInfo)loader.get(MetaDataTypeList.PACKAGE, newpk);
            String nodename = pkInfo.getAlias() == null ? pkInfo.getName() : pkInfo.getAlias();
            boolean exist = false;
            int rcc = pnode.getChildCount();
            for (int j = 0; j < rcc; ++j) {
                DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)pnode.getChildAt(j);
                if (!nodename.equals(tempNode.getUserObject())) continue;
                pnode = tempNode;
                exist = true;
                break;
            }
            if (!exist) {
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)nodename);
                pnode.add((MutableTreeNode)node);
                pnode = node;
            }
            first = false;
        }
        DefaultKingdeeTreeNode enumnode = new DefaultKingdeeTreeNode((Object)new EnumNode(enumInfo));
        BizEnumValueCollection bevc = enumInfo.getEnumValue();
        int si = bevc.size();
        for (int j = 0; j < si; ++j) {
            BizEnumValueInfo bevi = bevc.get(j);
            DefaultKingdeeTreeNode evnode = new DefaultKingdeeTreeNode((Object)bevi);
            enumnode.add((MutableTreeNode)evnode);
        }
        pnode.add((MutableTreeNode)enumnode);
        return root;
    }

    static class EnumNode {
        BizEnumInfo enumInfo;

        public EnumNode(BizEnumInfo _enumInfo) {
            this.enumInfo = _enumInfo;
        }

        public BizEnumInfo getEnumInfo() {
            return this.enumInfo;
        }

        public void setEnumInfo(BizEnumInfo enumInfo) {
            this.enumInfo = enumInfo;
        }

        public String toString() {
            String s = this.enumInfo.getAlias();
            return s == null || s.equals("") ? this.enumInfo.getName() : s;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EnumNode)) {
                return false;
            }
            EnumNode temp = (EnumNode)obj;
            BizEnumInfo tEnum = temp.getEnumInfo();
            if (tEnum == null || this.enumInfo == null) {
                return false;
            }
            return tEnum.getPackage().equals(this.enumInfo.getPackage()) && tEnum.getName().equals(this.enumInfo.getName());
        }
    }
}

