/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.builder;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.service.formula.api.BuilderResourceUtil;
import com.kingdee.bos.service.formula.builder.TableVarInfo;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObj;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjEntity;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjMember;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjMthd;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjProp;
import com.kingdee.bos.service.formula.builder.hr.IHRObject;
import com.kingdee.bos.service.formula.engine.FormulaException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class FormulaEleInfo {
    private int eleType = -1;
    private static Object selectedEle = null;
    private EntityObjectInfo entyInfo;
    private PropertyInfo propInfo;
    boolean isLeafProp;
    private BOSObjMember objMemberRef;
    private TableVarInfo varInfo;
    private String simpleStr;
    private String constantStr;
    public static final int BAS_MATHOP_TYPE = 11;
    public static final int BAS_COMPOP_TYPE = 12;
    public static final int BAS_LOGICOP_TYPE = 13;
    public static final int BAS_LOGICEXP_TYPE = 14;
    public static final int BAS_ASSIGN_TYPE = 15;
    public static final int BAS_SBRACKET_TYPE = 16;
    public static final int BAS_BBRACKET_TYPE = 17;
    public static final int BAS_CONSTANT_TYPE = 18;
    public static final int BAS_COMMA_TYPE = 19;
    public static final int BAS_NULL_TYPE = 20;
    public static final int FUNC_TYPE = 2;
    public static final int OBJM_TYPE = 3;
    public static final int VAR_TYPE = 4;
    public static final int PropValProp_TYPE = 5;
    public static final int PropValEntity_TYPE = 6;
    private IHRObject hrEnumObject;
    private IHRObject hrObject;
    public static final int HR_ENUMTYPE = 30;
    public static final int HR_HROBJECTTYPE = 31;
    public static Vector BAS_MATHOP_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{"+", "-", "*", "/"});
    public static Vector BAS_COMPOP_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{"==", "!=", ">", ">=", "<", "<="});
    public static Vector BAS_LOGICOP_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{"and", "or", "not"});
    public static Vector BAS_LOGICOP_TYPES_STRS_2 = FormulaEleInfo.convertArrayToVector(new String[]{"&&", "||", "!"});
    public static Vector BAS_LOGICEXP_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{"if", "else if", "else"});
    public static Vector BAS_ASSIGN_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{"="});
    public static Vector BAS_SBRACKET_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{"(", ")"});
    public static Vector BAS_BBRACKET_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{"{", "}"});
    public static Vector BAS_CONSTANT_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{BuilderResourceUtil.getString("constant")});
    public static Vector BAS_COMMA_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{","});
    public static Vector BAS_NULL_TYPES_STRS = FormulaEleInfo.convertArrayToVector(new String[]{""});
    private static long groupIdSeed = 1L;
    private long groupId = -1L;
    private boolean needAddGap = true;

    private static Vector convertArrayToVector(Object[] objs) {
        Vector<Object> result = null;
        if (objs != null) {
            result = new Vector<Object>();
            for (int i = 0; i < objs.length; ++i) {
                result.add(objs[i]);
            }
        }
        return result;
    }

    public static FormulaEleInfo createConstantEle(String str) {
        FormulaEleInfo newEle = new FormulaEleInfo();
        newEle.eleType = 18;
        newEle.constantStr = str;
        return newEle;
    }

    public static FormulaEleInfo createPropValEle(EntityObjectInfo entityInfo) {
        FormulaEleInfo newEle = new FormulaEleInfo();
        newEle.eleType = 6;
        newEle.entyInfo = entityInfo;
        return newEle;
    }

    public static FormulaEleInfo createPropValEle(PropertyInfo propInfo) {
        FormulaEleInfo newEle = new FormulaEleInfo();
        newEle.eleType = 5;
        newEle.propInfo = propInfo;
        return newEle;
    }

    public static ArrayList createPropValEles(List objs) {
        int i;
        if (objs == null) {
            return null;
        }
        ArrayList<FormulaEleInfo> objEles = new ArrayList<FormulaEleInfo>();
        long ourGroupId = FormulaEleInfo.genGroupId();
        for (i = 0; i < objs.size(); ++i) {
            if (objs.get(i) instanceof MetaDataBriefInfo) {
                MetaDataBriefInfo userObject = (MetaDataBriefInfo)objs.get(i);
                String clsName = userObject.getFullName();
                String varName = clsName.substring(clsName.lastIndexOf(".") + 1);
                TableVarInfo varInfo = new TableVarInfo(varName, userObject.getAlias(), clsName, "", "in", "", 4);
                FormulaEleInfo newEle = FormulaEleInfo.createVarEle(varInfo);
                newEle.groupId = ourGroupId;
                if (i != objs.size() - 1) {
                    newEle.setNeedAddGap(false);
                }
                objEles.add(newEle);
                continue;
            }
            if (objs.get(i) instanceof PropertyInfo) {
                PropertyInfo propInfo = (PropertyInfo)objs.get(i);
                FormulaEleInfo propEle = new FormulaEleInfo();
                propEle.eleType = 5;
                propEle.propInfo = propInfo;
                propEle.groupId = ourGroupId;
                if (i < objs.size() - 1) {
                    propEle.setNeedAddGap(false);
                }
                objEles.add(propEle);
                continue;
            }
            if (!(objs.get(i) instanceof EntityObjectInfo)) continue;
            EntityObjectInfo entyInfo = (EntityObjectInfo)objs.get(i);
            FormulaEleInfo entyEle = new FormulaEleInfo();
            entyEle.eleType = 6;
            entyEle.entyInfo = entyInfo;
            entyEle.groupId = ourGroupId;
            if (i < objs.size() - 1) {
                entyEle.setNeedAddGap(false);
            }
            objEles.add(entyEle);
        }
        for (i = 0; i < objEles.size(); ++i) {
            FormulaEleInfo eleInfo = (FormulaEleInfo)objEles.get(i);
            eleInfo.isLeafProp = false;
            if (i != objEles.size() - 1) continue;
            eleInfo.isLeafProp = true;
        }
        return objEles;
    }

    public static Vector createObjEles(Vector paths) {
        if (paths == null) {
            return null;
        }
        Vector<FormulaEleInfo> objEles = new Vector<FormulaEleInfo>();
        long ourGroupId = FormulaEleInfo.genGroupId();
        for (int i = 0; i < paths.size(); ++i) {
            FormulaEleInfo newEle;
            if (paths.get(i) instanceof BOSObj) {
                BOSObj bosObj = (BOSObj)((Object)paths.get(i));
                String clsName = bosObj.getObjClassName();
                if (i < paths.size() - 1 && paths.get(i + 1) instanceof BOSObjProp) {
                    clsName = ((BOSObjEntity)bosObj).getObjPropClassName();
                }
                String varName = clsName.substring(clsName.lastIndexOf(".") + 1);
                TableVarInfo varInfo = new TableVarInfo(varName, bosObj.getAlias(), clsName, "", "in", "", 4);
                FormulaEleInfo newEle2 = FormulaEleInfo.createVarEle(varInfo);
                newEle2.groupId = ourGroupId;
                if (i != paths.size() - 1) {
                    newEle2.setNeedAddGap(false);
                }
                objEles.add(newEle2);
                continue;
            }
            if (paths.get(i) instanceof BOSObjProp) {
                BOSObjProp bosProp = (BOSObjProp)paths.get(i);
                newEle = new FormulaEleInfo();
                newEle.eleType = 3;
                newEle.objMemberRef = bosProp;
                newEle.groupId = ourGroupId;
                if (i < paths.size() - 1) {
                    newEle.setNeedAddGap(false);
                }
                objEles.add(newEle);
                continue;
            }
            if (!(paths.get(i) instanceof BOSObjMthd)) continue;
            BOSObjMthd bosMthd = (BOSObjMthd)((Object)paths.get(i));
            newEle = new FormulaEleInfo();
            newEle.eleType = 3;
            newEle.objMemberRef = bosMthd;
            newEle.groupId = ourGroupId;
            newEle.setNeedAddGap(false);
            objEles.add(newEle);
            newEle = FormulaEleInfo.createBaseEle((String)BAS_SBRACKET_TYPES_STRS.get(0));
            newEle.groupId = ourGroupId;
            objEles.add(newEle);
            newEle = FormulaEleInfo.createBaseEle((String)BAS_SBRACKET_TYPES_STRS.get(1));
            newEle.groupId = ourGroupId;
            if (i < paths.size() - 1) {
                newEle.setNeedAddGap(false);
            }
            objEles.add(newEle);
        }
        if (paths.size() < 2 || paths.get(1) instanceof BOSObjProp) {
            // empty if block
        }
        return objEles;
    }

    public static Vector cloneMultiEles() {
        if (selectedEle == null || !(selectedEle instanceof Vector)) {
            return null;
        }
        Vector<FormulaEleInfo> multiEles = new Vector<FormulaEleInfo>();
        long newGroupId = FormulaEleInfo.genGroupId();
        for (int i = 0; i < ((Vector)selectedEle).size(); ++i) {
            FormulaEleInfo currEle = (FormulaEleInfo)((Vector)selectedEle).get(i);
            FormulaEleInfo newEle = new FormulaEleInfo();
            newEle.groupId = newGroupId;
            newEle.varInfo = currEle.varInfo;
            newEle.eleType = currEle.eleType;
            newEle.needAddGap = currEle.needAddGap;
            newEle.simpleStr = currEle.simpleStr;
            newEle.objMemberRef = currEle.objMemberRef;
            multiEles.add(newEle);
        }
        return multiEles;
    }

    public static FormulaEleInfo createVarEle(TableVarInfo varInfo) {
        FormulaEleInfo newEle = new FormulaEleInfo();
        newEle.eleType = 4;
        newEle.varInfo = varInfo;
        return newEle;
    }

    public static FormulaEleInfo createBaseEle(String str) {
        FormulaEleInfo newEle = new FormulaEleInfo();
        newEle.simpleStr = str;
        if (BAS_MATHOP_TYPES_STRS.contains(str)) {
            newEle.eleType = 11;
        } else if (BAS_COMPOP_TYPES_STRS.contains(str)) {
            newEle.eleType = 12;
        } else if (BAS_LOGICOP_TYPES_STRS_2.contains(str) || BAS_LOGICOP_TYPES_STRS.contains(str)) {
            newEle.eleType = 13;
        } else if (BAS_LOGICEXP_TYPES_STRS.contains(str)) {
            newEle.eleType = 14;
        } else if (BAS_ASSIGN_TYPES_STRS.contains(str)) {
            newEle.eleType = 15;
        } else if (BAS_SBRACKET_TYPES_STRS.contains(str)) {
            newEle.eleType = 16;
        } else if (BAS_BBRACKET_TYPES_STRS.contains(str)) {
            newEle.eleType = 17;
        } else if (BAS_CONSTANT_TYPES_STRS.contains(str)) {
            newEle.eleType = 18;
        } else if (BAS_COMMA_TYPES_STRS.contains(str)) {
            newEle.eleType = 19;
        } else if (BAS_NULL_TYPES_STRS.contains(str)) {
            newEle.eleType = 20;
        }
        return newEle;
    }

    public static Vector createFuncEle(String funcName) {
        Vector<FormulaEleInfo> funcEles = new Vector<FormulaEleInfo>();
        long ourGroupId = FormulaEleInfo.genGroupId();
        FormulaEleInfo funcEle = new FormulaEleInfo();
        funcEle.simpleStr = funcName;
        funcEle.eleType = 2;
        funcEle.setNeedAddGap(false);
        funcEle.setGroupId(ourGroupId);
        funcEles.add(funcEle);
        Vector bracketStrs = BAS_SBRACKET_TYPES_STRS;
        FormulaEleInfo lBracketEle = FormulaEleInfo.createBaseEle((String)bracketStrs.get(0));
        lBracketEle.setGroupId(ourGroupId);
        funcEles.add(lBracketEle);
        FormulaEleInfo rBracketEle = FormulaEleInfo.createBaseEle((String)bracketStrs.get(1));
        rBracketEle.setGroupId(ourGroupId);
        funcEles.add(rBracketEle);
        return funcEles;
    }

    public static FormulaEleInfo createHREnumEle(IHRObject enumObject) {
        FormulaEleInfo hrEnumEle = new FormulaEleInfo();
        hrEnumEle.eleType = 30;
        hrEnumEle.hrEnumObject = enumObject;
        return hrEnumEle;
    }

    public static FormulaEleInfo createHRObjEle(IHRObject hrObj) {
        FormulaEleInfo hrObjEle = new FormulaEleInfo();
        hrObjEle.eleType = 31;
        hrObjEle.hrObject = hrObj;
        return hrObjEle;
    }

    public void setEleType(int type) {
        this.eleType = type;
    }

    public int getEleType() {
        return this.eleType;
    }

    public static void setSelectedEle(Object obj) {
        if (obj == null) {
            selectedEle = null;
        } else if (obj instanceof FormulaEleInfo) {
            selectedEle = obj;
        } else if (obj instanceof Vector) {
            selectedEle = obj;
        } else if (obj instanceof ArrayList) {
            selectedEle = obj;
        }
    }

    public static Object getSelectedEle() {
        return selectedEle;
    }

    public static String getSelectedEleDispStr() {
        if (selectedEle == null) {
            return null;
        }
        if (selectedEle instanceof FormulaEleInfo) {
            return ((FormulaEleInfo)selectedEle).getDispStr();
        }
        if (selectedEle instanceof Vector) {
            String dispStr = "";
            for (int i = 0; i < ((Vector)selectedEle).size(); ++i) {
                dispStr = dispStr + ((FormulaEleInfo)((Vector)selectedEle).get(i)).getDispStr();
            }
            return dispStr;
        }
        if (selectedEle instanceof ArrayList) {
            StringBuffer dispBuff = new StringBuffer();
            dispBuff.append("\"");
            for (int i = 0; i < ((List)selectedEle).size(); ++i) {
                dispBuff.append(((FormulaEleInfo)((List)selectedEle).get(i)).getDispStr());
            }
            dispBuff.append("\"");
            return dispBuff.toString();
        }
        return null;
    }

    public String getDispStr() {
        String dispStr = "";
        if (this.eleType == 3) {
            if (this.objMemberRef != null) {
                return "." + this.objMemberRef.getAlias();
            }
        } else if (this.eleType == 4) {
            dispStr = this.varInfo.getVarAlias();
            if (dispStr == null || dispStr.trim().equals("")) {
                dispStr = this.varInfo.getVarName();
            }
        } else if (this.eleType == 2) {
            dispStr = this.simpleStr;
        } else {
            if (this.getEleType() == 13) {
                if (BAS_LOGICOP_TYPES_STRS.indexOf(this.getSimpleStr()) > -1) {
                    return this.getSimpleStr();
                }
                int idx = BAS_LOGICOP_TYPES_STRS_2.indexOf(this.getSimpleStr());
                return (String)BAS_LOGICOP_TYPES_STRS.get(idx);
            }
            dispStr = this.eleType == 30 ? this.hrEnumObject.getAlias() : (this.eleType == 31 ? this.hrObject.getAlias() : (this.eleType == 5 ? (this.propInfo.getAlias() != null ? "." + this.propInfo.getAlias() : "." + this.propInfo.getName()) : (this.eleType == 6 ? "\"" + this.entyInfo.getAlias() : this.simpleStr)));
        }
        return dispStr;
    }

    public void setVarInfo(TableVarInfo varInfo) {
        this.varInfo = varInfo;
    }

    public TableVarInfo getVarInfo() {
        return this.varInfo;
    }

    public String getSimpleStr() {
        return this.simpleStr;
    }

    public String genFormulaStr() {
        if (this.getEleType() == 11 || this.getEleType() == 12 || this.getEleType() == 14 || this.getEleType() == 15 || this.getEleType() == 16 || this.getEleType() == 17 || this.getEleType() == 19) {
            return this.getSimpleStr();
        }
        if (this.getEleType() == 13) {
            if (BAS_LOGICOP_TYPES_STRS_2.indexOf(this.getSimpleStr()) > -1) {
                return this.getSimpleStr();
            }
            int idx = BAS_LOGICOP_TYPES_STRS.indexOf(this.getSimpleStr());
            return (String)BAS_LOGICOP_TYPES_STRS_2.get(idx);
        }
        if (this.getEleType() == 3) {
            if (this.objMemberRef != null) {
                return "." + this.objMemberRef.getName();
            }
        } else {
            if (this.getEleType() == 4) {
                return this.varInfo.getVarName();
            }
            if (this.getEleType() == 2) {
                return this.simpleStr;
            }
            if (this.getEleType() == 30) {
                if (this.hrEnumObject != null) {
                    return "\"" + this.hrEnumObject.getUuid() + "\"";
                }
            } else if (this.getEleType() == 31) {
                if (this.hrObject != null) {
                    return this.hrObject.getUuid();
                }
            } else {
                if (this.getEleType() == 5) {
                    return "." + this.propInfo.getName();
                }
                if (this.getEleType() == 6) {
                    return "\"#" + this.entyInfo.getPackage() + "#" + this.entyInfo.getName();
                }
                throw new FormulaException("not support eleType " + this.getEleType());
            }
        }
        return this.simpleStr;
    }

    public String getConstantStr() {
        return this.constantStr;
    }

    public void setObjMemberRef(BOSObjMember objMember) {
        this.objMemberRef = objMember;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long id) {
        this.groupId = id;
    }

    public static long genGroupId() {
        return groupIdSeed++;
    }

    public void setNeedAddGap(boolean need) {
        this.needAddGap = need;
    }

    public boolean isNeedAddGap() {
        return this.needAddGap;
    }

    public FormulaEleInfo cloneMe() {
        FormulaEleInfo newEle = new FormulaEleInfo();
        newEle.eleType = this.eleType;
        newEle.simpleStr = this.simpleStr;
        newEle.constantStr = this.constantStr;
        newEle.groupId = this.groupId;
        newEle.needAddGap = this.needAddGap;
        newEle.hrEnumObject = this.hrEnumObject;
        newEle.hrObject = this.hrObject;
        newEle.entyInfo = this.entyInfo;
        newEle.propInfo = this.propInfo;
        newEle.isLeafProp = this.isLeafProp;
        if (this.varInfo != null) {
            TableVarInfo newVarInfo = new TableVarInfo(this.varInfo);
            newVarInfo.setCreatedWay(this.varInfo.getCreatedWay());
            newEle.varInfo = newVarInfo;
        }
        newEle.objMemberRef = this.objMemberRef;
        return newEle;
    }
}

