/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.builder;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.service.formula.api.BuilderResourceUtil;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.bos.service.formula.builder.FormulaBuilderUtil;
import com.kingdee.bos.service.formula.builder.TableVarInfo;
import com.kingdee.bos.service.formula.builder.VarCellEditor;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSMetaTreeModelCreator;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObj;
import java.awt.Component;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class TableModelVar
extends AbstractTableModel
implements KDTEditListener {
    private Vector rows = new Vector();
    private String[] columnNames = new String[]{BuilderResourceUtil.getString("varName"), BuilderResourceUtil.getString("varAlias"), BuilderResourceUtil.getString("varType"), BuilderResourceUtil.getString("varInitial"), BuilderResourceUtil.getString("varScope"), BuilderResourceUtil.getString("varDesc")};
    private KDTable theTable = null;
    private ICell editingCell = null;

    public TableModelVar() {
        this.init();
    }

    public void init() {
        this.addVar(new TableVarInfo("formula_result", BuilderResourceUtil.getString("formulaResult"), "", "", "return", BuilderResourceUtil.getString("formulaReturnResult"), 3));
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || row > this.rows.size() - 1) {
            return null;
        }
        return ((TableVarInfo)this.rows.get(row)).getColVal(col);
    }

    public Class getColumnClass(int c) {
        if (this.getValueAt(0, c) != null) {
            return this.getValueAt(0, c).getClass();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        TableVarInfo varInfo = (TableVarInfo)this.rows.get(row);
        return !"formula_result".equals(varInfo.getVarName()) || col != 0 && col != 4;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        BOSObj bobj;
        if (value == null) {
            return;
        }
        if (col == 0 && this.getVarInfoByName((String)value) != null) {
            return;
        }
        TableVarInfo varInfo = (TableVarInfo)this.rows.get(row);
        if (!(col != 2 || value.equals(varInfo.getVarType()) || varInfo.getVarAlias() != null && varInfo.getVarAlias().trim().length() != 0 || (bobj = BOSMetaTreeModelCreator.getBOSObjFromClassName((String)value)) == null)) {
            varInfo.setVarAlias(bobj.getAlias());
        }
        if (col == 3) {
            value = FormulaBuilderUtil.confirmFormulaConstant((String)value, (Component)((Object)FormulaBuilderPanelBean.This), true);
        }
        if (col == 4 && varInfo.getVarName().equals("formula_result")) {
            value = IVarInfo.VAR_SCOPE_RETURN_DISP;
        }
        varInfo.setColVal(col, (String)value);
        this.fireTableCellUpdated(row, col);
    }

    public TableVarInfo getVarInfoByName(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!name.equals(((TableVarInfo)this.rows.get(i)).getVarName())) continue;
            return (TableVarInfo)this.rows.get(i);
        }
        return null;
    }

    public TableVarInfo getVarInfoByType(String type) {
        if (type == null) {
            return null;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            if (((TableVarInfo)this.rows.get(i)).getVarType().trim().equals("") || !((TableVarInfo)this.rows.get(i)).getVarType().equals(type)) continue;
            return (TableVarInfo)this.rows.get(i);
        }
        return null;
    }

    public TableVarInfo[] getVarInfosByType(String type) {
        Vector varInfos = new Vector();
        if (type == null) {
            return null;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            if (((TableVarInfo)this.rows.get(i)).getVarType().trim().equals("") || !((TableVarInfo)this.rows.get(i)).getVarType().equals(type)) continue;
            varInfos.add(this.rows.get(i));
        }
        TableVarInfo[] varInfoArr = new TableVarInfo[varInfos.size()];
        for (int k = 0; k < varInfoArr.length; ++k) {
            varInfoArr[k] = (TableVarInfo)varInfos.get(k);
        }
        return varInfoArr;
    }

    public TableVarInfo addVar(TableVarInfo varInfo) {
        TableVarInfo oldVarInfo1;
        if (varInfo.getCreatedWay() == 1) {
            return this.getVarInfoByName(varInfo.getVarName());
        }
        if (varInfo.getCreatedWay() == 5) {
            String theName = varInfo.getVarName();
            int idx = 1;
            while (this.getVarInfoByName(theName) != null) {
                theName = varInfo.getVarName() + idx++;
            }
            varInfo.setVarName(theName);
            this.rows.add(varInfo);
            return varInfo;
        }
        if (varInfo.getCreatedWay() == 2 || varInfo.getCreatedWay() == 3) {
            TableVarInfo oldVarInfo = this.getVarInfoByName(varInfo.getVarName());
            if (oldVarInfo != null) {
                return oldVarInfo;
            }
            this.rows.add(varInfo);
            return varInfo;
        }
        if (!this.isBasicVarType(varInfo.getVarType()) && (oldVarInfo1 = this.getVarInfoByType(varInfo.getVarType())) != null) {
            return oldVarInfo1;
        }
        this.rows.add(varInfo);
        return varInfo;
    }

    private boolean isBasicVarType(String type) {
        if (type == null) {
            return false;
        }
        return type.equals("in") || type.equals("local");
    }

    public TableVarInfo getRow(int row) {
        return (TableVarInfo)this.rows.get(row);
    }

    public Vector getVars() {
        return this.rows;
    }

    public void removeAllVars() {
        this.rows.removeAllElements();
    }

    public boolean removeVar(int idx) {
        if (idx < 0 || idx > this.rows.size() - 1) {
            return false;
        }
        this.rows.remove(idx);
        return true;
    }

    public void editStarted(KDTEditEvent arg0) {
        this.editingCell = this.theTable.getEditManager().getEditCell();
    }

    public void editStarting(KDTEditEvent arg0) {
    }

    public void editStopped(KDTEditEvent arg0) {
        this.setValueAt(arg0.getValue(), arg0.getRowIndex(), arg0.getColIndex());
        if (this.editingCell != null) {
            this.editingCell.setValue(((TableVarInfo)this.rows.get(arg0.getRowIndex())).getColVal(arg0.getColIndex()));
        }
    }

    public void editStopping(KDTEditEvent arg0) {
    }

    public void editValueChanged(KDTEditEvent arg0) {
    }

    public void setKDTable(KDTable table) {
        if (table != null) {
            this.theTable = table;
            this.theTable.addKDTEditListener((KDTEditListener)this);
            this.initKDTable();
            this.fillKDTable();
        }
    }

    private void initKDTable() {
        this.theTable.setDefaultColumnWidth(100);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            IColumn tmpCol = this.theTable.addColumn();
            if (i == 2) {
                tmpCol.setWidth(70);
            }
            if (i == 3) {
                tmpCol.setWidth(80);
            }
            if (i != 4) continue;
            tmpCol.setWidth(50);
        }
        IColumn typeCol = this.theTable.getColumn(2);
        KDComboBox comboBoxTypes = new KDComboBox();
        comboBoxTypes.setEditable(true);
        comboBoxTypes.addItem((Object)"INT");
        comboBoxTypes.addItem((Object)"LONG");
        comboBoxTypes.addItem((Object)"DOUBLE");
        comboBoxTypes.addItem((Object)"STRING");
        comboBoxTypes.addItem((Object)"BOOLEAN");
        comboBoxTypes.addItem((Object)"DATE");
        comboBoxTypes.addItem((Object)"BIGDECIMAL");
        typeCol.setEditor((ICellEditor)new VarCellEditor(comboBoxTypes));
        IColumn scopeCol = this.theTable.getColumn(4);
        KDComboBox comboBox = new KDComboBox();
        comboBox.addItem((Object)IVarInfo.VAR_SCOPE_IN_DISP);
        comboBox.addItem((Object)IVarInfo.VAR_SCOPE_LOCAL_DISP);
        scopeCol.setEditor((ICellEditor)new VarCellEditor(comboBox));
        IRow headRow = this.theTable.addHeadRow();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            headRow.getCell(i).setValue((Object)this.getColumnName(i));
        }
    }

    private void fillKDTable() {
        if (this.theTable == null) {
            return;
        }
        this.theTable.removeRows();
        for (int i = 0; i < this.rows.size(); ++i) {
            TableVarInfo varInfo = (TableVarInfo)this.rows.get(i);
            IRow newRow = this.theTable.addRow();
            for (int k = 0; k < this.getColumnCount(); ++k) {
                ICell cell = newRow.getCell(k);
                cell.setValue(varInfo.getColVal(k));
                if (this.isCellEditable(i, k)) continue;
                cell.setEditor((ICellEditor)new VarCellEditor(false));
            }
        }
    }

    public void fireDataChanged() {
        this.fillKDTable();
    }

    public void editCanceled(KDTEditEvent arg0) {
    }
}

