/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.builder.bosmeta;

import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObj;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjEntity;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjMthd;
import com.kingdee.bos.service.formula.engine.AliasTransformer;
import java.util.Vector;

public class BOSObjFacade
extends BOSObj {
    FacadeInfo facadeInfo;
    Vector bosMthds = new Vector();

    public BOSObjFacade(FacadeInfo info) {
        if (info == null) {
            return;
        }
        this.facadeInfo = info;
        this.dealMethod(this.facadeInfo.getMethods());
        for (FacadeInfo baseFacade = this.facadeInfo.getBaseFacade(); baseFacade != null; baseFacade = baseFacade.getBaseFacade()) {
            this.dealMethod(baseFacade.getMethods());
        }
    }

    private void dealMethod(MethodCollection mthds) {
        if (mthds == null) {
            return;
        }
        for (int i = 0; i < mthds.size(); ++i) {
            MethodInfo mthdInfo = mthds.get(i);
            if (this.facadeInfo.isSystemMethod(mthdInfo)) continue;
            BOSObjMthd bosMthd = new BOSObjMthd();
            bosMthd.setName(mthdInfo.getName());
            bosMthd.setAlias(mthdInfo.getAlias());
            bosMthd.setDesc(BOSObjEntity.genParamsDescHtmlStr((BusinessObjectInfo)this.facadeInfo, mthdInfo));
            String dataType = BOSObjEntity.getReturnType(mthdInfo);
            bosMthd.setType(dataType);
            if (DataType.OBJECTVALUE.toString().equalsIgnoreCase(dataType) || DataType.OBJECTCOLLECTION.toString().equalsIgnoreCase(dataType)) {
                bosMthd.setIsEntity(true);
                String metaData = mthdInfo.getMetaDataRef();
                if (metaData == null || "".equals(metaData)) {
                    metaData = this.facadeInfo.getFullName();
                }
                MetaDataPK pk = new MetaDataPK(metaData);
                bosMthd.setMetaPK(pk);
            }
            this.bosMthds.add(bosMthd);
        }
    }

    @Override
    public String getObjClassName() {
        return this.facadeInfo.getBusinessInterface();
    }

    @Override
    public BusinessObjectInfo getBizObj() {
        return this.facadeInfo;
    }

    @Override
    public void setAlias(String alias) {
        super.setAlias(AliasTransformer.propTransform(alias));
    }
}

