/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.gpt.dynamic.processor;

import com.kingdee.bos.gpt.dynamic.exception.GPTException;
import com.kingdee.bos.gpt.dynamic.processor.ArrangeTypeEnum;
import com.kingdee.bos.gpt.dynamic.processor.dto.GPTTalkRequestDTO;
import com.kingdee.bos.gpt.dynamic.processor.entity.Arrange;
import com.kingdee.bos.gpt.dynamic.processor.entity.TaskProcessInfo;
import com.kingdee.bos.gpt.dynamic.processor.entity.inputs.Inputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.outputs.Outputs;
import java.util.HashMap;
import java.util.Map;

public class GPTSkillProcessFlowEngine {
    public Map executeTask(TaskProcessInfo taskProcessInfo, GPTTalkRequestDTO dto) throws Exception {
        Map<String, Object> inputParams;
        Map result = new HashMap<String, String>();
        if (taskProcessInfo.getInputParams() != null && (inputParams = dto.getInputParams()) != null) {
            taskProcessInfo.getInputParams().putAll(inputParams);
            dto.setInputParams(taskProcessInfo.getInputParams());
        }
        while (!taskProcessInfo.isEndOrFail() && taskProcessInfo.getCurrentArrange() != null) {
            Arrange<Inputs, Outputs> arrange = taskProcessInfo.getCurrentArrange();
            if (ArrangeTypeEnum.isAutomatic(arrange.getType())) {
                result = arrange.handle(dto);
            } else if (taskProcessInfo.isSuspend()) {
                taskProcessInfo.setSuspend(false);
                arrange.transformOutputParams(dto, new HashMap<String, Object>());
            } else {
                result = arrange.handle(dto);
                taskProcessInfo.setSuspend(true);
                break;
            }
            if (result.get("errorMsg") != null) {
                taskProcessInfo.setEndOrFail(true);
                throw new GPTException(result.get("errorMsg").toString());
            }
            taskProcessInfo.next();
        }
        if (!taskProcessInfo.isEndOrFail() && taskProcessInfo.getCurrentArrange() != null) {
            taskProcessInfo.setInputParams(dto.getInputParams());
            result.put("hasNext", "true");
        }
        result.put("ocid", dto.getOcid());
        return result;
    }
}

