/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.gpt.dynamic.processor;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.gpt.dynamic.GptTaskArrangeCollection;
import com.kingdee.bos.gpt.dynamic.GptTaskArrangeInfo;
import com.kingdee.bos.gpt.dynamic.GptTaskFactory;
import com.kingdee.bos.gpt.dynamic.GptTaskInfo;
import com.kingdee.bos.gpt.dynamic.processor.ArrangeTypeEnum;
import com.kingdee.bos.gpt.dynamic.processor.GPTSkillProcessFlowEngine;
import com.kingdee.bos.gpt.dynamic.processor.dto.GPTTalkRequestDTO;
import com.kingdee.bos.gpt.dynamic.processor.entity.Arrange;
import com.kingdee.bos.gpt.dynamic.processor.entity.TaskProcessInfo;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.BackendDetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.DetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.FontDetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.GuiDetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.InputsDetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.MessageDetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.OutputDetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.PromptDetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.inputs.Inputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.inputs.InputsInputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.outputs.Outputs;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class GPTSkillProcessor {
    private static Logger log = Logger.getLogger(GPTSkillProcessor.class);
    public static Map<String, TaskProcessInfo> taskMap = new ConcurrentHashMap<String, TaskProcessInfo>();
    public static Map<String, TaskProcessInfo> taskProcessMap = new ConcurrentHashMap<String, TaskProcessInfo>();
    public static GPTSkillProcessFlowEngine flowEngine = new GPTSkillProcessFlowEngine();

    public static Map process(GPTTalkRequestDTO dto) throws Exception {
        HashMap result = new HashMap();
        if (dto.getInputParams() == null) {
            dto.setInputParams(new HashMap<String, Object>());
        }
        if (StringUtils.isEmpty((String)dto.getOcid())) {
            dto.setOcid("com-" + MD5Util.getMD5String((String)UUID.randomUUID().toString()));
            TaskProcessInfo taskProcessInfo = taskMap.get(dto.getSkillId());
            GptTaskInfo info = GptTaskFactory.getLocalInstance(dto.getCtx()).getGptTaskInfo((IObjectPK)new ObjectUuidPK(dto.getSkillId()));
            GptTaskArrangeCollection arrange = info.getArrange();
            taskProcessInfo = GPTSkillProcessor.buildSkillTaskProcess(info, dto.getCtx());
            taskMap.put(dto.getSkillId(), taskProcessInfo);
            TaskProcessInfo newTaskProcessInfo = taskProcessInfo.clone();
            taskProcessMap.put(dto.getOcid(), newTaskProcessInfo);
            return flowEngine.executeTask(newTaskProcessInfo, dto);
        }
        TaskProcessInfo taskProcessInfo = taskProcessMap.get(dto.getOcid());
        if (taskProcessInfo != null) {
            return flowEngine.executeTask(taskProcessInfo, dto);
        }
        throw new Exception("\u627e\u4e0d\u5230GTP\u4efb\u52a1");
    }

    private static TaskProcessInfo buildSkillTaskProcess(GptTaskInfo info, Context ctx) {
        TaskProcessInfo taskProcessInfo = new TaskProcessInfo();
        taskProcessInfo.setTaskId(info.getId().toString());
        taskProcessInfo.setCtx(ctx);
        taskProcessInfo.setModule(info.getModule());
        taskProcessInfo.setOrg(info.getOrg());
        taskProcessInfo.setName(info.getName());
        taskProcessInfo.setNumber(info.getNumber());
        taskProcessInfo.setArranges(GPTSkillProcessor.buildArrange(info.getArrange()));
        return taskProcessInfo;
    }

    private static List<Arrange<Inputs, Outputs>> buildArrange(GptTaskArrangeCollection coll) {
        ArrayList<Arrange<Inputs, Outputs>> arranges = new ArrayList<Arrange<Inputs, Outputs>>();
        for (int i = 0; i < coll.size(); ++i) {
            GptTaskArrangeInfo info = coll.get(i);
            ArrangeTypeEnum type = ArrangeTypeEnum.getType(info.getType(), info.getName());
            Arrange<InputsInputs, Outputs> arrange = new Arrange<InputsInputs, Outputs>();
            arrange.setId(info.getId().toString());
            arrange.setName(info.getName());
            arrange.setNumber(info.getNumber());
            arrange.setExplain(info.getExplain());
            arrange.setType(type);
            arrange.setOrder(info.getOrder());
            DetailConfig detailConfig = null;
            switch (type) {
                case INPUTS: {
                    detailConfig = new InputsDetailConfig();
                    break;
                }
                case OUTPUTS: {
                    detailConfig = new OutputDetailConfig();
                    break;
                }
                case PROMPT: {
                    detailConfig = new PromptDetailConfig();
                    break;
                }
                case BACKEND: {
                    detailConfig = new BackendDetailConfig();
                    break;
                }
                case FONT: {
                    detailConfig = new FontDetailConfig();
                    break;
                }
                case GUI: {
                    detailConfig = new GuiDetailConfig();
                    break;
                }
                case MESSAGE: {
                    detailConfig = new MessageDetailConfig();
                }
            }
            detailConfig = ((DetailConfig)detailConfig).setValueFromConfig(info.getDetailConfig());
            arrange.setDetailConfig(detailConfig);
            arranges.add(arrange);
        }
        Collections.sort(arranges, new Comparator<Arrange>(){

            @Override
            public int compare(Arrange a1, Arrange a2) {
                Integer k1 = a1.getOrder();
                Integer k2 = a2.getOrder();
                if (k1 != null && k2 != null) {
                    if (k1 instanceof Comparable) {
                        return ((Comparable)k1).compareTo(k2);
                    }
                } else {
                    if (k1 == null && k2 == null) {
                        return 0;
                    }
                    if (k1 == null) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        });
        return arranges;
    }

    public void removeTask(String skillId) {
        taskMap.remove(skillId);
    }

    public void removeProcess(String ocid) {
        taskProcessMap.remove(ocid);
    }
}

