/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.gpt.dynamic.processor.entity.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.kingdee.bos.gpt.dynamic.helper.TokenHelper;
import com.kingdee.bos.gpt.dynamic.processor.dto.GPTTalkRequestDTO;
import com.kingdee.bos.gpt.dynamic.processor.entity.config.DetailConfig;
import com.kingdee.bos.gpt.dynamic.processor.entity.inputs.PromptInputs;
import com.kingdee.bos.gpt.dynamic.processor.entity.outputs.PromptOutputs;
import com.kingdee.bos.gpt.dynamic.response.OpenAPIResponse;
import com.kingdee.bos.gpt.dynamic.response.talk.Answer;
import com.kingdee.bos.gpt.dynamic.utils.GptPropertiesUtils;
import com.kingdee.bos.gpt.dynamic.utils.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PromptDetailConfig
extends DetailConfig<PromptInputs, PromptOutputs> {
    private static Logger log = Logger.getLogger(PromptDetailConfig.class);
    private String gptPrompt;
    private String userInputFrom;

    public String getGptPrompt() {
        return this.gptPrompt;
    }

    public void setGptPrompt(String gptPrompt) {
        this.gptPrompt = gptPrompt;
    }

    public String getUserInputFrom() {
        return this.userInputFrom;
    }

    public void setUserInputFrom(String userInputFrom) {
        this.userInputFrom = userInputFrom;
    }

    @Override
    public DetailConfig<PromptInputs, PromptOutputs> setValueFromConfig(String detailConfig) {
        return (DetailConfig)JSON.parseObject((String)detailConfig, PromptDetailConfig.class);
    }

    @Override
    public Map handle(Map params, GPTTalkRequestDTO dto) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String accessToken = TokenHelper.getAccessToken();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("access_token", accessToken);
        headers.put("X-Request-Id", dto.getWebSessionId());
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("stream", false);
        requestParams.put("promptNumber", this.gptPrompt);
        if ("userInput".equalsIgnoreCase(this.userInputFrom)) {
            requestParams.put("input", dto.getInput());
        } else {
            requestParams.put("input", dto.getInputParams().get(this.userInputFrom));
        }
        requestParams.put("varParams", params);
        String responseStr = HttpUtils.httpPost(GptPropertiesUtils.getGptProperties("openApiUrl") + "/kapi/v2/gai/prompt/syncCall", requestParams, headers);
        OpenAPIResponse response = (OpenAPIResponse)JSON.parseObject((String)responseStr, (TypeReference)new TypeReference<OpenAPIResponse<Answer>>(){}, (Feature[])new Feature[0]);
        if (response == null) {
            result.put("errorMsg", "\u8bf7\u6c42GPT\u5bf9\u8bdd\u63a5\u53e3\u5f02\u5e38");
        }
        if (response.getStatus().booleanValue()) {
            String outPutString = this.replaceSpecialCharacter(((Answer)response.getData()).getLlmValue());
            result.put(((PromptOutputs)this.getOutputs().get(0)).getPromptOutputParamName(), outPutString);
            if (((PromptOutputs)this.getOutputs().get(0)).isParseJson()) {
                String result2json = this.parseGPTResult2JSON(outPutString);
                try {
                    JSONObject json = JSON.parseObject((String)result2json);
                    for (int i = 1; i < this.getOutputs().size(); ++i) {
                        PromptOutputs output = (PromptOutputs)this.getOutputs().get(i);
                        result.put(output.getPromptOutputParamName(), json.get((Object)output.getPromptOutputParamName()));
                    }
                }
                catch (JSONException e) {
                    log.error((Object)("GPTResult value is not a JSON " + result2json), (Throwable)e);
                }
            }
        } else {
            result.put("errorMsg", response.getErrMsg());
        }
        return result;
    }

    private String replaceSpecialCharacter(String llmValue) {
        Pattern pattern = Pattern.compile("<sup>([\\s\\S]*?)</sup>", 2);
        Matcher matcher = pattern.matcher(llmValue);
        if (matcher.find()) {
            llmValue = llmValue.replaceAll("<sup>([\\s\\S]*?)</sup>", "");
        }
        if ((matcher = (pattern = Pattern.compile("#{8}(,|\\d{19})*", 2)).matcher(llmValue)).find()) {
            llmValue = llmValue.replaceAll("#{8}(,|\\d{19})*", "");
        }
        return llmValue;
    }

    private String parseGPTResult2JSON(String llmValue) {
        Pattern pattern = Pattern.compile("\\{(.|\n)*(?=\\})\\}", 2);
        Matcher matcher = pattern.matcher(llmValue);
        if (matcher.find()) {
            return matcher.group();
        }
        return llmValue;
    }
}

