/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.maintain.sshTunnel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.maintain.sshTunnel.ISshTunnelUser;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelState;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelUserFactory;
import com.kingdee.bos.maintain.sshTunnel.SshTunnelUserInfo;
import com.kingdee.bos.maintain.sshTunnel.client.AbstractSshTunnelAdminUI;
import com.kingdee.bos.maintain.sshTunnel.client.SshTunnelServerConfigUI;
import com.kingdee.bos.maintain.sshTunnel.util.BatUtil;
import com.kingdee.bos.maintain.sshTunnel.util.FileUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.util.httpDownload.HttpDownloadUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class SshTunnelAdminUI
extends AbstractSshTunnelAdminUI {
    private static final Logger logger = CoreUIObject.getLogger(SshTunnelAdminUI.class);
    private String easHome = System.getProperty("EAS_HOME");
    private String sshPath = this.easHome + "/client/easssh";
    private String zipSshPath = this.easHome + "/client/download/easssh.zip";
    private String clientpath = this.easHome + "/client/";

    public SshTunnelAdminUI() throws Exception {
        this.btnAddNew.hide();
        this.btnView.hide();
        this.btnEdit.hide();
        this.btnRemove.hide();
        this.btnQuery.hide();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.getSelectManager().setSelectMode(1);
        this.CancelSshPermitBtn.setEnabled(false);
        this.setTblMainIsApply();
    }

    private void setTblMainIsApply() {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            String state = row.getCell("state").getValue().toString();
            if (!state.equals(SshTunnelState.APPLIED.toString())) continue;
            row.getCell("isApply").setValue((Object)false);
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i >= 0) {
            ICell cell;
            Object state;
            if (this.tblMain.getSelectManager().getActiveColumnIndex() == 4 && (state = (cell = this.tblMain.getRow(i).getCell("isApply")).getValue()) != null) {
                if (Boolean.parseBoolean(state.toString())) {
                    cell.setValue((Object)false);
                } else {
                    cell.setValue((Object)true);
                }
            }
            IRow row = this.tblMain.getRow(i);
            String id = row.getCell("id").getValue().toString();
            ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
            SshTunnelUserInfo info = instance.getSshTunnelUserInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getState().equals((Object)SshTunnelState.APPLIED)) {
                this.CancelSshPermitBtn.setEnabled(false);
            } else {
                this.CancelSshPermitBtn.setEnabled(true);
            }
        }
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    protected void SshServerConfigBtn_actionPerformed(ActionEvent e) throws Exception {
        super.SshServerConfigBtn_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("Owner", this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SshTunnelServerConfigUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        SshTunnelServerConfigUI ui = (SshTunnelServerConfigUI)uiWindow.getUIObject();
        uiWindow.getUIObject().setUITitle("\u7f51\u8def\u52a0\u901f\u670d\u52a1\u5668\u8bbe\u7f6e");
        uiWindow.show();
    }

    protected void AllotSshPermitBtn_actionPerformed(ActionEvent e) throws Exception {
        super.AllotSshPermitBtn_actionPerformed(e);
        ArrayList<String> sshUserList = new ArrayList<String>();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell cell = row.getCell("isApply");
            Object state = cell.getValue();
            if (state == null || !state.equals(true)) continue;
            sshUserList.add(row.getCell("id").getValue().toString());
        }
        int size = sshUserList.size();
        if (size <= 0) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5206\u914d\u6743\u9650\u7684\u7528\u6237");
        } else {
            for (int l = 0; l < size; ++l) {
                String id = (String)sshUserList.get(l);
                ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
                SshTunnelUserInfo info = instance.getSshTunnelUserInfo((IObjectPK)new ObjectUuidPK(id));
                info.setState(SshTunnelState.AUTHORIZED);
                instance.submit(info);
                this.tblMain.refresh();
                this.setTblMainIsApply();
            }
        }
    }

    protected void CancelSshPermitBtn_actionPerformed(ActionEvent e) throws Exception {
        super.CancelSshPermitBtn_actionPerformed(e);
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        if (i < 0) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u9700\u8981\u53d6\u6d88\u6743\u9650\u7684\u7528\u6237");
        } else {
            IRow row = this.tblMain.getRow(i);
            if (MsgBox.showConfirm2((String)"\u786e\u8ba4\u53d6\u6d88") == 0) {
                String id = row.getCell("id").getValue().toString();
                ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
                SshTunnelUserInfo info = instance.getSshTunnelUserInfo((IObjectPK)new ObjectUuidPK(id));
                info.setState(SshTunnelState.APPLIED);
                instance.submit(info);
                this.tblMain.refresh();
                this.setTblMainIsApply();
            }
        }
    }

    protected void ApplySshBtn_actionPerformed(ActionEvent e) throws Exception {
        super.ApplySshBtn_actionPerformed(e);
        ISshTunnelUser instance = SshTunnelUserFactory.getRemoteInstance();
        String config = instance.getSSHConfig();
        String[] ipPort = config.split("!");
        int length = ipPort.length;
        if (length != 2) {
            MsgBox.showWarning((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u6b63\u786e\u7684\u7f51\u8def\u52a0\u901f\u670d\u52a1\u5668\u4fe1\u606f\uff0c\u518d\u7533\u8bf7");
        } else if (StringUtils.isEmpty((String)ipPort[0]) || StringUtils.isEmpty((String)ipPort[1])) {
            MsgBox.showWarning((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u6b63\u786e\u7684\u7f51\u8def\u52a0\u901f\u670d\u52a1\u5668\u4fe1\u606f\uff0c\u518d\u7533\u8bf7");
        } else {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            String userNum = userInfo.getNumber();
            boolean isApply = false;
            int size = this.tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                String clientMd5;
                String serverMd5;
                IRow row = this.tblMain.getRow(i);
                String name = row.getCell("user.number").getValue().toString();
                if (!userNum.equals(name)) continue;
                File easSshFile = new File(this.sshPath);
                if (!easSshFile.exists()) {
                    HttpDownloadUtil.downloadFileFromServer((String)"download/easssh.zip");
                    FileUtil.delAndDecompress(this.zipSshPath, this.clientpath);
                } else if (!BatUtil.hasStartedSSH() && !(serverMd5 = instance.getSSHZipMd5()).equals(clientMd5 = FileUtil.getFileMd5(this.zipSshPath))) {
                    FileUtil.deleteFile(this.zipSshPath);
                    HttpDownloadUtil.downloadFileFromServer((String)"download/easssh.zip");
                    FileUtil.delAndDecompress(this.zipSshPath, this.clientpath);
                }
                MsgBox.showWarning((String)"\u5df2\u7533\u8bf7\u4f7f\u7528\u7f51\u8def\u52a0\u901f\u670d\u52a1");
                isApply = true;
                break;
            }
            if (!isApply) {
                File easSshFile = new File(this.sshPath);
                if (!easSshFile.exists()) {
                    if (HttpDownloadUtil.downloadFileFromServer((String)"download/easssh.zip") && FileUtil.decompressionFile(this.zipSshPath, this.clientpath)) {
                        this.addNewSshTunnel(instance, userInfo);
                    } else {
                        MsgBox.showError((String)"\u4e0b\u8f7d\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u914d\u4ef6\u51fa\u9519\uff0c\u8bf7\u9000\u51fa\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u548c\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38");
                    }
                } else if (!BatUtil.hasStartedSSH()) {
                    String clientMd5;
                    String serverMd5 = instance.getSSHZipMd5();
                    if (!serverMd5.equals(clientMd5 = FileUtil.getFileMd5(this.zipSshPath))) {
                        FileUtil.deleteFile(this.zipSshPath);
                        if (HttpDownloadUtil.downloadFileFromServer((String)"download/easssh.zip") && FileUtil.delAndDecompress(this.zipSshPath, this.clientpath)) {
                            this.addNewSshTunnel(instance, userInfo);
                        } else {
                            MsgBox.showError((String)"\u66f4\u65b0\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u914d\u4ef6\u51fa\u9519\uff0c\u8bf7\u9000\u51fa\u7f51\u7edc\u52a0\u901f\u670d\u52a1\u548c\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38");
                        }
                    } else {
                        this.addNewSshTunnel(instance, userInfo);
                    }
                } else {
                    this.addNewSshTunnel(instance, userInfo);
                }
            }
        }
    }

    private void addNewSshTunnel(ISshTunnelUser instance, UserInfo userInfo) throws BOSException, EASBizException {
        SshTunnelUserInfo info = new SshTunnelUserInfo();
        info.setUser(userInfo);
        info.setState(SshTunnelState.APPLIED);
        instance.submit(info);
        this.tblMain.refresh();
        this.setTblMainIsApply();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setTblMainIsApply();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }
}

