/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.maintain.sshTunnel.util;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.util.StringUtils;
import com.twmacinta.util.MD5;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final Logger logger = CoreUIObject.getLogger(FileUtil.class);
    private static final int BUFFER = 2048;
    private static String sshPath = System.getProperty("EAS_HOME") + "/server/deploy/fileserver.ear/easWebClient/download/easssh/kdeasssh_env.bat";

    public static boolean delAndDecompress(String fileName, String pathName) {
        FileUtil.deleteFile(pathName + "easssh");
        return FileUtil.decompressionFile(fileName, pathName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressionFile(String fileName, String pathName) {
        boolean isFinish = true;
        try {
            ZipFile zipFile = new ZipFile(fileName);
            Enumeration<? extends ZipEntry> enu = zipFile.entries();
            while (enu.hasMoreElements()) {
                int count;
                ZipEntry zipEntry = enu.nextElement();
                if (zipEntry.isDirectory()) {
                    new File(pathName + zipEntry.getName()).mkdirs();
                    continue;
                }
                InputStream in = zipFile.getInputStream(zipEntry);
                File file = new File(pathName + zipEntry.getName());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(file);
                byte[] array = new byte[2048];
                while ((count = in.read(array)) != -1) {
                    fos.write(array, 0, count);
                }
                in.close();
                fos.close();
            }
            zipFile.close();
        }
        catch (Exception e) {
            logger.error((Object)("decompression:" + e.toString()));
            isFinish = false;
            return isFinish;
        }
        finally {
            return isFinish;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compressionFile(String sourcePath, String zipPath, String base) {
        boolean isFinish = true;
        try {
            File sourceFile = new File(sourcePath);
            FileOutputStream fos = new FileOutputStream(zipPath);
            ZipOutputStream zos = new ZipOutputStream(fos);
            FileUtil.zip(zos, sourceFile, base);
            zos.closeEntry();
            zos.close();
        }
        catch (Exception e) {
            logger.error((Object)("compression:" + e.toString()));
            isFinish = false;
            return isFinish;
        }
        finally {
            return isFinish;
        }
    }

    private static void zip(ZipOutputStream out, File file, String base) throws Exception {
        if (file.isDirectory()) {
            File[] fl = file.listFiles();
            base = base.length() == 0 ? "" : base + File.separator;
            for (int i = 0; i < fl.length; ++i) {
                FileUtil.zip(out, fl[i], base + fl[i].getName());
            }
        } else {
            int count;
            out.putNextEntry(new ZipEntry(base));
            byte[] array = new byte[2048];
            FileInputStream in = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(in, 2048);
            while ((count = bis.read(array, 0, 2048)) != -1) {
                out.write(array, 0, count);
            }
            bis.close();
        }
    }

    public static String getFileMd5(String path) {
        String md5 = "";
        try {
            File file = new File(path);
            if (file.exists()) {
                md5 = MD5.asHex((byte[])MD5.getHash((File)file));
            }
        }
        catch (IOException e) {
            logger.error((Object)"getFileMd5 error :", (Throwable)e);
        }
        return md5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveEassshEnv(String ip, String port) {
        boolean isSucc = true;
        try {
            File sshEnvFile = new File(sshPath);
            File tmpFile = new File(sshPath + "_tmp");
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sshPath), "gb2312"));
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "gb2312"));
            String line = null;
            while ((line = br.readLine()) != null) {
                String tmp;
                if (line.contains("SSHSERVER=") && !line.contains("%") && !line.contains("#")) {
                    tmp = line.substring(line.indexOf("=") + 1, line.length());
                    line = !StringUtils.isEmpty((String)tmp) ? StringUtils.replace((String)line, (String)tmp, (String)ip) : line + ip;
                }
                if (line.contains("SSHPORT=")) {
                    tmp = line.substring(line.indexOf("=") + 1, line.length());
                    line = !StringUtils.isEmpty((String)tmp) ? StringUtils.replace((String)line, (String)tmp, (String)port) : line + port;
                }
                bw.write(line);
                bw.write("\r\n");
            }
            bw.close();
            br.close();
            File bakFile = new File(sshPath + "_bak");
            bakFile.delete();
            sshEnvFile.renameTo(bakFile);
            tmpFile.renameTo(new File(sshPath));
        }
        catch (IOException ex) {
            logger.error((Object)"kdeasssh_env.bat save error :", (Throwable)ex);
            isSucc = false;
            return isSucc;
        }
        finally {
            return isSucc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getEassshEnv(String path) {
        if (path.equalsIgnoreCase("server")) {
            path = sshPath;
        }
        ArrayList<String> ipPort = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "gb2312"));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.contains("SSHSERVER=") && !line.contains("%") && !line.contains("#")) {
                    String ip = line.substring(line.indexOf("=") + 1, line.length());
                    ipPort.add(ip);
                }
                if (!line.contains("SSHPORT=")) continue;
                String port = line.substring(line.indexOf("=") + 1, line.length());
                ipPort.add(port);
            }
            br.close();
        }
        catch (IOException ex) {
            logger.error((Object)"kdeasssh_env.bat save error :", (Throwable)ex);
        }
        finally {
            return ipPort;
        }
    }

    public static void deleteFile(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] fileList = file.listFiles();
                    if (fileList != null && fileList.length > 0) {
                        for (int i = 0; i < fileList.length; ++i) {
                            String path = fileList[i].getCanonicalPath();
                            FileUtil.deleteFile(path);
                        }
                    }
                } else {
                    file.delete();
                }
                file.delete();
            }
        }
        catch (Exception e) {
            logger.error((Object)"delete file error", (Throwable)e);
        }
    }

    public static void cpFile(File srcFile, File destFile) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), "gb2312"));
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), "gb2312"));
            char[] buf = new char[1024];
            int j = 0;
            while ((j = br.read(buf)) != -1) {
                bw.write(buf, 0, j);
            }
            br.close();
            bw.close();
        }
        catch (IOException ie) {
            logger.error((Object)"", (Throwable)ie);
        }
    }
}

