/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mbos.light.deploy.handle;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.sql.DbType;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.mbos.light.deploy.handle.HttpCheckHelper;
import com.kingdee.mbos.light.deploy.handle.ILightDeploy;
import com.kingdee.mbos.light.deploy.handle.MBosUtil;
import com.kingdee.mbos.light.deploy.handle.WXMenuUtil;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class LightDeploy
extends ORMObject
implements ILightDeploy {
    private Logger logger = Logger.getLogger((String)"com.kingdee.mbos.light.deploy.handle.LightDeploy");

    @Override
    public List deploy(Map map) {
        Map<String, String> lczsApp;
        boolean success = false;
        String message = "";
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        boolean mcloudLink = false;
        HashMap<String, String> deployMap = new HashMap<String, String>();
        deployMap.put("operation", "deployEas");
        List appMassageList = (List)map.get("appMassageList");
        String eid = (String)map.get("eid");
        String easurl = (String)map.get("easurl");
        String type = (String)map.get("type");
        try {
            String easpath = System.getProperty("EAS_HOME");
            String XTFilePath = easpath + "/server/properties/XTServiceConfig.xml";
            this.checkExitFIle(XTFilePath);
            this.editConfigXml(XTFilePath, map);
            this.mbosdeploy(map);
            deployMap.put("success", "true");
        }
        catch (Exception e) {
            deployMap.put("success", "false");
            deployMap.put("msg", "\u90e8\u7f72\u5931\u8d25:" + e.getMessage());
            this.logger.error((Object)"LightDeployHandle  deploy  failed!", (Throwable)e);
        }
        list.add(deployMap);
        HashMap<String, String> yzjMap = new HashMap<String, String>();
        yzjMap.put("operation", "checkyzj");
        String mcloudHost = "";
        if ("1".equals(type)) {
            try {
                mcloudHost = XTServiceConfig.getInstance().getXTMcloudUrl();
                mcloudLink = HttpCheckHelper.checkMcloud(mcloudHost);
                yzjMap.put("success", String.valueOf(mcloudLink));
            }
            catch (Exception e) {
                yzjMap.put("success", String.valueOf(mcloudLink));
                yzjMap.put("msg", "EAS\u670d\u52a1\u5668\u8fde\u63a5\u4e91\u4e4b\u5bb6\u5730\u5740\u5931\u8d25\uff1a" + mcloudHost + " " + e.getMessage());
            }
            list.add(yzjMap);
        }
        String mbostype = (String)map.get("mbostype");
        map.remove("appMassageList");
        if (!"0".equals(mbostype)) {
            list.add(MBosUtil.deployMbos(map));
        }
        if ("2".equals(type) && (lczsApp = this.getLczsApp(appMassageList)) != null) {
            map.put("wxcorpid", lczsApp.get("wxcorpid"));
            map.put("wxappid", lczsApp.get("wxappid"));
            map.put("wxsecret", lczsApp.get("wxsecret"));
            list.add(WXMenuUtil.createMenu(map));
        }
        return list;
    }

    private void mbosdeploy(Map map) throws IOException {
        String mbostype = (String)map.get("mbostype");
        String easpath = System.getProperty("EAS_HOME");
        String mbosfilePath = easpath + "/server/properties/mbosconfig.properties";
        HashMap<String, String> propmap = new HashMap<String, String>();
        if ("0".equals(mbostype)) {
            propmap.put("isprivate", "true");
        } else {
            propmap.put("isprivate", "false");
        }
        Properties mbosProps = this.setProps(mbosfilePath, propmap);
        if ("0".equals(mbostype)) {
            String entConfigDir = this.getProperties((String)mbosProps.get("entConfigDir"));
            String eid = (String)map.get("eid");
            HashMap<String, String> propmap1 = new HashMap<String, String>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            String dt = sdf.format(date);
            propmap1.put("eid", eid);
            propmap1.put("logLevel", "ERROR");
            String filePath = entConfigDir + eid + ".properties";
            File f = new File(filePath);
            if (!f.exists()) {
                propmap1.put("registerDate", dt);
            }
            propmap1.put("authorizationMode", "0");
            propmap1.put("lastModify", dt);
            propmap1.put("email", (String)map.get("email"));
            propmap1.put("easUrl", (String)map.get("easurl"));
            propmap1.put("allowUser", "");
            propmap1.put("telphone", (String)map.get("telphone"));
            propmap1.put("isDeveloper", "false");
            propmap1.put("companyName", "");
            this.setProps(filePath, propmap1);
            String schemeDir = this.getProperties((String)mbosProps.get("schemeDir")) + eid + "/";
            File file = new File(schemeDir);
            file.mkdirs();
        }
    }

    private String getProperties(String value) {
        if (value != null && !"".equals(value) && value.indexOf("${EAS_HOME}") > -1) {
            String eashome = System.getProperty("EAS_HOME");
            value = value.replace("${EAS_HOME}", eashome);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProps(String filePath) throws IOException {
        Properties props = new Properties();
        try (FileInputStream in = null;){
            File f = new File(filePath);
            if (f.exists()) {
                in = new FileInputStream(filePath);
                props.load(in);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties setProps(String filePath, Map<String, String> propmap) throws IOException {
        OutputStreamWriter os = null;
        FileInputStream in = null;
        FileOutputStream fo = null;
        Properties props = new Properties();
        try {
            File f = new File(filePath);
            if (f.exists()) {
                in = new FileInputStream(filePath);
                props.load(in);
                f.delete();
            }
            for (String key : propmap.keySet()) {
                String value = propmap.get(key) == null ? "" : propmap.get(key).toString();
                props.put(key, value);
            }
            f.createNewFile();
            fo = new FileOutputStream(f);
            os = new OutputStreamWriter((OutputStream)fo, "UTF-8");
            props.store(os, "");
            os.flush();
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (in != null) {
                in.close();
            }
            if (fo != null) {
                fo.close();
            }
        }
        return props;
    }

    private void checkExitFIle(String file) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
    }

    public boolean editConfigXml(String XTFilePath, Map m) throws Exception {
        String slname;
        boolean edit = false;
        edit = true;
        String eid = (String)m.get("eid");
        String dbcode = (String)m.get("dbcode");
        String dbtype = (String)m.get("dbtype");
        String type = (String)m.get("type");
        if (StringUtils.isEmpty((String)dbtype)) {
            dbtype = this.getDbType(dbcode);
        }
        if (StringUtils.isEmpty((String)(slname = (String)m.get("slname")))) {
            slname = "eas";
        }
        String cloudurl = (String)m.get("cloudurl");
        try {
            File configFile = new File(XTFilePath);
            if (configFile.exists()) {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(configFile);
                Element foo = doc.getRootElement();
                List allChildren = foo.getChildren("configitem");
                boolean hasMultiApp = false;
                for (int i = allChildren.size() - 1; i >= 0; --i) {
                    Element e = (Element)allChildren.get(i);
                    String name = e.getAttributeValue("name");
                    if ("AppSecret".equals(name)) {
                        this.checkSecret(e);
                        this.addMutilAppSecret(m, e);
                    } else if ("DbInfo".equals(name) && !StringUtils.isEmpty((String)eid)) {
                        this.checkDbinfo(eid, dbcode, dbtype, slname, e);
                    } else if ("PubAcct".equals(name) && !StringUtils.isEmpty((String)eid)) {
                        this.checkPubAcct(eid, e, m);
                    } else if ("XTInfo".equals(name)) {
                        this.checkXTInfo(cloudurl, e);
                    }
                    if (!("2".equals(type) && "WX".equals(name) || "2".equals(type) && "WXSecret".equals(name) || "3".equals(type) && "WeLink".equals(name) || "4".equals(type) && "Dingtalk".equals(name)) && (!"5".equals(type) || !"OtherApp".equals(name))) continue;
                    allChildren.remove(i);
                }
                if ("2".equals(type)) {
                    this.addWXConfig(m, foo);
                }
                if ("2".equals(type)) {
                    this.addSecretConfig(m, foo);
                }
                if ("3".equals(type)) {
                    this.addWLConfig(m, foo);
                }
                if ("4".equals(type)) {
                    this.addDTConfig(m, foo);
                }
                if ("5".equals(type)) {
                    this.addOtherConfig(m, foo);
                }
                Format format = Format.getPrettyFormat();
                format.setEncoding("UTF-8");
                format.setIndent("\t");
                XMLOutputter outputter = new XMLOutputter(format);
                outputter.output(doc, (OutputStream)new FileOutputStream(XTFilePath));
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236xml\u5185\u5bb9\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
            throw new Exception("error copyFolder: ", e);
        }
        return edit;
    }

    private void addAppSecret(Map m, Element e) {
        String value;
        String key;
        String type = (String)m.get("type");
        List appMassageList = (List)m.get("appMassageList");
        HashMap<String, String> keyAndValueMap = new HashMap<String, String>();
        if ("0".equals(type)) {
            for (Map messageMap : appMassageList) {
                key = (String)messageMap.get("yzjprivappid");
                value = (String)messageMap.get("yzjprivsecret");
                keyAndValueMap.put(key, value);
            }
        } else if ("1".equals(type)) {
            for (Map messageMap : appMassageList) {
                key = (String)messageMap.get("yzjpubappid");
                value = (String)messageMap.get("yzjpubsecret");
                keyAndValueMap.put(key, value);
            }
        } else if ("3".equals(type)) {
            for (Map messageMap : appMassageList) {
                key = (String)messageMap.get("wlclientid");
                value = (String)messageMap.get("wlclientsecret");
                keyAndValueMap.put(key, value);
            }
        } else if ("4".equals(type)) {
            for (Map messageMap : appMassageList) {
                key = (String)messageMap.get("dtappkey");
                value = (String)messageMap.get("dtappsecret");
                keyAndValueMap.put(key, value);
            }
        }
        List l = e.getChildren();
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String attr = child.getAttributeValue("key");
            if (!"10036".equals(attr) && !"10060".equals(attr)) {
                iterator.remove();
                continue;
            }
            String value36 = (String)keyAndValueMap.get("10036");
            if ("10036".equals(attr) && !StringUtils.isEmpty((String)value36)) {
                child.setAttribute("value", value36);
            }
            String value60 = (String)keyAndValueMap.get("10060");
            if (!"10060".equals(attr) || StringUtils.isEmpty((String)value60)) continue;
            child.setAttribute("value", value60);
        }
        for (Map.Entry entry : keyAndValueMap.entrySet()) {
            String entryKey = (String)entry.getKey();
            if ("10036".equals(entryKey) || "10060".equals(entryKey)) continue;
            e.addContent((Content)new Element("attribute").setAttribute("key", (String)entry.getKey()).setAttribute("value", (String)entry.getValue()));
        }
    }

    private void addMutilAppSecret(Map m, Element e) {
        String value;
        String key;
        String type = (String)m.get("type");
        List appMassageList = (List)m.get("appMassageList");
        HashMap<String, String> keyAndValueMap = new HashMap<String, String>();
        if ("0".equals(type)) {
            for (Map messageMap : appMassageList) {
                key = (String)messageMap.get("yzjprivappid");
                value = (String)messageMap.get("yzjprivsecret");
                keyAndValueMap.put(key, value);
            }
        } else if ("1".equals(type)) {
            for (Map messageMap : appMassageList) {
                key = (String)messageMap.get("yzjpubappid");
                value = (String)messageMap.get("yzjpubsecret");
                keyAndValueMap.put(key, value);
            }
        } else if ("3".equals(type)) {
            for (Map messageMap : appMassageList) {
                key = (String)messageMap.get("wlclientid");
                value = (String)messageMap.get("wlclientsecret");
                keyAndValueMap.put(key, value);
            }
        } else if ("4".equals(type)) {
            for (Map messageMap : appMassageList) {
                key = (String)messageMap.get("dtappkey");
                value = (String)messageMap.get("dtappsecret");
                keyAndValueMap.put(key, value);
            }
        }
        List l = e.getChildren();
        for (Element child : l) {
            String attr = child.getAttributeValue("key");
            String value2 = (String)keyAndValueMap.get(attr);
            if (StringUtils.isEmpty((String)value2)) continue;
            child.setAttribute("value", value2);
            keyAndValueMap.remove(attr);
        }
        for (Map.Entry entry : keyAndValueMap.entrySet()) {
            String entryKey = (String)entry.getKey();
            if ("10036".equals(entryKey) || "10060".equals(entryKey)) continue;
            e.addContent((Content)new Element("attribute").setAttribute("key", (String)entry.getKey()).setAttribute("value", (String)entry.getValue()));
        }
    }

    private void addSecretConfig(Map m, Element foo) {
        Element e = new Element("configitem").setAttribute("name", "WXSecret");
        List appMassageList = (List)m.get("appMassageList");
        for (Map messageMap : appMassageList) {
            String wxappid = (String)messageMap.get("wxappid");
            String wxsecret = (String)messageMap.get("wxsecret");
            e.addContent((Content)new Element("attribute").setAttribute("key", wxappid).setAttribute("value", wxsecret));
        }
        foo.addContent((Content)e);
    }

    private void addWXConfig(Map m, Element foo) {
        Map<String, String> wxApp = this.getLczsApp(m);
        if (wxApp == null) {
            wxApp = this.getCommonMessage(m);
        }
        String wxcorpid = wxApp.get("wxcorpid");
        String wxappid = wxApp.get("wxappid");
        String wxsecret = wxApp.get("wxsecret");
        Element e = new Element("configitem").setAttribute("name", "WX");
        e.addContent((Content)new Element("attribute").setAttribute("key", "corpid").setAttribute("value", wxcorpid));
        e.addContent((Content)new Element("attribute").setAttribute("key", "corpsecret").setAttribute("value", wxsecret));
        e.addContent((Content)new Element("attribute").setAttribute("key", "agentid").setAttribute("value", wxappid));
        foo.addContent((Content)e);
    }

    private void addWLConfig(Map m, Element foo) {
        Map<String, String> wlApp = this.getLczsApp(m);
        if (wlApp == null) {
            wlApp = this.getCommonMessage(m);
        }
        String wlcorpid = wlApp.get("wlcorpid");
        String wlclientid = wlApp.get("wlclientid");
        String wlclientsecret = wlApp.get("wlclientsecret");
        Element e = new Element("configitem").setAttribute("name", "WeLink");
        e.addContent((Content)new Element("attribute").setAttribute("key", "CorpId").setAttribute("value", wlcorpid));
        Element e1 = new Element("configitem").setAttribute("name", wlcorpid);
        e1.addContent((Content)new Element("attribute").setAttribute("key", "client_id").setAttribute("value", wlclientid));
        e1.addContent((Content)new Element("attribute").setAttribute("key", "client_secret").setAttribute("value", wlclientsecret));
        e.addContent((Content)e1);
        foo.addContent((Content)e);
    }

    private void addDTConfig(Map m, Element foo) {
        Map<String, String> dtApp = this.getLczsApp(m);
        if (dtApp == null) {
            dtApp = this.getCommonMessage(m);
        }
        String dtcorpid = dtApp.get("dtcorpid");
        String dtagentid = dtApp.get("dtagentid");
        String dtappkey = dtApp.get("dtappkey");
        String dtappsecret = dtApp.get("dtappsecret");
        Element e = new Element("configitem").setAttribute("name", "Dingtalk");
        e.addContent((Content)new Element("attribute").setAttribute("key", "CorpId").setAttribute("value", dtcorpid));
        e.addContent((Content)new Element("attribute").setAttribute("key", "ApiType").setAttribute("value", "3"));
        Element e1 = new Element("configitem").setAttribute("name", dtcorpid);
        e1.addContent((Content)new Element("attribute").setAttribute("key", "AgentId").setAttribute("value", dtagentid));
        e1.addContent((Content)new Element("attribute").setAttribute("key", "AppKey").setAttribute("value", dtappkey));
        e1.addContent((Content)new Element("attribute").setAttribute("key", "AppSecret").setAttribute("value", dtappsecret));
        e.addContent((Content)e1);
        foo.addContent((Content)e);
    }

    private void addOtherConfig(Map m, Element foo) {
        String otherloginurl = (String)m.get("otherloginurl");
        Element e = new Element("configitem").setAttribute("name", "OtherApp");
        e.addContent((Content)new Element("attribute").setAttribute("key", "tokenurl").setAttribute("value", otherloginurl));
        e.addContent((Content)new Element("attribute").setAttribute("key", "appid").setAttribute("value", ""));
        e.addContent((Content)new Element("attribute").setAttribute("key", "secret").setAttribute("value", ""));
        foo.addContent((Content)e);
    }

    private void checkWXSecret(Map m, Element e) {
        List appMassageList = (List)m.get("appMassageList");
        HashMap<String, String> keyAndValueMap = new HashMap<String, String>();
        for (Map messageMap : appMassageList) {
            String key = (String)messageMap.get("wxappid");
            String value = (String)messageMap.get("wxsecret");
            keyAndValueMap.put(key, value);
        }
        List l = e.getChildren();
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            Element child = (Element)iterator.next();
            String key = child.getAttribute("key").getValue();
            if (!keyAndValueMap.containsKey(key)) continue;
            iterator.remove();
        }
        for (Map.Entry entry : keyAndValueMap.entrySet()) {
            e.addContent((Content)new Element("attribute").setAttribute("key", (String)entry.getKey()).setAttribute("value", (String)entry.getValue()));
        }
    }

    private void checkWX(Map m, Element e) {
        Map<String, String> wxLczsApp = this.getLczsApp(m);
        String wxcorpid = wxLczsApp.get("wxcorpid");
        String wxappid = wxLczsApp.get("wxappid");
        String wxsecret = wxLczsApp.get("wxsecret");
        boolean findcorp = false;
        boolean findsecret = false;
        boolean findapp = false;
        List l = e.getChildren();
        for (int x = 0; x < l.size(); ++x) {
            Element dbinfoChild = (Element)e.getChildren().get(x);
            String v = dbinfoChild.getAttribute("key").getValue();
            if ("corpid".equals(v)) {
                findcorp = true;
                dbinfoChild.setAttribute("value", wxcorpid);
            }
            if ("corpsecret".equals(v)) {
                findsecret = true;
                dbinfoChild.setAttribute("value", wxsecret);
            }
            if (!"agentid".equals(v)) continue;
            findapp = true;
            dbinfoChild.setAttribute("value", wxappid);
        }
        if (!findcorp) {
            Element child = new Element("attribute");
            child.setAttribute("key", "corpid");
            child.setAttribute("value", wxcorpid);
            e.addContent((Content)child);
        }
        if (!findsecret) {
            Element child = new Element("attribute");
            child.setAttribute("key", "corpsecret");
            child.setAttribute("value", wxsecret);
            e.addContent((Content)child);
        }
        if (!findapp) {
            Element child = new Element("attribute");
            child.setAttribute("key", "agentid");
            child.setAttribute("value", wxappid);
            e.addContent((Content)child);
        }
    }

    private void checkWL(Map m, Element e) {
        Map<String, String> wlLczsApp = this.getLczsApp(m);
        String wlcorpid = wlLczsApp.get("wlcorpid");
        String wlclientid = wlLczsApp.get("wlclientid");
        String wlclientsecret = wlLczsApp.get("wlclientsecret");
        boolean findcorp = false;
        boolean findconfigitem = false;
        boolean findclientid = false;
        boolean findclientsecret = false;
        List l = e.getChildren();
        for (int x = 0; x < l.size(); ++x) {
            Element dbinfoChild = (Element)l.get(x);
            String childName = dbinfoChild.getName();
            if ("configitem".equals(childName)) {
                findconfigitem = true;
                List dbinfoChildChildren = dbinfoChild.getChildren();
                for (Element dbinfoChildChild : dbinfoChildChildren) {
                    String key = dbinfoChildChild.getAttribute("key").getValue();
                    if ("client_id".equals(key)) {
                        findclientid = true;
                        dbinfoChildChild.setAttribute("value", wlclientid);
                    }
                    if (!"client_secret".equals(key)) continue;
                    findclientsecret = true;
                    dbinfoChildChild.setAttribute("value", wlclientsecret);
                }
                continue;
            }
            String v = dbinfoChild.getAttribute("key").getValue();
            if (!"CorpId".equals(v)) continue;
            findcorp = true;
            dbinfoChild.setAttribute("value", wlcorpid);
        }
        if (!findcorp) {
            Element child = new Element("attribute");
            child.setAttribute("key", "CorpId");
            child.setAttribute("value", wlcorpid);
            e.addContent((Content)child);
        }
        if (!findconfigitem) {
            Element child;
            Element e1 = new Element("configitem").setAttribute("name", wlcorpid);
            if (!findclientid) {
                child = new Element("attribute");
                child.setAttribute("key", "client_id");
                child.setAttribute("value", wlclientid);
                e1.addContent((Content)child);
            }
            if (!findclientsecret) {
                child = new Element("attribute");
                child.setAttribute("key", "client_secret");
                child.setAttribute("value", wlclientsecret);
                e1.addContent((Content)child);
            }
            e.addContent((Content)e1);
        }
    }

    private void checkDT(Map m, Element e) {
        Map<String, String> dtLczsApp = this.getLczsApp(m);
        String dtcorpid = dtLczsApp.get("dtcorpid");
        String dtagentid = dtLczsApp.get("dtagentid");
        String dtappkey = dtLczsApp.get("dtappkey");
        String dtappsecret = dtLczsApp.get("dtappsecret");
        boolean findcropid = false;
        boolean findapitype = false;
        boolean findconfigitem = false;
        List l = e.getChildren();
        for (int x = 0; x < l.size(); ++x) {
            Element dbinfoChild = (Element)l.get(x);
            String childName = dbinfoChild.getName();
            if ("configitem".equals(childName)) {
                findconfigitem = true;
                List dbinfoChildChildren = dbinfoChild.getChildren();
                for (Element dbinfoChildChild : dbinfoChildChildren) {
                    String key = dbinfoChildChild.getAttribute("key").getValue();
                    if ("AgentId".equals(key)) {
                        dbinfoChildChild.setAttribute("value", dtagentid);
                    }
                    if ("AppKey".equals(key)) {
                        dbinfoChildChild.setAttribute("value", dtappkey);
                    }
                    if (!"AppSecret".equals(key)) continue;
                    dbinfoChildChild.setAttribute("value", dtappsecret);
                }
                continue;
            }
            String v = dbinfoChild.getAttribute("key").getValue();
            if ("CorpId".equals(v)) {
                findcropid = true;
                dbinfoChild.setAttribute("value", dtcorpid);
                continue;
            }
            if (!"ApiType".equals(v)) continue;
            findapitype = true;
            dbinfoChild.setAttribute("value", "3");
        }
        if (!findcropid) {
            Element child = new Element("attribute");
            child.setAttribute("key", "CorpId");
            child.setAttribute("value", dtcorpid);
            e.addContent((Content)child);
        }
        if (!findapitype) {
            Element child = new Element("attribute");
            child.setAttribute("key", "ApiType");
            child.setAttribute("value", "3");
            e.addContent((Content)child);
        }
        if (!findconfigitem) {
            Element e1 = new Element("configitem").setAttribute("name", dtcorpid);
            e1.addContent((Content)new Element("attribute").setAttribute("key", "AgentId").setAttribute("value", dtagentid));
            e1.addContent((Content)new Element("attribute").setAttribute("key", "AppKey").setAttribute("value", dtappkey));
            e1.addContent((Content)new Element("attribute").setAttribute("key", "AppSecret").setAttribute("value", dtappsecret));
            e.addContent((Content)e1);
        }
    }

    private void checkOther(Map m, Element e) {
        String tokenurl = (String)m.get("tokenurl");
        boolean findtokenurl = false;
        boolean findappid = false;
        boolean findsecret = false;
        List l = e.getChildren();
        for (int x = 0; x < l.size(); ++x) {
            Element dbinfoChild = (Element)l.get(x);
            String v = dbinfoChild.getAttribute("key").getValue();
            if ("tokenurl".equals(v)) {
                findtokenurl = true;
                dbinfoChild.setAttribute("value", tokenurl);
                continue;
            }
            if ("appid".equals(v)) {
                findappid = true;
                dbinfoChild.setAttribute("value", "");
                continue;
            }
            if (!"secret".equals(v)) continue;
            findsecret = true;
            dbinfoChild.setAttribute("value", "");
        }
        if (!findtokenurl) {
            Element child = new Element("attribute");
            child.setAttribute("key", "tokenurl");
            child.setAttribute("value", tokenurl);
            e.addContent((Content)child);
        }
        if (!findappid) {
            Element child = new Element("attribute");
            child.setAttribute("key", "appid");
            child.setAttribute("value", "");
            e.addContent((Content)child);
        }
        if (!findsecret) {
            Element child = new Element("attribute");
            child.setAttribute("key", "secret");
            child.setAttribute("value", "");
            e.addContent((Content)child);
        }
    }

    private String getDbType(String dbcode) throws Exception {
        String easpath = System.getProperty("EAS_HOME");
        String datapath = easpath + "/server/properties/datacenters.xml";
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(datapath);
        Element foo = doc.getRootElement();
        List allChildren = foo.getChildren("datacenter");
        String dbType = "";
        for (int i = 0; i < allChildren.size(); ++i) {
            Element e = (Element)allChildren.get(i);
            HashMap m = new HashMap();
            System.out.println(".getValue()=" + e.getAttribute("id").getValue());
            List chlist = e.getChildren();
            String name = "";
            for (int j = 0; j < chlist.size(); ++j) {
                Element che = (Element)chlist.get(j);
                if (!"zh_CN".equals(che.getAttribute("locale").getValue())) continue;
                name = che.getText();
            }
            if (!dbcode.equals(e.getAttribute("id").getValue())) continue;
            String type = e.getAttribute("dbtype").getValue();
            dbType = DbType.getValue((String)type) + "";
        }
        return dbType;
    }

    private void checkXTInfo(String cloudurl, Element e) {
        if (StringUtils.isEmpty((String)cloudurl)) {
            cloudurl = "http://kingdee.yunzhijia.com";
        }
        boolean findmcloud = false;
        boolean findconnect = false;
        List l = e.getChildren();
        for (int x = 0; x < l.size(); ++x) {
            Element dbinfoChild = (Element)e.getChildren().get(x);
            String v = dbinfoChild.getAttribute("key").getValue();
            if ("xt.mcloud.url".equals(v)) {
                findmcloud = true;
                dbinfoChild.setAttribute("value", cloudurl);
            }
            if (!"xt.pubacct.connect.server.url".equals(v)) continue;
            findconnect = true;
            dbinfoChild.setAttribute("value", cloudurl + "/pubacc/pubsend");
        }
        if (!findmcloud) {
            Element child = new Element("attribute");
            child.setAttribute("key", "xt.mcloud.url");
            child.setAttribute("value", cloudurl);
            e.addContent((Content)child);
        }
        if (!findconnect) {
            Element child = new Element("attribute");
            child.setAttribute("key", "xt.pubacct.connect.server.url");
            child.setAttribute("value", cloudurl + "/pubacc/pubsend");
            e.addContent((Content)child);
        }
    }

    private void checkPubAcct(String eid, Element e, Map m) {
        Element child;
        String type = (String)m.get("type");
        String mbostype = (String)m.get("mbostype");
        List hlist = e.getChildren();
        boolean addchild = true;
        Element clonechild = null;
        for (int hlen = 0; hlen < hlist.size(); ++hlen) {
            Element dbinfoChild = (Element)hlist.get(hlen);
            clonechild = (Element)hlist.get(hlen);
            if (!eid.equals(dbinfoChild.getAttribute("name").getValue())) continue;
            addchild = false;
            dbinfoChild.setAttribute("name", eid);
            List chlist = dbinfoChild.getChildren();
            for (int jl = 0; jl < chlist.size(); ++jl) {
                Element dbinfocChild = (Element)chlist.get(jl);
                if (!"WFMessage".equals(dbinfocChild.getAttribute("name").getValue())) continue;
                for (int ji = 0; ji < dbinfocChild.getChildren().size(); ++ji) {
                    if ("eid".equals(((Element)dbinfocChild.getChildren().get(ji)).getAttributeValue("key"))) {
                        ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", eid);
                    }
                    if ("appId".equals(((Element)dbinfocChild.getChildren().get(ji)).getAttributeValue("key"))) {
                        if (!"5".equals(type)) {
                            List appMassageList = (List)m.get("appMassageList");
                            Map<String, String> lczsApp = this.getLczsApp(appMassageList);
                            if (lczsApp != null) {
                                String appid = "";
                                if ("0".equals(type)) {
                                    appid = lczsApp.get("yzjprivappid");
                                } else if ("1".equals(type)) {
                                    appid = lczsApp.get("yzjpubappid");
                                } else if ("2".equals(type)) {
                                    appid = lczsApp.get("wxappid");
                                } else if ("3".equals(type)) {
                                    appid = lczsApp.get("wlclientid");
                                } else if ("4".equals(type)) {
                                    appid = lczsApp.get("dtappkey");
                                }
                                ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", appid);
                            } else {
                                ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", "10036");
                            }
                        } else {
                            ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", "10036");
                        }
                    }
                    if (!"host".equals(((Element)dbinfocChild.getChildren().get(ji)).getAttributeValue("key"))) continue;
                    if ("0".equals(mbostype)) {
                        String easurl = (String)m.get("easurl");
                        ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", easurl + "/mbos/page/loadPage?path=lczs2");
                        continue;
                    }
                    ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", "https://mbos.kdeascloud.com/mbos/page/loadPage?path=lczs2");
                }
            }
        }
        boolean findwf = false;
        if (addchild && clonechild != null) {
            child = clonechild.clone();
            e.addContent((Content)child);
            Element dbinfoChild = (Element)hlist.get(hlist.size() - 1);
            dbinfoChild.setAttribute("name", eid);
            List chlist = dbinfoChild.getChildren();
            for (int jl = 0; jl < chlist.size(); ++jl) {
                Element dbinfocChild = (Element)chlist.get(jl);
                if (!"WFMessage".equals(dbinfocChild.getAttribute("name").getValue())) continue;
                findwf = true;
                for (int ji = 0; ji < dbinfocChild.getChildren().size(); ++ji) {
                    if ("eid".equals(((Element)dbinfocChild.getChildren().get(ji)).getAttributeValue("key"))) {
                        ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", eid);
                        continue;
                    }
                    if ("appId".equals(((Element)dbinfocChild.getChildren().get(ji)).getAttributeValue("key"))) {
                        if (!"5".equals(type)) {
                            List appMassageList = (List)m.get("appMassageList");
                            Map<String, String> lczsApp = this.getLczsApp(appMassageList);
                            if (lczsApp != null) {
                                String appid = "";
                                if ("0".equals(type)) {
                                    appid = lczsApp.get("yzjprivappid");
                                } else if ("1".equals(type)) {
                                    appid = lczsApp.get("yzjpubappid");
                                } else if ("2".equals(type)) {
                                    appid = lczsApp.get("wxappid");
                                } else if ("3".equals(type)) {
                                    appid = lczsApp.get("wlclientid");
                                } else if ("4".equals(type)) {
                                    appid = lczsApp.get("dtappkey");
                                }
                                ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", appid);
                                continue;
                            }
                            ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", "10036");
                            continue;
                        }
                        ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", "10036");
                        continue;
                    }
                    if ("host".equals(((Element)dbinfocChild.getChildren().get(ji)).getAttributeValue("key"))) {
                        if ("0".equals(mbostype)) {
                            String easurl = (String)m.get("easurl");
                            ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", easurl + "/mbos/page/loadPage?path=lczs2");
                            continue;
                        }
                        ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", "https://mbos.kdeascloud.com/mbos/page/loadPage?path=lczs2");
                        continue;
                    }
                    if ("code".equals(((Element)dbinfocChild.getChildren().get(ji)).getAttributeValue("key"))) {
                        ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", "XT-6fb96101-b0d7-445e-b53b-cd8b4373d6d7");
                        continue;
                    }
                    if (!"pubKey".equals(((Element)dbinfocChild.getChildren().get(ji)).getAttributeValue("key"))) continue;
                    ((Element)dbinfocChild.getChildren().get(ji)).setAttribute("value", "c3b5fc1703dadfb5b815092bac5951a0");
                }
            }
            if (!findwf) {
                Element childwf = new Element("configitem").setAttribute("name", "WFMessage");
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "code").setAttribute("value", "XT-6fb96101-b0d7-445e-b53b-cd8b4373d6d7"));
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "pubKey").setAttribute("value", "c3b5fc1703dadfb5b815092bac5951a0"));
                if ("0".equals(mbostype)) {
                    String easurl = (String)m.get("easurl");
                    childwf.addContent((Content)new Element("attribute").setAttribute("key", "host").setAttribute("value", easurl + "/mbos/page/loadPage?path=lczs2"));
                } else {
                    childwf.addContent((Content)new Element("attribute").setAttribute("key", "host").setAttribute("value", "https://mbos.kdeascloud.com/mbos/page/loadPage?path=lczs2"));
                }
                if (!"5".equals(type)) {
                    List appMassageList = (List)m.get("appMassageList");
                    Map<String, String> lczsApp = this.getLczsApp(appMassageList);
                    if (lczsApp != null) {
                        String appid = "";
                        if ("0".equals(type)) {
                            appid = lczsApp.get("yzjprivappid");
                        } else if ("1".equals(type)) {
                            appid = lczsApp.get("yzjpubappid");
                        } else if ("2".equals(type)) {
                            appid = lczsApp.get("wxappid");
                        } else if ("3".equals(type)) {
                            appid = lczsApp.get("wlclientid");
                        } else if ("4".equals(type)) {
                            appid = lczsApp.get("dtappkey");
                        }
                        childwf.addContent((Content)new Element("attribute").setAttribute("key", "appId").setAttribute("value", appid));
                    } else {
                        childwf.addContent((Content)new Element("attribute").setAttribute("key", "appId").setAttribute("value", "10036"));
                    }
                } else {
                    childwf.addContent((Content)new Element("attribute").setAttribute("key", "appId").setAttribute("value", "10036"));
                }
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "eid").setAttribute("value", eid));
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "MsgShow").setAttribute("value", "1"));
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "enabled").setAttribute("value", "true"));
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "xt.pubacct.local.server.dir").setAttribute("value", "${EAS_HOME}/server/deploy/eas.ear/workflow.war/xt"));
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "clean").setAttribute("value", "false"));
                dbinfoChild.addContent((Content)childwf);
            }
        }
        if (clonechild == null) {
            child = new Element("configitem").setAttribute("name", eid);
            Element childwf = new Element("configitem").setAttribute("name", "WFMessage");
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "code").setAttribute("value", "XT-6fb96101-b0d7-445e-b53b-cd8b4373d6d7"));
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "pubKey").setAttribute("value", "c3b5fc1703dadfb5b815092bac5951a0"));
            if ("0".equals(mbostype)) {
                String easurl = (String)m.get("easurl");
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "host").setAttribute("value", easurl + "/mbos/page/loadPage?path=lczs2"));
            } else {
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "host").setAttribute("value", "https://mbos.kdeascloud.com/mbos/page/loadPage?path=lczs2"));
            }
            if (!"5".equals(type)) {
                List appMassageList = (List)m.get("appMassageList");
                Map<String, String> lczsApp = this.getLczsApp(appMassageList);
                if (lczsApp != null) {
                    String appid = "";
                    if ("0".equals(type)) {
                        appid = lczsApp.get("yzjprivappid");
                    } else if ("1".equals(type)) {
                        appid = lczsApp.get("yzjpubappid");
                    } else if ("2".equals(type)) {
                        appid = lczsApp.get("wxappid");
                    } else if ("3".equals(type)) {
                        appid = lczsApp.get("wlclientid");
                    } else if ("4".equals(type)) {
                        appid = lczsApp.get("dtappkey");
                    }
                    childwf.addContent((Content)new Element("attribute").setAttribute("key", "appId").setAttribute("value", appid));
                } else {
                    childwf.addContent((Content)new Element("attribute").setAttribute("key", "appId").setAttribute("value", "10036"));
                }
            } else {
                childwf.addContent((Content)new Element("attribute").setAttribute("key", "appId").setAttribute("value", "10036"));
            }
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "eid").setAttribute("value", eid));
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "MsgShow").setAttribute("value", "1"));
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "enabled").setAttribute("value", "true"));
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "xt.pubacct.local.server.dir").setAttribute("value", "${EAS_HOME}/server/deploy/eas.ear/workflow.war/xt"));
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "clean").setAttribute("value", "false"));
            child.addContent((Content)childwf);
            e.addContent((Content)child);
        }
    }

    private void checkDbinfo(String eid, String dbcode, String dbtype, String slname, Element e) {
        ArrayList clist = new ArrayList();
        Object dbinfoChild = null;
        boolean adddbchild = true;
        Element clonechild = null;
        if (e.getChildren().size() > 0) {
            clonechild = (Element)e.getChildren().get(0);
        }
        for (int ci = 0; ci < e.getChildren().size(); ++ci) {
            Element forinfoChild = (Element)e.getChildren().get(ci);
            if (!eid.equals(forinfoChild.getAttribute("name").getValue())) continue;
            adddbchild = false;
            List dbeidchilds = forinfoChild.getChildren();
            for (int j = 0; j < dbeidchilds.size(); ++j) {
                Element dbeidchild = (Element)dbeidchilds.get(j);
                if ("dbCode".equals(dbeidchild.getAttribute("key").getValue())) {
                    dbeidchild.setAttribute("value", dbcode);
                }
                if ("dbType".equals(dbeidchild.getAttribute("key").getValue())) {
                    dbeidchild.setAttribute("value", dbtype);
                }
                if (!"slnName".equals(dbeidchild.getAttribute("key").getValue())) continue;
                dbeidchild.setAttribute("value", slname);
            }
        }
        if (adddbchild && clonechild != null) {
            Element child = clonechild.clone();
            e.addContent((Content)child);
            Element infoChild = (Element)e.getChildren().get(e.getChildren().size() - 1);
            infoChild.setAttribute("name", eid);
            List chlist = infoChild.getChildren();
            for (int jl = 0; jl < chlist.size(); ++jl) {
                Element dbinfocChild = (Element)chlist.get(jl);
                if ("dbCode".equals(dbinfocChild.getAttribute("key").getValue())) {
                    dbinfocChild.setAttribute("value", dbcode);
                    continue;
                }
                if ("dbType".equals(dbinfocChild.getAttribute("key").getValue())) {
                    dbinfocChild.setAttribute("value", dbtype);
                    continue;
                }
                if ("slnName".equals(dbinfocChild.getAttribute("key").getValue())) {
                    dbinfocChild.setAttribute("value", "eas");
                    continue;
                }
                if (!"locale".equals(dbinfocChild.getAttribute("key").getValue())) continue;
                dbinfocChild.setAttribute("value", "L2");
            }
        } else if (adddbchild && clonechild == null) {
            Element childwf = new Element("configitem").setAttribute("name", eid);
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "dbCode").setAttribute("value", dbcode));
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "dbType").setAttribute("value", dbtype));
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "slnName").setAttribute("value", "eas"));
            childwf.addContent((Content)new Element("attribute").setAttribute("key", "locale").setAttribute("value", "L2"));
            e.addContent((Content)childwf);
        }
    }

    private void checkSecret(Element e) {
        ArrayList clist = new ArrayList();
        Object dbinfoChild = null;
        boolean hasappid36 = false;
        boolean hasappid60 = false;
        for (int ci = 0; ci < e.getChildren().size(); ++ci) {
            Element forinfoChild = (Element)e.getChildren().get(ci);
            if ("10036".equals(forinfoChild.getAttribute("key").getValue())) {
                hasappid36 = true;
            }
            if (!"10060".equals(forinfoChild.getAttribute("key").getValue())) continue;
            hasappid60 = true;
        }
        if (!hasappid36) {
            Element child = new Element("attribute").setAttribute("key", "10036").setAttribute("value", "123456789");
            e.addContent((Content)child);
        }
        if (!hasappid60) {
            Element child = new Element("attribute").setAttribute("key", "10060").setAttribute("value", "123456789");
            e.addContent((Content)child);
        }
    }

    public void editEventXml(String oldPath, String newPath) throws Exception {
        try {
            String path = newPath;
            File configFile = new File(path);
            if (configFile.exists()) {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(configFile);
                Element foo = doc.getRootElement();
                List allChildren = foo.getChildren("event");
                boolean has1 = false;
                boolean has2 = false;
                Object element = null;
                for (int i = 0; i < allChildren.size(); ++i) {
                    Element e = (Element)allChildren.get(i);
                    String name = e.getAttributeValue("name");
                    if ("OnAssignmentComplete".equals(name)) {
                        has1 = true;
                    }
                    if (!"OnAssignmentAborted".equals(name)) continue;
                    has2 = true;
                }
                if (!has1) {
                    Element child = new Element("event");
                    child.setAttribute("name", "OnAssignmentComplete");
                    child.setAttribute("handler", "com.kingdee.bos.workflow.handler.AssignmentHandler");
                    foo.addContent((Content)child);
                }
                if (!has2) {
                    Element child = new Element("event");
                    child.setAttribute("name", "OnAssignmentAborted");
                    child.setAttribute("handler", "com.kingdee.bos.workflow.handler.AssignmentHandler");
                    foo.addContent((Content)child);
                }
                Format format = Format.getPrettyFormat();
                format.setEncoding("UTF-8");
                format.setIndent("\t");
                XMLOutputter outputter = new XMLOutputter(format);
                outputter.output(doc, (OutputStream)new FileOutputStream(path));
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236configxml\u5185\u5bb9\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
            throw new Exception("error copyFolder: ", e);
        }
    }

    private String getdb() throws Exception {
        String easpath = System.getProperty("EAS_HOME");
        String datapath = easpath + "/server/properties/datacenters.xml";
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(datapath);
        Element foo = doc.getRootElement();
        List allChildren = foo.getChildren("datacenter");
        Object element = null;
        ArrayList list = new ArrayList();
        for (int i = 0; i < allChildren.size(); ++i) {
            Element e = (Element)allChildren.get(i);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", e.getAttribute("id").getValue());
            m.put("dbtype", e.getAttribute("dbtype").getValue());
            m.put("dbname", e.getAttribute("dbname").getValue());
            m.put("dbname", e.getAttribute("dbname").getValue());
            m.put("version", e.getAttribute("version").getValue());
            list.add(m);
        }
        return JSON.toJSONString(list);
    }

    public List getlist() throws Exception {
        String easpath = System.getProperty("EAS_HOME");
        String path = easpath + "/server/properties/XTServiceConfig.xml";
        ArrayList list = new ArrayList();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(path);
        Element foo = doc.getRootElement();
        List allChildren = foo.getChildren("configitem");
        Object element = null;
        for (int i = 0; i < allChildren.size(); ++i) {
            Element e = (Element)allChildren.get(i);
            String name = e.getAttributeValue("name");
            if (!"DbInfo".equals(name)) continue;
            ArrayList clist = new ArrayList();
            for (int ci = 0; ci < e.getChildren().size(); ++ci) {
                Element forinfoChild = (Element)e.getChildren().get(ci);
                String eid = forinfoChild.getAttributeValue("name");
                List dbeidchilds = forinfoChild.getChildren();
                for (int j = 0; j < dbeidchilds.size(); ++j) {
                    Element dbeidchild = (Element)dbeidchilds.get(j);
                    if (!"dbCode".equals(dbeidchild.getAttribute("key").getValue())) continue;
                    String value = dbeidchild.getAttributeValue("value");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("eid", eid);
                    map.put("value", value);
                    list.add(map);
                }
            }
        }
        return list;
    }

    @Override
    public String deleteDbinfo(String eid) throws Exception {
        String easpath = System.getProperty("EAS_HOME");
        String path = easpath + "/server/properties/XTServiceConfig.xml";
        System.out.println("1111111=" + path);
        ArrayList list = new ArrayList();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(path);
        Element foo = doc.getRootElement();
        List allChildren = foo.getChildren("configitem");
        Object element = null;
        for (int i = 0; i < allChildren.size(); ++i) {
            Element e = (Element)allChildren.get(i);
            String name = e.getAttributeValue("name");
            if (!"DbInfo".equals(name)) continue;
            ArrayList<Element> newlist = new ArrayList<Element>();
            List clist = e.getChildren();
            for (int ci = 0; ci < clist.size(); ++ci) {
                Element forinfoChild = (Element)clist.get(ci);
                String geid = forinfoChild.getAttributeValue("name");
                if (!geid.equals(eid)) {
                    newlist.add(forinfoChild);
                    continue;
                }
                e.removeChildren(geid);
            }
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        format.setIndent("\t");
        XMLOutputter outputter = new XMLOutputter(format);
        outputter.output(doc, (OutputStream)new FileOutputStream(path));
        return "success";
    }

    @Override
    public String deleteDbinfo() throws Exception {
        String easpath = System.getProperty("EAS_HOME");
        String path = easpath + "/server/properties/XTServiceConfig.xml";
        System.out.println("1111111=" + path);
        ArrayList list = new ArrayList();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(path);
        Element foo = doc.getRootElement();
        List allChildren = foo.getChildren("configitem");
        Object element = null;
        for (int i = 0; i < allChildren.size(); ++i) {
            Element e = (Element)allChildren.get(i);
            String name = e.getAttributeValue("name");
            if (!"DbInfo".equals(name)) continue;
            ArrayList newlist = new ArrayList();
            List clist = e.getChildren();
            for (int ci = 0; ci < clist.size(); ++ci) {
                Element forinfoChild = (Element)clist.get(ci);
                String geid = forinfoChild.getAttributeValue("name");
                e.removeChildren(geid);
            }
        }
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        format.setIndent("\t");
        XMLOutputter outputter = new XMLOutputter(format);
        outputter.output(doc, (OutputStream)new FileOutputStream(path));
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(String remoteFilePath, String localFilePath) {
        URL urlfile = null;
        HttpURLConnection httpUrl = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        File f = new File(localFilePath);
        try {
            if (f.exists()) {
                f.delete();
            }
            urlfile = new URL(remoteFilePath);
            httpUrl = (HttpURLConnection)urlfile.openConnection();
            httpUrl.setReadTimeout(5000);
            httpUrl.setConnectTimeout(5000);
            httpUrl.setReadTimeout(5000);
            httpUrl.connect();
            bis = new BufferedInputStream(httpUrl.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(f));
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = bis.read(b)) != -1) {
                ((BufferedOutputStream)bos).write(b, 0, len);
            }
            ((BufferedOutputStream)bos).flush();
            bis.close();
            httpUrl.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bis.close();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipFile(String sourceFile, String descDir) {
        File zipFile = new File(sourceFile);
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        OutputStream out = null;
        InputStream in = null;
        try {
            ZipFile zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                in = zip.getInputStream(entry);
                String outPath = (descDir + zipEntryName).replaceAll("\\*", "/");
                File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (new File(outPath).isDirectory()) continue;
                out = new FileOutputStream(outPath);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    out.write(buf1, 0, len);
                }
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void editApplyXml(String oldPath, String newPath, String type) throws Exception {
        try {
            String path = newPath;
            File configFile = new File(path);
            if (configFile.exists()) {
                Element ee;
                List cchild;
                Element childweb;
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(configFile);
                Element foo = doc.getRootElement();
                List allChildren = foo.getChildren("module");
                boolean hasworkflow = false;
                boolean haslight = false;
                Element element = null;
                Element cloneChild = null;
                for (int i = 0; i < allChildren.size(); ++i) {
                    Element e;
                    cloneChild = (Element)allChildren.get(i);
                    element = e = (Element)allChildren.get(i);
                    List moduleChild = e.getChildren("web");
                    if (moduleChild.size() <= 0) continue;
                    String warname = ((Element)moduleChild.get(0)).getChild("web-uri").getText();
                    String contextbname = ((Element)moduleChild.get(0)).getChild("context-root").getText();
                    if ((type + ".war").equals(warname)) {
                        hasworkflow = true;
                    }
                    if (!"light_app_bas.war".equals(warname) || !"/lightapp".equals(contextbname)) continue;
                    haslight = true;
                }
                if (!hasworkflow) {
                    Element child = cloneChild.clone();
                    childweb = child.getChild("web");
                    cchild = childweb.getChildren();
                    for (int len = 0; len < cchild.size(); ++len) {
                        ee = (Element)cchild.get(len);
                        ee.getAdditionalNamespaces();
                        if (ee.getName() == "web-uri") {
                            ee.setText("workflow.war");
                            continue;
                        }
                        if (ee.getName() != "context-root") continue;
                        ee.setText("/workflow");
                    }
                    foo.addContent((Content)child);
                }
                if (!haslight) {
                    Element child = cloneChild.clone();
                    childweb = child.getChild("web");
                    cchild = childweb.getChildren();
                    for (int len = 0; len < cchild.size(); ++len) {
                        ee = (Element)cchild.get(len);
                        ee.getAdditionalNamespaces();
                        if (ee.getName() == "web-uri") {
                            ee.setText("light_app_bas.war");
                            continue;
                        }
                        if (ee.getName() != "context-root") continue;
                        ee.setText("/lightapp");
                    }
                    foo.addContent((Content)child);
                }
                Format format = Format.getPrettyFormat();
                format.setEncoding("UTF-8");
                format.setIndent("\t");
                XMLOutputter outputter = new XMLOutputter(format);
                outputter.output(doc, (OutputStream)new FileOutputStream(path));
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236xml\u5185\u5bb9\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
            throw new Exception("error copyFolder: ", e);
        }
    }

    public void copyFolder(String oldPath, String newPath) throws Exception {
        System.out.println("1111111111111111111111111111111111111111111111111=" + newPath);
        System.out.println("1111111111111111111111111111111111111111111111111=" + oldPath);
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            if (!a.exists()) {
                return;
            }
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(newPath + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory()) continue;
                this.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("error copyFolder: ", e);
        }
    }

    public Map<String, String> getLczsApp(Map m) {
        List appMassageList = (List)m.get("appMassageList");
        return this.getLczsApp(appMassageList);
    }

    public Map<String, String> getLczsApp(List<Map<String, String>> appMassageList) {
        for (Map<String, String> messageMap : appMassageList) {
            String wxislczs = messageMap.get("islczs");
            if (!"1".equals(wxislczs)) continue;
            return messageMap;
        }
        return null;
    }

    public Map<String, String> getCommonMessage(Map m) {
        List appMassageList = (List)m.get("appMassageList");
        return appMassageList.size() > 0 ? (Map)appMassageList.get(0) : null;
    }

    public void checkAppInfo(Element e, Map m) {
        String type = (String)m.get("type");
        String eid = (String)m.get("eid");
        List children = e.getChildren();
        for (Element child : children) {
            String name = child.getAttributeValue("name");
            if ("CurrentApp".equals(name)) {
                Element attribute = child.getChild("attribute");
                attribute.setAttribute("key", type);
                attribute.setAttribute("value", eid);
                continue;
            }
            if (!"AppInfos".equals(name)) continue;
            List appChildren = child.getChildren();
            Iterator appIterator = appChildren.iterator();
            while (appIterator.hasNext()) {
                Element app = (Element)appIterator.next();
                String appType = app.getAttributeValue("name");
                if (!("0".equals(appType) && "0".equals(type) || "1".equals(appType) && "1".equals(type) || "2".equals(appType) && "2".equals(type) || "3".equals(appType) && "3".equals(type)) && (!"4".equals(appType) || !"4".equals(type))) continue;
                appIterator.remove();
            }
            this.addAppInfo(child, m);
        }
    }

    public void checkMultiApp(Element e, Map m) {
        String eid = (String)m.get("eid");
        String dbcode = (String)m.get("dbcode");
        String type = (String)m.get("type");
        String appType = "";
        int typeInt = Integer.parseInt(type);
        switch (typeInt) {
            case 0: 
            case 1: {
                appType = "Yzj";
                break;
            }
            case 2: {
                appType = "WX";
                break;
            }
            case 3: {
                appType = "WeLink";
                break;
            }
            case 4: {
                appType = "Dingtalk";
            }
        }
        boolean addNewItem = true;
        boolean addNewApp = true;
        List children = e.getChildren();
        for (Element child : children) {
            String name = child.getAttributeValue("name");
            if (!name.equals(dbcode)) continue;
            addNewItem = false;
            List appList = child.getChildren();
            for (Object app : appList) {
                Element appElement = (Element)app;
                Attribute curAppType = appElement.getAttribute("key");
                if (!curAppType.equals(appType)) continue;
                appElement.setAttribute("value", eid);
                addNewApp = false;
            }
            if (appList != null && appList.size() > 0) {
                if (!addNewApp || appType.equals("")) continue;
                child.addContent((Content)new Element("attribute").setAttribute("key", appType).setAttribute("value", eid));
                continue;
            }
            if (appType.equals("")) continue;
            child.addContent((Content)new Element("attribute").setAttribute("key", appType).setAttribute("value", eid));
        }
        if (addNewItem) {
            this.addMultiApp(e, m);
        }
    }

    public Element addAppInfo(Element e, Map m) {
        String type = (String)m.get("type");
        List massageList = (List)m.get("appMassageList");
        Element e1 = new Element("configitem").setAttribute("name", type);
        if ("0".equals(type)) {
            for (Map map : massageList) {
                String yzjprivappid = (String)map.get("yzjprivappid");
                String yzjprivsecret = (String)map.get("yzjprivsecret");
                String isLczs = (String)map.get("islczs");
                Element e2 = new Element("configitem");
                if ("1".equals(isLczs)) {
                    e2.setAttribute("name", "lczs");
                }
                e2.addContent((Content)new Element("attribute").setAttribute("key", "yzjprivappid").setAttribute("value", yzjprivappid));
                e2.addContent((Content)new Element("attribute").setAttribute("key", "yzjprivsecret").setAttribute("value", yzjprivsecret));
                e1.addContent((Content)e2);
            }
            e.addContent((Content)e1);
        } else if ("1".equals(type)) {
            for (Map map : massageList) {
                String yzjpubappid = (String)map.get("yzjpubappid");
                String yzjpubsecret = (String)map.get("yzjpubsecret");
                String isLczs = (String)map.get("islczs");
                Element e2 = new Element("configitem");
                if ("1".equals(isLczs)) {
                    e2.setAttribute("name", "lczs");
                }
                e2.addContent((Content)new Element("attribute").setAttribute("key", "yzjpubappid").setAttribute("value", yzjpubappid));
                e2.addContent((Content)new Element("attribute").setAttribute("key", "yzjpubsecret").setAttribute("value", yzjpubsecret));
                e1.addContent((Content)e2);
            }
            e.addContent((Content)e1);
        } else if ("2".equals(type)) {
            for (Map map : massageList) {
                String wxappid = (String)map.get("wxappid");
                String wxsecret = (String)map.get("wxsecret");
                String isLczs = (String)map.get("islczs");
                Element e2 = new Element("configitem");
                if ("1".equals(isLczs)) {
                    e2.setAttribute("name", "lczs");
                }
                e2.addContent((Content)new Element("attribute").setAttribute("key", "agentid").setAttribute("value", wxappid));
                e2.addContent((Content)new Element("attribute").setAttribute("key", "corpsecret").setAttribute("value", wxsecret));
                e1.addContent((Content)e2);
            }
            e.addContent((Content)e1);
        } else if ("3".equals(type)) {
            for (Map map : massageList) {
                String wlclientid = (String)map.get("wlclientid");
                String wlclientsecret = (String)map.get("wlclientsecret");
                String isLczs = (String)map.get("islczs");
                Element e2 = new Element("configitem");
                if ("1".equals(isLczs)) {
                    e2.setAttribute("name", "lczs");
                }
                e2.addContent((Content)new Element("attribute").setAttribute("key", "client_id").setAttribute("value", wlclientid));
                e2.addContent((Content)new Element("attribute").setAttribute("key", "client_secret").setAttribute("value", wlclientsecret));
                e1.addContent((Content)e2);
            }
            e.addContent((Content)e1);
        } else if ("4".equals(type)) {
            for (Map map : massageList) {
                String dtagentid = (String)map.get("dtagentid");
                String dtappkey = (String)map.get("dtappkey");
                String dtappsecret = (String)map.get("dtappsecret");
                String isLczs = (String)map.get("islczs");
                Element e2 = new Element("configitem");
                if ("1".equals(isLczs)) {
                    e2.setAttribute("name", "lczs");
                }
                e2.addContent((Content)new Element("attribute").setAttribute("key", "AgentId").setAttribute("value", dtagentid));
                e2.addContent((Content)new Element("attribute").setAttribute("key", "AppKey").setAttribute("value", dtappkey));
                e2.addContent((Content)new Element("attribute").setAttribute("key", "AppSecret").setAttribute("value", dtappsecret));
                e1.addContent((Content)e2);
            }
            e.addContent((Content)e1);
        }
        return e;
    }

    public Element addMultiApp(Element e, Map m) {
        String eid = (String)m.get("eid");
        String dbcode = (String)m.get("dbcode");
        String type = (String)m.get("type");
        Element e1 = new Element("configitem").setAttribute("name", dbcode);
        String appType = "";
        int typeInt = Integer.parseInt(type);
        switch (typeInt) {
            case 0: 
            case 1: {
                appType = "Yzj";
                break;
            }
            case 2: {
                appType = "WX";
                break;
            }
            case 3: {
                appType = "WeLink";
                break;
            }
            case 4: {
                appType = "Dingtalk";
            }
        }
        if (!appType.equals("")) {
            e1.addContent((Content)new Element("attribute").setAttribute("key", appType).setAttribute("value", eid));
        }
        e.addContent((Content)e1);
        return e;
    }

    private String getAppType(String type) {
        String appType = null;
        if ("0".equals(type)) {
            appType = "YZJPrivInfo";
        } else if ("1".equals(type)) {
            appType = "YZJPubInfo";
        } else if ("2".equals(type)) {
            appType = "WXInfo";
        } else if ("3".equals(type)) {
            appType = "WLInfo";
        } else if ("4".equals(type)) {
            appType = "DTInfo";
        } else if ("5".equals(type)) {
            appType = "OtherInfo";
        }
        return appType;
    }
}

