/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.mobile.BizFunctionCollection;
import com.kingdee.eas.mobile.BizModuleCollection;
import com.kingdee.eas.mobile.IServerEngineNew;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.framework.ConnectionState;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.msg.CommunicateException;
import org.apache.log4j.Logger;

public class ServerEngineNew
extends AbstractBOSObject
implements IServerEngineNew {
    private Logger logger = Logger.getLogger(ServerEngineNew.class);
    private Context ctx = null;

    public ServerEngineNew() {
    }

    public ServerEngineNew(Context ctx) {
        this.ctx = ctx;
    }

    private ServerCenter getServer() {
        this.logger.info((Object)"------mobile----ServerEngineNew---getServer-");
        if (this.ctx == null) {
            this.ctx = this.getContext();
        }
        ServerCenter serverCenter = ServerCenter.getInstance(this.ctx);
        this.logger.info((Object)"------mobile----ServerEngineNew---serverCenter-");
        return serverCenter;
    }

    @Override
    public boolean start() throws ORMCoreException, CommunicateException {
        return this.start(null, null, null);
    }

    @Override
    public boolean start(MobileConfigInfo mobileConfigInfo, BizModuleCollection bizModules, BizFunctionCollection[] bizFunctionCols) throws ORMCoreException, CommunicateException {
        boolean success = false;
        this.logger.info((Object)"------mobile----ServerEngineNew---will getServer----");
        ServerCenter serverCenter = this.getServer();
        if (serverCenter != null) {
            this.logger.info((Object)"------mobile----ServerEngineNew---will loadConfig----");
            try {
                serverCenter.loadConfig(mobileConfigInfo, bizModules, bizFunctionCols);
            }
            catch (BOSException e) {
                this.logger.error((Object)("------mobile----ServerEngineNew---error:" + e.getMessage()));
                throw new ORMCoreException((Throwable)e);
            }
            this.logger.info((Object)"------mobile----ServerEngineNew---will start----");
            success = serverCenter.start();
        }
        this.logger.info((Object)("------mobile----ServerEngineNew---start is" + success));
        return success;
    }

    @Override
    public boolean stop() throws ORMCoreException {
        ServerCenter serverCenter = this.getServer();
        if (serverCenter != null) {
            serverCenter.stop();
        }
        return true;
    }

    @Override
    public boolean testConnect(MobileConfigInfo mobileConfigInfo, BizModuleCollection bizModules, BizFunctionCollection[] bizFunctionCols) throws ORMCoreException {
        boolean success;
        block5: {
            success = false;
            this.logger.info((Object)"------mobile----ServerEngineNew---testConnect----");
            try {
                ServerCenter serverCenter = this.getServer();
                if (serverCenter == null) break block5;
                this.logger.info((Object)"------mobile----ServerEngineNew---loadConfig----");
                try {
                    serverCenter.loadConfig(mobileConfigInfo, bizModules, bizFunctionCols);
                }
                catch (BOSException e) {
                    this.logger.error((Object)("------mobile----ServerEngineNew---error:" + e.getMessage()));
                    throw new ORMCoreException((Throwable)e);
                }
                this.logger.info((Object)"------mobile----ServerEngineNew---start()----");
                success = serverCenter.start();
                this.logger.info((Object)("------mobile----ServerEngineNew---start()finish-=" + success));
                if (success) {
                    serverCenter.stop();
                    this.logger.info((Object)"------mobile----ServerEngineNew---stop()----");
                }
            }
            catch (CommunicateException err) {
                this.logger.info((Object)"------mobile----CommunicateException----");
            }
        }
        return success;
    }

    @Override
    public ConnectionState getEngineState() throws ORMCoreException {
        ServerCenter serverCenter = this.getServer();
        if (serverCenter != null) {
            return serverCenter.getCurState();
        }
        this.logger.debug((Object)"loadConfig() end");
        return null;
    }

    public BOSObjectType getType() {
        return null;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }
}

