/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.biz;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.mobile.CoreReceiveMessageInfo;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.EmailReceiveMessageInfo;
import com.kingdee.eas.mobile.ReceiveMobileMessageInfo;
import com.kingdee.eas.mobile.biz.IMessageHandler;
import com.kingdee.eas.mobile.biz.ReplyMsgHandler;
import com.kingdee.eas.mobile.biz.SendMsgHandler;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.ObjectUtils;

public class BizDispatcher {
    private BizDispatcher() {
    }

    public static CoreSendMessageInfo executeBizAction(Context ctx, UserInfo userInfo, CoreReceiveMessageInfo receiveMsgInfo) {
        ctx = BizDispatcher.handleContext(ctx, userInfo);
        IMessageHandler handler = BizDispatcher.getHandler(BizDispatcher.isReply(receiveMsgInfo));
        return handler.executeBizAction(ctx, userInfo, receiveMsgInfo);
    }

    private static Context handleContext(Context ctx, UserInfo userInfo) {
        if (userInfo != null) {
            try {
                Context newCtx = (Context)ObjectUtils.createCopy((Object)ctx);
                newCtx.setCaller((IObjectPK)new ObjectUuidPK(userInfo.getId().toString()));
                newCtx.setUserName(userInfo.getName());
                ContextUtil.setCurrentUserInfo((Context)newCtx, (UserInfo)userInfo);
                return newCtx;
            }
            catch (CloneNotSupportedException e) {
                return ctx;
            }
        }
        return ctx;
    }

    private static IMessageHandler getHandler(boolean isReply) {
        IMessageHandler handler = null;
        handler = isReply ? new ReplyMsgHandler() : new SendMsgHandler();
        return handler;
    }

    private static final boolean isReply(CoreReceiveMessageInfo receiveMsgInfo) {
        if (receiveMsgInfo instanceof ReceiveMobileMessageInfo) {
            return ((ReceiveMobileMessageInfo)receiveMsgInfo).getParentMsg() != null;
        }
        if (receiveMsgInfo instanceof EmailReceiveMessageInfo) {
            return ((EmailReceiveMessageInfo)receiveMsgInfo).getParentMsg() != null;
        }
        return false;
    }
}

