/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.client.AbstractMailServerConfigUI;
import com.kingdee.eas.mobile.util.CheckLicense;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MailServerConfigUI
extends AbstractMailServerConfigUI {
    public static final String MOBILE_PKG = "com.kingdee.eas.mobile.client.BizConfigUI";
    public static final String strResource = "com.kingdee.eas.framework.FrameWorkResource.";
    private static final Logger logger = CoreUIObject.getLogger(MailServerConfigUI.class);

    public MailServerConfigUI() throws Exception {
        this.initData();
        this.initUI();
        this.checkLicense();
    }

    public void onLoad() {
        if (!this.tlsEnableCheckbox.isSelected()) {
            this.tls2EnableCheckbox.setEnabled(false);
        }
        this.tlsEnableCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!MailServerConfigUI.this.tlsEnableCheckbox.isSelected()) {
                    MailServerConfigUI.this.tls2EnableCheckbox.setSelected(false);
                    MailServerConfigUI.this.tls2EnableCheckbox.setEnabled(false);
                } else {
                    MailServerConfigUI.this.tls2EnableCheckbox.setEnabled(true);
                }
            }
        });
    }

    private boolean checkLicense() throws LicenseException {
        LicenseUserInfo user = (LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo");
        int iresult = LicenseSrvAgentFactory.getRemoteInstance().requestLicense(user, MOBILE_PKG);
        if (iresult == 4) {
            try {
                MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)CheckLicense.constructMessage(MOBILE_PKG, this.ui), (int)0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SysUtil.abort();
            return false;
        }
        if (iresult == 2) {
            try {
                MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"), (String)CheckLicense.constructMessage(MOBILE_PKG, this.ui), (int)0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SysUtil.abort();
            return false;
        }
        return true;
    }

    private void initData() throws Exception {
        String forceStr;
        String smtpAuthStr;
        String tlsEnableStr;
        String tls2EnableStr;
        IMsgFacade iMsgFacade = MsgFacadeFactory.getRemoteInstance();
        Properties properties = iMsgFacade.getMailServerConfig();
        this.hostTextField.setText(properties.getProperty("mail.smtp.host"));
        this.portTextField.setText(properties.getProperty("mail.smtp.port"));
        this.usernameTextField.setText(properties.getProperty("mail.login.username"));
        this.passwordField.setText(properties.getProperty("mail.login.password"));
        this.senderMailTextField.setText(properties.getProperty("mail.from.account"));
        this.senderMailUsernameTextField.setText(properties.getProperty("mail.from.username"));
        String sslEnableStr = properties.getProperty("mail.sslEnable");
        if ("true".equalsIgnoreCase(sslEnableStr)) {
            this.sslEnableCheckbox.setSelected(true);
            this.tlsEnableCheckbox.setEnabled(false);
        }
        if ("true".equalsIgnoreCase(tls2EnableStr = properties.getProperty("mail.tls2Enable"))) {
            this.tls2EnableCheckbox.setSelected(true);
        }
        if ("true".equalsIgnoreCase(tlsEnableStr = properties.getProperty("mail.tlsEnable"))) {
            this.tlsEnableCheckbox.setSelected(true);
            this.sslEnableCheckbox.setEnabled(false);
        }
        if ("true".equalsIgnoreCase(smtpAuthStr = properties.getProperty("mail.smtpAuthEnable"))) {
            this.smtpEnableCheckBox.setSelected(true);
        }
        if ("true".equalsIgnoreCase(forceStr = properties.getProperty("mail.forceEnable4OldGateway"))) {
            this.forceEnable4OldGatewayCheckbox.setSelected(true);
        }
    }

    private void initUI() throws Exception {
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveAction.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.saveAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    MailServerConfigUI.this.saveAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    MailServerConfigUI.this.handUIException(e);
                }
            }
        });
        this.sslEnableCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MailServerConfigUI.this.sslEnableCheckbox.isSelected()) {
                    MailServerConfigUI.this.tlsEnableCheckbox.setEnabled(false);
                } else {
                    MailServerConfigUI.this.tlsEnableCheckbox.setEnabled(true);
                }
            }
        });
        this.tlsEnableCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MailServerConfigUI.this.tlsEnableCheckbox.isSelected()) {
                    MailServerConfigUI.this.sslEnableCheckbox.setEnabled(false);
                } else {
                    MailServerConfigUI.this.sslEnableCheckbox.setEnabled(true);
                }
            }
        });
    }

    protected void saveAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.hostTextField.getText() == null || this.hostTextField.getText().trim().length() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"hostNull"));
            return;
        }
        if (this.usernameTextField.getText() == null || this.usernameTextField.getText().trim().length() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"usernameNull"));
            return;
        }
        if (this.senderMailTextField.getText() == null || this.senderMailTextField.getText().trim().length() == 0) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"mailFromNull"));
            return;
        }
        Properties prop = new Properties();
        prop.setProperty("mail.smtp.host", this.hostTextField.getText());
        prop.setProperty("mail.smtp.port", this.portTextField.getText());
        prop.setProperty("mail.login.username", this.usernameTextField.getText());
        char[] code = this.passwordField.getPassword();
        if (code != null) {
            prop.setProperty("mail.login.password", String.valueOf(code));
        }
        prop.setProperty("mail.from.account", this.senderMailTextField.getText());
        prop.setProperty("mail.from.username", this.senderMailUsernameTextField.getText());
        if (this.sslEnableCheckbox.isSelected()) {
            prop.setProperty("mail.sslEnable", "true");
        } else {
            prop.setProperty("mail.sslEnable", "false");
        }
        if (this.tlsEnableCheckbox.isSelected()) {
            prop.setProperty("mail.tlsEnable", "true");
        } else {
            prop.setProperty("mail.tlsEnable", "false");
        }
        if (this.smtpEnableCheckBox.isSelected()) {
            prop.setProperty("mail.smtpAuthEnable", "true");
        } else {
            prop.setProperty("mail.smtpAuthEnable", "false");
        }
        if (this.tls2EnableCheckbox.isSelected()) {
            prop.setProperty("mail.tls2Enable", "true");
        } else {
            prop.setProperty("mail.tls2Enable", "false");
        }
        if (this.forceEnable4OldGatewayCheckbox.isSelected()) {
            prop.setProperty("mail.forceEnable4OldGateway", "true");
        } else {
            prop.setProperty("mail.forceEnable4OldGateway", "false");
        }
        IMsgFacade iMsgFacade = MsgFacadeFactory.getRemoteInstance();
        iMsgFacade.saveMailServerConfig(prop);
        this.showMsg("SaveOK");
    }

    private void showMsg(String key) {
        String resClassName = "com.kingdee.eas.mobile.client.BizConfigUIResources";
        String s = EASResource.getString((String)resClassName, (String)key);
        MsgBox.showInfo((String)s);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

