/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.IReceiveMobileMessage;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.ReceiveMobileMessageFactory;
import com.kingdee.eas.mobile.client.AbstractMyReceiveMobileListUI;
import com.kingdee.eas.mobile.client.MobileMsgContentViewUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;

public class MyReceiveMobileListUI
extends AbstractMyReceiveMobileListUI {
    private static final String RESOURCE = "com.kingdee.eas.mobile.client.SmsResource";

    public MyReceiveMobileListUI() throws Exception {
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.mobile.app", "AdminReceiveFromSendMobileMessageQuery");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
    }

    private void initTable() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int begin = e.getFirstRow();
                int end = e.getLastRow();
                for (int i = begin; i <= end; ++i) {
                    Object sendNumber;
                    Object sender = MyReceiveMobileListUI.this.tblMain.getRow(i).getCell("sender").getValue();
                    if (sender == null || StringUtils.isEmpty((String)sender.toString())) {
                        MyReceiveMobileListUI.this.tblMain.getRow(i).getCell("sender").setValue(null);
                    }
                    if ((sendNumber = MyReceiveMobileListUI.this.tblMain.getRow(i).getCell("sendNumber").getValue()) != null && !StringUtils.isEmpty((String)sendNumber.toString())) continue;
                    MyReceiveMobileListUI.this.tblMain.getRow(i).getCell("sendNumber").setValue(null);
                }
            }
        });
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        String msgContent = this.tblMain.getRow(rowIndex).getCell("content").getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"mobileContent", (Object)msgContent);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MobileMsgContentViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException e1) {
            ExceptionHandler.handle((String)EASResource.getString((String)RESOURCE, (String)"viewError"), (Throwable)e1);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList != null && MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"delConfirm")) == 0) {
            IReceiveMobileMessage iReceiveMobileMessage = ReceiveMobileMessageFactory.getRemoteInstance();
            IMsgFacade iMsgFacade = MsgFacadeFactory.getRemoteInstance();
            for (int i = 0; i < idList.size(); ++i) {
                if (!iReceiveMobileMessage.exists((IObjectPK)new ObjectUuidPK((String)idList.get(i)))) {
                    MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"cannotRemove"));
                    return;
                }
                iMsgFacade.deleteReceiveMoMsg((String)idList.get(i));
            }
            this.refresh();
        }
    }

    private void refresh() {
        this.tblMain.refresh();
        int rows = this.tblMain.getRowCount();
        if (rows != 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        EntityViewInfo execCondition = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone();
        String receiveId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IQueryExecutor exec = null;
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("receiveId", (Object)receiveId, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("deleted", (Object)new Integer(0), CompareType.EQUALS));
            if (execCondition.getFilter() != null && !StringUtils.isEmpty((String)execCondition.getFilter().toString())) {
                execCondition.getFilter().mergeFilter(filterInfo, "AND");
            } else {
                execCondition.setFilter(filterInfo);
            }
            exec = super.getQueryExecutor(queryPK, execCondition);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return exec;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[5];
        locateNames[0] = "sendNumber";
        locateNames[1] = "sender";
        locateNames[2] = "content";
        return locateNames;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

