/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.CoreSendMessageCollection;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.CustomCMDShortCutCollection;
import com.kingdee.eas.mobile.CustomCMDShortCutFactory;
import com.kingdee.eas.mobile.EmailSendMessageCollection;
import com.kingdee.eas.mobile.ICustomCMDShortCut;
import com.kingdee.eas.mobile.IMessageSubscript;
import com.kingdee.eas.mobile.IUserMessageConfig;
import com.kingdee.eas.mobile.MessageSubscriptCollection;
import com.kingdee.eas.mobile.MessageSubscriptFactory;
import com.kingdee.eas.mobile.PriorityEnum;
import com.kingdee.eas.mobile.SendMobileMessageCollection;
import com.kingdee.eas.mobile.UserInfo;
import com.kingdee.eas.mobile.UserMessageConfigFactory;
import com.kingdee.eas.mobile.UserMessageConfigInfo;
import com.kingdee.eas.mobile.dao.DefaultEmailMessageDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.msg.UserCommandInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class DefaultMsgDAO {
    private DefaultMsgDAO() {
    }

    public static UserMessageConfigInfo getUserMessageConfigInfoByUserId(Context ctx, String userId) throws BOSException {
        String sql = "select FID,FUserId,FReceiveCommon,FReceiveImportant from T_MO_UserMsgConfig  where FUserId=?";
        Object[] params = new Object[]{userId};
        UserMessageConfigInfo userMsgConfigInfo = null;
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            rowset.beforeFirst();
            userMsgConfigInfo = new UserMessageConfigInfo();
            while (rowset.next()) {
                userMsgConfigInfo.setUserId(rowset.getString("FUserId"));
                userMsgConfigInfo.setReceiveCommon(rowset.getInt("FReceiveCommon"));
                userMsgConfigInfo.setReceiveImportant(rowset.getInt("FReceiveImportant"));
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return null;
    }

    public static CoreSendMessageCollection getUnSendMsgs(Context ctx) throws BOSException, EASBizException {
        SendMobileMessageCollection unSendMoMsgs = DefaultSendMoMsgDao.getUnSendMobileMsgs(ctx);
        EmailSendMessageCollection unSendEmails = DefaultEmailMessageDAO.getUnSendEmails(ctx);
        CoreSendMessageCollection coreSendMsgs = new CoreSendMessageCollection();
        DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.HIGHT);
        DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendEmails, PriorityEnum.HIGHT);
        DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.COMMON);
        DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendEmails, PriorityEnum.COMMON);
        DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.LOW);
        DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendEmails, PriorityEnum.LOW);
        return coreSendMsgs;
    }

    public static CoreSendMessageCollection getUnSendMsgsByChannel(Context ctx, int Channel2) throws BOSException, EASBizException {
        CoreSendMessageCollection coreSendMsgs = new CoreSendMessageCollection();
        EmailSendMessageCollection unSendEmails = null;
        SendMobileMessageCollection unSendMoMsgs = null;
        switch (Channel2) {
            case 1: {
                unSendEmails = DefaultEmailMessageDAO.getUnSendEmails(ctx);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendEmails, PriorityEnum.HIGHT);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendEmails, PriorityEnum.COMMON);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendEmails, PriorityEnum.LOW);
                break;
            }
            case 4: {
                unSendMoMsgs = DefaultSendMoMsgDao.getUnSendMobileMsgs(ctx);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.HIGHT);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.COMMON);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.LOW);
                break;
            }
            default: {
                unSendMoMsgs = DefaultSendMoMsgDao.getUnSendMobileMsgs(ctx);
                unSendEmails = DefaultEmailMessageDAO.getUnSendEmails(ctx);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.HIGHT);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendEmails, PriorityEnum.HIGHT);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.COMMON);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendEmails, PriorityEnum.COMMON);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendMoMsgs, PriorityEnum.LOW);
                DefaultMsgDAO.addMoMsgsByPriority(coreSendMsgs, unSendEmails, PriorityEnum.LOW);
            }
        }
        return coreSendMsgs;
    }

    public static void addMoMsgsByPriority(CoreSendMessageCollection desCoreMsfs, AbstractObjectCollection srcCoreMsfs, PriorityEnum priority) throws BOSException, EASBizException {
        if (desCoreMsfs == null) {
            desCoreMsfs = new CoreSendMessageCollection();
        } else if (desCoreMsfs.size() >= 100) {
            return;
        }
        if (srcCoreMsfs != null) {
            for (int i = 0; i < srcCoreMsfs.size(); ++i) {
                CoreSendMessageInfo coreSendMessageInfo;
                if (srcCoreMsfs.getObject(i) == null || !(srcCoreMsfs.getObject(i) instanceof CoreSendMessageInfo) || !(coreSendMessageInfo = (CoreSendMessageInfo)srcCoreMsfs.getObject(i)).getPriority().equals((Object)priority)) continue;
                desCoreMsfs.add(coreSendMessageInfo);
                if (desCoreMsfs.size() < 100) continue;
                return;
            }
        }
    }

    public static boolean saveBizCommand(Context ctx, HashMap bizCommandHM) throws BOSException {
        if (bizCommandHM == null || bizCommandHM.size() == 0) {
            String clearAllCommand = " update T_MO_CommandObject set FCmdCustomNumber = '' ";
            DbUtil.execute((Context)ctx, (String)clearAllCommand);
            return true;
        }
        StringBuffer functionIdSB = new StringBuffer("");
        Iterator iter = bizCommandHM.keySet().iterator();
        while (iter.hasNext()) {
            functionIdSB.append(",'" + iter.next().toString() + "'");
        }
        String functionIds = functionIdSB.toString().substring(0, 1).equals(",") ? functionIdSB.toString().substring(1) : functionIdSB.toString();
        String updateCommandNullSQL = "update T_MO_CommandObject set FCmdCustomNumber = '' where FID not in (select a.FID from T_MO_CommandObject a, T_MO_BizFunction b where a.FID = b.FCommandObjID and b.FID in (" + functionIds + "))";
        DbUtil.execute((Context)ctx, (String)updateCommandNullSQL);
        String updateCommandSQL = "";
        String bizFunction = "";
        iter = bizCommandHM.keySet().iterator();
        while (iter.hasNext()) {
            bizFunction = iter.next().toString();
            updateCommandSQL = "update T_MO_CommandObject set FCmdCustomNumber = ? where FID in (select a.FID from T_MO_CommandObject a, T_MO_BizFunction b where a.FID = b.FCommandObjID and b.FID = ?)";
            Object[] params = new Object[]{bizCommandHM.get(bizFunction), bizFunction};
            DbUtil.execute((Context)ctx, (String)updateCommandSQL, (Object[])params);
        }
        return true;
    }

    public static String[] getAllBizFunctionImpClass(Context ctx) throws BOSException {
        String sql = "select FImplClassName from T_MO_BizFunction ";
        ArrayList<String> classList = new ArrayList<String>();
        String[] classes = null;
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                classList.add(rowset.getString("FImplClassName"));
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        if (classList.size() > 0) {
            classes = new String[classList.size()];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = classList.get(i).toString();
            }
            classList.toArray();
        }
        return classes;
    }

    public static String getPersonEmailByMobileNumber(Context ctx, String mobileNumber) throws Exception {
        String email = null;
        String sql = "select FEMail from T_BD_Person where FCell = '" + mobileNumber + "'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rows.next()) {
            email = rows.getString(1);
        }
        return email;
    }

    public static boolean updatePersonConfig(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        if (personInfo == null) {
            return false;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("cell"));
        sic.add(new SelectorItemInfo("email"));
        sic.add(new SelectorItemInfo("rtx"));
        PersonFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)personInfo, sic);
        return true;
    }

    public static boolean saveUserMessageConfigInfo(Context ctx, UserMessageConfigInfo userMsgConfigInfo) throws BOSException, EASBizException {
        if (userMsgConfigInfo == null) {
            return false;
        }
        IUserMessageConfig iUserMessageConfig = UserMessageConfigFactory.getLocalInstance(ctx);
        IObjectPK pk = null;
        if (userMsgConfigInfo.getId() != null) {
            pk = new ObjectUuidPK(userMsgConfigInfo.getId());
            UserMessageConfigInfo theUserMsgConfigInfo = iUserMessageConfig.getUserMessageConfigInfo(pk);
            if (theUserMsgConfigInfo == null) {
                pk = iUserMessageConfig.addnew(userMsgConfigInfo);
                if (pk == null) {
                    return false;
                }
            } else {
                iUserMessageConfig.update(pk, userMsgConfigInfo);
            }
        } else {
            pk = iUserMessageConfig.addnew(userMsgConfigInfo);
            if (pk == null) {
                return false;
            }
        }
        return true;
    }

    public static boolean saveUserShortCut(Context ctx, CustomCMDShortCutCollection cCMDShortCutInfos) throws BOSException, EASBizException {
        if (cCMDShortCutInfos == null || cCMDShortCutInfos.size() == 0) {
            return false;
        }
        String sql = "delete from T_MO_CustomCMDShortCut";
        DbUtil.execute((Context)ctx, (String)sql);
        ICustomCMDShortCut iCustomCMDShortCut = CustomCMDShortCutFactory.getLocalInstance(ctx);
        for (int i = 0; i < cCMDShortCutInfos.size(); ++i) {
            iCustomCMDShortCut.addnew(cCMDShortCutInfos.get(i));
        }
        return true;
    }

    public static boolean saveUserShortCut1(Context ctx, CustomCMDShortCutCollection cCMDShortCutInfos, String userId) throws BOSException, EASBizException {
        if (cCMDShortCutInfos == null || cCMDShortCutInfos.size() == 0) {
            return false;
        }
        String sql = "delete from T_MO_CustomCMDShortCut where FUserID = '" + userId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        ICustomCMDShortCut iCustomCMDShortCut = CustomCMDShortCutFactory.getLocalInstance(ctx);
        for (int i = 0; i < cCMDShortCutInfos.size(); ++i) {
            iCustomCMDShortCut.addnew(cCMDShortCutInfos.get(i));
        }
        return true;
    }

    public static boolean saveUserSubscript(Context ctx, MessageSubscriptCollection subscriptCol, String userId) throws BOSException, EASBizException {
        if (subscriptCol == null || subscriptCol.size() == 0) {
            return false;
        }
        String sql = "delete from T_MO_MessageSubscript where FUserID = '" + userId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        IMessageSubscript iMessageSubscript = MessageSubscriptFactory.getLocalInstance(ctx);
        for (int i = 0; i < subscriptCol.size(); ++i) {
            iMessageSubscript.addnew(subscriptCol.get(i));
        }
        return true;
    }

    public static String[] getBizFunctionByUserShortCut(Context ctx, String userId, char shortcut) throws BOSException {
        String[] bizFunction = new String[3];
        String sql = "select top 1 FImplClassName, FCommandNumber, a.fid from T_MO_BizFunction a, T_MO_CustomCMDShortCut b, T_MO_CommandObject c  where a.FID = b.FBizFunctionID and a.FCommandObjID = c.FID and b.FUserID = ? and b.FShortCut= ?";
        Object[] params = new Object[]{userId, new String(shortcut + "")};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                bizFunction[0] = rowset.getString(1);
                bizFunction[1] = rowset.getString(2);
                bizFunction[2] = rowset.getString(3);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return bizFunction;
    }

    public static String[] getBizFunctionByCommand(Context ctx, String command) throws BOSException {
        String[] bizFunction = new String[]{null, null, null};
        String sql = "select top 1 FImplClassName, FCommandNumber, a.fid from T_MO_BizFunction a, T_MO_CommandObject b where b.FID = a.FCommandObjID and b.FCmdCustomNumber = ?";
        Object[] params = new Object[]{command};
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                bizFunction[0] = rowset.getString(1);
                bizFunction[1] = rowset.getString(2);
                bizFunction[2] = rowset.getString(3);
            }
            if (StringUtils.isEmpty((String)bizFunction[0])) {
                sql = "select top 1 FImplClassName, FCommandNumber, a.fid from T_MO_BizFunction a, T_MO_CommandObject b where b.FID = a.FCommandObjID and b.FCommandNumber = ?";
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                rowset.beforeFirst();
                while (rowset.next()) {
                    bizFunction[0] = rowset.getString(1);
                    bizFunction[1] = rowset.getString(2);
                    bizFunction[2] = rowset.getString(3);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return bizFunction;
    }

    public UserInfo getUserInfo(String userid, Connection con, boolean autoClose) {
        return null;
    }

    public UserInfo getUserInfoByMobile(String moblieNum, Connection con, boolean autoClose) {
        return null;
    }

    public UserInfo getUserInfoByRtx(String rtx, Connection con, boolean autoClose) {
        return null;
    }

    public String getUserCommand(String addressNumber, char num, String ais, int mode, Connection conn) {
        return null;
    }

    public UserInfo getUserInfoByEmail(String email, Connection con, boolean autoClose) {
        return null;
    }

    public String getUserCommand(char c, String userid, String ais, Connection con) {
        return null;
    }

    public UserCommandInfo[] getUserCommands(String userid, String ais, Connection con) {
        return null;
    }

    public boolean saveUser(UserInfo userinfo, UserCommandInfo[] shotCuts, Connection con, String ais) {
        return false;
    }
}

