/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.message.client.BizInterface;
import com.kingdee.bos.message.client.BizInterfaceFactory;
import com.kingdee.bos.message.client.ConnectMonitor;
import com.kingdee.bos.message.client.KDMsgListener;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.message.common.KDMsgCreator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.EmailAddressInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.framework.IMobileGatewayProvider;
import com.kingdee.eas.mobile.msg.MobileConnectException;
import com.kingdee.eas.mobile.util.MailServerConfigPropUtil;
import com.kingdee.eas.mobile.util.MailUtil;
import com.kingdee.eas.util.client.EASResource;
import org.apache.log4j.Logger;

public class KingdeeMobileGatewayProvider
implements IMobileGatewayProvider {
    private static final Logger logger = Logger.getLogger(KingdeeMobileGatewayProvider.class);
    private KDMsgCreator helper = KDMsgCreator.create();
    private BizInterface bizInterface = BizInterfaceFactory.getInstance();

    @Override
    public boolean sendMessage(SendMobileMessageInfo sendMoMsgInfo, MobileConfigInfo mobileConfigInfo, Context ctx) throws EASBizException, BOSException {
        KDMessage kdMsg = sendMoMsgInfo.transform2KDMsg(ctx);
        return this.bizInterface.sendMessage(kdMsg);
    }

    @Override
    public boolean sendMail(EmailSendMessageInfo emailSendMessageInfo, Context ctx) throws EASBizException, BOSException {
        if (MailServerConfigPropUtil.isForceEnable4OldGateway()) {
            EmailAddressInfo address = emailSendMessageInfo.getAddress();
            if (address == null) {
                logger.error((Object)"sendMail error: address is null");
                return false;
            }
            String content = "";
            content = emailSendMessageInfo.getContent() != null && emailSendMessageInfo.getContent().length() > 0 ? emailSendMessageInfo.getContent() : emailSendMessageInfo.getLongContent();
            return MailUtil.sendMail(ctx, emailSendMessageInfo.getTitle(), content, emailSendMessageInfo.getMimeType(), address.getTo(), address.getBcc(), address.getCc(), null);
        }
        KDMessage kdMsg = emailSendMessageInfo.transform2KDMsg(ctx);
        return this.bizInterface.sendMessage(kdMsg);
    }

    @Override
    public boolean testConnection(MobileConfigInfo mobileConfigInfo) {
        return this.bizInterface.connect(mobileConfigInfo.getHost(), Integer.parseInt(mobileConfigInfo.getPort()), mobileConfigInfo.getLoginName(), mobileConfigInfo.getPassword());
    }

    @Override
    public String displayBalance(MobileConfigInfo mobileConfigInfo) throws EASBizException, BOSException {
        return EASResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"balanceTipNotSupport");
    }

    @Override
    public void receiveMessage(MobileConfigInfo mobileConfigInfo, Context ctx) throws BOSException {
        logger.info((Object)"KingdeeMobileGatewayProvider-receiveMessage...doing nothing");
    }

    @Override
    public void addConnectMonitor(ConnectMonitor connectMonitor) {
        this.bizInterface.addConnectMonitor(connectMonitor);
    }

    @Override
    public void addMsgListener(KDMsgListener kDMsgListener) {
        this.bizInterface.addMsgListener(kDMsgListener);
    }

    @Override
    public boolean connect(String hostname, int port, String loginName, String password) {
        return this.bizInterface.connect(hostname, port, loginName, password);
    }

    @Override
    public void disConnect() {
        this.bizInterface.disConnect();
    }

    @Override
    public boolean isConnected() {
        return this.bizInterface.isConnected();
    }

    @Override
    public boolean sendMessage(KDMessage arg0) {
        return this.bizInterface.sendMessage(arg0);
    }

    @Override
    public boolean sendMail(Context ctx, String title, String content, MimeTypeEnum contentMimeType, String receiver, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        if (MailServerConfigPropUtil.isForceEnable4OldGateway()) {
            return MailUtil.sendMail(ctx, title, content, contentMimeType, receiver, secretReceiver, copyReceiver, attachment);
        }
        if (content.trim().length() < 1) {
            content = null;
        }
        if (receiver == null) {
            throw new MobileConnectException(MobileConnectException.USER_NOT_LOIGN_EMAIL);
        }
        logger.info((Object)("----mobile----title=" + title + " content=" + content + " receiver=" + receiver));
        KDMessage message = this.helper.createMsgForMail(receiver, title, content, attachment);
        this.helper.addMailBcc(message, secretReceiver);
        this.helper.addMailCc(message, copyReceiver);
        return this.bizInterface.sendMessage(message);
    }

    @Override
    public boolean sendMessage(String content, String receiver, MobileConfigInfo mobileConfigInfo, Context ctx) throws BOSException, EASBizException {
        if (receiver == null) {
            logger.debug((Object)"receiver is null");
            throw new MobileConnectException(MobileConnectException.USER_NOT_LOIGN);
        }
        KDMessage message = this.helper.createMsgForSMS(receiver, content);
        KDMessageAddress sendAddress = new KDMessageAddress(ctx.getAIS(), ctx.getAIS());
        message.setSender(sendAddress);
        KDMessageAddress receiveAddress = new KDMessageAddress("mp:sms", receiver);
        message.setReceivers(new KDMessageAddress[]{receiveAddress});
        return this.bizInterface.sendMessage(message);
    }
}

