/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.mobile.BOSMsgTypeEnum;
import com.kingdee.eas.mobile.CellphoneNumberTypeEnum;
import com.kingdee.eas.mobile.CoreReceiveMessageInfo;
import com.kingdee.eas.mobile.CoreSendMessageCollection;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.EmailAddressInfo;
import com.kingdee.eas.mobile.EmailReceiveMessageInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.IMobileConfig;
import com.kingdee.eas.mobile.MobileConfigCollection;
import com.kingdee.eas.mobile.MobileConfigFactory;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.MobileMessageAddressInfo;
import com.kingdee.eas.mobile.ReceiveMobileMessageInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.biz.BizDispatcher;
import com.kingdee.eas.mobile.dao.DBHelper;
import com.kingdee.eas.mobile.dao.DefaultEmailMessageDAO;
import com.kingdee.eas.mobile.dao.DefaultMsgDAO;
import com.kingdee.eas.mobile.dao.DefaultReceiveMoMsgDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDaoImp;
import com.kingdee.eas.mobile.framework.BizServer;
import com.kingdee.eas.mobile.msg.CommunicateException;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.mobile.util.MobileUtil;
import com.kingdee.eas.mobile.util.MsgTransform;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class MsgServiceAssistant {
    private static final Logger logger = Logger.getLogger(MsgServiceAssistant.class);

    private MsgServiceAssistant() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void sendMessages(Context ctx, CoreSendMessageCollection unSendMsgs) {
        CoreSendMessageInfo coreSendMsgInfo = null;
        KDMessage kdMsg = null;
        BizServer bizServer = BizServer.getInstance(ctx);
        Connection conn = null;
        try {
            try {
                MobileConfigInfo mobileConfigInfo;
                int channels;
                IMobileConfig iMobileConfig = MobileConfigFactory.getLocalInstance(ctx);
                MobileConfigCollection mobileConfigs = iMobileConfig.getMobileConfigCollection();
                if (mobileConfigs.size() > 0 && ((channels = (mobileConfigInfo = mobileConfigs.get(0)).getChannels()) == 4 || channels == 5 || channels == 6 || channels == 7)) {
                    bizServer.open();
                }
            }
            catch (BOSException e) {
                logger.error((Object)"sendMessages--MobileConfigFactory.getLocalInstance(ctx) Error");
            }
            conn = DBHelper.getConnection(ctx);
            boolean sendSucceed = false;
            for (int i = 0; i < unSendMsgs.size(); ++i) {
                coreSendMsgInfo = unSendMsgs.get(i);
                try {
                    boolean isSendFail;
                    kdMsg = coreSendMsgInfo.transform2KDMsg(ctx);
                    try {
                        if (coreSendMsgInfo instanceof SendMobileMessageInfo) {
                            SendMobileMessageInfo sendMobileMessageInfo = (SendMobileMessageInfo)coreSendMsgInfo;
                            if (sendMobileMessageInfo != null && sendMobileMessageInfo.getAddress() != null && StringUtils.isEmpty((String)sendMobileMessageInfo.getAddress().getSendMobileNumber())) {
                                sendMobileMessageInfo.setSendFail(true);
                                logger.info((Object)"--------mobile--send----Send Mobile Message  MobileNumber is null,Set sendFail=true ");
                            }
                            sendSucceed = bizServer.sendMessage(sendMobileMessageInfo);
                        } else if (coreSendMsgInfo instanceof EmailSendMessageInfo) {
                            sendSucceed = bizServer.sendMail((EmailSendMessageInfo)coreSendMsgInfo);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("--------mobile--send----Send Email error, id = " + coreSendMsgInfo.getId().toString()));
                        logger.error((Object)e.getMessage());
                        sendSucceed = false;
                    }
                    catch (Throwable t) {
                        logger.error((Object)("--------mobile--send----Send Email error, id = " + coreSendMsgInfo.getId().toString()));
                        logger.error((Object)t.getMessage());
                        sendSucceed = false;
                    }
                    boolean bl = isSendFail = coreSendMsgInfo.getSentFailNumber() == 4;
                    if (coreSendMsgInfo instanceof EmailSendMessageInfo) {
                        if (!sendSucceed) {
                            logger.error((Object)("--------mobile--send----Send Email error, id = " + coreSendMsgInfo.getId().toString() + ", this message send failed."));
                            DefaultEmailMessageDAO.updateSendEmailMsgInfo(ctx, coreSendMsgInfo.getId().toString(), false, null, isSendFail);
                            if (bizServer.isOldKingdeeGatewayProvider()) {
                                if (isSendFail) {
                                    MsgServiceAssistant.sendFailMessages(ctx, kdMsg, coreSendMsgInfo, false);
                                } else {
                                    logger.warn((Object)"==================REACHED THE MAX FIALED TIMES, LOG BEGIN=========================");
                                    logger.warn((Object)("Email MSG Id:" + coreSendMsgInfo.getId()));
                                    logger.warn((Object)("Email MSG Title:" + coreSendMsgInfo.getTitle()));
                                    logger.warn((Object)"==================REACHED THE MAX FIALED TIMES, LOG END=========================");
                                }
                            }
                        } else {
                            Timestamp ts = new Timestamp(System.currentTimeMillis());
                            DefaultEmailMessageDAO.updateSendEmailMsgInfo(ctx, coreSendMsgInfo.getId().toString(), true, ts, isSendFail);
                        }
                    } else if (coreSendMsgInfo instanceof SendMobileMessageInfo) {
                        if (!sendSucceed) {
                            logger.error((Object)("--------mobile--send----Send Mobile error, id = , id = " + coreSendMsgInfo.getId().toString() + ", this message send failed."));
                            if (bizServer.isOldKingdeeGatewayProvider()) {
                                if (isSendFail) {
                                    MsgServiceAssistant.sendFailMessages(ctx, kdMsg, coreSendMsgInfo, true);
                                } else {
                                    logger.warn((Object)"==================REACHED THE MAX FIALED TIMES, LOG BEGIN=========================");
                                    logger.warn((Object)("MOBILE MSG Id:" + coreSendMsgInfo.getId()));
                                    logger.warn((Object)("MOBILE MSG Content:" + coreSendMsgInfo.getContent()));
                                    logger.warn((Object)"==================REACHED THE MAX FIALED TIMES, LOG END=========================");
                                }
                            }
                        }
                        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new DefaultSendMoMsgDaoImp());
                        try {
                            Class<?> c = Class.forName("com.kingdee.eas.mobile.dao.DefaultSendMoMsgDaoImp");
                            Class[] partypes = new Class[]{Context.class, String.class, Connection.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE};
                            Method method = c.getMethod("updateSendMoMsgInfo", partypes);
                            txInvoker.invoke(method, new Object[]{ctx, coreSendMsgInfo.getId().toString(), conn, new Boolean(true), new Boolean(sendSucceed), new Boolean(isSendFail)}, 3);
                        }
                        catch (Throwable ex) {
                            logger.error((Object)ex);
                            logger.info((Object)"----mobile---send error----\u53d1\u9001\u77ed\u4fe1\u540e\u56de\u5199\u6570\u636e\u5e93\u5931\u8d25,\u53ef\u80fd\u9020\u6210\u91cd\u590d\u53d1\u9001\u7684\u95ee\u9898----------------------");
                        }
                    }
                    sendSucceed = false;
                    continue;
                }
                catch (Throwable err) {
                    logger.error((Object)("Send messages have some error, id = " + coreSendMsgInfo.getId().toString() + ", and error information is : "), err);
                }
            }
        }
        catch (CommunicateException err) {
            logger.error((Object)"Send messages have some communicate error", (Throwable)err);
            DBHelper.cleanup(conn);
        }
        catch (SQLException err2) {
            logger.error((Object)"Send messages have some sql error", (Throwable)err2);
            {
                catch (Throwable throwable) {
                    DBHelper.cleanup(conn);
                    throw throwable;
                }
            }
            DBHelper.cleanup(conn);
        }
        DBHelper.cleanup(conn);
    }

    public static void sendFailMessages(Context ctx, KDMessage kdMsg, CoreSendMessageInfo coreSendMsgInfo, boolean mobileFlag) {
        String receiver = "";
        String title = kdMsg.getTitle();
        String content = kdMsg.getContent();
        title = !StringUtils.isEmpty((String)title) ? EASResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"sendFail") + title : EASResource.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"sendFail") + content;
        receiver = mobileFlag ? ((SendMobileMessageInfo)coreSendMsgInfo).getAddress().getReceiveBizUser().getId().toString() : ((EmailSendMessageInfo)coreSendMsgInfo).getAddress().getReceiveBizUser().getId().toString();
        Message noticeMsg = MsgUtil.createMessage(ctx, receiver, title, content);
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        senderAgent.sendMessage(noticeMsg);
    }

    public static void handleForNotifyMsg(Context ctx, KDMessage msg) {
        KDMessageAddress address = msg.getSender();
        String mobile = address.getDetail();
        if (!"1".equalsIgnoreCase(msg.getTitle()) && "0".equalsIgnoreCase(msg.getTitle())) {
            logger.info((Object)("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u6539\u4e3a\u90ae\u4ef6\u53d1\u9001\uff0c\u53d1\u9001\u5931\u8d25\u7684\u77ed\u4fe1ID: " + msg.getId()));
            try {
                String email = null;
                email = DefaultMsgDAO.getPersonEmailByMobileNumber(ctx, mobile);
                if (!StringUtils.isEmpty((String)email)) {
                    SendMobileMessageInfo sendMobileMessageInfo;
                    if (1 == BOSMsgTypeEnum.getMsgType(address.getDeviceName()) && (sendMobileMessageInfo = DefaultSendMoMsgDao.getSendMoMsgInfoByMsgId(ctx, msg.getId())) != null) {
                        MsgUtil.msgMailDerect(ctx, sendMobileMessageInfo.getContent(), "", email, null, null, null);
                    }
                } else {
                    logger.warn((Object)("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u6539\u4e3a\u90ae\u4ef6\u53d1\u9001\uff0c\u4f46\u63a5\u6536\u4eba " + mobile + " \u65e0\u90ae\u4ef6\u5730\u5740\uff0c\u4e0d\u4e88\u53d1\u9001"));
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u53d1\u9001\u5931\u8d25\u7684\u77ed\u4fe1\u8f6c\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void handleForSendHandcraftMsg(Context ctx, KDMessage receiveMsg, SendMobileMessageInfo parentSendMoMsgInfo) {
        logger.info((Object)("ReceiveMessage(in handleForSendHandcraftMsg) : title= " + receiveMsg.getTitle() + "; content= " + receiveMsg.getContent()));
        try {
            String sendNumber;
            ReceiveMobileMessageInfo receiveMoMsgInfo = MsgTransform.msg2ReceiveMoMsg(ctx, receiveMsg, parentSendMoMsgInfo);
            receiveMoMsgInfo.getAddress().setReceiveMobileNumber(parentSendMoMsgInfo.getAddress().getSendMobileNumber());
            receiveMoMsgInfo.getAddress().setReceiveBizUser(parentSendMoMsgInfo.getAddress().getSendBizUser());
            String userid = null;
            try {
                userid = AppMsgUtil.getUserIdByAddress(ctx, receiveMsg.getSender());
                UserInfo userInfo = null;
                IUser iUser = UserFactory.getLocalInstance((Context)ctx);
                if (userid != null) {
                    userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userid));
                }
                if (userInfo != null) {
                    receiveMoMsgInfo.getAddress().setSendBizUser(userInfo);
                }
            }
            catch (BOSException err) {
                logger.error((Object)("ReceiveMessage: " + receiveMsg.getTitle() + " , has none send user\uff01"));
                return;
            }
            IObjectPK pk = DefaultReceiveMoMsgDAO.addNew(ctx, receiveMoMsgInfo);
            if (pk == null) {
                logger.error((Object)("\u5904\u7406\u624b\u5de5\u53d1\u9001\u540e\u76f4\u63a5\u56de\u590d\u7684\u6d88\u606f\u62a5\u9519\uff0c\u65e0\u6cd5\u4fdd\u5b58\u63a5\u6536\u5230\u7684\u77ed\u4fe1\uff01MsgId: " + receiveMsg.getId()));
                return;
            }
            SendMobileMessageInfo sendMoMsgInfo = MsgTransform.receiveMsg2SendMoMsg(ctx, receiveMsg, parentSendMoMsgInfo, receiveMoMsgInfo);
            if (sendMoMsgInfo == null) {
                logger.error((Object)"handleForSendHandcraftMsg error: \u5904\u7406\u624b\u5de5\u53d1\u9001\u540e\u76f4\u63a5\u56de\u590d\u7684\u6d88\u606f\u62a5\u9519\uff1asendMoMsgInfo is null");
            }
            sendMoMsgInfo.setSendHandcraft(true);
            sendMoMsgInfo.setRevertible(true);
            sendMoMsgInfo.setSent(false);
            MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
            addressInfo.setReceiveMobileNumber(parentSendMoMsgInfo.getAddress().getSendMobileNumber());
            addressInfo.setReceiveBizUser(parentSendMoMsgInfo.getAddress().getSendBizUser());
            addressInfo.setSendMobileNumber(parentSendMoMsgInfo.getAddress().getReceiveMobileNumber());
            addressInfo.setSendBizUser(receiveMoMsgInfo.getAddress().getSendBizUser());
            String recNumber = addressInfo.getReceiveMobileNumber();
            if (!StringUtils.isEmpty((String)recNumber)) {
                CellphoneNumberTypeEnum recCellNumType = CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(recNumber));
                addressInfo.setReceiveCellNumberType(recCellNumType);
            }
            if (!StringUtils.isEmpty((String)(sendNumber = addressInfo.getReceiveMobileNumber()))) {
                CellphoneNumberTypeEnum sendCellNumType = CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(sendNumber));
                addressInfo.setSendCellNumberType(sendCellNumType);
            }
            sendMoMsgInfo.setAddress(addressInfo);
            sendMoMsgInfo.setParentMsg(receiveMoMsgInfo);
            sendMoMsgInfo.setRootMsgID(receiveMoMsgInfo.getRootMsgID());
            sendMoMsgInfo.setId(null);
            pk = DefaultSendMoMsgDao.addNew(ctx, sendMoMsgInfo);
            if (pk == null) {
                logger.error((Object)("\u5904\u7406\u624b\u5de5\u53d1\u9001\u540e\u76f4\u63a5\u56de\u590d\u7684\u6d88\u606f\u62a5\u9519\uff0c\u65e0\u6cd5\u8f6c\u53d1\u63a5\u6536\u5230\u7684\u77ed\u4fe1\u7ed9\u539f\u53d1\u77ed\u4fe1\u4eba\uff01id: " + receiveMoMsgInfo.getId().toString()));
                return;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5904\u7406\u624b\u5de5\u53d1\u9001\u540e\u76f4\u63a5\u56de\u590d\u7684\u6d88\u606f\u62a5\u9519", (Throwable)e);
        }
    }

    public static void handleForAllTypeMsg(Context ctx, KDMessage msg, String userid, SendMobileMessageInfo theParentSendMsgInfo) {
    }

    public static void handleForSendOrReplyMsg(Context ctx, KDMessage msg, String userId, CoreSendMessageInfo theParentSendMsgInfo) {
        logger.info((Object)("ReceiveMessage(in handleForSendOrReplyMsg) : title = " + msg.getTitle() + "; content = " + msg.getContent()));
        try {
            IObjectPK pk;
            CoreReceiveMessageInfo coreReceiveMessageInfo = null;
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = iUser.getUserInfo((IObjectPK)new ObjectUuidPK(userId));
            KDMessageAddress address = msg.getSender();
            String deviceName = address.getDeviceName();
            if ("mp:sms".equals(deviceName)) {
                ReceiveMobileMessageInfo receiveMoMsgInfo = null;
                SendMobileMessageInfo theParentSendMoMsgInfo = null;
                if (theParentSendMsgInfo != null) {
                    theParentSendMoMsgInfo = (SendMobileMessageInfo)theParentSendMsgInfo;
                }
                if (StringUtils.isEmpty((String)(receiveMoMsgInfo = theParentSendMoMsgInfo != null ? MsgTransform.msg2ReceiveMoMsg(ctx, msg, theParentSendMoMsgInfo) : MsgTransform.msg2ReceiveMoMsg(ctx, msg)).getContent())) {
                    return;
                }
                if (userInfo == null) {
                    return;
                }
                receiveMoMsgInfo.getAddress().setSendBizUser(userInfo);
                if (theParentSendMoMsgInfo != null) {
                    if (theParentSendMoMsgInfo.getAddress().getSendBizUser() != null) {
                        receiveMoMsgInfo.getAddress().setReceiveBizUser(theParentSendMoMsgInfo.getAddress().getSendBizUser());
                    }
                    if (StringUtils.isEmpty((String)receiveMoMsgInfo.getAddress().getReceiveMobileNumber()) && !StringUtils.isEmpty((String)theParentSendMoMsgInfo.getAddress().getSendMobileNumber())) {
                        receiveMoMsgInfo.getAddress().setReceiveMobileNumber(theParentSendMoMsgInfo.getAddress().getSendMobileNumber());
                    }
                    if (!StringUtils.isEmpty((String)theParentSendMoMsgInfo.getAddress().getSendOrgId())) {
                        receiveMoMsgInfo.getAddress().setCU(theParentSendMoMsgInfo.getCU());
                        receiveMoMsgInfo.setCU(theParentSendMoMsgInfo.getCU());
                        receiveMoMsgInfo.getAddress().setReceiveOrgId(theParentSendMoMsgInfo.getAddress().getSendOrgId());
                    }
                }
                if ((pk = DefaultReceiveMoMsgDAO.addNew(ctx, receiveMoMsgInfo)) == null) {
                    logger.error((Object)"handleForSendOrReplyMsg error: can't save the receive message.");
                    return;
                }
                coreReceiveMessageInfo = receiveMoMsgInfo;
            } else if ("mp:mail".equals(deviceName)) {
                EmailReceiveMessageInfo emailReceiveMessageInfo = null;
                EmailSendMessageInfo theParentEmailSendMsgInfo = null;
                if (theParentSendMsgInfo != null) {
                    theParentEmailSendMsgInfo = (EmailSendMessageInfo)theParentSendMsgInfo;
                }
                if (StringUtils.isEmpty((String)(emailReceiveMessageInfo = theParentEmailSendMsgInfo != null ? MsgTransform.msg2ReceiveEmail(ctx, msg, theParentEmailSendMsgInfo) : MsgTransform.msg2ReceiveEmail(ctx, msg)).getContent())) {
                    return;
                }
                if (userInfo != null) {
                    emailReceiveMessageInfo.getAddress().setSendBizUser(userInfo);
                }
                if (theParentEmailSendMsgInfo != null) {
                    if (theParentEmailSendMsgInfo.getAddress().getSendBizUser() != null) {
                        emailReceiveMessageInfo.getAddress().setReceiveBizUser(theParentEmailSendMsgInfo.getAddress().getSendBizUser());
                    }
                    if (StringUtils.isEmpty((String)emailReceiveMessageInfo.getAddress().getTo()) && !StringUtils.isEmpty((String)theParentEmailSendMsgInfo.getAddress().getFrom())) {
                        emailReceiveMessageInfo.getAddress().setTo(theParentEmailSendMsgInfo.getAddress().getFrom());
                    }
                    if (!StringUtils.isEmpty((String)theParentEmailSendMsgInfo.getAddress().getSendOrgId())) {
                        emailReceiveMessageInfo.getAddress().setCU(theParentEmailSendMsgInfo.getCU());
                        emailReceiveMessageInfo.setCU(theParentEmailSendMsgInfo.getCU());
                        emailReceiveMessageInfo.getAddress().setReceiveOrgId(theParentEmailSendMsgInfo.getAddress().getSendOrgId());
                    }
                }
                if ((pk = DefaultEmailMessageDAO.addNew(ctx, emailReceiveMessageInfo)) == null) {
                    logger.error((Object)"handleForSendOrReplyMsg error: can't save the receive message.");
                    return;
                }
                coreReceiveMessageInfo = emailReceiveMessageInfo;
            } else if ("mp:im".equals(deviceName)) {
                return;
            }
            CoreSendMessageInfo coreSendMessageInfo = BizDispatcher.executeBizAction(ctx, userInfo, coreReceiveMessageInfo);
            if (coreSendMessageInfo != null) {
                IObjectPK pk2 = null;
                if (coreReceiveMessageInfo instanceof ReceiveMobileMessageInfo) {
                    ReceiveMobileMessageInfo receiveMoMsgInfo = (ReceiveMobileMessageInfo)coreReceiveMessageInfo;
                    MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
                    addressInfo.setReceiveMobileNumber(receiveMoMsgInfo.getAddress().getSendMobileNumber());
                    addressInfo.setReceiveCellNumberType(CellphoneNumberTypeEnum.getEnum(MobileUtil.getCellphoneNumberType(receiveMoMsgInfo.getAddress().getSendMobileNumber())));
                    addressInfo.setReceiveBizUser(userInfo);
                    coreSendMessageInfo.setRevertible(true);
                    if (theParentSendMsgInfo != null) {
                        // empty if block
                    }
                    ((SendMobileMessageInfo)coreSendMessageInfo).setParentMsg(receiveMoMsgInfo);
                    if (!StringUtils.isEmpty((String)coreReceiveMessageInfo.getRootMsgID())) {
                        coreSendMessageInfo.setRootMsgID(coreReceiveMessageInfo.getRootMsgID());
                    } else if (receiveMoMsgInfo.getParentMsg() != null) {
                        coreSendMessageInfo.setRootMsgID(receiveMoMsgInfo.getParentMsg().getId().toString());
                    }
                    if (theParentSendMsgInfo != null && !StringUtils.isEmpty((String)((SendMobileMessageInfo)theParentSendMsgInfo).getAddress().getSendOrgId())) {
                        ((SendMobileMessageInfo)coreSendMessageInfo).getAddress().setCU(((SendMobileMessageInfo)theParentSendMsgInfo).getCU());
                        ((SendMobileMessageInfo)coreSendMessageInfo).getAddress().setSendOrgId(((SendMobileMessageInfo)theParentSendMsgInfo).getAddress().getSendOrgId());
                        ((SendMobileMessageInfo)coreSendMessageInfo).setCU(((SendMobileMessageInfo)theParentSendMsgInfo).getCU());
                    }
                    coreSendMessageInfo.setCU(userInfo.getCU());
                    ((SendMobileMessageInfo)coreSendMessageInfo).setAddress(addressInfo);
                    pk2 = DefaultSendMoMsgDao.addNew(ctx, (SendMobileMessageInfo)coreSendMessageInfo);
                    if (pk2 == null) {
                        logger.error((Object)"handleForSendOrReplyMsg error: can't save the reply message.");
                        return;
                    }
                    if ("Reply message".equals(coreSendMessageInfo.getTitle()) && theParentSendMsgInfo != null) {
                        DefaultSendMoMsgDao.updateSendMoMsgInfo(ctx, theParentSendMsgInfo.getId().toString(), null, true);
                    }
                } else if (coreReceiveMessageInfo instanceof EmailReceiveMessageInfo) {
                    EmailAddressInfo addressInfo = new EmailAddressInfo();
                    addressInfo.setTo(((EmailReceiveMessageInfo)coreReceiveMessageInfo).getAddress().getFrom());
                    addressInfo.setReceiveBizUser(userInfo);
                    coreSendMessageInfo.setRevertible(true);
                    ((EmailSendMessageInfo)coreSendMessageInfo).setParentMsg((EmailReceiveMessageInfo)coreReceiveMessageInfo);
                    if (!StringUtils.isEmpty((String)coreReceiveMessageInfo.getRootMsgID())) {
                        coreSendMessageInfo.setRootMsgID(coreReceiveMessageInfo.getRootMsgID());
                    } else if (((EmailReceiveMessageInfo)coreReceiveMessageInfo).getParentMsg() != null) {
                        coreSendMessageInfo.setRootMsgID(((EmailReceiveMessageInfo)coreReceiveMessageInfo).getParentMsg().getId().toString());
                    }
                    if (theParentSendMsgInfo != null && !StringUtils.isEmpty((String)((EmailSendMessageInfo)theParentSendMsgInfo).getAddress().getSendOrgId())) {
                        ((EmailSendMessageInfo)coreSendMessageInfo).getAddress().setCU(((EmailSendMessageInfo)theParentSendMsgInfo).getCU());
                        ((EmailSendMessageInfo)coreSendMessageInfo).getAddress().setReceiveOrgId(((EmailSendMessageInfo)theParentSendMsgInfo).getAddress().getSendOrgId());
                        ((EmailSendMessageInfo)coreSendMessageInfo).setCU(((EmailSendMessageInfo)theParentSendMsgInfo).getCU());
                    }
                    ((EmailSendMessageInfo)coreSendMessageInfo).setAddress(addressInfo);
                    pk2 = DefaultEmailMessageDAO.addNew(ctx, (EmailSendMessageInfo)coreSendMessageInfo);
                    if (pk2 == null) {
                        logger.error((Object)"handleForSendOrReplyMsg error: can't save the reply message.");
                        return;
                    }
                    if ("Reply message".equals(coreSendMessageInfo.getTitle()) && theParentSendMsgInfo != null) {
                        DefaultEmailMessageDAO.updateSendEmailMsgInfoForResponsed(ctx, theParentSendMsgInfo.getId().toString(), true);
                    }
                }
            } else {
                logger.info((Object)("has none reply message : title= " + msg.getTitle() + "; content= " + msg.getContent()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"handleForSendOrReplyMsg error: ", (Throwable)e);
        }
    }

    public static void handleForEmail(Context ctx, KDMessage msg, String userid) {
    }
}

