/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.framework;

import com.kingdee.bos.Context;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.msg.MobileConnectException;
import org.apache.log4j.Logger;

public class ServerCenterFactory {
    private static final Logger logger = Logger.getLogger((String)ServerCenterFactory.class.getName());

    private ServerCenterFactory() {
    }

    public static ServerCenter getServerCenter(Context ctx) throws MobileConnectException {
        ServerCenter serverCenter = ServerCenter.getInstance(ctx);
        boolean succeed = false;
        try {
            succeed = serverCenter.isConnect();
        }
        catch (NullPointerException e1) {
            logger.error((Object)("----mobile----check connection error:" + e1));
            throw new MobileConnectException(MobileConnectException.CONNECT_FAIL);
        }
        catch (ORMCoreException e) {
            logger.error((Object)("----mobile----check connection error:" + (Object)((Object)e)));
            throw new MobileConnectException(MobileConnectException.CONNECT_FAIL);
        }
        if (!succeed) {
            logger.info((Object)"----mobile----connection error...");
        }
        if (!succeed && ServerCenterFactory.isShowNoConnection(ctx)) {
            throw new MobileConnectException(MobileConnectException.CONNECT_FAIL);
        }
        return serverCenter;
    }

    private static boolean isShowNoConnection(Context ctx) {
        try {
            String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"isShowNoConnection");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6\u5f97isShowNoConnection\u53c2\u6570\u51fa\u9519", (Throwable)e);
            return false;
        }
    }
}

