/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.message.client.ConnectMonitor;
import com.kingdee.bos.message.client.KDMsgError;
import com.kingdee.bos.message.client.KDMsgListener;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.BOSMsgTypeEnum;
import com.kingdee.eas.mobile.BizFunctionCollection;
import com.kingdee.eas.mobile.BizModuleCollection;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.IMobileConfig;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.MobileConfigCollection;
import com.kingdee.eas.mobile.MobileConfigFactory;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.biz.IBizService;
import com.kingdee.eas.mobile.dao.DBHelper;
import com.kingdee.eas.mobile.dao.DefaultEmailMessageDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.eas.mobile.dao.UserInfoDao;
import com.kingdee.eas.mobile.framework.ConnectionState;
import com.kingdee.eas.mobile.framework.IMobileGatewayProvider;
import com.kingdee.eas.mobile.framework.ISendMessageService;
import com.kingdee.eas.mobile.framework.KingdeeMobileGatewayProvider;
import com.kingdee.eas.mobile.framework.MessageServiceFactory;
import com.kingdee.eas.mobile.framework.MsgServiceAssistant;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.framework.ServerContext;
import com.kingdee.eas.mobile.framework.StateChangeEvent;
import com.kingdee.eas.mobile.msg.BizFunction;
import com.kingdee.eas.mobile.msg.BizModuleConfig;
import com.kingdee.eas.mobile.msg.BizModuleItem;
import com.kingdee.eas.mobile.msg.CommunicateException;
import com.kingdee.eas.mobile.msg.MobileConnectException;
import com.kingdee.eas.mobile.msg.biz.ProcessQueryBiz;
import com.kingdee.eas.mobile.msg.dao.BizConfigDao;
import com.kingdee.eas.mobile.msg.dao.DaoFactory;
import com.kingdee.eas.mobile.msg.framework.IBizModule;
import com.kingdee.eas.mobile.msg.framework.IQueryBiz;
import com.kingdee.eas.mobile.msg.framework.IRevertible;
import com.kingdee.eas.mobile.msg.framework.IStateListener;
import com.kingdee.eas.mobile.msg.framework.ValidateException;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.mobile.util.MessageConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ServerCenterImp
implements KDMsgListener,
ConnectMonitor {
    private static final Logger logger = Logger.getLogger(ServerCenter.class);
    private static HashMap serverCenterHM = new HashMap();
    private static Class[] classes = null;
    private static HashMap messageServerHM = new HashMap();
    private IMobileGatewayProvider iMobileGatewayProvider = null;
    private MobileConfigInfo mobileConfigInfo = null;
    private Context ctx = null;
    private ServerContext context;
    private ConnectionState state = ConnectionState.NOINIT;
    private KDMsgError loginError = null;
    private ArrayList stateListeners = new ArrayList();
    private HashMap bizModules_old = new HashMap();
    private HashMap queryBizs = new HashMap();
    private ArrayList responseBizs = new ArrayList();
    private BizModuleConfig config = new BizModuleConfig();
    private static HashMap configurables = new HashMap();
    private boolean isSorted = false;

    static void loadClasses() {
        for (int i = 0; classes != null && i < classes.length; ++i) {
            Object obj = null;
            Class clazz = classes[i];
            try {
                obj = clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (obj == null) continue;
            String className = clazz.getName();
            logger.debug((Object)("loadedClass: " + className));
            messageServerHM.put(clazz, obj);
        }
    }

    private ServerCenterImp(Context ctx) throws BOSException {
        this.ctx = ctx;
        this.context = new ServerContext(ctx);
        this.iMobileGatewayProvider = this.getGatewayProvider(ctx);
        if (this.iMobileGatewayProvider != null) {
            this.iMobileGatewayProvider.addConnectMonitor(this);
            this.iMobileGatewayProvider.addMsgListener(this);
        }
    }

    private ServerCenterImp() {
        this.ctx = new Context();
    }

    private IMobileGatewayProvider getGatewayProvider(Context ctx) throws BOSException {
        if (this.mobileConfigInfo == null) {
            IMobileConfig iMobileConfig = MobileConfigFactory.getLocalInstance(ctx);
            MobileConfigCollection mobileConfigs = iMobileConfig.getMobileConfigCollection();
            if (mobileConfigs != null && mobileConfigs.size() > 0) {
                this.mobileConfigInfo = mobileConfigs.get(0);
            } else {
                return null;
            }
        }
        if (this.mobileConfigInfo.isKingdeeGatewayProvider()) {
            logger.info((Object)("MobileGatewayProviderClass is:" + KingdeeMobileGatewayProvider.class.getName()));
            return new KingdeeMobileGatewayProvider();
        }
        String gatewayProviderClass = this.mobileConfigInfo.getGatewayProviderClass();
        logger.info((Object)("MobileGatewayProviderClass is:" + gatewayProviderClass));
        try {
            Class<?> providerClass = Class.forName(gatewayProviderClass);
            return (IMobileGatewayProvider)providerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("ServerCenterImp-getGatewayProvider error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)("ServerCenterImp-getGatewayProvider error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("ServerCenterImp-getGatewayProvider error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        catch (ClassCastException e) {
            logger.error((Object)("ServerCenterImp-getGatewayProvider error:" + e.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerCenterImp getInstance(Context ctx) throws BOSException {
        if (ctx == null || ctx.getAIS() == null) {
            return new ServerCenterImp();
        }
        ServerCenterImp serverCenter = null;
        HashMap hashMap = serverCenterHM;
        synchronized (hashMap) {
            Object obj = serverCenterHM.get(ctx.getAIS());
            if (obj != null) {
                return (ServerCenterImp)obj;
            }
            serverCenter = new ServerCenterImp(ctx);
            serverCenterHM.put(ctx.getAIS(), serverCenter);
        }
        if (serverCenter == null) {
            throw new RuntimeException("Server Instance is null");
        }
        return serverCenter;
    }

    private Connection getConnection() throws Exception {
        return DBHelper.getConnection(this.ctx);
    }

    public void loadConfig(MobileConfigInfo mobileConfigInfo, BizModuleCollection bizModules, BizFunctionCollection[] bizFunctionCols) throws BOSException {
        if (mobileConfigInfo != null) {
            this.mobileConfigInfo = mobileConfigInfo;
        }
        this.iMobileGatewayProvider = this.getGatewayProvider(this.ctx);
        if (this.iMobileGatewayProvider != null) {
            this.iMobileGatewayProvider.addConnectMonitor(this);
            this.iMobileGatewayProvider.addMsgListener(this);
        }
    }

    public boolean start() throws ORMCoreException, CommunicateException {
        logger.info((Object)"------mobile----ServerCenterImp---will connect----");
        boolean success = this.connect();
        logger.info((Object)("------mobile----ServerCenterImp---=" + success));
        if (success) {
            this.initSevice();
            logger.info((Object)"------mobile----ServerCenterImp---initSevice end----");
        }
        return success;
    }

    public boolean connect() throws ORMCoreException, CommunicateException {
        boolean success;
        try {
            success = this.connect2BIZ();
        }
        catch (EASBizException e) {
            throw new ORMCoreException((Throwable)e);
        }
        catch (BOSException e) {
            throw new ORMCoreException((Throwable)e);
        }
        logger.info((Object)("------mobile----ServerCenterImp---=" + success));
        if (!success) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.info((Object)e);
            }
            if (this.loginError != null) {
                String cause = this.loginError.getDescription();
                this.loginError = null;
                logger.info((Object)("---mobile---\u767b\u5f55\u901a\u8baf\u5e73\u53f0\u51fa\u9519: " + cause));
                throw new CommunicateException(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"connectError", (Locale)this.context.bosContext.getLocale()));
            }
            throw new CommunicateException(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"connectError", (Locale)this.context.bosContext.getLocale()));
        }
        this.changeState(ConnectionState.CONNECTING);
        logger.info((Object)"------mobile----changeState end----");
        return success;
    }

    private boolean connect2BIZ() throws EASBizException, BOSException {
        String loginName;
        boolean succeed = false;
        String host = this.mobileConfigInfo.getHost();
        int port = 80;
        if (this.mobileConfigInfo.getPort() != null && this.mobileConfigInfo.getPort().trim().length() > 0) {
            Integer portObj = new Integer(this.mobileConfigInfo.getPort());
            port = portObj;
        }
        if (this.mobileConfigInfo.getChannels() == 1) {
            return true;
        }
        if (this.mobileConfigInfo.isKingdeeGatewayProvider()) {
            if (!this.iMobileGatewayProvider.isConnected()) {
                logger.info((Object)"------mobile----ServerCenterImp---MobileGatewayProvider----");
                if (this.mobileConfigInfo != null) {
                    this.loginError = null;
                    logger.info((Object)"------mobile----ServerCenterImp---connect2BIZ----");
                    loginName = this.ctx.getAIS();
                    String code = MessageConstant.BIZINTERFACE_P;
                    succeed = this.iMobileGatewayProvider.connect(host, port, loginName, code);
                    logger.info((Object)("---mobile---connect BOS Comunication Platform " + succeed));
                }
            } else {
                succeed = true;
            }
        } else {
            loginName = this.mobileConfigInfo.getLoginName();
            String code = this.mobileConfigInfo.getPassword();
            logger.debug((Object)("Host: " + host + " port: " + this.mobileConfigInfo.getPort() + " LoginName: " + loginName + " code: " + code));
            succeed = this.iMobileGatewayProvider.testConnection(this.mobileConfigInfo);
        }
        return succeed;
    }

    boolean initSevice() {
        for (Object object : messageServerHM.values()) {
            if (object instanceof IStateListener) {
                this.stateListeners.add(object);
            }
            if (object instanceof ISendMessageService) {
                ((ISendMessageService)object).init(this.ctx);
                continue;
            }
            if (!(object instanceof IBizService)) continue;
            ((IBizService)object).init(this.ctx);
        }
        this.state = ConnectionState.INITED;
        this.broadCast(StateChangeEvent.INITED);
        return true;
    }

    public void stop() {
        logger.info((Object)"------mobile----ServerCenterImp---stopConnect----");
        this.iMobileGatewayProvider.disConnect();
        logger.info((Object)"------mobile----ServerCenterImp---stopConnect finish----");
        this.destroyService();
        logger.info((Object)"------mobile----ServerCenterImp---destroyService finish----");
        this.state = ConnectionState.DESTROIED;
    }

    private void destroyService() {
        for (Object object : messageServerHM.values()) {
            if (object instanceof ISendMessageService) {
                ((ISendMessageService)object).destroy();
                continue;
            }
            if (!(object instanceof IBizService)) continue;
            ((IBizService)object).destroy();
        }
    }

    public void disConnect() {
        this.iMobileGatewayProvider.disConnect();
        this.changeState(ConnectionState.DISCONNECTED);
    }

    public boolean isConnect() {
        return this.iMobileGatewayProvider.isConnected();
    }

    public ConnectionState getCurState() {
        return this.state;
    }

    public IMobileGatewayProvider getiMobileGatewayProvider() {
        return this.iMobileGatewayProvider;
    }

    public boolean sendMailDerect(Context ctx, String title, String content, MimeTypeEnum contentMimeType, String receiver, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        return this.iMobileGatewayProvider.sendMail(ctx, title, content, contentMimeType, receiver, secretReceiver, copyReceiver, attachment);
    }

    public void onMessage(KDMessage msg) {
        logger.info((Object)("-----mobile---onMessage---Title:" + msg.getTitle() + " --end--\n"));
        if (msg.isNotify()) {
            MsgServiceAssistant.handleForNotifyMsg(this.ctx, msg);
        } else {
            if (this.isPause(msg)) {
                this.pause();
                return;
            }
            if (msg.getSender() == null) {
                return;
            }
            CoreSendMessageInfo coreSendMessageInfo = null;
            if (!StringUtils.isEmpty((String)msg.getRelativeId())) {
                KDMessageAddress address = msg.getSender();
                if (address == null) {
                    logger.error((Object)("-----mobile---onMessage---'" + msg.getTitle() + "' none sender--\n"));
                    return;
                }
                if (1 == BOSMsgTypeEnum.getMsgType(address.getDeviceName())) {
                    SendMobileMessageInfo theSendMoMsgInfo = DefaultSendMoMsgDao.getSendMoMsgInfoByMsgId(this.ctx, msg.getRelativeId());
                    if (theSendMoMsgInfo != null && this.isSendHandcraftMsg(theSendMoMsgInfo)) {
                        MsgServiceAssistant.handleForSendHandcraftMsg(this.ctx, msg, theSendMoMsgInfo);
                        return;
                    }
                    coreSendMessageInfo = theSendMoMsgInfo;
                } else if (2 == BOSMsgTypeEnum.getMsgType(address.getDeviceName())) {
                    EmailSendMessageInfo emailSendMessageInfo = DefaultEmailMessageDAO.getEmailSendMsgInfoByMsgId(this.ctx, msg.getRelativeId());
                    if (emailSendMessageInfo != null) {
                        coreSendMessageInfo = emailSendMessageInfo;
                    }
                } else {
                    logger.error((Object)("-----mobile---onMessage---" + msg.getTitle() + " Unsoppurt type--\n"));
                    return;
                }
            }
            String userId = null;
            try {
                userId = AppMsgUtil.getUserIdByAddress(this.ctx, msg.getSender());
            }
            catch (BOSException e) {
                logger.error((Object)("-----mobile---onMessage---" + msg.getTitle() + " none sendUser!--\n"));
                return;
            }
            if (userId == null) {
                logger.info((Object)("-----mobile---onMessage---title = " + msg.getTitle() + "\n content = " + msg.getContent() + "--end--\n"));
                this.actionForUnPass(msg);
                return;
            }
            MsgServiceAssistant.handleForSendOrReplyMsg(this.ctx, msg, userId, coreSendMessageInfo);
        }
    }

    public void onError(KDMsgError error) {
        this.loginError = error;
    }

    public void onConnect() {
        logger.debug((Object)"\u4e0e\u901a\u8baf\u5e73\u53f0\u8fde\u63a5\u5df2\u7ecf\u5efa\u7acb");
        this.changeState(ConnectionState.CONNECTING);
    }

    public void onClose() {
        logger.debug((Object)"\u4e0e\u901a\u8baf\u5e73\u53f0\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00");
        this.changeState(ConnectionState.DISCONNECTED);
    }

    private boolean isPause(KDMessage msg) {
        return false;
    }

    private void pause() {
        this.iMobileGatewayProvider.disConnect();
        this.changeState(ConnectionState.DISCONNECTED);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isSendHandcraftMsg(SendMobileMessageInfo info) {
        return info.isSendHandcraft() && "for.hander".equals(info.getTitle());
    }

    private void actionForUnPass(KDMessage msg) {
        KDMessage response = new KDMessage();
        String addressDetail = msg.getSender().getDeviceName();
        String addressId = msg.getSender().getDetail();
        StringBuffer title = new StringBuffer();
        logger.info((Object)("-----mobile---actionForUnPass---addressDetail = " + addressDetail + "\n addressId = " + addressId + "--end--\n"));
        if ("mp:sms".equals(addressDetail)) {
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"mobileNumber", (Locale)this.context.bosContext.getLocale()));
            title.append(addressId);
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"hasnotlogin", (Locale)this.context.bosContext.getLocale()));
        } else if ("mp:mail".equals(addressDetail)) {
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"emailAddress", (Locale)this.context.bosContext.getLocale()));
            title.append(addressId);
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"hasnotlogin", (Locale)this.context.bosContext.getLocale()));
        } else if ("mp:im".equals(addressDetail)) {
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"rtxNumber", (Locale)this.context.bosContext.getLocale()));
            title.append(addressId);
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"hasnotlogin", (Locale)this.context.bosContext.getLocale()));
        } else {
            title.append(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"messengerTypeError", (Locale)this.context.bosContext.getLocale()));
        }
        logger.info((Object)("-----mobile---actionForUnPass---title = " + title));
        response.setTitle(title.toString());
        response.setContent(title.toString());
        KDMessage[] msgs = ServerCenterImp.afterWork(new KDMessage[]{response}, msg);
        this.sendOnlyMsg(msgs[0]);
    }

    private static KDMessage[] afterWork(KDMessage[] responses, KDMessage msg) {
        for (int i = 0; responses != null && i < responses.length; ++i) {
            KDMessage response = responses[i];
            KDMessageAddress receiver = msg.getSender();
            response.setReceivers(new KDMessageAddress[]{receiver});
            response.setRelativeId(msg.getId());
        }
        return responses;
    }

    private synchronized void sendOnlyMsg(KDMessage msg) {
        if (this.iMobileGatewayProvider.isConnected()) {
            this.iMobileGatewayProvider.sendMessage(msg);
        } else {
            logger.error((Object)"msg has not sent cause by disconnect");
        }
    }

    public boolean sendMessage(SendMobileMessageInfo sendMoMsgInfo) throws EASBizException, BOSException {
        if (this.iMobileGatewayProvider.isConnected()) {
            return this.iMobileGatewayProvider.sendMessage(sendMoMsgInfo, this.mobileConfigInfo, this.ctx);
        }
        logger.error((Object)"msg has not sent cause by disconnect");
        return false;
    }

    public boolean sendMail(EmailSendMessageInfo emailSendMessageInfo) throws EASBizException, BOSException {
        return this.iMobileGatewayProvider.sendMail(emailSendMessageInfo, this.ctx);
    }

    public boolean sendMessageDerect(Context ctx, String title, String receiver) throws BOSException, EASBizException {
        return this.iMobileGatewayProvider.sendMessage(title, receiver, this.mobileConfigInfo, ctx);
    }

    public void receiveMessage() throws BOSException {
        logger.info((Object)"----ServerCenterImp receiveMessage----111");
        if (!this.mobileConfigInfo.isKingdeeGatewayProvider()) {
            logger.info((Object)"----ServerCenterImp receiveMessage----222");
            this.iMobileGatewayProvider.receiveMessage(this.mobileConfigInfo, this.ctx);
        }
    }

    public IBizService[] getBizService() {
        ArrayList servicesList = new ArrayList();
        for (Object object : messageServerHM.values()) {
            if (!(object instanceof IBizService)) continue;
            servicesList.add(object);
        }
        IBizService[] services = null;
        if (servicesList.size() > 0) {
            services = new IBizService[servicesList.size()];
            for (int i = 0; i < services.length; ++i) {
                services[i] = (IBizService)servicesList.get(i);
            }
        }
        return services;
    }

    private void changeState(ConnectionState nextState) {
        StateChangeEvent event = new StateChangeEvent(this.state, nextState);
        this.state = nextState;
        this.broadCast(event);
    }

    private void broadCast(StateChangeEvent event) {
        for (int i = 0; i < this.stateListeners.size(); ++i) {
            Thread t = new Thread(new StateChangeThread((IStateListener)this.stateListeners.get(i), event));
            t.start();
        }
    }

    KDMessage[] service(KDMessage msg) {
        if (this.isResponse(msg)) {
            try {
                KDMessage[] responses = this.doResponse(msg);
                return ServerCenterImp.afterWork(responses, msg);
            }
            catch (MobileConnectException e) {
                logger.info((Object)"\u6b64\u5904\u4e3a\u53ef\u56de\u590d\u529f\u80fd");
            }
        }
        return this.serviceisNotResponse(msg);
    }

    private final boolean isResponse(KDMessage msg) {
        return msg.getRelativeId() != null && msg.getRelativeId().length() > 0;
    }

    private final KDMessage[] doResponse(KDMessage msg) throws MobileConnectException {
        ArrayList<KDMessage> temp = new ArrayList<KDMessage>();
        logger.debug((Object)("\u5904\u7406\u56de\u590d\u6d88\u606f,\u53ef\u56de\u590d\u6d88\u606f\u6a21\u5757\u6570\u76ee" + this.responseBizs.size()));
        for (int i = 0; i < this.responseBizs.size(); ++i) {
            IRevertible obj = (IRevertible)this.responseBizs.get(i);
            boolean isOk = false;
            try {
                isOk = obj.validate(msg);
            }
            catch (ValidateException e) {
                logger.error((Object)("msg '" + msg.getTitle() + "' is not validate cause:" + e.getMessage()));
                KDMessage response = new KDMessage();
                response.setTitle(e.getMessage());
                temp.add(response);
            }
            if (!isOk) continue;
            if (obj instanceof ProcessQueryBiz) {
                throw new MobileConnectException(MobileConnectException.LOGINEXCEPTION);
            }
            KDMessage[] msgs = obj.doResponse(msg);
            for (int j = 0; msgs != null && j < msgs.length; ++j) {
                temp.add(msgs[j]);
            }
        }
        KDMessage[] response = new KDMessage[temp.size()];
        temp.toArray(response);
        for (int i = 0; i < response.length; ++i) {
            logger.debug((Object)("content:" + response[i].getTitle()));
        }
        return response;
    }

    public KDMessage[] serviceisNotResponse(KDMessage msg) {
        KDMessage[] msgs = new KDMessage[]{};
        String title = msg.getTitle();
        if (title == null || title.trim().length() == 0) {
            return IQueryBiz.NORESPONSE;
        }
        title = title.trim();
        char numKey = title.charAt(0);
        logger.debug((Object)("numKey:" + numKey));
        switch (numKey) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                logger.debug((Object)"\u6839\u636e\u7528\u6237\u81ea\u5b9a\u4e49\u5feb\u6377\u952e\u627e\u5230\u5bf9\u5e94\u7684\u529f\u80fd\u53f7");
                String command = this.getCommand(numKey, msg.getSender());
                if (command != null && command.trim().length() > 0) {
                    title = command + title.substring(1);
                    msg.setTitle(title);
                    msgs = this.doQuery(msg);
                    break;
                }
                KDMessage response = new KDMessage();
                response.setTitle(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"youHaveNotDefineKJJ", (Locale)this.context.bosContext.getLocale()) + numKey);
                msgs = new KDMessage[]{response};
                break;
            }
            case '?': {
                logger.debug((Object)"\u663e\u793a\u547d\u4ee4\u4fe1\u606f");
                title = title.substring(1);
                msgs = this.doViewCommand(title);
                break;
            }
            default: {
                logger.debug((Object)"\u5904\u7406\u67e5\u8be2\u4fe1\u606f");
                msgs = this.doQuery(msg);
            }
        }
        for (int i = 0; msgs != null && i < msgs.length; ++i) {
            logger.debug((Object)("msg:" + msgs[i].getTitle()));
        }
        return ServerCenterImp.afterWork(msgs, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCommand(char num, KDMessageAddress address) {
        String id = address.getDetail();
        String ais = this.ctx.getAIS();
        String addressType = address.getDeviceName();
        int code = 0;
        if ("mp:sms".equals(addressType)) {
            code = 0;
        } else if ("mp:mail".equals(addressType)) {
            code = 2;
        } else if ("mp:im".equals(addressType)) {
            code = 1;
        }
        Connection con = null;
        String command = "";
        UserInfoDao dao = DaoFactory.getUserInfoDao();
        try {
            con = this.getConnection();
            command = dao.getUserCommand(id, num, ais, code, con);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            DBHelper.cleanup(con);
        }
        return command;
    }

    private KDMessage[] doQuery(KDMessage msg) {
        String title = msg.getTitle().trim();
        String[] s = title.split(" ");
        if (s == null || s.length == 0) {
            return IQueryBiz.NORESPONSE;
        }
        String command = s[0];
        BizModuleItem wrap = this.findModuleWrap(command);
        if (wrap == null) {
            logger.warn((Object)("can not the matched Module : " + command));
            return ServerCenterImp.genResponse(ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"byCommand", (Locale)this.context.bosContext.getLocale()) + command + ResourceBase.getString((String)"com.kingdee.eas.mobile.msg.MobileResource", (String)"notFindBiz", (Locale)this.context.bosContext.getLocale()), msg);
        }
        int num = wrap.getBizKey();
        IQueryBiz service = (IQueryBiz)this.queryBizs.get(wrap.getClassName());
        if (service == null) {
            logger.warn((Object)"can not the matched service ");
            return IQueryBiz.NORESPONSE;
        }
        if (title.length() > command.length()) {
            String content = title.substring(command.length() + 1);
            msg.setTitle(content.trim());
        } else {
            msg.setTitle("");
        }
        return service.service(msg, num);
    }

    private BizModuleItem findModuleWrap(String key) {
        ArrayList arr = this.config.getConfigedModules();
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            BizModuleItem wrap = (BizModuleItem)arr.get(i);
            if (!wrap.getCommand().equalsIgnoreCase(key)) continue;
            return wrap;
        }
        return null;
    }

    private KDMessage[] doViewCommand(String title) {
        logger.debug((Object)("\u663e\u793a\u547d\u4ee4\u4fe1\u606f:" + title));
        if (title.trim().length() == 0 || title.trim().equalsIgnoreCase("all")) {
            return this.doListAllCommands();
        }
        return this.doSeekCommand(title.trim());
    }

    private final KDMessage[] doListAllCommands() {
        ArrayList arr = this.config.getConfigedModules();
        int size = arr.size();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            BizModuleItem wrap = (BizModuleItem)arr.get(i);
            BizModuleItem fullInfo = (BizModuleItem)configurables.get(wrap.getClassName());
            buffer.append(wrap.getCommand());
            buffer.append(":");
            buffer.append(BizFunction.getBizDescription(fullInfo.getBizFunctions(), wrap.getBizKey(), this.ctx.getLocale()));
            buffer.append("\r\n");
        }
        KDMessage response = new KDMessage();
        response.setTitle(buffer.toString());
        return new KDMessage[]{response};
    }

    private final KDMessage[] doSeekCommand(String key) {
        ArrayList arr = this.config.getConfigedModules();
        int size = arr.size();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            BizModuleItem wrap = (BizModuleItem)arr.get(i);
            String description = wrap.getDescription(this.ctx.getLocale());
            if (description.indexOf(key) == -1) continue;
            buffer.append(wrap.getCommand());
            buffer.append(":");
            buffer.append(wrap.getDescription(this.ctx.getLocale()));
            buffer.append("\r\n");
        }
        KDMessage response = new KDMessage();
        response.setTitle(buffer.toString());
        return new KDMessage[]{response};
    }

    private static KDMessage[] genResponse(String title, KDMessage srcMsg) {
        KDMessage msg = new KDMessage();
        msg.setTitle(title);
        return new KDMessage[]{msg};
    }

    boolean init() {
        this.config = this.loadConfig();
        for (Object object : this.bizModules_old.values()) {
            if (object instanceof IStateListener) {
                this.stateListeners.add(object);
            }
            ((IBizModule)object).init(this.context);
        }
        this.state = ConnectionState.getEnum(1);
        this.broadCast(StateChangeEvent.INITED);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfig(BizModuleConfig config) throws Exception {
        logger.debug((Object)"saveConfig");
        boolean success = false;
        this.config = config;
        Connection conn = null;
        try {
            conn = this.getConnection();
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)DaoFactory.getBizConfigDao());
            try {
                Class<?> c = Class.forName("com.kingdee.eas.mobile.msg.dao.BizConfigDao");
                Class[] partypes = new Class[]{BizModuleConfig.class, String.class, Connection.class};
                Method method = c.getMethod("saveConfig", partypes);
                Object result = txInvoker.invoke(method, new Object[]{config, this.ctx.getAIS(), conn}, 3);
                success = (Boolean)result;
            }
            catch (Throwable ex) {
                logger.error((Object)ex);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
        }
        finally {
            DBHelper.cleanup(conn);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BizModuleConfig loadConfig() {
        if (this.config.getModules().length == 0) {
            Collection c = configurables.values();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.config.addConfigurable((BizModuleItem)it.next());
            }
        }
        BizModuleConfig config2 = null;
        Connection conn = null;
        BizConfigDao bizDao = DaoFactory.getBizConfigDao();
        try {
            conn = this.getConnection();
            String ais = this.ctx.getAIS();
            config2 = bizDao.getConfig(ais, conn);
        }
        catch (SQLException ais) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBHelper.cleanup(conn);
        }
        if (config2 != null) {
            this.config.setHost(config2.getHost());
            this.config.setPort(config2.getPort());
            this.config.setConfigedModules(config2.getConfigedModules());
            this.config.setMsgTypes(config2.getMsgTypes());
        }
        return this.config;
    }

    void sortOut() {
        if (!this.isSorted) {
            for (int i = 0; classes != null && i < classes.length; ++i) {
                this.loadClass(classes[i]);
            }
            this.isSorted = true;
        }
    }

    private void loadClass(Class clazz) {
        Object obj = null;
        String className = clazz.getName();
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof IBizModule) {
            this.bizModules_old.put(className, obj);
            logger.debug((Object)(obj.getClass().getName() + " add into BizModules"));
            if (obj instanceof IQueryBiz && !this.queryBizs.containsKey(className)) {
                this.queryBizs.put(className, obj);
                logger.debug((Object)(obj.getClass().getName() + " add into queryBizs"));
            }
            if (obj instanceof IRevertible) {
                this.responseBizs.add(obj);
                logger.debug((Object)(obj.getClass().getName() + " add into responseBizs"));
            }
        }
    }

    public void clearCache() {
        serverCenterHM.clear();
    }

    static {
        Class[] classes1 = MessageServiceFactory.getSendMessageServiceClasses();
        Class[] classes2 = MessageServiceFactory.getBizServiceClasses();
        classes = new Class[classes1.length + classes2.length];
        for (int i = 0; i < classes1.length; ++i) {
            ServerCenterImp.classes[i] = classes1[i];
        }
        int j = 0;
        for (int i = classes1.length; i < classes.length; ++i) {
            ServerCenterImp.classes[i] = classes2[j];
            ++j;
        }
        ServerCenterImp.loadClasses();
    }

    class StateChangeThread
    implements Runnable {
        private IStateListener listener;
        private StateChangeEvent event;

        StateChangeThread(IStateListener listener, StateChangeEvent event) {
            this.listener = listener;
            this.event = event;
        }

        @Override
        public void run() {
            this.listener.onChange(this.event);
        }
    }
}

