/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.eas.base.myeas.MyEasResource;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mobile.IServerEngine;
import com.kingdee.eas.mobile.ServerEnginefactory;
import com.kingdee.eas.mobile.msg.BizFunction;
import com.kingdee.eas.mobile.msg.BizModuleConfig;
import com.kingdee.eas.mobile.msg.BizModuleItem;
import com.kingdee.eas.mobile.msg.CommunicateException;
import com.kingdee.eas.mobile.msg.client.AbstractBizConfigUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class BizConfigUI
extends AbstractBizConfigUI
implements KDTActiveCellListener {
    private static final String RES = "com.kingdee.eas.mobile.msg.client.SmsResource";
    private static final Logger logger = Logger.getLogger(BizConfigUI.class);
    private Window window = null;
    private static final int ERROR_COMMAND_NULL = -1;
    private static final int ERROR_COMMAND_EXIST = 1;
    private static final int ERROR_MODULE_NULL = 2;
    private static final int ERROR_FUNCTION_NULL = 3;
    private static final int ERROR_MODULE_FUNCTION_EXIST = 4;
    private static final int CONFIG_OK = 0;
    Action actAdd;
    Action actDel;
    private ServerEnginefactory client = new ServerEnginefactory();
    protected BizModuleConfig config;
    protected IServerEngine engine;
    protected String url;
    protected KDComboBox modules;
    private boolean test = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setButtonDefaultStyl(this.saveAction);
        this.setButtonDefaultStyl(this.resetAction);
        this.setButtonDefaultStyl(this.connectAction);
        this.setButtonDefaultStyl(this.startAction);
        this.setButtonDefaultStyl(this.stopAction);
        this.setButtonDefaultStyl(this.disConnectAction);
    }

    public BizConfigUI() throws Exception {
        this.kDTable2.addKDTEditListener((KDTEditListener)new EditAdapter());
        this.kDTable2.getIndexColumn().getStyleAttributes().setHided(true);
        this.initUI();
    }

    private void initUI() throws Exception {
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.actAdd = new AbstractAction("", MyEasResource.getCommonIcon((String)"imgTbtn_addline")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BizConfigUI.this.kDTable2.addRow();
                }
                catch (Exception es) {
                    es.printStackTrace();
                }
            }
        };
        this.actAdd.putValue("ShortDescription", EASResource.getString((String)RES, (String)"addLine"));
        this.kDContainer1.add(this.actAdd);
        this.actDel = new AbstractAction("", MyEasResource.getCommonIcon((String)"imgTbtn_deleteline")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int activeRow = BizConfigUI.this.kDTable2.getSelectManager().getActiveRowIndex();
                    if (activeRow > 0 && activeRow < BizConfigUI.this.kDTable2.getRowCount()) {
                        BizConfigUI.this.kDTable2.removeRow(activeRow);
                    } else {
                        BizConfigUI.this.kDTable2.removeRow(BizConfigUI.this.kDTable2.getRowCount() - 1);
                    }
                }
                catch (Exception es) {
                    es.printStackTrace();
                }
            }
        };
        this.kDContainer1.add(this.actDel);
        this.actDel.putValue("ShortDescription", EASResource.getString((String)RES, (String)"removeLine"));
        this.saveAction.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.resetAction.setIcon(EASResource.getIcon((String)"imgTbtn_reset"));
        this.startAction.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.stopAction.setIcon(EASResource.getIcon((String)"imgTbtn_stopserve"));
        this.disConnectAction.setIcon(EASResource.getIcon((String)"imgTbtn_cutlink"));
        this.connectAction.setIcon(EASResource.getIcon((String)"imgTbtn_openlink"));
        this.saveAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.saveAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.resetAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.resetAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.connectAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.connectAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.disConnectAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.disConnectAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.startAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.startAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.stopAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BizConfigUI.this.stopAction_actionPerformed(arg0);
                }
                catch (Exception e) {
                    BizConfigUI.this.handUIException(e);
                }
            }
        });
        this.getEngine();
        if (this.engine != null) {
            try {
                this.generated();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.viewToolBarByState();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void saveConfig() throws Exception {
        for (int i = 0; i < this.kDTable2.getRowCount(); ++i) {
            IRow irow = this.kDTable2.getRow(i);
            ModuleItem item = (ModuleItem)irow.getCell(0).getValue();
            FunctionItem func = (FunctionItem)irow.getCell(1).getValue();
            String command = (String)irow.getCell(2).getValue();
            if (item != null || func != null || command != null) continue;
            this.kDTable2.removeRow(i);
        }
        ControlUtilities.checkFocusAndCommit();
        boolean ok = false;
        try {
            ok = this.validateHost();
        }
        catch (UnknownHostException ex) {
            this.alert("unValidateAddress");
        }
        if (!ok) {
            return;
        }
        ok = this.validatePort();
        if (!ok) {
            return;
        }
        ArrayList<BizModuleItem> arr = new ArrayList<BizModuleItem>();
        int statue = 0;
        block11: for (int i = 0; statue == 0 && i < this.kDTable2.getRowCount(); ++i) {
            IRow irow = this.kDTable2.getRow(i);
            statue = this.validateConfig(irow, arr);
            switch (statue) {
                case -1: {
                    this.alert("CommandNotSetup");
                    this.kDTable2.getSelectManager().select(i, 2);
                    continue block11;
                }
                case 0: {
                    ModuleItem item = (ModuleItem)irow.getCell(0).getValue();
                    FunctionItem func = (FunctionItem)irow.getCell(1).getValue();
                    String command = (String)irow.getCell(2).getValue();
                    BizModuleItem wrap = new BizModuleItem(command, item.getClassName(), func.bizKey);
                    arr.add(wrap);
                    continue block11;
                }
                case 2: {
                    logger.debug((Object)"Module Is NULL");
                    this.alert("ModuleNotSelect");
                    this.kDTable2.getSelectManager().select(i, 0);
                    continue block11;
                }
                case 3: {
                    logger.debug((Object)"Function is Null");
                    this.alert("FunctionNotSelect");
                    this.kDTable2.getSelectManager().select(i, 1);
                    continue block11;
                }
                case 1: {
                    logger.debug((Object)"COMMAND IS DEFINED");
                    this.alert("MutiCommand");
                    this.kDTable2.getSelectManager().select(i, 2);
                    continue block11;
                }
                case 4: {
                    logger.debug((Object)"MODULE FINCTION IS DEFINED");
                    this.alert("MutiModuleAndFunction");
                    this.kDTable2.getSelectManager().select(i, 0, i, 1);
                }
            }
        }
        if (statue != 0) {
            return;
        }
        this.config.setHost(this.hostText.getText());
        this.config.setPort(Integer.parseInt(this.portText.getText()));
        int msgTypes = 0;
        if (this.smsType.isSelected()) {
            msgTypes += 4;
        }
        if (this.EmailType.isSelected()) {
            ++msgTypes;
        }
        if (this.RtxType.isSelected()) {
            msgTypes += 2;
        }
        this.config.setMsgTypes(msgTypes);
        this.config.setConfigedModules(arr);
        boolean success = this.engine.saveConfig(this.config);
        if (success) {
            this.showMsg("SaveOK");
        } else {
            this.alert("SaveFailure");
        }
    }

    private void reset() throws Exception {
        this.displayConfig();
    }

    private boolean start() {
        boolean success = false;
        if (this.engine != null) {
            try {
                this.engine.start();
            }
            catch (CommunicateException e) {
                MsgBox.showError((String)e.getMessage());
            }
        }
        if (success) {
            this.alert("StartOK");
        }
        return success;
    }

    private boolean stop() {
        boolean success = false;
        if (this.engine != null) {
            this.engine.stop();
        }
        if (success) {
            this.alert("StopOK");
        }
        return success;
    }

    public void activeCellChanged(KDTActiveCellEvent e) {
    }

    private boolean connect() {
        boolean success = false;
        try {
            if (this.engine != null) {
                success = this.engine.connect();
            }
            if (success) {
                this.alert("ConnectOK");
            }
        }
        catch (CommunicateException ex) {
            MsgBox.showError((String)ex.getMessage());
        }
        return success;
    }

    private boolean disConnect() {
        boolean success = false;
        if (this.engine != null) {
            success = this.engine.disConnect();
        }
        if (success) {
            this.alert("DisConnectOK");
        }
        return success;
    }

    private void displayConfig() {
        this.hostText.setText(this.config.getHost());
        this.portText.setText(String.valueOf(this.config.getPort()));
        if (this.config.isEmailOK()) {
            this.EmailType.setSelected(true);
        }
        if (this.config.isMobileOK()) {
            this.smsType.setSelected(true);
        }
        if (this.config.isRtxOK()) {
            this.RtxType.setSelected(true);
        }
        this.modules = new KDComboBox();
        BizModuleItem[] items = this.config.getModules();
        for (int i = 0; i < items.length; ++i) {
            BizModuleItem wrap = items[i];
            this.modules.addItem((Object)new ModuleItem(wrap.getClassName(), wrap.getModuleName()));
        }
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)this.modules);
        this.kDTable2.checkParsed();
        this.kDTable2.getColumn(0).setEditor((ICellEditor)cellEditor);
        this.kDTable2.removeRows();
        ArrayList configedModules = this.config.getConfigedModules();
        for (int i = 0; i < configedModules.size(); ++i) {
            BizModuleItem wrap = (BizModuleItem)configedModules.get(i);
            IRow irow = null;
            irow = this.kDTable2.getRowCount() <= i ? this.kDTable2.addRow() : this.kDTable2.getRow(i);
            BizModuleItem fullWrapInfo = this.config.getModule(wrap.getClassName());
            irow.getCell(0).setValue((Object)new ModuleItem(fullWrapInfo.getClassName(), fullWrapInfo.getModuleName()));
            this.setFunctions(i, 1, wrap.getClassName());
            int bizKey = wrap.getBizKey();
            String description = BizFunction.getBizDescription(fullWrapInfo.getBizFunctions(), bizKey, SysContext.getSysContext().getLocale());
            irow.getCell(1).setValue((Object)new FunctionItem(bizKey, description));
            irow.getCell(2).setValue((Object)wrap.getCommand());
        }
    }

    private void setFunctions(int row, int col, String className) {
        BizFunction[] functions = this.config.getBizFunction(className);
        IRow irow = this.kDTable2.getRow(row);
        ICell icell = irow.getCell(col);
        KDComboBox box = new KDComboBox();
        for (int i = 0; functions != null && i < functions.length; ++i) {
            box.addItem((Object)new FunctionItem(functions[i]));
            logger.debug((Object)functions[i].getDescription(SysContext.getSysContext().getLocale()));
        }
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)box);
        icell.setEditor((ICellEditor)cellEditor);
    }

    protected void saveAction_actionPerformed(ActionEvent e) throws Exception {
        this.saveConfig();
    }

    protected void resetAction_actionPerformed(ActionEvent e) throws Exception {
        this.reset();
    }

    protected void startAction_actionPerformed(ActionEvent e) {
        if (this.engine.getEngineState().getValue() < 1) {
            try {
                this.engine.start();
            }
            catch (CommunicateException e1) {
                MsgBox.showError((String)e1.getMessage());
            }
        }
        this.viewToolBarByState();
    }

    protected void connectAction_actionPerformed(ActionEvent e) {
        if (this.engine.getEngineState().getValue() != 2) {
            try {
                this.engine.connect();
            }
            catch (CommunicateException e1) {
                MsgBox.showError((String)e1.getMessage());
            }
        }
        this.viewToolBarByState();
    }

    protected void disConnectAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.engine.getEngineState().getValue() == 2) {
            this.engine.disConnect();
        }
        this.viewToolBarByState();
    }

    protected void exitAction_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected void stopAction_actionPerformed(ActionEvent e) throws Exception {
        this.engine.stop();
        this.viewToolBarByState();
    }

    protected void deleteAction_actionPerformed(ActionEvent e) throws Exception {
        int activeRow = this.kDTable2.getSelectManager().getActiveRowIndex();
        if (activeRow > 0 && activeRow < this.kDTable2.getRowCount()) {
            this.kDTable2.removeRow(activeRow);
        } else {
            this.kDTable2.removeRow(this.kDTable2.getRowCount() - 1);
        }
    }

    protected void addAction_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable2.addRow();
    }

    private void viewToolBarByState() {
        switch (this.engine.getEngineState().getValue()) {
            case -1: 
            case 0: {
                this.startAction.setEnabled(true);
                this.connectAction.setEnabled(false);
                this.disConnectAction.setEnabled(false);
                this.stopAction.setEnabled(false);
                break;
            }
            case 1: {
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(true);
                this.connectAction.setEnabled(false);
                this.disConnectAction.setEnabled(true);
                break;
            }
            case 2: {
                this.connectAction.setEnabled(false);
                this.disConnectAction.setEnabled(true);
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(true);
                break;
            }
            case 3: {
                this.connectAction.setEnabled(true);
                this.disConnectAction.setEnabled(false);
                this.startAction.setEnabled(false);
                this.stopAction.setEnabled(true);
            }
        }
    }

    private void getEngine() throws Exception {
        this.url = UIConfig.getUrl();
        this.client.setHostAddress(this.url);
        this.engine = this.client.getService(this.url);
        this.config = this.engine.loadConfig();
    }

    void generated() {
        this.saveAction.setEnabled(true);
        this.resetAction.setEnabled(true);
        this.hostText.setEditable(true);
        this.portText.setEditable(true);
        this.actDel.setEnabled(true);
        this.actAdd.setEnabled(true);
        this.displayConfig();
    }

    private boolean validateHost() throws UnknownHostException {
        if (this.hostText.getText() == null || this.hostText.getText().trim().length() == 0) {
            this.alert("hostNull");
            this.hostText.requestFocus();
            return false;
        }
        InetAddress.getByName(this.hostText.getText());
        return true;
    }

    public void handUIException(Throwable t) {
        Throwable e = t;
        this.setCursorOfDefault();
        if (e instanceof AlreadyBindProcessInstanceException) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_BindWfInstance"));
            return;
        }
        if (e instanceof MatchAssignmentException) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFMatch"));
            return;
        }
        ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
    }

    public void setCursorOfDefault() {
        this.window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (this.window == null) {
            this.window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (this.window == null) {
                return;
            }
        }
        this.window.setCursor(Cursor.getDefaultCursor());
        this._setCursor((Component)((Object)this), Cursor.getDefaultCursor());
        this.window = null;
    }

    private void _setCursor(Component cp, Cursor cursor) {
        cp.setCursor(cursor);
        if (cp instanceof Container) {
            Container cc = (Container)cp;
            int n = cc.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component curComponent = cc.getComponent(i);
                if (!curComponent.isFocusable()) continue;
                this._setCursor(curComponent, cursor);
            }
        }
    }

    private boolean validatePort() {
        String portStr = this.portText.getText();
        boolean success = true;
        try {
            int port = Integer.parseInt(portStr);
            if (port <= 0 || port > 65535) {
                this.alert("portRange");
                this.portText.requestFocus();
                success = false;
            }
        }
        catch (NumberFormatException ex) {
            this.alert("portError");
            this.portText.requestFocus();
            success = false;
        }
        return success;
    }

    private void alert(String key) {
        String resClassName = "com.kingdee.eas.mobile.msg.client.BizConfigUIResources";
        String s = EASResource.getString((String)resClassName, (String)key);
        MsgBox.showError((String)s);
    }

    private void showMsg(String key) {
        String resClassName = "com.kingdee.eas.mobile.msg.client.BizConfigUIResources";
        String s = EASResource.getString((String)resClassName, (String)key);
        MsgBox.showInfo((String)s);
    }

    private int validateConfig(IRow irow, ArrayList arr) {
        ModuleItem item = (ModuleItem)irow.getCell(0).getValue();
        FunctionItem func = (FunctionItem)irow.getCell(1).getValue();
        String command = (String)irow.getCell(2).getValue();
        int index = irow.getRowIndex();
        if (command == null || command.trim().length() == 0) {
            return -1;
        }
        if (item == null || item.getClassName() == null || item.getClassName().trim().length() == 0) {
            return 2;
        }
        if (func == null) {
            this.kDTable2.getSelectManager().select(index, 1);
            return 3;
        }
        for (int i = 0; i < arr.size(); ++i) {
            BizModuleItem wrap = (BizModuleItem)arr.get(i);
            if (wrap.getCommand().equalsIgnoreCase(command)) {
                return 1;
            }
            if (!wrap.getClassName().equals(item.getClassName()) || wrap.getBizKey() != func.bizKey) continue;
            return 4;
        }
        return 0;
    }

    private String getResourceClassName() {
        return "";
    }

    public String getResource(String resClassName, String itemKey) {
        Locale locale = this.getLocale();
        return ResourceBase.getString((String)resClassName, (String)itemKey, (Locale)locale);
    }

    public void doLayout() {
        super.doLayout();
    }

    class EditAdapter
    extends KDTEditAdapter {
        EditAdapter() {
        }

        public void editStopping(KDTEditEvent e) {
            ModuleItem item;
            String className;
            KDTable tbl;
            Object value;
            int currRow = e.getRowIndex();
            int currCol = e.getColIndex();
            if (currCol == 0 && (value = (tbl = (KDTable)e.getSource()).getEditManager().getEditor().getValue()) instanceof ModuleItem && (className = (item = (ModuleItem)value).getClassName()) != null) {
                BizConfigUI.this.setFunctions(currRow, 1, className);
            }
        }
    }

    private class FunctionItem {
        int bizKey = -1;
        String description;

        FunctionItem(int bizKey, String description) {
            this.bizKey = bizKey;
            this.description = description;
        }

        public FunctionItem(BizFunction func) {
            this.bizKey = func.getBizKey();
            this.description = func.getDescription(SysContext.getSysContext().getLocale());
        }

        public String toString() {
            return this.description;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof FunctionItem) {
                FunctionItem item = (FunctionItem)obj;
                if (item.bizKey == this.bizKey) {
                    return true;
                }
            }
            return false;
        }
    }

    private class ModuleItem {
        String className;
        String moduleName;

        public ModuleItem(String className, String moduleName) {
            this.className = className;
            this.moduleName = moduleName;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ModuleItem) {
                ModuleItem item = (ModuleItem)obj;
                if (this.className != null && this.className.equals(item.getClassName())) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.moduleName;
        }
    }
}

