/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mobile.msg.IReceiveUserMsg;
import com.kingdee.eas.mobile.msg.ISendUserMsg;
import com.kingdee.eas.mobile.msg.ReceiveUserMsgFactory;
import com.kingdee.eas.mobile.msg.ReceiveUserMsgInfo;
import com.kingdee.eas.mobile.msg.SendUserMsgCollection;
import com.kingdee.eas.mobile.msg.SendUserMsgFactory;
import com.kingdee.eas.mobile.msg.SendUserMsgInfo;
import com.kingdee.eas.mobile.msg.client.AbstractMySendSmsListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class MySendSmsListUI
extends AbstractMySendSmsListUI {
    private static final String RES = "com.kingdee.eas.mobile.msg.client.SmsResource";
    private static final DateFormat dateformat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
    private static final Logger logger = Logger.getLogger(MySendSmsListUI.class);
    private SorterItemCollection allSorters = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.initSorters();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceiveUserMsgFactory.getRemoteInstance();
    }

    protected ISendUserMsg getISendUserMsg() throws BOSException {
        return SendUserMsgFactory.getRemoteInstance();
    }

    public void refresh() {
        logger.info((Object)"\u5237\u65b0\u6d88\u606f\u5217\u8868");
        this.tblMain.refresh();
    }

    private void initQuery() {
        String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        FilterInfo filterInfo = this.mainQuery.getFilter();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        FilterItemInfo filterItemInfo = new FilterItemInfo("userid", (Object)userid);
        filterInfo.getFilterItems().add(filterItemInfo);
        this.mainQuery.setFilter(filterInfo);
        this.refresh();
    }

    private void initUI() {
        try {
            UIManager.setLookAndFeel("com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.btnAddNew.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnQuery.setEnabled(false);
        this.btnView.setEnabled(false);
        this.setUITitle(EASResource.getString((String)RES, (String)"SendMsgList"));
        this.kDScrollPane1.setCustomInsets(new Insets(0, -8, 0, -2));
        this.kDSplitPaneSmsMsg.setCustomInsets(new Insets(10, 10, 10, 10));
        this.smsDetail.setAutoscrolls(true);
        this.initQuery();
    }

    private void initSorters() {
        this.allSorters = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("id");
        sorterItemInfo.setSortType(SortType.ASCEND);
        this.allSorters.add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("title");
        sorterItemInfo.setSortType(SortType.ASCEND);
        this.allSorters.add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("srcAddress");
        sorterItemInfo.setSortType(SortType.ASCEND);
        this.allSorters.add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("receiveTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        this.allSorters.add(sorterItemInfo);
    }

    public void tblMain_tableClicked(KDTMouseEvent e) {
        try {
            int clickCount = e.getClickCount();
            int rowIndex = -1;
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
            if (selectBlock != null) {
                rowIndex = selectBlock.getTop();
            }
            if (clickCount == 1 && e.getType() == 0 && e.getColIndex() != -1) {
                SorterItemInfo selectedSorter = this.allSorters.get(e.getColIndex());
                SorterItemCollection sorterItemCols = this.mainQuery.getSorter();
                if (sorterItemCols == null) {
                    sorterItemCols = new SorterItemCollection();
                }
                sorterItemCols.add(selectedSorter);
                this.tblMain.refresh();
            }
            if (rowIndex != -1) {
                Object object = this.tblMain.getRow(rowIndex).getCell(0).getValue();
                ObjectUuidPK iObjectPK = new ObjectUuidPK(BOSUuid.read((String)object.toString()));
                ReceiveUserMsgInfo info = ((IReceiveUserMsg)this.getBizInterface()).getReceiveUserMsgInfo((IObjectPK)iObjectPK);
                String detail = this.getSmsDetail(info);
                this.smsDetail.setText(detail);
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"getMessageFail"), (Throwable)e1);
        }
    }

    private String getSmsDetail(ReceiveUserMsgInfo info) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append(EASResource.getString((String)RES, (String)"content"));
        buf.append("       :");
        buf.append(info.getTitle());
        buf.append("\r\n");
        buf.append(EASResource.getString((String)RES, (String)"mobile"));
        buf.append(" :");
        buf.append(info.getSrcAddress());
        buf.append("\r\n");
        buf.append(EASResource.getString((String)RES, (String)"sendTime") + " :");
        buf.append(dateformat.format(info.getReceiveTime()));
        String msgId = info.getMsgId();
        SendUserMsgInfo response = null;
        SendUserMsgCollection cols = null;
        try {
            cols = this.getISendUserMsg().getSendUserMsgCollection("where srcMsgId = '" + msgId + "'");
        }
        catch (Exception ex) {
            buf.append(EASResource.getString((String)RES, (String)"getMessageFail") + "\r\n" + ex.getMessage());
        }
        if (cols != null && cols.size() > 0) {
            buf.append("\r\n-----------------           ");
            buf.append(EASResource.getString((String)RES, (String)"SystemReplyMsgList"));
            buf.append("---------------------          \r\n");
            for (int i = 0; i < cols.size(); ++i) {
                response = cols.get(i);
                if (response == null) continue;
                buf.append(EASResource.getString((String)RES, (String)"replyContent"));
                buf.append(":\r\n    ");
                buf.append(response.getTitle());
                buf.append("\r\n");
                buf.append(EASResource.getString((String)RES, (String)"replyTime") + ":");
                buf.append(dateformat.format(response.getSendTime()));
                buf.append("\r\n");
            }
            buf.append("\r\n-------------------------------------------------------");
        }
        return buf.toString();
    }
}

