/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.MobileConfigInfo;
import com.kingdee.eas.mobile.framework.MobileMsgInfo;
import com.kingdee.eas.mobile.framework.WeinaduoMobileGatewayProvider;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MobileCommonUtil
extends WeinaduoMobileGatewayProvider {
    private static final Logger logger = Logger.getLogger(MobileCommonUtil.class);

    public boolean sendMessage(MobileMsgInfo mobileMsgInfo, MobileConfigInfo mobileConfigInfo) throws BOSException, EASBizException {
        if (mobileMsgInfo == null) {
            logger.error((Object)"WeinaduoMobileGatewayProvider sendMessage error:---mobileMsgInfo is null!!");
            return false;
        }
        if (mobileMsgInfo.getReceiverPhoneNo() == null) {
            logger.error((Object)"WeinaduoMobileGatewayProvider sendMessage error:---ReceiverPhoneNo is null!");
            return false;
        }
        if (mobileMsgInfo.getContent() == null) {
            logger.error((Object)"WeinaduoMobileGatewayProvider sendMessage error:Content is null!");
            return false;
        }
        StringBuffer queryStringBuffer = new StringBuffer();
        queryStringBuffer.append("&sequeid=").append(mobileMsgInfo.getMsgIdInGateway()).append("&dst=").append(mobileMsgInfo.getReceiverPhoneNo().trim()).append("&msg=");
        boolean isLength63 = mobileMsgInfo.getContent().length() <= 63;
        logger.info((Object)("SendMessage to Weinaduo: mobileMsgInfo.getReceiverPhoneNo()===" + mobileMsgInfo.getReceiverPhoneNo()));
        logger.info((Object)("SendMessage to Weinaduo: mobileMsgInfo.getContent()===" + mobileMsgInfo.getContent()));
        try {
            String encodeContent = URLEncoder.encode(mobileMsgInfo.getContent(), "GBK");
            queryStringBuffer.append(encodeContent);
        }
        catch (UnsupportedEncodingException e1) {
            logger.error((Object)("sendMessage4Common UnsupportedEncodingException:" + e1.getMessage()));
            e1.printStackTrace();
        }
        logger.info((Object)("SendMessage to Weinaduo: mobileMsgInfo.getContent()====encode=" + mobileMsgInfo.getContent()));
        String responseStr = null;
        try {
            String uri = isLength63 ? "/send/g70send.aspx" : "/send/longsend.aspx";
            responseStr = this.sendRequest2Gateway(uri, queryStringBuffer.toString(), mobileConfigInfo);
        }
        catch (Exception e) {
            logger.error((Object)("WeinaduoMobileGatewayProvider-sendMessage4Common error:" + e.getMessage()));
            e.printStackTrace();
        }
        logger.debug((Object)("WeinaduoMobileGatewayProvider sendMessage result:" + responseStr));
        if (responseStr != null && responseStr.indexOf("num=0") == -1) {
            return true;
        }
        logger.error((Object)("WeinaduoMobileGatewayProvider sendMessage error:" + responseStr));
        return false;
    }

    public MobileMsgInfo[] receiveMessage(MobileConfigInfo mobileConfigInfo) throws BOSException {
        String responseStr = null;
        try {
            responseStr = this.sendRequest2Gateway("/send/readxmlsmsconfig.aspx", null, mobileConfigInfo);
        }
        catch (Exception e) {
            logger.error((Object)("WeinaduoMobileGatewayProvider-receiveMessage error." + e.getMessage()));
            e.printStackTrace();
        }
        logger.info((Object)("WeinaduoMobileGatewayProvider-receiveMessage responseStr :" + responseStr));
        if (!StringUtil.isEmpty((String)responseStr)) {
            logger.info((Object)("WeinaduoMobileGatewayProvider-receiveMessage contet:" + responseStr));
            if (responseStr.indexOf("id=0&") != -1) {
                logger.info((Object)"WeinaduoMobileGatewayProvider-receiveMessage no message unread.");
                return null;
            }
            logger.info((Object)"_receiveMessage from Weinaduo");
            String[] msgStrArray = responseStr.split("\\|\\|\\|\\|");
            MobileMsgInfo[] mobileMsgInfos = new MobileMsgInfo[msgStrArray.length];
            String ids = "";
            String id = "";
            for (int i = 0; i < msgStrArray.length; ++i) {
                String msgStr = msgStrArray[i];
                if (StringUtil.isEmpty((String)msgStr)) continue;
                String[] keyValueArray = msgStr.split("&");
                HashMap<String, String> keyValueMap = new HashMap<String, String>();
                for (int j = 0; j < keyValueArray.length; ++j) {
                    String keyValue = keyValueArray[j];
                    String[] keyValueSplit = keyValue.split("=");
                    if (keyValueSplit.length > 1) {
                        keyValueMap.put(keyValueSplit[0], keyValueSplit[1]);
                    } else {
                        logger.info((Object)("WeinaduoMobileGatewayProvider-receiveMessage value is empty, key:" + keyValueSplit[0]));
                    }
                    id = keyValueMap.get("id").toString();
                    if (id == null || id.equals("")) continue;
                    ids = ids + id + ";";
                }
                String fromPhoneNo = (String)keyValueMap.get("src");
                String content = (String)keyValueMap.get("msg");
                String msgIdInGateway = (String)keyValueMap.get("sequeid");
                logger.debug((Object)("_receiveMessage from Weinaduo fromPhoneNo===" + fromPhoneNo));
                logger.debug((Object)("_receiveMessage from Weinaduo content===" + content));
                logger.debug((Object)("_receiveMessage from Weinaduo msgIdInGateway===" + msgIdInGateway));
                mobileMsgInfos[i] = new MobileMsgInfo(null, content, msgIdInGateway, fromPhoneNo);
            }
            try {
                logger.info((Object)("WeinaduoMobileGatewayProvider-receiveMessage configupsms:" + ids));
                if (ids != null && !ids.equals("")) {
                    responseStr = this.sendRequest2Gateway("/send/configupsms.aspx", "&ids=" + ids, mobileConfigInfo);
                    logger.info((Object)("WeinaduoMobileGatewayProvider-receiveMessage responseStr:" + responseStr));
                }
            }
            catch (Exception e) {
                logger.error((Object)("WeinaduoMobileGatewayProvider-receiveMessage configupsms." + e.getMessage()));
                e.printStackTrace();
            }
            return mobileMsgInfos;
        }
        return null;
    }

    private String sendRequest2Gateway(String uri, String queryString, MobileConfigInfo mobileConfigInfo) throws IOException {
        StringBuffer htmlBuff = new StringBuffer();
        boolean isPortEmpty = StringUtils.isEmpty((String)mobileConfigInfo.getPort());
        StringBuffer urlStr = new StringBuffer("http://").append(mobileConfigInfo.getHost()).append(isPortEmpty ? "" : ":" + mobileConfigInfo.getPort()).append(uri).append("?name=").append(mobileConfigInfo.getLoginName().trim()).append("&pwd=").append(mobileConfigInfo.getPassword().trim());
        if (queryString != null) {
            urlStr.append(queryString);
        }
        logger.info((Object)("WeinaduoMobileGatewayProvider-sendRequest2Gateway content:" + urlStr));
        BufferedReader inBuff = null;
        try {
            URL url = new URL(urlStr.toString());
            URLConnection urlConnection = url.openConnection();
            urlConnection.setAllowUserInteraction(false);
            inBuff = new BufferedReader(new InputStreamReader(url.openStream(), "GBK"));
            if (null != inBuff) {
                String inputLine;
                while ((inputLine = inBuff.readLine()) != null) {
                    htmlBuff.append(inputLine);
                }
            }
        }
        catch (MalformedURLException ue) {
            logger.info((Object)("WeinaduoMobileGatewayProvider-sendRequest2Gateway:" + ue.getMessage() + "|urlStr:" + urlStr));
            throw ue;
        }
        catch (IOException ie) {
            logger.info((Object)("WeinaduoMobileGatewayProvider-sendRequest2Gateway IO error:" + ie.getMessage()));
            throw ie;
        }
        finally {
            if (inBuff != null) {
                try {
                    inBuff.close();
                }
                catch (IOException ce) {
                    logger.info((Object)("WeinaduoMobileGatewayProvider-sendRequest2Gateway IO close error:" + ce));
                    throw ce;
                }
            }
        }
        return htmlBuff.toString();
    }
}

