/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.message.common.KDMessageType;
import com.kingdee.bos.message.common.KDMimeType;
import com.kingdee.bos.message.common.KDMsgCreator;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.BOSMsgTypeEnum;
import com.kingdee.eas.mobile.EmailAddressInfo;
import com.kingdee.eas.mobile.EmailReceiveMessageInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.MobileMessageAddressInfo;
import com.kingdee.eas.mobile.MsgTypeEnum;
import com.kingdee.eas.mobile.RTXAddressInfo;
import com.kingdee.eas.mobile.RTXMessageInfo;
import com.kingdee.eas.mobile.ReceiveMobileMessageInfo;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.dao.DefaultEmailMessageDAO;
import com.kingdee.eas.mobile.dao.DefaultReceiveMoMsgDAO;
import com.kingdee.eas.mobile.dao.DefaultSendMoMsgDao;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MsgTransform {
    private static final Logger logger = Logger.getLogger(MsgTransform.class);
    private static final KDMsgCreator kdMsgCreator = KDMsgCreator.create();

    private MsgTransform() {
    }

    public static EmailSendMessageInfo msg2SendEmail(Context ctx, KDMessage msg, MsgTypeEnum msgType) throws EASBizException, BOSException {
        return MsgTransform.msg2SendEmail(ctx, msg, msgType, null);
    }

    public static EmailSendMessageInfo msg2SendEmail(Context ctx, KDMessage msg, MsgTypeEnum msgType, EmailReceiveMessageInfo parentEmailReceiveMoMsgInfo) throws EASBizException, BOSException {
        KDMessageAddress address = msg.getSender();
        if (2 != BOSMsgTypeEnum.getMsgType(address.getDeviceName())) {
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        EmailSendMessageInfo emailSendMsgInfo = new EmailSendMessageInfo();
        EmailAddressInfo addressInfo = new EmailAddressInfo();
        addressInfo.setFrom(address.getDetail());
        KDMessageAddress[] receiverAddress = msg.getReceivers();
        if (receiverAddress.length > 0 && receiverAddress[0].getDeviceName().equals("mp:mail")) {
            emailSendMsgInfo.setMimeType(MimeTypeEnum.HTML);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < receiverAddress.length; ++i) {
            sb.append(receiverAddress[i].getDetail());
            if (i >= receiverAddress.length - 1) continue;
            sb.append(";");
        }
        addressInfo.setTo(sb.toString());
        emailSendMsgInfo.setAddress(addressInfo);
        emailSendMsgInfo.setTitle(msg.getTitle());
        emailSendMsgInfo.setContent(msg.getContent());
        emailSendMsgInfo.setMsgType(msgType);
        if (msgType.equals((Object)MsgTypeEnum.SEND) && !StringUtils.isEmpty((String)msg.getId())) {
            emailSendMsgInfo.setMsgID(msg.getId());
        }
        KDMessageAddress sentAddress = msg.getSender();
        addressInfo.setFrom(sentAddress.getDetail());
        emailSendMsgInfo.setRevertible(msg.isRevertible());
        emailSendMsgInfo.setResponsed(msg.isResponsed());
        if (parentEmailReceiveMoMsgInfo == null) {
            if (!StringUtils.isEmpty((String)msg.getRelativeId())) {
                EmailReceiveMessageInfo emailReceiveMessageInfo = DefaultEmailMessageDAO.getEmailReceiveMsgInfoByMsgId(ctx, msg.getId());
                if (emailReceiveMessageInfo != null) {
                    emailSendMsgInfo.setParentMsg(emailReceiveMessageInfo);
                    if (!StringUtils.isEmpty((String)emailReceiveMessageInfo.getRootMsgID())) {
                        emailSendMsgInfo.setRootMsgID(emailReceiveMessageInfo.getRootMsgID());
                    } else {
                        emailSendMsgInfo.setRootMsgID(emailReceiveMessageInfo.getMsgID());
                    }
                } else {
                    emailSendMsgInfo.setRootMsgID(msg.getId());
                }
            } else {
                emailSendMsgInfo.setRootMsgID(msg.getId());
            }
        } else {
            emailSendMsgInfo.setParentMsg(parentEmailReceiveMoMsgInfo);
            if (!StringUtils.isEmpty((String)parentEmailReceiveMoMsgInfo.getRootMsgID())) {
                emailSendMsgInfo.setRootMsgID(parentEmailReceiveMoMsgInfo.getRootMsgID());
            } else {
                emailSendMsgInfo.setRootMsgID(parentEmailReceiveMoMsgInfo.getMsgID());
            }
        }
        return emailSendMsgInfo;
    }

    public static EmailReceiveMessageInfo msg2ReceiveEmail(Context ctx, KDMessage msg, EmailSendMessageInfo parentEmailSendMsgInfo) throws EASBizException, BOSException {
        KDMessageAddress address = msg.getSender();
        if (2 != BOSMsgTypeEnum.getMsgType(address.getDeviceName())) {
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        EmailReceiveMessageInfo emailReceiveMsgInfo = new EmailReceiveMessageInfo();
        EmailAddressInfo addressInfo = new EmailAddressInfo();
        addressInfo.setFrom(address.getDetail());
        KDMessageAddress[] receiverAddress = msg.getReceivers();
        if (receiverAddress.length > 0 && receiverAddress[0].getDeviceName().equals("mp:mail")) {
            emailReceiveMsgInfo.setMimeType(MimeTypeEnum.HTML);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < receiverAddress.length; ++i) {
            sb.append(receiverAddress[i].getDetail());
            if (i >= receiverAddress.length - 1) continue;
            sb.append(";");
        }
        KDMessageAddress sentAddress = msg.getSender();
        addressInfo.setFrom(sentAddress.getDetail());
        addressInfo.setTo(sb.toString());
        emailReceiveMsgInfo.setAddress(addressInfo);
        emailReceiveMsgInfo.setTitle(msg.getTitle());
        emailReceiveMsgInfo.setContent(MsgTransform.handleEmailContent(msg.getContent()));
        if (!StringUtils.isEmpty((String)msg.getId())) {
            emailReceiveMsgInfo.setMsgID(msg.getId());
        }
        if (parentEmailSendMsgInfo == null && !StringUtils.isEmpty((String)msg.getRelativeId())) {
            parentEmailSendMsgInfo = DefaultEmailMessageDAO.getEmailSendMsgInfoByMsgId(ctx, msg.getRelativeId());
        }
        if (parentEmailSendMsgInfo != null) {
            emailReceiveMsgInfo.setParentMsg(parentEmailSendMsgInfo);
            if (!StringUtils.isEmpty((String)parentEmailSendMsgInfo.getRootMsgID())) {
                emailReceiveMsgInfo.setRootMsgID(parentEmailSendMsgInfo.getRootMsgID());
            } else {
                emailReceiveMsgInfo.setRootMsgID(parentEmailSendMsgInfo.getMsgID());
            }
        } else {
            emailReceiveMsgInfo.setRootMsgID(msg.getId());
        }
        emailReceiveMsgInfo.setMsgID(msg.getId());
        return emailReceiveMsgInfo;
    }

    private static String handleEmailContent(String content) {
        String approveContent = content;
        String regEx = "<[^>]+>|</[^>]+>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(approveContent);
        approveContent = m.replaceAll("");
        approveContent.trim();
        if (approveContent.indexOf("&nbsp;") > 0) {
            regEx = "&nbsp;";
            p = Pattern.compile(regEx);
            m = p.matcher(approveContent);
            approveContent = m.replaceAll("");
            approveContent = approveContent.trim();
        }
        return approveContent;
    }

    public static EmailReceiveMessageInfo msg2ReceiveEmail(Context ctx, KDMessage msg) throws EASBizException, BOSException {
        return MsgTransform.msg2ReceiveEmail(ctx, msg, null);
    }

    public static RTXMessageInfo msg2RTX(Context ctx, KDMessage msg, MsgTypeEnum msgType) throws EASBizException, BOSException {
        KDMessageAddress address = msg.getSender();
        if (3 != BOSMsgTypeEnum.getMsgType(address.getDeviceName())) {
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        RTXMessageInfo rtxMsgInfo = new RTXMessageInfo();
        RTXAddressInfo addressInfo = new RTXAddressInfo();
        addressInfo.setSendRTXNumber(address.getDetail());
        KDMessageAddress[] relativeAddress = msg.getReceivers();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < relativeAddress.length; ++i) {
            sb.append(relativeAddress[i].getDetail());
            if (i >= relativeAddress.length - 1) continue;
            sb.append(";");
        }
        addressInfo.setReceiveRTXNumber(sb.toString());
        rtxMsgInfo.setAddress(addressInfo);
        rtxMsgInfo.setMsgType(MsgTypeEnum.RECEIVE);
        rtxMsgInfo.setContent(msg.getTitle());
        rtxMsgInfo.setMsgID(msg.getRelativeId());
        return rtxMsgInfo;
    }

    public static SendMobileMessageInfo receiveMsg2SendMoMsg(Context ctx, KDMessage msg, SendMobileMessageInfo parentSendMoMsgInfo, ReceiveMobileMessageInfo receiveMoMsgInfo) throws EASBizException, BOSException {
        if (parentSendMoMsgInfo == null || receiveMoMsgInfo == null || StringUtils.isEmpty((String)parentSendMoMsgInfo.getAddress().getSendMobileNumber())) {
            logger.info((Object)"MsgTransform-receiveMsg2SendMoMsg: parentSendMoMsgInfo null or receiveMoMsgInfo null or no parentSendMoMsgInfo.getAddress().getSendMobileNumber()");
            return null;
        }
        KDMessageAddress sendAddress = msg.getSender();
        if (1 != BOSMsgTypeEnum.getMsgType(sendAddress.getDeviceName())) {
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        if (parentSendMoMsgInfo == null) {
            return null;
        }
        SendMobileMessageInfo sendMoMsgInfo = new SendMobileMessageInfo();
        MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
        addressInfo.setReceiveMobileNumber(parentSendMoMsgInfo.getAddress().getSendMobileNumber());
        addressInfo.setSendMobileNumber(sendAddress.getDetail());
        sendMoMsgInfo.setAddress(addressInfo);
        sendMoMsgInfo.setMsgType(MsgTypeEnum.SEND);
        sendMoMsgInfo.setTitle(msg.getContent());
        sendMoMsgInfo.setCustomStr(msg.getContent());
        sendMoMsgInfo.setContent(receiveMoMsgInfo.getContent());
        if (!StringUtils.isEmpty((String)msg.getId())) {
            sendMoMsgInfo.setMsgID(msg.getId());
        }
        sendMoMsgInfo.setNotify(msg.isNotify());
        if (!StringUtils.isEmpty((String)msg.getContent()) && "for.hander".equals(msg.getContent().trim().toLowerCase())) {
            sendMoMsgInfo.setSendHandcraft(true);
            sendMoMsgInfo.setTitle("for.hander");
        }
        sendMoMsgInfo.setRevertible(msg.isRevertible());
        sendMoMsgInfo.setResponsed(msg.isResponsed());
        sendMoMsgInfo.setMsgID(msg.getId());
        sendMoMsgInfo.setParentMsg(receiveMoMsgInfo);
        if (!StringUtils.isEmpty((String)receiveMoMsgInfo.getRootMsgID())) {
            sendMoMsgInfo.setRootMsgID(receiveMoMsgInfo.getRootMsgID());
        } else {
            sendMoMsgInfo.setRootMsgID(receiveMoMsgInfo.getMsgID());
        }
        return sendMoMsgInfo;
    }

    public static SendMobileMessageInfo msg2SendMoMsg(Context ctx, KDMessage msg) throws EASBizException, BOSException {
        return MsgTransform.msg2SendMoMsg(ctx, msg, null);
    }

    public static SendMobileMessageInfo msg2SendMoMsg(Context ctx, KDMessage msg, ReceiveMobileMessageInfo parentReceiveMoMsgInfo) throws EASBizException, BOSException {
        KDMessageAddress address = msg.getSender();
        if (1 != BOSMsgTypeEnum.getMsgType(address.getDeviceName())) {
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        SendMobileMessageInfo sendMoMsgInfo = new SendMobileMessageInfo();
        MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
        addressInfo.setSendMobileNumber(address.getDetail());
        KDMessageAddress[] relativeAddress = msg.getReceivers();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < relativeAddress.length; ++i) {
            sb.append(relativeAddress[i].getDetail());
            if (i >= relativeAddress.length - 1) continue;
            sb.append(";");
        }
        KDMessageAddress sentAddress = msg.getSender();
        addressInfo.setSendMobileNumber(sentAddress.getDetail());
        addressInfo.setReceiveMobileNumber(sb.toString());
        sendMoMsgInfo.setAddress(addressInfo);
        sendMoMsgInfo.setMsgType(MsgTypeEnum.SEND);
        sendMoMsgInfo.setTitle(msg.getContent());
        sendMoMsgInfo.setCustomStr(msg.getContent());
        sendMoMsgInfo.setContent(msg.getTitle());
        if (!StringUtils.isEmpty((String)msg.getId())) {
            sendMoMsgInfo.setMsgID(msg.getId());
        }
        sendMoMsgInfo.setNotify(msg.isNotify());
        if (!StringUtils.isEmpty((String)msg.getContent()) && "for.hander".equals(msg.getContent().trim().toLowerCase())) {
            sendMoMsgInfo.setSendHandcraft(true);
            sendMoMsgInfo.setTitle("for.hander");
        }
        sendMoMsgInfo.setRevertible(msg.isRevertible());
        sendMoMsgInfo.setResponsed(msg.isResponsed());
        sendMoMsgInfo.setMsgID(msg.getId());
        if (parentReceiveMoMsgInfo == null) {
            if (!StringUtils.isEmpty((String)msg.getRelativeId())) {
                ReceiveMobileMessageInfo receiveMoMsgInfo = DefaultReceiveMoMsgDAO.getReceiveMoMsgInfoByMsgId(ctx, msg.getId());
                if (receiveMoMsgInfo != null) {
                    sendMoMsgInfo.setParentMsg(receiveMoMsgInfo);
                    if (!StringUtils.isEmpty((String)receiveMoMsgInfo.getRootMsgID())) {
                        sendMoMsgInfo.setRootMsgID(receiveMoMsgInfo.getRootMsgID());
                    } else {
                        sendMoMsgInfo.setRootMsgID(receiveMoMsgInfo.getMsgID());
                    }
                } else {
                    sendMoMsgInfo.setRootMsgID(msg.getId());
                }
            } else {
                sendMoMsgInfo.setRootMsgID(msg.getId());
            }
        } else {
            sendMoMsgInfo.setParentMsg(parentReceiveMoMsgInfo);
            sendMoMsgInfo.setRootMsgID(parentReceiveMoMsgInfo.getRootMsgID());
        }
        return sendMoMsgInfo;
    }

    public static ReceiveMobileMessageInfo msg2ReceiveMoMsg(Context ctx, KDMessage msg) throws EASBizException, BOSException {
        return MsgTransform.msg2ReceiveMoMsg(ctx, msg, null);
    }

    public static ReceiveMobileMessageInfo msg2ReceiveMoMsg(Context ctx, KDMessage msg, SendMobileMessageInfo parentSendMoMsgInfo) throws EASBizException, BOSException {
        KDMessageAddress sendAddress = msg.getSender();
        if (1 != BOSMsgTypeEnum.getMsgType(sendAddress.getDeviceName())) {
            throw new MobileException(MobileException.MSGTYPE_ERROR);
        }
        ReceiveMobileMessageInfo receiveMoMsgInfo = new ReceiveMobileMessageInfo();
        MobileMessageAddressInfo addressInfo = new MobileMessageAddressInfo();
        KDMessageAddress[] relativeAddress = msg.getReceivers();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < relativeAddress.length; ++i) {
            sb.append(relativeAddress[i].getDetail());
            if (i >= relativeAddress.length - 1) continue;
            sb.append(";");
        }
        addressInfo.setReceiveMobileNumber(sb.toString());
        addressInfo.setSendMobileNumber(sendAddress.getDetail());
        receiveMoMsgInfo.setAddress(addressInfo);
        receiveMoMsgInfo.setTitle(msg.getContent());
        String content = msg.getTitle();
        String appendLink = " ";
        if (parentSendMoMsgInfo != null && parentSendMoMsgInfo.isIsAppendPersonName() && parentSendMoMsgInfo.getAddress().getReceiveBizUser() != null && parentSendMoMsgInfo.getAddress().getReceiveBizUser().getPerson() != null) {
            content = content + " " + parentSendMoMsgInfo.getAddress().getReceiveBizUser().getPerson().getName();
            appendLink = "-";
        }
        if (parentSendMoMsgInfo != null && parentSendMoMsgInfo.isIsAppendNumber()) {
            content = content + appendLink + parentSendMoMsgInfo.getAddress().getReceiveMobileNumber();
        }
        receiveMoMsgInfo.setContent(content);
        if (!StringUtils.isEmpty((String)msg.getId())) {
            receiveMoMsgInfo.setMsgID(msg.getId());
        }
        if (parentSendMoMsgInfo == null && !StringUtils.isEmpty((String)msg.getRelativeId())) {
            parentSendMoMsgInfo = DefaultSendMoMsgDao.getSendMoMsgInfoByMsgId(ctx, msg.getRelativeId());
        }
        if (parentSendMoMsgInfo != null) {
            receiveMoMsgInfo.setParentMsg(parentSendMoMsgInfo);
            if (!StringUtils.isEmpty((String)parentSendMoMsgInfo.getRootMsgID())) {
                receiveMoMsgInfo.setRootMsgID(parentSendMoMsgInfo.getRootMsgID());
            } else {
                receiveMoMsgInfo.setRootMsgID(parentSendMoMsgInfo.getMsgID());
            }
        } else {
            receiveMoMsgInfo.setRootMsgID(msg.getId());
        }
        return receiveMoMsgInfo;
    }

    public static KDMessage sendEmail2Msg(Context ctx, EmailSendMessageInfo emailSendMsgInfo) throws EASBizException, BOSException {
        String title = emailSendMsgInfo.getTitle();
        String content = emailSendMsgInfo.getContent();
        String receiver = emailSendMsgInfo.getAddress().getTo();
        KDMessage kdMsg = kdMsgCreator.createMsgForMail(receiver, title, content, new KDMessageAttachment[0]);
        if (MimeTypeEnum.HTML.equals((Object)emailSendMsgInfo.getMimeType())) {
            kdMsg.setMimeType(KDMimeType.HTML);
        } else {
            kdMsg.setMimeType(KDMimeType.TEXT);
        }
        if (!StringUtils.isEmpty((String)emailSendMsgInfo.getMsgID())) {
            kdMsg.setId(emailSendMsgInfo.getMsgID());
        } else {
            String msgId = Uuid.create().toString();
            kdMsg.setId(msgId);
            DefaultEmailMessageDAO.updateSendEmailMsgInfo(ctx, emailSendMsgInfo.getId().toString(), msgId);
        }
        if (emailSendMsgInfo.isNotify()) {
            kdMsg.setType(KDMessageType.NOTIFY);
        } else if (emailSendMsgInfo.isRevertible()) {
            kdMsg.setType(KDMessageType.REVERTIBLE);
        }
        return kdMsg;
    }

    public static KDMessage rtx2Msg(Context ctx, RTXMessageInfo msg) throws EASBizException, BOSException {
        return null;
    }

    public static KDMessage sendMoMsg2Msg(Context ctx, SendMobileMessageInfo sendMoMsgInfo) throws EASBizException, BOSException {
        String title = sendMoMsgInfo.getContent();
        String receiver = sendMoMsgInfo.getAddress().getReceiveMobileNumber();
        KDMessage kdMsg = kdMsgCreator.createMsgForSMS(receiver, title);
        if (!StringUtils.isEmpty((String)sendMoMsgInfo.getMsgID())) {
            kdMsg.setId(sendMoMsgInfo.getMsgID());
        } else {
            String msgId = Uuid.create().toString();
            kdMsg.setId(msgId);
            try {
                DefaultSendMoMsgDao.updateSendMoMsgInfo(ctx, sendMoMsgInfo.getId().toString(), null, msgId);
            }
            catch (Exception err) {
                logger.error((Object)("sendMoMsg2Msg has some error, id = " + sendMoMsgInfo.getId().toString() + " , and information : " + err.getMessage()));
            }
        }
        if (sendMoMsgInfo.isNotify()) {
            kdMsg.setType(KDMessageType.NOTIFY);
        } else if (sendMoMsgInfo.isRevertible()) {
            kdMsg.setType(KDMessageType.REVERTIBLE);
        }
        if (sendMoMsgInfo.isSendHandcraft()) {
            kdMsg.setContent("for.hander");
        }
        return kdMsg;
    }

    public static KDMessage receiveMoMsg2Msg(Context ctx, ReceiveMobileMessageInfo receiveMobileMessageInfo) throws EASBizException, BOSException {
        return null;
    }
}

