/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.reportmeta.ctrlreport.adapter.TableManager;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.AbstractDeployAccreditSelectUserOnlyUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class DeployAccreditSelectUserOnlyUI
extends AbstractDeployAccreditSelectUserOnlyUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DeployAccreditSelectUserOnlyUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = true;
    private KDTable tableAccUser;
    EntityViewInfo view;

    public DeployAccreditSelectUserOnlyUI() throws Exception {
        this.kDButtonGroup1.add((AbstractButton)this.rbCurrent);
        this.kDButtonGroup1.add((AbstractButton)this.rbAll);
        this.rbCurrent.setSelected(true);
    }

    public DeployAccreditSelectUserOnlyUI(KDTable tableAccUser) throws Exception {
        this();
        this.tableAccUser = tableAccUser;
    }

    public void onLoad() throws Exception {
        this.initUserOneUserF7();
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private void initUserOneUserF7() throws BOSException, EASBizException {
        if (this.rbCurrent.isSelected() && null == this.view) {
            IObjectPK currentUserPK = this.getCurrentUserPK();
            this.view = this.getUserCondition(currentUserPK);
        }
        this.pmtUser.setEntityViewInfo(this.view);
        this.pmtUser.setEnabledMultiSelection(true);
    }

    private EntityViewInfo getUserCondition(IObjectPK currentUserPK) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter = Administrator.isCUAdmin(null, (IObjectPK)currentUserPK) ? this.getAdminUserCondition(currentUserPK, true) : (Administrator.isBizAdmin(null, (IObjectPK)currentUserPK) ? this.getAdminUserCondition(currentUserPK, false) : this.getCommonUserCondition(currentUserPK));
        filter.mergeFilter(this.getAdminExceptFilter(), "and");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    private FilterInfo getAdminUserCondition(IObjectPK currentUserPK, boolean isCUAdmin) throws BOSException, EASBizException {
        List manageCuIDList = null;
        manageCuIDList = isCUAdmin ? PermissionRangeHelper.getUserOrgId(null, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE) : PermissionRangeHelper.getUserOrgId(null, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.MANAGE_ORG_TYPE);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ToolUtils.aryToStr((List)manageCuIDList), CompareType.INNER));
        return filterInfo;
    }

    private FilterInfo getCommonUserCondition(IObjectPK currentUserPK) {
        FilterInfo filter = new FilterInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT DISTINCT FUserID FROM T_PM_OrgRange ").append(" WHERE FOrgID IN (SELECT FOrgID FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(currentUserPK).append("' ").append(" AND FType = ").append(10).append(") ").append(" AND FType = ").append(10).append(" ").append(" AND FUserID <> '").append(currentUserPK.toString()).append("' ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), CompareType.INNER));
        return filter;
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    private FilterInfo getAdminExceptFilter() {
        return Administrator.getNotAdminUserFilter();
    }

    protected void rbAll_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.pmtUser.setEntityViewInfo(null);
        }
    }

    protected void rbCurrent_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.initUserOneUserF7();
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        Object[] objecs = (Object[])this.pmtUser.getData();
        int size = objecs.length;
        String[] selectedIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            String fid;
            UserInfo userInfo = (UserInfo)objecs[i];
            if (userInfo == null) {
                MessageUtil.showInfo("\u8bf7\u9009\u62e9\u7528\u6237", false);
                this.pmtUser.requestFocus();
                return;
            }
            String id = CtrlReportUtil.getObjectString(userInfo.getId());
            String name = CtrlReportUtil.getObjectString(userInfo.getName());
            selectedIDs[i] = fid = id;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fid", fid);
            Object[] values = new String[]{name};
            TableManager.insertToTable(this.tableAccUser, "fid", map, values);
        }
        TableManager.rowSelected(this.tableAccUser, selectedIDs, "fid");
        this.isCancel = false;
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }
}

