/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.wizard.common.CommonResource;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.reportmeta.ctrlreport.DefineReportFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.DefineReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.IDefineReport;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.AbstractEditBatchUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.DeployBatchUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.DeploySelectedUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportDialog;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.FilterType;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MultiLangUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.base.reportmeta.sumreport.enumtype.TempletType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class EditBatchUI
extends AbstractEditBatchUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(EditBatchUI.class);
    private static final int COL_NAME = 0;
    private static final int COL_SNAP_TYPE = 1;
    private static final int COL_FILTER_TYPE = 2;
    private boolean isinitLayout = false;
    private boolean isCancel = true;
    protected KDBizMultiLangBox mlbName;
    protected KDComboBox cmbFilterType;
    protected KDComboBox cmbSnapType;
    ReportSnapType snapTypeOld;
    ArrayList initReportList;
    String defaultTypeString;
    String selectedTreeNode = "";

    public EditBatchUI() throws Exception {
        this.initLayout();
        this.tableReport.checkParsed();
    }

    public EditBatchUI(ArrayList initReportList) throws Exception {
        this();
        this.initReportList = initReportList;
    }

    public void onLoad() throws Exception {
        this.initReportList(this.initReportList);
        this.setDefaultOrgType();
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private void setDefaultOrgType() {
        Object[] cbArray = OrgType.getEnumList().toArray();
        DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>(cbArray);
        for (int i = 0; i < cbModel.getSize(); ++i) {
            OrgType orgType = (OrgType)cbModel.getElementAt(i);
            if (orgType.getValue() == 0) {
                cbModel.removeElementAt(i);
                --i;
                continue;
            }
            int ivalue = orgType.getValue();
            String orgTypeString = String.valueOf(ivalue);
            if (!orgTypeString.equals(this.defaultTypeString)) continue;
            cbModel.setSelectedItem(orgType);
        }
        this.cbOrgType.setModel(cbModel);
    }

    private void initReportList(ArrayList lstSelectedReport) {
        for (HashMap map : lstSelectedReport) {
            String fid = CtrlReportUtil.getObjectString(map.get("fid"));
            String name = CtrlReportUtil.getObjectString(map.get("fname"));
            String filterType = CtrlReportUtil.getObjectString(map.get("ffiltertype"));
            String orgType = CtrlReportUtil.getObjectString(map.get("forgtype"));
            String fisstdproduct = CtrlReportUtil.getObjectString(map.get("fisstdproduct"));
            String snapType = CtrlReportUtil.getObjectString(map.get("fsnaptype"));
            if (snapType.equals("")) {
                snapType = "-1";
            }
            this.defaultTypeString = orgType;
            if (DeployBatchUI.isExistReport(this.tableReport, fid)) continue;
            IRow irow = this.tableReport.addRow();
            irow.setUserObject((Object)map);
            irow.getCell(0).setValue((Object)name);
            MultiLangUtil.setMultiLangItemListToCell(irow.getCell(0), name, this.mlbName);
            if (fisstdproduct.equals("1")) {
                irow.getCell(0).getStyleAttributes().setLocked(true);
                irow.getCell(0).getStyleAttributes().setFontColor(Color.GRAY);
            }
            irow.getCell(1).setValue((Object)ReportSnapType.getDataType(Integer.parseInt(snapType)));
            irow.getCell(2).setValue((Object)FilterType.getFilterType(filterType));
        }
    }

    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        DeploySelectedUI dtui = new DeploySelectedUI(EditBatchUI.class.getName());
        ReportDialog.showDialog((CoreUIObject)dtui, MessageUtil.getMsgInfo("label333"), true, true);
        if (!dtui.isCanceled()) {
            ArrayList lst = dtui.getLstSelected();
            this.initReportList(lst);
        }
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        int selEnd;
        KDTSelectBlock sel = this.tableReport.getSelectManager().get();
        if (sel == null) {
            return;
        }
        if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)CommonResource.getString((String)"res_39"), (String)CommonResource.getString((String)"res_40"))) {
            return;
        }
        int selBegin = sel.getBeginRow();
        for (int i = selEnd = sel.getEndRow(); i >= selBegin; --i) {
            this.tableReport.removeRow(i);
        }
    }

    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        this.tableReport.getEditManager().stopEditing();
        OrgType orgType = (OrgType)this.cbOrgType.getSelectedItem();
        int ivalue = orgType.getValue();
        final String orgTypeString = String.valueOf(ivalue);
        final int length = this.tableReport.getRowCount();
        if (length <= 0) {
            MessageUtil.showInfo("label379", true);
            return;
        }
        if (length > 100) {
            MessageUtil.showInfo(MessageUtil.getMsgInfo("label380") + 100, false);
            return;
        }
        this.deployMessage.setVisible(true);
        this.btnOk.setEnabled(false);
        this.btnCancel.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    for (int i = 0; i < length; ++i) {
                        IRow row = EditBatchUI.this.tableReport.getRow(i);
                        String newName = MultiLangUtil.getMultiLangItemListFromCell(row.getCell(0));
                        if (newName.equals("")) {
                            MessageUtil.showInfo("label381", true);
                            EditBatchUI.this.tableReport.getEditManager().editCellAt(i, 0);
                            return;
                        }
                        if (newName.indexOf(" ") != -1) {
                            MessageUtil.showInfo("label202", true);
                            EditBatchUI.this.tableReport.getEditManager().editCellAt(i, 0);
                            return;
                        }
                        if (newName.indexOf("/") == -1) continue;
                        MessageUtil.showInfo("label203", true);
                        EditBatchUI.this.tableReport.getEditManager().editCellAt(i, 0);
                        return;
                    }
                    int intSuccess = 0;
                    int intError = 0;
                    StringBuffer sbErrMsg = new StringBuffer();
                    for (int i = 0; i < length; ++i) {
                        IRow row = EditBatchUI.this.tableReport.getRow(i);
                        HashMap map = (HashMap)row.getUserObject();
                        String fname = CtrlReportUtil.getObjectString(map.get("fname"));
                        String strRet = EditBatchUI.modify(row, orgTypeString, 0, 1, 2);
                        if (strRet.length() > 0) {
                            sbErrMsg.append(fname).append("\uff1a").append("\r\n    ").append(strRet).append("\r\n");
                            ++intError;
                            continue;
                        }
                        ++intSuccess;
                    }
                    String msg1 = MessageUtil.getMsgInfo("label382") + "\r\n";
                    String msg2 = MessageUtil.getMsgInfo("label383") + length + "\r\n";
                    String msg3 = MessageUtil.getMsgInfo("label344") + intSuccess + "\r\n";
                    String msg4 = MessageUtil.getMsgInfo("label345") + intError;
                    String msg = msg1 + msg2 + msg3 + msg4;
                    if (intError > 0) {
                        MessageUtil.showDetailAndOK(null, msg, sbErrMsg.toString());
                    } else {
                        MessageUtil.showInfo(msg, false);
                    }
                    EditBatchUI.this.isCancel = false;
                    EditBatchUI.this.closeWin();
                }
                finally {
                    EditBatchUI.this.deployMessage.setVisible(false);
                    EditBatchUI.this.btnOk.setEnabled(true);
                    EditBatchUI.this.btnCancel.setEnabled(true);
                }
            }
        });
    }

    public static int saveReportPropety(KDTable tableReport, StringBuffer okMessage, boolean isCheck) {
        tableReport.getEditManager().stopEditing();
        int ivalue = -1;
        String orgTypeString = String.valueOf(ivalue);
        int length = tableReport.getRowCount();
        if (length <= 0) {
            return 0;
        }
        if (isCheck) {
            if (length > 200) {
                okMessage.append(MessageUtil.getMsgInfo("label380") + 200);
                return 1;
            }
            for (int i = 0; i < length; ++i) {
                IRow row = tableReport.getRow(i);
                HashMap map = (HashMap)row.getUserObject();
                String fisstdproduct = CtrlReportUtil.getObjectString(map.get("fisstdproduct"));
                if (fisstdproduct.equals("1")) continue;
                String newName = MultiLangUtil.getMultiLangItemListFromCell(row.getCell(0));
                if (newName.equals("")) {
                    tableReport.getEditManager().editCellAt(i, 0);
                    okMessage.append(MessageUtil.getMsgInfo("label381"));
                    return 1;
                }
                if (newName.indexOf(" ") != -1) {
                    tableReport.getEditManager().editCellAt(i, 0);
                    okMessage.append(MessageUtil.getMsgInfo("label202"));
                    return 1;
                }
                if (newName.indexOf("/") != -1) {
                    tableReport.getEditManager().editCellAt(i, 0);
                    okMessage.append(MessageUtil.getMsgInfo("label203"));
                    return 1;
                }
                if (!newName.toLowerCase().startsWith("std_")) continue;
                tableReport.getEditManager().editCellAt(i, 0);
                okMessage.append("std_\u662f\u6807\u51c6\u4ea7\u54c1\u7684\u524d\u7f00\uff0c\u666e\u901a\u62a5\u8868\u4e0d\u80fd\u4f7f\u7528");
                return 1;
            }
            return 0;
        }
        int intSuccess = 0;
        int intError = 0;
        StringBuffer sbErrMsg = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            IRow row = tableReport.getRow(i);
            HashMap map = (HashMap)row.getUserObject();
            String fname = CtrlReportUtil.getObjectString(map.get("fname"));
            String strRet = EditBatchUI.modify(row, orgTypeString, 0, 1, 2);
            if (strRet.length() > 0) {
                sbErrMsg.append(fname).append("\uff1a").append("\r\n    ").append(strRet).append("\r\n");
                ++intError;
                continue;
            }
            ++intSuccess;
        }
        if (intSuccess > 0 && intError > 0) {
            okMessage.append(sbErrMsg.toString());
            return 2;
        }
        if (intSuccess == 0 && intError > 0) {
            okMessage.append(sbErrMsg.toString());
            return 3;
        }
        return 4;
    }

    private static String modify(IRow row, String orgTypeString, int COL_NAME, int COL_SNAP_TYPE, int COL_FILTER_TYPE) {
        StringBuffer sb = new StringBuffer();
        HashMap map = (HashMap)row.getUserObject();
        String fid = CtrlReportUtil.getObjectString(map.get("fid"));
        String systemID = CtrlReportUtil.getObjectString(map.get("fsystemid"));
        HashMap newNameMap = MultiLangUtil.getMultiLangItemMapFromCell(row.getCell(COL_NAME));
        int newTemplettype = ((TempletType)row.getCell(COL_SNAP_TYPE).getValue()).intValue();
        String ffiltertype = String.valueOf(((FilterType)row.getCell(COL_FILTER_TYPE).getValue()).intValue());
        String strLocal = SysContext.getSysContext().getLocale().toString();
        String newName = (String)newNameMap.get(strLocal);
        String fname = CtrlReportUtil.getObjectString(map.get("fname"));
        String ftemplettype = CtrlReportUtil.getObjectString(map.get("ftemplettype"));
        if (fname.equals(newName) && ftemplettype.equals(String.valueOf(newTemplettype))) {
            return sb.toString();
        }
        try {
            RptParams pr = new RptParams();
            pr.setString("MethodName", "exitsEntity");
            pr.setString("fid", fid);
            pr.setString("Local", strLocal);
            pr.setString("fname", newName);
            pr.setString("systemid", systemID);
            pr.setString("orgid", SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
            RptParams ps_r = FacadeFactory.commonExecuteNever(null, pr);
            boolean flagExist = ps_r.getBoolean("flag");
            if (flagExist) {
                sb.append("\u540d\u79f0\u91cd\u590d\uff0c\u4fee\u6539\u5931\u8d25");
            } else {
                DefineReportInfo info = new DefineReportInfo();
                IDefineReport report = DefineReportFactory.getRemoteInstance();
                LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
                int z = lc.size();
                for (int i = 0; i < z; ++i) {
                    LanguageInfo li = lc.get(i);
                    String alias = (String)newNameMap.get(li.getLocale().toString());
                    info.setName(alias, li.getLocale());
                }
                if (orgTypeString.equals("-1")) {
                    orgTypeString = null;
                }
                info.setOrgType(orgTypeString);
                info.setFilterType(ffiltertype);
                info.setTempletType(newTemplettype);
                BOSUuid bid = BOSUuid.read((String)fid);
                ObjectUuidPK reportPK = new ObjectUuidPK("id", bid);
                info.setId(bid);
                report.update((IObjectPK)reportPK, info);
            }
        }
        catch (Exception e) {
            sb.append(e.getMessage());
            Throwable t = e.getCause();
            while (null != t) {
                sb.append("\r\n").append(t.getMessage());
            }
        }
        return sb.toString();
    }

    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setSelectedTreeNode(String selectedTreeNode) {
        this.selectedTreeNode = selectedTreeNode;
    }
}

