/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.fulfil.IShowLinkage;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.eas.base.reportmeta.base.execution.InvokeFunctionUtil;
import com.kingdee.eas.base.reportmeta.base.license.EXTLicenseException;
import com.kingdee.eas.base.reportmeta.base.license.EXTREPORTLicenseChecker;
import com.kingdee.eas.base.reportmeta.base.license.ILicenseChecker;
import com.kingdee.eas.base.reportmeta.ctrlreport.DefineReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.AbstractExtReportRunUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ExportCompleteRepoertAction;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.LinkageHyperLink;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.PermissionKind;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.DataSetBaseFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.ProcessingBoxPanel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExtReportRunUI
extends AbstractExtReportRunUI {
    private static final long serialVersionUID = 3995638840997219481L;
    private static final Logger logger = LogUtil.getPackageLogger(ExtReportRunUI.class);
    protected SpreadContext _context = null;
    protected String report_id;
    protected boolean isInitToolBar = true;
    protected boolean isLimitRecord = false;
    protected boolean isEntryFromMenu = true;
    protected Map filterMap = null;
    protected ProcessingBoxPanel processingBoxPanel;
    protected DataSetBaseFactory[] DataSetFactorys = new DataSetBaseFactory[5];
    protected DefineReportInfo info = null;
    protected ILicenseChecker _licenseChecker;

    public ExtReportRunUI() throws Exception {
        ExtContextUtils.setContext(null);
    }

    public void onLoad() throws Exception {
        if (null != this.getUIContext().get("UIClassParam")) {
            this.report_id = (String)this.getUIContext().get("UIClassParam");
        } else {
            Object obj = this.getUIContext().get("DefineReportInfo");
            if (null != obj) {
                this.info = (DefineReportInfo)obj;
                this.report_id = this.info.getId().toString();
            }
        }
        this._licenseChecker = new EXTREPORTLicenseChecker(null);
        this.doCheck();
        super.onLoad();
        Object title = this.getUIContext().get("MainMenuName");
        if (title == null) {
            InvokeFunctionUtil.doUISetting(this, this.report_id);
        } else {
            this.setUITitle(String.valueOf(title));
        }
        this.hideBizData();
        this.openGetDataThread();
    }

    public boolean destroyWindow() {
        CtrlReportUtil.releaseCtrl(this, this.report_id);
        return super.destroyWindow();
    }

    protected void doCheck() {
        String isEntryFromMenu;
        String isLimitRecord;
        try {
            if (this.report_id != null && this.info == null) {
                this.info = DefineReportBO.getReportInfo(null, this.report_id);
            }
            if (this.info == null) {
                MessageUtil.showInfo("label327", true);
                this.abort();
            }
        }
        catch (BOSException e) {
            MessageUtil.showDetailAndOKFromResource(null, "label17", (Exception)((Object)e));
            this.abort();
        }
        String canExcute = CtrlReportUtil.getObjectString(this.getUIContext().get("canExcute"));
        if (!canExcute.equals("true")) {
            this.checkDeploy();
            this.checkFunctionPermission();
        }
        if ((isLimitRecord = CtrlReportUtil.getObjectString(this.getUIContext().get("isLimitRecord"))).equals("true")) {
            this.isLimitRecord = true;
        }
        if ((isEntryFromMenu = CtrlReportUtil.getObjectString(this.getUIContext().get("isEntryFromMenu"))).equals("false")) {
            this.isEntryFromMenu = false;
        }
        if (this.getUIContext().get("filterMap") != null) {
            this.filterMap = (Map)this.getUIContext().get("filterMap");
        }
    }

    protected void checkDeploy() {
        try {
            String deployPath;
            if (null == this.info) {
                MessageUtil.showInfo("label327", true);
                this.abort();
            }
            if ((deployPath = CtrlReportUtil.getObjectString(this.info.getDeployPath())).equals("")) {
                MessageUtil.showInfo("label20", true);
                this.abort();
                return;
            }
            byte[] bContent = this.info.getContent();
            int stdProduct = this.info.getIsStdProduct();
            if (stdProduct == 1) {
                boolean isStdProduct = BookIOUtil.hasValidCoupon((byte[])bContent, (boolean)true);
                if (!isStdProduct) {
                    MessageUtil.showInfo("label229", true);
                    this.abort();
                }
            } else {
                try {
                    this._licenseChecker.checkLicense();
                }
                catch (EXTLicenseException e) {
                    MessageUtil.showInfo("label230", true);
                    this.abort();
                }
            }
        }
        catch (AbortException ae) {
            this.abort();
        }
        catch (Exception e) {
            MessageUtil.showDetailAndOKFromResource(null, "label17", e);
            this.abort();
        }
    }

    protected void checkFunctionPermission() {
        String message = null;
        boolean flag = false;
        try {
            flag = PermissionBO.hasDataPermission(this.report_id, PermissionKind.VIEW);
            if (!flag) {
                message = MessageUtil.getMsgInfo("label19");
            }
        }
        catch (Exception e1) {
            message = MessageUtil.getMsgInfo("label17") + e1.getMessage();
        }
        if (!flag) {
            MessageUtil.showInfo(message, false);
            this.abort();
        }
    }

    protected void openGetDataThread() {
        new GetDataThread().start();
    }

    public void showBizData(final ExtGuiExecutor re) {
        if (this._context != null) {
            this.add((Component)this._context);
        }
        this.remove((Component)((Object)this.processingBoxPanel));
        this.validate();
        this.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExtReportRunUI.this.initToolBar(re);
            }
        });
    }

    public void hideBizData() {
        if (this._context != null) {
            this.remove((Component)this._context);
        }
        if (this.processingBoxPanel == null) {
            this.processingBoxPanel = new ProcessingBoxPanel();
        }
        this.add((Component)((Object)this.processingBoxPanel), "Center");
        this.repaint();
    }

    protected void initToolBar(ExtGuiExecutor re) {
        if (this.isInitToolBar) {
            Container c;
            KDToolBar toolBar = this.getUIToolBar();
            Component quit = null;
            if (toolBar.getToolBarComponentCount() >= 2) {
                quit = toolBar.getComponent(2);
                toolBar.removeAllToolBarComponents();
            }
            Action[] acs = null;
            acs = !this.isLimitRecord && this.isEntryFromMenu ? re.getContextualActions(0) : re.getContextualActions(5);
            ExportCompleteRepoertAction exportAction = new ExportCompleteRepoertAction("\u5bfc\u51fa\u5168\u4fe1\u606f\u62a5\u8868", (Component)((Object)this));
            exportAction.setPK(this.report_id);
            exportAction.setBook(this._context.getBook());
            for (int i = 0; i < acs.length; ++i) {
                toolBar.add(acs[i], i + 1);
            }
            toolBar.add((Action)exportAction);
            if (quit != null) {
                toolBar.add(quit);
            }
            if ((c = toolBar.getParent()) != null) {
                c.validate();
                c.repaint();
            }
            this.isInitToolBar = false;
        }
    }

    protected void miExtConsole_actionPerformed(ActionEvent e) throws Exception {
        MiscUtil.showConsole();
    }

    class GetDataThread
    extends Thread {
        boolean isShow = true;
        ExtGuiExecutor re = null;

        public void run() {
            try {
                ExtReportRunUI.this.hideBizData();
                this.initBook();
                if (this.isShow) {
                    ExtReportRunUI.this.showBizData(this.re);
                }
            }
            catch (Exception e) {
                MessageUtil.showDetailAndOK(null, EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label151"), e);
                logger.error((Object)"\u8fd0\u884c\u62a5\u8868:", (Throwable)e);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ExtReportRunUI.this.getUIWindow().close();
                    }
                });
            }
        }

        protected void initBook() throws Exception {
            this.re = new ExtGuiExecutor(ExtReportRunUI.this.info.getContent(), (IExtRuntimeDataProvider)new ExtCallbackImpl(ExtReportRunUI.this.info, ExtReportRunUI.this.isLimitRecord, ExtReportRunUI.this.isEntryFromMenu), ExtReportRunUI.this.isLimitRecord);
            boolean isOk = false;
            isOk = null == ExtReportRunUI.this.filterMap ? this.re.execute() : this.re.execute(ExtReportRunUI.this.filterMap);
            if (!isOk) {
                if (ExtReportRunUI.this.isInitToolBar) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ExtReportRunUI.this.getUIWindow().close();
                        }
                    });
                    this.isShow = false;
                    return;
                }
            } else {
                ExtReportRunUI.this._context = this.re.getSpreadContext();
                Object owner = ExtReportRunUI.this.getUIContext().get("Owner");
                LinkageHyperLink linkage = new LinkageHyperLink(owner);
                this.re.getPrefixHyperLink().setShowLinkage((IShowLinkage)linkage);
            }
        }
    }
}

