/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.ext.util.VerifyUserService;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class GlassPane {
    private Component parentGlassPane;
    private RootPaneContainer rootPane;
    private JPanel glassPane;
    private ArrayList functions;
    private KDDialog dialog;
    private JComponent own;
    private KeyStroke ctrlAltH = KeyStroke.getKeyStroke("control alt H");
    private int maxNumber = 18;
    private boolean isChangeSize = false;
    private int width = 200;
    private int height = 520;

    public GlassPane(JComponent component) {
        this.own = component;
        this.registedKeyEvent();
    }

    public void addFunction(final KDWorkButton function, boolean isOnlyInside) {
        if (isOnlyInside && VerifyUserService.isInsideNet()) {
            return;
        }
        KDWorkButton button = new KDWorkButton();
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GlassPane.this.dialog.dispose();
                if (GlassPane.this.rootPane != null) {
                    GlassPane.this.rootPane.setGlassPane(GlassPane.this.parentGlassPane);
                }
                function.getAction().actionPerformed(e);
            }
        });
        if (this.functions == null) {
            this.functions = new ArrayList();
        }
        this.functions.add(button);
    }

    public void addFunctions(ArrayList fumctions) {
        this.functions = fumctions;
    }

    public void setKeyStroke(KeyStroke ks) {
        this.ctrlAltH = ks;
        this.registedKeyEvent();
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.isChangeSize = true;
    }

    private void registedKeyEvent() {
        if (this.own == null) {
            throw new IllegalArgumentException("null owner window");
        }
        this.own.getInputMap(1).put(this.ctrlAltH, "ShowHideFunctionUI");
        this.own.getActionMap().put("ShowHideFunctionUI", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (GlassPane.this.dialog == null) {
                    Window w = SwingUtilities.getWindowAncestor(GlassPane.this.own);
                    if (w instanceof RootPaneContainer) {
                        GlassPane.this.rootPane = (RootPaneContainer)((Object)w);
                        GlassPane.this.parentGlassPane = GlassPane.this.rootPane.getGlassPane();
                    }
                    Container c = GlassPane.this.own;
                    boolean is = true;
                    Frame p = null;
                    while (is) {
                        if (c.getParent() instanceof Frame) {
                            is = false;
                            p = (Frame)c.getParent();
                            continue;
                        }
                        c = c.getParent();
                    }
                    GlassPane.this.dialog = new KDDialog(p);
                    GlassPane.this.dialog.setTitle("\u9690\u85cf\u529f\u80fd");
                    GlassPane.this.dialog.setSize(GlassPane.this.width, GlassPane.this.height);
                    GlassPane.this.dialog.setModal(true);
                    GlassPane.this.dialog.addWindowListener((WindowListener)new WindowAdapter(){

                        public void windowClosing(WindowEvent e) {
                            if (GlassPane.this.rootPane != null) {
                                GlassPane.this.rootPane.setGlassPane(GlassPane.this.parentGlassPane);
                            }
                        }
                    });
                }
                if (GlassPane.this.rootPane != null) {
                    GlassPane.this.todoAddControls(GlassPane.this.functions, GlassPane.this.dialog);
                    GlassPane.this.rootPane.setGlassPane(GlassPane.this.getGlassPanel());
                    GlassPane.this.rootPane.getGlassPane().setVisible(true);
                    GlassPane.this.dialog.show();
                }
            }
        });
    }

    protected void todoAddControls(ArrayList functions, KDDialog dialog) {
        if (functions == null || functions.size() == 0) {
            return;
        }
        int size = functions.size();
        int column = size / this.maxNumber + (size % this.maxNumber == 0 ? 0 : 1);
        int row = size / column + (size % column == 0 ? 0 : 1);
        if (!this.isChangeSize) {
            dialog.setSize(column <= 3 ? 210 * column : 620, dialog.getSize().height);
        }
        TableLayout2 layout = new TableLayout2(row + 1, column);
        layout.setRowsSpacing(TableLayout2.ALL, 5);
        layout.setFixedHeight(TableLayout2.ALL, 30);
        layout.setColsSpacing(TableLayout2.ALL, 10);
        int count = 1;
        layout.setRatableHeight(row, 1);
        CtrlSwingUtilities.makeAlignBounds((boolean)true, (boolean)true, (Component)dialog);
        Container container = dialog.getContentPane();
        container.setLayout((LayoutManager)layout);
        int index = 0;
        for (int c = 0; c < column; ++c) {
            count = size % column != 0 && size % column - 1 < c ? 1 : 0;
            for (int r = 0; r < row - count; ++r) {
                KDWorkButton button = (KDWorkButton)functions.get(index++);
                container.add((Component)button, TableLayout2.param((int)r, (int)c));
            }
        }
    }

    private JPanel getGlassPanel() {
        if (this.glassPane != null) {
            return this.glassPane;
        }
        this.glassPane = new JPanel(){

            protected void paintComponent(Graphics g) {
                g.setColor(new Color(255, 255, 255, 150));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        this.glassPane.setOpaque(false);
        return this.glassPane;
    }
}

