/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.client;

import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.reportmeta.ctrlreport.ReportSnapInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.ReportSnapBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.AbstractReportSnapEditUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MultiLangUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.base.reportmeta.sumreport.enumtype.TempletType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ReportSnapEditUI
extends AbstractReportSnapEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ReportSnapEditUI.class);
    private HashMap mapInfo;
    ReportSnapInfo info;
    private boolean isCanceled = true;
    int iSnapType = -1;

    public ReportSnapEditUI() throws Exception {
    }

    public ReportSnapEditUI(HashMap mapInfo) throws Exception {
        this();
        this.mapInfo = mapInfo;
        this.init();
    }

    private void init() {
        String snapName = CtrlReportUtil.getObjectString(this.mapInfo.get("snapname"));
        MultiLangUtil.setMlbValue(this.snapName, snapName);
        String memo = CtrlReportUtil.getObjectString(this.mapInfo.get("memo"));
        MultiLangUtil.setMlbValue(this.memo, memo);
        String reportName = CtrlReportUtil.getObjectString(this.mapInfo.get("reportname"));
        this.reportName.setText(reportName);
        String strReportType = CtrlReportUtil.getObjectString(this.mapInfo.get("fsnaptype"));
        if (strReportType.equals("")) {
            strReportType = String.valueOf(-1);
        }
        this.iSnapType = Integer.parseInt(strReportType);
        this.snapType.setText(ReportSnapType.getDataType(this.iSnapType).getName());
        String strReportTime = CtrlReportUtil.getObjectString(this.mapInfo.get("freporttime"));
        this.setDateTimeValue(strReportTime);
        String strTempletType = CtrlReportUtil.getObjectString(this.mapInfo.get("templetType"));
        this.templetType.setText(TempletType.getTempletType(strTempletType).getName());
    }

    private void setDateTimeValue(String value) {
        if (value.equals("")) {
            this.reportTime.setValue(null);
            return;
        }
        try {
            Date date = CtrlReportUtil.sdfDateTime.parse(value);
            this.reportTime.setValue((Object)date);
        }
        catch (ParseException e) {
            logger.debug((Object)e);
        }
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        HashMap mapSnapName = MultiLangUtil.getEaslocaleFromKDMultiLangBox((KDMultiLangBox)this.snapName);
        HashMap mapMemo = MultiLangUtil.getEaslocaleFromKDMultiLangBox(this.memo);
        String strLocal = SysContext.getSysContext().getLocale().toString();
        Iterator it = mapSnapName.keySet().iterator();
        while (it.hasNext()) {
            String strLocalTmp = it.next().toString();
            String curName = CtrlReportUtil.getObjectString(mapSnapName.get(strLocalTmp));
            if (!curName.equals("") || !strLocalTmp.equals(strLocal)) continue;
            String msg1 = MessageUtil.getMsgInfo("label78");
            String msg2 = MessageUtil.getMsgInfo("label91");
            String msg = msg1 + "(" + CtrlReportUtil.bosToEasLang(strLocal) + ")" + msg2;
            MessageUtil.showInfo(msg, false);
            this.snapName.requestFocus();
            return;
        }
        String fid = CtrlReportUtil.getObjectString(this.mapInfo.get("fid"));
        String fname = String.valueOf(mapSnapName.get(strLocal));
        String fsystemID = CtrlReportUtil.getObjectString(this.mapInfo.get("fsystemid"));
        String freportid = CtrlReportUtil.getObjectString(this.mapInfo.get("freportid"));
        String sumRangeID = CtrlReportUtil.getObjectString(this.mapInfo.get("sumRangeID"));
        String taskDistributeID = CtrlReportUtil.getObjectString(this.mapInfo.get("taskDistributeID"));
        Object objValue = this.reportTime.getValue();
        this.info = new ReportSnapInfo();
        String orgOrUnitID = CtrlReportUtil.getObjectString(this.mapInfo.get("orgOrUnitID"));
        String currentSnapDate = "";
        if (objValue instanceof Date) {
            currentSnapDate = CtrlReportUtil.formatDate((Date)objValue);
        } else if (this.iSnapType != -1 && this.iSnapType != 0) {
            MessageUtil.showInfo("\u4e0a\u62a5\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", false);
            return;
        }
        String snapFlag = ReportSnapBO.getSnapFlagByType(this.iSnapType, currentSnapDate);
        if (fid.equals("") && this.iSnapType != -1 && this.iSnapType != 0) {
            try {
                HashMap<String, String> parmMap = new HashMap<String, String>();
                parmMap.put("currentSnapDate", currentSnapDate);
                parmMap.put("reportID", freportid);
                parmMap.put("orgOrUnitID", orgOrUnitID);
                parmMap.put("reportPeriod", String.valueOf(this.iSnapType));
                parmMap.put("sumRangeID", sumRangeID);
                parmMap.put("taskDistributeID", taskDistributeID);
                HashMap exitsMap = ReportSnapBO.existSameTypeSnap(null, parmMap);
                if (exitsMap != null) {
                    String msg = SysContext.getSysContext().getCurrentOrgUnit().getName() + "\u672c\u671f\u4e0a\u62a5\u7684" + ReportSnapType.getDataType(this.iSnapType) + "\u5df2\u5b58\u5728\uff0c\r\n\u4e0a\u62a5\u65e5\u671f\u662f" + currentSnapDate + "\uff0c\u662f\u5426\u8986\u76d6\uff1f";
                    int confirm = MsgBox.showConfirm2((String)msg);
                    if (confirm == 2) {
                        return;
                    }
                    String systemDate = CtrlReportUtil.formatDateTime(new Date());
                    this.info.setId(BOSUuid.read((String)CtrlReportUtil.getObjectString(exitsMap.get("fid"))));
                    LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
                    int z = lc.size();
                    for (int i = 0; i < z; ++i) {
                        LanguageInfo li = lc.get(i);
                        String alias = (String)mapSnapName.get(li.getLocale().toString());
                        this.info.setName(alias, li.getLocale());
                        String memo = (String)mapMemo.get(li.getLocale().toString());
                        memo = memo + "\r\n" + systemDate + " \u8986\u76d6";
                        if (strLocal.equals("l2")) {
                            memo = STConverter.tc2sc((String)memo);
                        } else if (strLocal.equals("l3")) {
                            memo = STConverter.sc2tc((String)memo);
                        }
                        this.info.setMemo(memo, li.getLocale());
                    }
                    if (objValue instanceof Date) {
                        this.info.setReportTime(new Timestamp(((Date)objValue).getTime()));
                    } else {
                        this.info.setReportTime(null);
                    }
                    this.isCanceled = false;
                    CtrlReportUtil.closeWin((CoreUIObject)this);
                    return;
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        } else {
            boolean flagExist;
            if (!fname.equals(CtrlReportUtil.getObjectString(this.mapInfo.get("snapname"))) && (flagExist = ReportSnapBO.isexist(null, fid, fsystemID, fname, strLocal))) {
                MessageUtil.showInfo("report_name_repeat", true);
                this.snapName.requestFocus();
                return;
            }
            String oldReportDate = CtrlReportUtil.getObjectString(this.mapInfo.get("freporttime"));
            if (!oldReportDate.equals("")) {
                oldReportDate = CtrlReportUtil.formatDateYMD(oldReportDate);
            }
            if (!currentSnapDate.equals("") && !oldReportDate.equals(currentSnapDate) && this.iSnapType != -1 && this.iSnapType != 0) {
                MessageUtil.showInfo("\u4e0d\u5141\u8bb8\u4fee\u6539\u6c47\u603b\u4e0a\u62a5\u62a5\u8868\u7684\u5feb\u7167\u65e5\u671f\uff01", false);
                return;
            }
        }
        if (!fid.equals("")) {
            this.info.setId(BOSUuid.read((String)fid));
        }
        this.info.setReportID(BOSUuid.read((String)freportid));
        this.info.setSystemID(fsystemID);
        this.info.setSnapFlag(snapFlag);
        this.info.setOrgID(orgOrUnitID);
        if (!sumRangeID.equals("")) {
            this.info.setSumRangeID(sumRangeID);
            this.info.setTaskDistributeID(taskDistributeID);
            String templetType = CtrlReportUtil.getObjectString(this.mapInfo.get("templetType"));
            this.info.setOrgID(templetType);
        }
        LanguageCollection lc = ExtContextUtils.getMetaDataLoader().getSolution().getLanguages();
        int z = lc.size();
        for (int i = 0; i < z; ++i) {
            LanguageInfo li = lc.get(i);
            String alias = (String)mapSnapName.get(li.getLocale().toString());
            this.info.setName(alias, li.getLocale());
            String memo = (String)mapMemo.get(li.getLocale().toString());
            this.info.setMemo(memo, li.getLocale());
        }
        if (objValue instanceof Date) {
            this.info.setReportTime(new Timestamp(((Date)objValue).getTime()));
        } else {
            this.info.setReportTime(null);
        }
        this.isCanceled = false;
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public ReportSnapInfo getInfo() {
        return this.info;
    }
}

