/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.LicenseBo;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ChoosedBITreeUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.DeployAliasUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportDialog;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CheckJavaDataSet;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CheckJavaDataSetException;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeployMenu {
    private static final Logger logger = Logger.getLogger(DeployMenu.class);
    private ExtReportManageUI reportUI = null;

    public DeployMenu(ExtReportManageUI reportUI) {
        this.reportUI = reportUI;
    }

    public static final void unDeployReport(String reportID, String menuID, boolean updateLicenseStrategy, Map stdInfo) throws BOSException {
        try {
            IMainMenuItem menu = MainMenuItemFactory.getRemoteInstance();
            ObjectUuidPK menuPk_del = new ObjectUuidPK("id", new MainMenuItemInfo().getBOSType());
            menuPk_del.setKeyValue("id", (Object)menuID);
            menu.delete((IObjectPK)menuPk_del);
        }
        catch (Exception e) {
            logger.error((Object)"\u79fb\u9664\u7cfb\u7edf\u83dc\u5355\u9879\u9519\u8bef\uff0c\u5f3a\u5236\u6e05\u7a7a\u62a5\u8868\u53d1\u5e03\u6807\u8bc6", (Throwable)e);
        }
        catch (Throwable t) {
            logger.error((Object)"\u79fb\u9664\u7cfb\u7edf\u83dc\u5355\u9879\u9519\u8bef\uff0c\u5f3a\u5236\u6e05\u7a7a\u62a5\u8868\u53d1\u5e03\u6807\u8bc6", t);
        }
        Boolean isNeedDelUI = (Boolean)stdInfo.get("isDelMenuUI");
        StringBuffer sqlBuf = new StringBuffer("update T_RM_DefineReport set FdeployPath = null, FMenuID = null");
        if (isNeedDelUI.booleanValue()) {
            sqlBuf.append(",FMenuui = null ");
        }
        if (updateLicenseStrategy) {
            sqlBuf.append(",FLicenseStrategy=");
            sqlBuf.append(0);
        }
        sqlBuf.append(" where fid = ?");
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(reportID);
        ExtDBUtil.maintainRecord(null, sqlBuf.toString(), queryValue);
    }

    public boolean deployToBI(HashMap map) throws AbortException, CheckJavaDataSetException {
        RptParams pr_r;
        String fid = map.get("fid").toString();
        if (!CheckJavaDataSet.checkUIType(null, fid)) {
            throw new CheckJavaDataSetException("\u62a5\u8868\u4e2d\u7684JAVA\u6570\u636e\u96c6\u4f7f\u7528\u4e86\u4ee3\u7801\u7f16\u5199\u7684\u53c2\u6570\u754c\u9762\uff0c\u4e0d\u80fd\u53d1\u5e03\u5230BI\u3002");
        }
        String fname = CtrlReportUtil.getObjectString(map.get("fname"));
        HashMap mapName = null;
        Object path = null;
        Object pathText = null;
        boolean flag = false;
        ArrayList lstName = null;
        HashMap descriptionMap = null;
        String currentame = "";
        int licenseDeployStrategy = 0;
        try {
            ChoosedBITreeUI nameUI = new ChoosedBITreeUI(this.reportUI);
            nameUI.clear();
            ReportDialog.showDialog((CoreUIObject)nameUI, EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label167"), true);
            if (!nameUI.isOk()) {
                return false;
            }
            mapName = nameUI.getMapData();
            path = mapName.get("path");
            pathText = mapName.get("pathText");
            if (path == null) {
                return false;
            }
            lstName = (ArrayList)mapName.get("lstName");
            HashMap newAlias = null;
            DeployAliasUI aliasUI = new DeployAliasUI(fname);
            aliasUI.setDeployLicenseType(((Number)map.get("flicensestrategy")).intValue());
            aliasUI.clear();
            ReportDialog dialog = ReportDialog.showDialog(aliasUI, EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label16"), true);
            while (true) {
                boolean licenseControl;
                if (!aliasUI.isOk()) {
                    return false;
                }
                newAlias = aliasUI.getMapAlias();
                currentame = String.valueOf(newAlias.get(SysContext.getSysContext().getLocale().toString()));
                String fisstdproduct = CtrlReportUtil.getObjectString(map.get("fisstdproduct"));
                if (!"1".endsWith(fisstdproduct)) {
                    licenseDeployStrategy = aliasUI.getDeployLicenseType();
                }
                if (licenseDeployStrategy == 1 && CtrlReportUtil.getObjectString(map.get("fmenuid")).equals("") && !(licenseControl = LicenseBo.deployChkLicense(null))) {
                    return false;
                }
                boolean isRepeat = false;
                for (String name : lstName) {
                    if (!name.equals(currentame)) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label159"));
                    isRepeat = true;
                    break;
                }
                if (!isRepeat) break;
                dialog.setVisible(true);
            }
            descriptionMap = aliasUI.getDescriptionMap();
            dialog.dispose();
        }
        catch (AbortException ae) {
            throw ae;
        }
        catch (Exception e) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label17") + e.getMessage()));
        }
        String extReportPath = this.reportUI.getLeafParentTreePathString() + "/" + fname;
        extReportPath = ExtStringUtil.replace(extReportPath, "\\", "/");
        RptParams pr = new RptParams();
        pr.setString("MethodName", "saveBIMenu");
        pr.setString("parentNodePath", path.toString());
        pr.setString("reportFullPathCaption", extReportPath);
        pr.setString("parentBILabel", pathText.toString());
        pr.setString("displayName", currentame);
        pr.setString("FID", fid);
        String biPath = "";
        try {
            pr_r = ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
            biPath = pr_r.getString("biPath");
        }
        catch (Exception e) {
            MessageUtil.showDetailAndOKFromResource(null, "label175", e);
            return flag;
        }
        pr.clear();
        pr.setString("MethodName", "deployReport");
        pr.setString("deployTo", "1");
        pr.setString("biPath", biPath);
        pr.setString("FID", fid);
        pr.setInt("LicenseStrategy", licenseDeployStrategy);
        pr.setString("UserID", SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        pr.setString("IP", SysContext.getSysContext().getClientIP());
        pr.setObject("descriptionMap", (Object)descriptionMap);
        try {
            pr_r = ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
            flag = pr_r.getBoolean("Flag");
        }
        catch (BOSException e) {
            int n;
            if (biPath.equals("")) {
                return false;
            }
            if (biPath.length() > 0 && (n = biPath.indexOf("@@")) != -1) {
                biPath = biPath.substring(0, n);
            }
            pr.clear();
            pr.setString("MethodName", "delBIMenu");
            pr.setString("bipath", biPath);
            try {
                ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
            }
            catch (Exception ec) {
                ec.printStackTrace();
            }
            MessageUtil.showDetailAndOKFromResource(null, "label175", (Exception)((Object)e));
        }
        return flag;
    }

    public static final void unDeployToBI(String reportId, String bipath, boolean updateLicenseStrategy) throws BOSException {
        int n;
        if (bipath.equals("")) {
            return;
        }
        if (bipath.length() > 0 && (n = bipath.indexOf("@@")) != -1) {
            bipath = bipath.substring(0, n);
        }
        RptParams pr = new RptParams();
        pr.setString("MethodName", "delBIMenu");
        pr.setString("bipath", bipath);
        FacadeFactory.commonExecuteNever(null, pr);
        StringBuffer sqlBuf = new StringBuffer("update T_RM_DefineReport set FBIPath = null ");
        if (updateLicenseStrategy) {
            sqlBuf.append(",FLicenseStrategy =");
            sqlBuf.append(0);
        }
        sqlBuf.append(" where fid = '");
        sqlBuf.append(reportId).append('\'');
        ExtDBUtil.maintainRecord(null, sqlBuf.toString(), null);
    }
}

