/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.Permission;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.LicenseBo;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.PermissionInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.uiframe.IOutsideMenuEntrance;
import com.kingdee.eas.base.uiframe.OutsideMenuBizTypeEnum;
import com.kingdee.eas.base.uiframe.OutsideMenuEntranceInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ExtReportMenuEntrance
implements IOutsideMenuEntrance {
    public static final String[] EXTREPORTFORCUS = new String[]{"com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportRunUI", "com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportRunTimeUI"};
    public static final String[] EXTREPORT = new String[]{"com.kingdee.eas.base.reportmeta.sumreport.client.SumTaskListUI", "com.kingdee.eas.base.reportmeta.sumreport.client.UploadTaskListUI"};

    public OutsideMenuEntranceInfo getOutsideMenuEntranceInfo(Context ctx) throws BOSException, EASBizException {
        boolean isApplyMenuPermission;
        MenuEntranceList lst = new MenuEntranceList();
        OutsideMenuEntranceInfo omei = new OutsideMenuEntranceInfo();
        omei.setType(OutsideMenuBizTypeEnum.REPORT_TYPE);
        if (ctx == null) {
            LicenseBo.LEAVE_COUNT = 0;
            PermissionBO.clearClientUserPermission();
        }
        if (isApplyMenuPermission = DefineReportBO.isApplyMenuPermission(ctx)) {
            List orgList = ExtReportMenuEntrance.getCurrentUserBizOrgList(ctx);
            HashMap permissionObj = PermissionBO.getUserAllPermissionForMultyOrg(ctx, null, orgList);
            if (permissionObj instanceof HashMap) {
                List checkedList = ExtReportMenuEntrance.getItemListToBeChecked(permissionObj);
                lst.addAll(checkedList);
            } else if (permissionObj instanceof Set) {
                List checkedList = ExtReportMenuEntrance.getItemListToBeChecked(ctx, (Set)((Object)permissionObj));
                lst.addAll(checkedList);
            }
        }
        List upAndSumAllowMenuIdList = ExtReportMenuEntrance.checkUploadAndSumPermission(ctx);
        lst.addUploadAndSumMenu(upAndSumAllowMenuIdList);
        omei.setList((List)lst);
        return omei;
    }

    private static List getCurrentUserBizOrgList(Context ctx) throws EASBizException, BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        String userId = null == ctx ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ctx.getCaller().toString();
        ObjectUuidPK currentUserPK = new ObjectUuidPK(userId);
        OrgRangeCollection orgRange = PermissionRangeHelper.getUserOrgRange((Context)ctx, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE);
        Object[] orgArr = orgRange.toArray();
        for (int i = 0; i < orgArr.length; ++i) {
            Object obj = orgArr[i];
            if (!(obj instanceof OrgRangeInfo)) continue;
            OrgRangeInfo orgItem = (OrgRangeInfo)obj;
            resultList.add(orgItem.getOrg().getId().toString());
        }
        return resultList;
    }

    public static boolean checkFunctionPermission(Context ctx, String ui) throws BOSException, EASBizException {
        boolean result = false;
        if (ctx == null) {
            return result;
        }
        Permission permission = new Permission();
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)ctx.get((Object)"CurOU");
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        ObjectUuidPK orgPk = new ObjectUuidPK(orgUnit.getId());
        ObjectUuidPK userPk = new ObjectUuidPK(userInfo.getId());
        if (EXTREPORT[0].equalsIgnoreCase(ui)) {
            result = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Sum_Make");
            if (!result) {
                boolean bl = result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Sum_Approve");
            }
            if (!result) {
                result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Sum_Upload");
            }
        } else if (EXTREPORT[1].equalsIgnoreCase(ui)) {
            result = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Upload_Make");
            if (!result) {
                boolean bl = result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Upload_Approve");
            }
            if (!result) {
                result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Upload_Upload");
            }
        } else {
            result = false;
        }
        return result;
    }

    private static List getItemListToBeChecked(HashMap itemMap) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (String reportId : itemMap.keySet()) {
            PermissionInfo info = (PermissionInfo)itemMap.get(reportId);
            Object menuID = null;
            if (resultList.contains(menuID)) continue;
            resultList.add(menuID);
        }
        return resultList;
    }

    private static List getItemListToBeChecked(Context ctx, Set itemSet) throws BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT fid, FMenuID FROM T_RM_DefineReport where FMenuID is not null");
        ArrayList dataList = ExtDBUtil.getResultListBySql(ctx, sb.toString(), null);
        for (HashMap map : dataList) {
            String menuID = CtrlReportUtil.getObjectString(map.get("fid"));
            BOSUuid bosUuid = BOSUuid.read((String)menuID);
            if (!itemSet.contains(bosUuid)) continue;
            String fmenuid = CtrlReportUtil.getObjectString(map.get("fmenuid"));
            resultList.add(fmenuid);
        }
        return resultList;
    }

    private static List checkUploadAndSumPermission(Context ctx) throws EASBizException, BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        ArrayList<String> idList = new ArrayList<String>();
        for (int index = 0; index < EXTREPORT.length; ++index) {
            if (!ExtReportMenuEntrance.checkFunctionPermission(ctx, EXTREPORT[index])) continue;
            idList.add(EXTREPORT[index]);
        }
        if (!idList.isEmpty()) {
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT fid,fuiclassname FROM T_PM_MainMenuItem WHERE fuiclassname IN ( ");
            for (int index = 0; index < idList.size(); ++index) {
                sqlBuffer.append("'");
                sqlBuffer.append(idList.get(index));
                sqlBuffer.append("',");
            }
            String sql = sqlBuffer.substring(0, sqlBuffer.length() - 1) + ")";
            ArrayList menuIdList = ExtDBUtil.getResultListBySql(ctx, sql, null);
            for (HashMap map : menuIdList) {
                String menuId = CtrlReportUtil.getObjectString(map.get("fid"));
                resultList.add(menuId);
            }
        }
        return resultList;
    }

    private static class MenuEntranceList
    extends ArrayList {
        private static final long serialVersionUID = 2537380928073318532L;
        private List uploadAndSumMenuIdList = new ArrayList();
        private boolean _isApplyMenuPermission = true;

        void addUploadAndSumMenu(List menuId) {
            this.uploadAndSumMenuIdList.addAll(menuId);
        }

        public boolean contains(Object elem) {
            if (this.uploadAndSumMenuIdList.contains(elem)) {
                boolean result = true;
                return result;
            }
            if (this._isApplyMenuPermission) {
                return super.contains(elem);
            }
            return true;
        }
    }
}

