/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.util;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.model.struct.IPackageQuery;
import com.kingdee.bos.ctrl.kds.model.struct.Parameter;
import com.kingdee.bos.ctrl.kds.model.struct.QueryPackage;
import com.kingdee.bos.ctrl.kds.model.util.SortedParameterArray;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtEASFusionUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class BatchQueryInterceptor
implements IPackageQuery {
    private final ICalculateContextProvider _ctxProvider;

    public BatchQueryInterceptor(ICalculateContextProvider ctxProvider) {
        this._ctxProvider = ctxProvider;
        this._ctxProvider.getServerContext();
    }

    public boolean batchQuery(QueryPackage pkg) {
        if (!pkg.isEmpty()) {
            ArrayList formulaCollector = new ArrayList();
            MiscUtil.log((int)2, (String)("\u8d22\u52a1\u516c\u5f0f\u6279\u91cf\u53d6\u6570\u8ba1\u7b97 [Method Count:" + this.getMethodCount(pkg, formulaCollector) + "]"));
            try {
                long begin = System.currentTimeMillis();
                this.fillQueryValue(pkg, ExtEASFusionUtil.clientCalc(new Date(), formulaCollector));
                long end = System.currentTimeMillis();
                MiscUtil.log((int)2, (String)("\u8d22\u52a1\u516c\u5f0f\u6279\u91cf\u53d6\u6570\u8ba1\u7b97 [Cost Time:" + (end - begin) + "]"));
            }
            catch (Throwable e) {
                MiscUtil.log((int)2, (String)"\u8d22\u52a1\u516c\u5f0f\u6279\u91cf\u53d6\u6570\u8ba1\u7b97\u5931\u8d25\uff0c\u5806\u6808\u4fe1\u606f\uff1a");
                MiscUtil.log((Throwable)e);
            }
        }
        return true;
    }

    private HashMap fillQueryValue(QueryPackage pkg, Variant[] result) {
        HashMap<Integer, com.kingdee.bos.ctrl.extcommon.variant.Variant> valuesMap = new HashMap<Integer, com.kingdee.bos.ctrl.extcommon.variant.Variant>();
        Iterator it = pkg.iterator();
        int i = 0;
        while (it.hasNext()) {
            Variant easVariant;
            QueryPackage.Node node = (QueryPackage.Node)it.next();
            if ((easVariant = result[i++]) != null) {
                valuesMap.put(node.getParameter().getUID(), new com.kingdee.bos.ctrl.extcommon.variant.Variant(easVariant.getValue(), easVariant.getVt()));
                continue;
            }
            valuesMap.put(node.getParameter().getUID(), com.kingdee.bos.ctrl.extcommon.variant.Variant.nullVariant);
        }
        for (Map.Entry e : pkg.getQueryManager().getBatchQueries().entrySet()) {
            this.fillParameter((HashMap)e.getValue(), valuesMap);
        }
        for (Map.Entry e : pkg.getQueryManager().getInvokeQueries().entrySet()) {
            this.fillParameter((HashMap)e.getValue(), valuesMap);
        }
        return valuesMap;
    }

    private void fillParameter(HashMap providerBag, HashMap valuesMap) {
        Iterator bi = providerBag.entrySet().iterator();
        while (bi.hasNext()) {
            SortedParameterArray params = (SortedParameterArray)bi.next().getValue();
            for (int i = params.size() - 1; i >= 0; --i) {
                Parameter param = params.getParameter(i);
                param.setValue(valuesMap.get(param.getUID()));
            }
        }
    }

    private int getMethodCount(QueryPackage pkg, List formulaCollector) {
        int ret = 0;
        for (QueryPackage.Node node : pkg) {
            StringBuffer formula = new StringBuffer();
            formula.append(node.getMethodName());
            formula.append('(');
            Object[] args = node.getParameter().getArgs();
            int length = args.length;
            for (int i = 0; i < length; ++i) {
                Object o = args[i];
                if (i != 0) {
                    formula.append(',');
                }
                if (o instanceof com.kingdee.bos.ctrl.extcommon.variant.Variant) {
                    formula.append(this.getParameterString((com.kingdee.bos.ctrl.extcommon.variant.Variant)o));
                    continue;
                }
                if (o instanceof com.kingdee.bos.ctrl.extcommon.variant.Variant[]) {
                    com.kingdee.bos.ctrl.extcommon.variant.Variant[] vars = (com.kingdee.bos.ctrl.extcommon.variant.Variant[])o;
                    int size = vars.length;
                    for (int m = 0; m < size; ++m) {
                        if (m != 0) {
                            formula.append(',');
                        }
                        formula.append(this.getParameterString(vars[m]));
                    }
                    continue;
                }
                formula.append(o);
            }
            formula.append(')');
            formulaCollector.add(formula.toString());
            ++ret;
        }
        return ret;
    }

    private String getParameterString(com.kingdee.bos.ctrl.extcommon.variant.Variant var) {
        if (var.getVt() == 11) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('\"');
            buffer.append(var.getValue());
            buffer.append('\"');
            return buffer.toString();
        }
        return var.getValue().toString();
    }
}

