/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.util;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.reportmeta.ctrlreport.DefineReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.adapter.ReportSelectManager;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.LicenseBo;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.MainMenuItemBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ExtReportRunUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.client.ReportRunTimeUI;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.PermissionKind;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportQuery;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.base.reportmeta.ctrlreport.permission.IReportPermission;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.UINewTabFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Frame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExtEasBillUtil {
    private static final Logger logger = LogUtil.getPackageLogger(ExtEasBillUtil.class);

    public static final DefineReportInfo showReportDialog() {
        try {
            List lstSelectedReport = ReportSelectManager.showReportDialog(null, ExtCallbackImpl.class.getName(), false, false);
            if (null != lstSelectedReport) {
                HashMap mapReport = (HashMap)lstSelectedReport.get(0);
                String fid = mapReport.get("fid").toString();
                String reportName = CtrlReportUtil.getObjectString(mapReport.get("fname"));
                String deploypath = MainMenuItemBO.getDeployName(CtrlReportUtil.getObjectString(mapReport.get("fdeploypath")));
                String systemID = CtrlReportUtil.getObjectString(mapReport.get("fsystemid"));
                String orgID = CtrlReportUtil.getObjectString(mapReport.get("forgid"));
                DefineReportInfo dri = new DefineReportInfo();
                dri.setId(BOSUuid.read((String)fid));
                dri.setName(reportName);
                dri.setDeployPath(deploypath);
                dri.setSystemID(systemID);
                dri.setOrgID(BOSUuid.read((String)orgID));
                return dri;
            }
        }
        catch (Exception ex) {
            MessageUtil.showDetailAndOK(null, "\u6253\u5f00\u62a5\u8868\u7a97\u53e3\u5931\u8d25", ex);
        }
        return null;
    }

    public static final void executeWithinWindow(Component component, String reportID, String reportName, String systemID, String orgID, int showType, Map params) {
        if (params == null) {
            params = new HashMap(1);
        }
        if (orgID == null) {
            orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        }
        DefineReportInfo info = null;
        if (CtrlReportUtil.getObjectString(reportID).equals("")) {
            reportID = "qUvvbL4yQsyQYFIDSlvngID2+FI=";
        }
        try {
            info = DefineReportBO.getReportInfo(null, systemID, reportName, orgID, reportID);
            if (info == null) {
                info = DefineReportBO.getStdReportInfo(null, systemID, reportName, reportID);
            }
            if (info == null) {
                MessageUtil.showInfo("label327", true);
                return;
            }
            if (showType == 1) {
                Frame mainFrame = UIFrameUtil.getCurrMainFrame((Component)component);
                UIContext uiContext = new UIContext((Object)mainFrame);
                uiContext.put("checkLicense", "true");
                uiContext.put("UIClassParam", null);
                uiContext.put("MainMenuName", reportName);
                uiContext.put("isEntryFromMenu", "true");
                uiContext.put("isLimitRecord", "false");
                uiContext.put("filterMap", params);
                uiContext.put("DefineReportInfo", info);
                String name = null;
                int licenseType = info.getLicenseStrategy();
                if (licenseType == 1) {
                    name = ExtReportRunUI.class.getName();
                } else if (licenseType == 2 || licenseType == 0) {
                    name = ReportRunTimeUI.class.getName();
                }
                IUIFactory uiFactory = null;
                uiFactory = UIFactory.createUIFactory((String)UINewTabFactory.class.getName());
                IUIWindow uiWindow = uiFactory.create(name, (Map)uiContext, null, null);
                if (uiWindow != null) {
                    uiWindow.show();
                }
            } else {
                String deployPath = CtrlReportUtil.getObjectString(info.getDeployPath());
                if (deployPath.equals("")) {
                    MessageUtil.showInfo("label20", true);
                    return;
                }
                byte[] bContent = info.getContent();
                int stdProduct = info.getIsStdProduct();
                if (stdProduct == 1) {
                    boolean isStdProduct = BookIOUtil.hasValidCoupon((byte[])bContent, (boolean)true);
                    if (!isStdProduct) {
                        MessageUtil.showInfo("label229", true);
                        return;
                    }
                } else {
                    int spareCount = LicenseBo.getCacheSpareCount(null);
                    if (spareCount < 0) {
                        MessageUtil.showInfo("label230", true);
                        return;
                    }
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("report_id", info.getId().toString());
                boolean flag = PermissionBO.hasDataPermission(reportID, PermissionKind.VIEW);
                if (!flag) {
                    IReportPermission permission = CtrlReportQuery.getIReportPermissionInstance();
                    flag = permission.hasDataPermission(map);
                }
                if (!flag) {
                    MessageUtil.showInfo("label19", true);
                    return;
                }
                ExtGuiExecutor re = new ExtGuiExecutor(info.getContent(), (IExtRuntimeDataProvider)new ExtCallbackImpl(info, false, true), false);
                re.executeWithinWindow(params, reportName);
            }
        }
        catch (UIException ae) {
            if (component instanceof CoreUI) {
                ((CoreUI)component).setCursorOfDefault();
            }
            MessageUtil.showDetailAndOK(null, EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label151"), (Exception)((Object)ae));
            logger.error((Object)"\u8fd0\u884c\u9519\u8bef", (Throwable)ae);
        }
        catch (Exception ex) {
            MessageUtil.showDetailAndOK(null, EASResource.getString((String)"com.kingdee.eas.base.reportmeta.ctrlreport.MessageResource", (String)"label151"), ex);
            logger.error((Object)"\u8fd0\u884c\u9519\u8bef", (Throwable)ex);
        }
    }

    public static final void executeWithinWindow(Component component, String reportID, String reportName, String systemID, int showType, Map params) {
        ExtEasBillUtil.executeWithinWindow(component, reportID, reportName, systemID, null, showType, params);
    }
}

