/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.client;

import com.kingdee.bos.ctrl.common.ui.editor.styled.SQLStyledEditor;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.client.AbstractCurrentSQLUI;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class CurrentSQLUI
extends AbstractCurrentSQLUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(CurrentSQLUI.class);
    private boolean isinitLayout = false;
    private HashMap logMap;
    private SQLStyledEditor textKSQL;
    private SQLStyledEditor textDialectSQL;

    public CurrentSQLUI() throws Exception {
        this.initLayout();
        this.labelUseTime.setHorizontalAlignment(4);
        this.kDButtonGroup1.add((AbstractButton)this.rbSqlServer);
        this.kDButtonGroup1.add((AbstractButton)this.rbOracle);
        this.kDButtonGroup1.add((AbstractButton)this.rbDB2);
        this.textKSQL = new SQLStyledEditor();
        this.kDScrollPane1.getViewport().add((Component)this.textKSQL, null);
        this.textDialectSQL = new SQLStyledEditor();
        this.kDScrollPane2.getViewport().add((Component)this.textDialectSQL, null);
    }

    public void onLoad() throws Exception {
        String dbTypeString;
        super.onLoad();
        String sql = CtrlReportUtil.getObjectString(this.logMap.get("sql"));
        if (!sql.equals("")) {
            String sqlFlag = sql.toLowerCase();
            if (sqlFlag.startsWith("/*dialect*/")) {
                this.btnTraslate.setEnabled(false);
            }
            this.textKSQL.setText(sql);
            String useTime = CtrlReportUtil.getObjectString(this.logMap.get("useTime"));
            this.labelUseTime.setText(useTime);
        }
        if (!(dbTypeString = CtrlReportUtil.getObjectString(this.logMap.get("dbType"))).equals("")) {
            int dbType = Integer.parseInt(dbTypeString);
            if (dbType == 3) {
                this.rbSqlServer.setSelected(true);
            } else if (dbType == 2) {
                this.rbOracle.setSelected(true);
            } else if (dbType == 1) {
                this.rbDB2.setSelected(true);
            }
        }
    }

    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    protected void btnTraslate_actionPerformed(ActionEvent e) throws Exception {
        int dbType = -1;
        if (this.rbSqlServer.isSelected()) {
            dbType = 3;
        } else if (this.rbOracle.isSelected()) {
            dbType = 2;
        } else if (this.rbDB2.isSelected()) {
            dbType = 1;
        } else {
            return;
        }
        String dialectSQL = TransUtil.Translate((String)this.textKSQL.getText(), (int)dbType);
        this.textDialectSQL.setText(dialectSQL);
    }

    protected void btnTestTime_actionPerformed(ActionEvent e) throws Exception {
        String sql = CtrlReportUtil.getObjectString(this.logMap.get("sql"));
        if (!sql.equals("")) {
            try {
                IRowSet rs = CtrlDesignDataExecutor.execute("", sql, this.logMap, 0, -1);
                if (rs != null) {
                    rs.close();
                }
                String useTime = CtrlReportUtil.getObjectString(this.logMap.get("useTime"));
                this.labelUseTime.setText(useTime);
            }
            catch (Exception e1) {
                logger.debug((Object)e1);
            }
        }
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    public void setLogMap(HashMap logMap) {
        this.logMap = logMap;
    }
}

